/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.preferences;

import java.util.regex.Pattern;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;

class FloatFieldEditor
extends StringFieldEditor {
    Float _minValue = null;
    Float _maxValue = null;
    boolean _maxValueIsIncluded = true;
    boolean _minValueIsIncluded = true;

    public FloatFieldEditor(Float value, Float value2) {
        this._minValue = value;
        this._maxValue = value2;
        this._maxValueIsIncluded = true;
        this._minValueIsIncluded = true;
    }

    public FloatFieldEditor() {
    }

    public FloatFieldEditor(String name, String labelText, Composite parent, Float value, Float value2) {
        super(name, labelText, parent);
        this._minValue = value;
        this._maxValue = value2;
        this._maxValueIsIncluded = true;
        this._minValueIsIncluded = true;
    }

    public FloatFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    public void setMinValue(float minValue, boolean bInclude) {
        this._minValue = new Float(minValue);
        this._minValueIsIncluded = bInclude;
    }

    public void setMaxValue(float maxValue, boolean bInclude) {
        this._maxValue = new Float(maxValue);
        this._maxValueIsIncluded = bInclude;
    }

    protected boolean checkState() {
        boolean bok = true;
        if (this.getStringValue().compareTo("") == 0 && !this.isEmptyStringAllowed()) {
            bok = false;
            this.setErrorMessage("Field should contain a float value");
            this.showErrorMessage();
        } else {
            Pattern pattern = Pattern.compile("[ \\D &&[^\\.]&&[^-]]");
            if (pattern.matcher(this.getStringValue()).find()) {
                this.setErrorMessage("Field should contain a float value");
                this.showErrorMessage();
                bok = false;
            } else {
                this.clearErrorMessage();
                try {
                    float myValue = Float.parseFloat(this.getStringValue());
                    if (this._minValue != null && this._maxValue != null) {
                        if (this._minValueIsIncluded && this._maxValueIsIncluded) {
                            bok = Float.compare(myValue, this._minValue.floatValue()) >= 0 && Float.compare(myValue, this._maxValue.floatValue()) <= 0;
                            this.setErrorMessage("Field should contain a float value between " + this._minValue + " and " + this._maxValue);
                        } else if (!this._minValueIsIncluded && !this._maxValueIsIncluded) {
                            bok = Float.compare(myValue, this._minValue.floatValue()) > 0 && Float.compare(myValue, this._maxValue.floatValue()) < 0;
                            this.setErrorMessage("Field should contain a float value greater than " + this._minValue + "  and less than " + this._maxValue);
                        } else if (!this._minValueIsIncluded && this._maxValueIsIncluded) {
                            bok = Float.compare(myValue, this._minValue.floatValue()) > 0 && Float.compare(myValue, this._maxValue.floatValue()) <= 0;
                            this.setErrorMessage("Field should contain a float value greater than " + this._minValue + "  and less or equal than " + this._maxValue);
                        } else if (this._minValueIsIncluded && !this._maxValueIsIncluded) {
                            bok = Float.compare(myValue, this._minValue.floatValue()) >= 0 && Float.compare(myValue, this._maxValue.floatValue()) < 0;
                            this.setErrorMessage("Field should contain a float value greater or equel than " + this._minValue + "  and less than " + this._maxValue);
                        }
                    } else if (this._minValue == null && this._maxValue != null) {
                        if (this._maxValueIsIncluded) {
                            bok = Float.compare(myValue, this._maxValue.floatValue()) <= 0;
                            this.setErrorMessage("Field should contain a float value less or equal than " + this._maxValue);
                        } else {
                            bok = Float.compare(myValue, this._maxValue.floatValue()) < 0;
                            this.setErrorMessage("Field should contain a float value less than " + this._maxValue);
                        }
                    } else if (this._minValue != null && this._maxValue == null) {
                        if (this._minValueIsIncluded) {
                            bok = Float.compare(myValue, this._minValue.floatValue()) >= 0;
                            this.setErrorMessage("Field should contain a float value greater or equal than " + this._minValue);
                        } else {
                            bok = Float.compare(myValue, this._minValue.floatValue()) > 0;
                            this.setErrorMessage("Field should contain a float value greater than " + this._minValue);
                        }
                    }
                }
                catch (Exception exception) {}
            }
            if (bok) {
                this.clearErrorMessage();
            } else {
                this.showErrorMessage();
            }
        }
        return bok;
    }
}

