/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.LONG;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PrintDialog
extends Dialog {
    PrinterData printerData;
    int scope = 0;
    int startPage = 1;
    int endPage = 1;
    boolean printToFile = false;
    long handle;
    int index;
    byte[] settingsData;
    static final String GET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.getModalDialog";
    static final String SET_MODAL_DIALOG = "org.eclipse.swt.internal.gtk.setModalDialog";
    static final String ADD_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.addIdleProc";
    static final String REMOVE_IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk.removeIdleProc";
    static final String GET_EMISSION_PROC_KEY = "org.eclipse.swt.internal.gtk.getEmissionProc";

    public PrintDialog(Shell parent) {
        this(parent, 32768);
    }

    public PrintDialog(Shell parent, int style) {
        super(parent, parent == null ? style : PrintDialog.checkStyleBit(parent, style));
        this.checkSubclass();
    }

    public void setPrinterData(PrinterData data) {
        this.printerData = data;
    }

    public PrinterData getPrinterData() {
        return this.printerData;
    }

    static int checkBits(int style, int int0, int int1, int int2, int int3, int int4, int int5) {
        int mask = int0 | int1 | int2 | int3 | int4 | int5;
        if ((style & mask) == 0) {
            style |= int0;
        }
        if ((style & int0) != 0) {
            style = style & ~mask | int0;
        }
        if ((style & int1) != 0) {
            style = style & ~mask | int1;
        }
        if ((style & int2) != 0) {
            style = style & ~mask | int2;
        }
        if ((style & int3) != 0) {
            style = style & ~mask | int3;
        }
        if ((style & int4) != 0) {
            style = style & ~mask | int4;
        }
        if ((style & int5) != 0) {
            style = style & ~mask | int5;
        }
        return style;
    }

    static int checkStyleBit(Shell parent, int style) {
        if (((style &= 0xF7FFFFFF) & 0x6000000) == 0 && parent != null) {
            if ((parent.getStyle() & 0x2000000) != 0) {
                style |= 0x2000000;
            }
            if ((parent.getStyle() & 0x4000000) != 0) {
                style |= 0x4000000;
            }
        }
        return PrintDialog.checkBits(style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
    }

    public int getScope() {
        return this.scope;
    }

    public void setScope(int scope) {
        this.scope = scope;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }

    public int getEndPage() {
        return this.endPage;
    }

    public void setEndPage(int endPage) {
        this.endPage = endPage;
    }

    public boolean getPrintToFile() {
        return this.printToFile;
    }

    public void setPrintToFile(boolean printToFile) {
        this.printToFile = printToFile;
    }

    public PrinterData open() {
        long printer;
        byte[] buffer;
        if (OS.GTK_VERSION < OS.VERSION(2, 10, 0)) {
            return Printer.getDefaultPrinterData();
        }
        byte[] titleBytes = Converter.wcsToMbcs(null, this.getText(), true);
        long topHandle = this.getParent().handle;
        while (topHandle != 0L && !OS.GTK_IS_WINDOW(topHandle)) {
            topHandle = OS.gtk_widget_get_parent(topHandle);
        }
        this.handle = OS.gtk_print_unix_dialog_new(titleBytes, topHandle);
        OS.gtk_print_unix_dialog_set_current_page(this.handle, -1);
        OS.gtk_print_unix_dialog_set_manual_capabilities(this.handle, 7L);
        long settings = OS.gtk_print_settings_new();
        long page_setup = OS.gtk_page_setup_new();
        if (this.printerData != null) {
            if (this.printerData.otherData != null) {
                Printer.restore(this.printerData.otherData, settings, page_setup);
            }
            Printer.setScope(settings, this.printerData.scope, this.printerData.startPage, this.printerData.endPage);
            if (this.printerData.printToFile) {
                buffer = Converter.wcsToMbcs(null, this.printerData.fileName, true);
                OS.gtk_print_settings_set(settings, OS.GTK_PRINT_SETTINGS_OUTPUT_URI, buffer);
            }
            if (this.printerData.driver.equals("GtkPrintBackendFile") && this.printerData.name.equals("Print to File")) {
                buffer = Converter.wcsToMbcs(null, this.printerData.fileName, true);
                OS.gtk_print_settings_set(settings, OS.GTK_PRINT_SETTINGS_OUTPUT_URI, buffer);
            }
            OS.gtk_print_settings_set_n_copies(settings, this.printerData.copyCount);
            OS.gtk_print_settings_set_collate(settings, this.printerData.collate);
        }
        Printer.setScope(settings, this.scope, this.startPage, this.endPage);
        if (this.printToFile) {
            buffer = Converter.wcsToMbcs(null, "Print to File", true);
            OS.gtk_print_settings_set_printer(settings, buffer);
        }
        OS.gtk_print_unix_dialog_set_settings(this.handle, settings);
        OS.gtk_print_unix_dialog_set_page_setup(this.handle, page_setup);
        OS.g_object_unref(settings);
        OS.g_object_unref(page_setup);
        PrinterData data = null;
        Display display = this.getParent() != null ? this.getParent().getDisplay() : Display.getCurrent();
        int signalId = 0;
        long hookId = 0L;
        if ((this.getStyle() & 0x4000000) != 0) {
            signalId = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
            hookId = OS.g_signal_add_emission_hook(signalId, 0, ((LONG)display.getData((String)GET_EMISSION_PROC_KEY)).value, this.handle, 0L);
        }
        display.setData(ADD_IDLE_PROC_KEY, null);
        Object oldModal = null;
        if (OS.gtk_window_get_modal(this.handle)) {
            oldModal = display.getData(GET_MODAL_DIALOG);
            display.setData(SET_MODAL_DIALOG, this);
        }
        int response = OS.gtk_dialog_run(this.handle);
        if (OS.gtk_window_get_modal(this.handle)) {
            display.setData(SET_MODAL_DIALOG, oldModal);
        }
        if ((this.getStyle() & 0x4000000) != 0) {
            OS.g_signal_remove_emission_hook(signalId, hookId);
        }
        if (response == -5 && (printer = OS.gtk_print_unix_dialog_get_selected_printer(this.handle)) != 0L) {
            settings = OS.gtk_print_unix_dialog_get_settings(this.handle);
            page_setup = OS.gtk_print_unix_dialog_get_page_setup(this.handle);
            data = Printer.printerDataFromGtkPrinter(printer);
            int print_pages = OS.gtk_print_settings_get_print_pages(settings);
            switch (print_pages) {
                case 0: {
                    this.scope = 0;
                    break;
                }
                case 2: {
                    this.scope = 1;
                    int[] num_ranges = new int[1];
                    long page_ranges = OS.gtk_print_settings_get_page_ranges(settings, num_ranges);
                    int[] pageRange = new int[2];
                    int length = num_ranges[0];
                    int min = Integer.MAX_VALUE;
                    int max = 0;
                    int i = 0;
                    while (i < length) {
                        OS.memmove(pageRange, page_ranges + (long)(i * pageRange.length * 4), (long)(pageRange.length * 4));
                        min = Math.min(min, pageRange[0] + 1);
                        max = Math.max(max, pageRange[1] + 1);
                        ++i;
                    }
                    OS.g_free(page_ranges);
                    this.startPage = min == Integer.MAX_VALUE ? 1 : min;
                    this.endPage = max == 0 ? 1 : max;
                    break;
                }
                case 1: {
                    this.scope = 2;
                    this.startPage = this.endPage = OS.gtk_print_unix_dialog_get_current_page(this.handle);
                }
            }
            this.printToFile = data.name.equals("Print to File");
            if (this.printToFile) {
                long address = OS.gtk_print_settings_get(settings, OS.GTK_PRINT_SETTINGS_OUTPUT_URI);
                int length = OS.strlen(address);
                byte[] buffer2 = new byte[length];
                OS.memmove(buffer2, address, (long)length);
                data.fileName = new String(Converter.mbcsToWcs(null, buffer2));
            }
            data.scope = this.scope;
            data.startPage = this.startPage;
            data.endPage = this.endPage;
            data.printToFile = this.printToFile;
            data.copyCount = OS.gtk_print_settings_get_n_copies(settings);
            data.collate = OS.gtk_print_settings_get_collate(settings);
            Callback printSettingsCallback = new Callback(this, "GtkPrintSettingsFunc", 3);
            long GtkPrintSettingsFunc = printSettingsCallback.getAddress();
            if (GtkPrintSettingsFunc == 0L) {
                SWT.error(3);
            }
            this.index = 0;
            this.settingsData = new byte[1024];
            OS.gtk_print_settings_foreach(settings, GtkPrintSettingsFunc, 0L);
            printSettingsCallback.dispose();
            ++this.index;
            this.store("orientation", OS.gtk_page_setup_get_orientation(page_setup));
            this.store("top_margin", OS.gtk_page_setup_get_top_margin(page_setup, 3));
            this.store("bottom_margin", OS.gtk_page_setup_get_bottom_margin(page_setup, 3));
            this.store("left_margin", OS.gtk_page_setup_get_left_margin(page_setup, 3));
            this.store("right_margin", OS.gtk_page_setup_get_right_margin(page_setup, 3));
            long paper_size = OS.gtk_page_setup_get_paper_size(page_setup);
            this.storeBytes("paper_size_name", OS.gtk_paper_size_get_name(paper_size));
            this.storeBytes("paper_size_display_name", OS.gtk_paper_size_get_display_name(paper_size));
            this.storeBytes("paper_size_ppd_name", OS.gtk_paper_size_get_ppd_name(paper_size));
            this.store("paper_size_width", OS.gtk_paper_size_get_width(paper_size, 3));
            this.store("paper_size_height", OS.gtk_paper_size_get_height(paper_size, 3));
            this.store("paper_size_is_custom", OS.gtk_paper_size_is_custom(paper_size));
            data.otherData = this.settingsData;
            OS.g_object_unref(settings);
        }
        display.setData(REMOVE_IDLE_PROC_KEY, null);
        OS.gtk_widget_destroy(this.handle);
        return data;
    }

    long GtkPrintSettingsFunc(long key, long value, long data) {
        int length = OS.strlen(key);
        byte[] keyBuffer = new byte[length];
        OS.memmove(keyBuffer, key, (long)length);
        length = OS.strlen(value);
        byte[] valueBuffer = new byte[length];
        OS.memmove(valueBuffer, value, (long)length);
        this.store(keyBuffer, valueBuffer);
        return 0L;
    }

    void store(String key, int value) {
        this.store(key, String.valueOf(value));
    }

    void store(String key, double value) {
        this.store(key, String.valueOf(value));
    }

    void store(String key, boolean value) {
        this.store(key, String.valueOf(value));
    }

    void storeBytes(String key, long value) {
        int length = OS.strlen(value);
        byte[] valueBuffer = new byte[length];
        OS.memmove(valueBuffer, value, (long)length);
        this.store(key.getBytes(), valueBuffer);
    }

    void store(String key, String value) {
        this.store(key.getBytes(), value.getBytes());
    }

    void store(byte[] key, byte[] value) {
        int length = key.length + 1 + value.length + 1;
        if (this.index + length + 1 > this.settingsData.length) {
            byte[] newData = new byte[this.settingsData.length + Math.max(length + 1, 1024)];
            System.arraycopy(this.settingsData, 0, newData, 0, this.settingsData.length);
            this.settingsData = newData;
        }
        System.arraycopy(key, 0, this.settingsData, this.index, key.length);
        this.index += key.length + 1;
        System.arraycopy(value, 0, this.settingsData, this.index, value.length);
        this.index += value.length + 1;
    }
}

