/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.editors;

import fable.framework.ui.actions.SaveAsColumnFileEditorAction;
import fable.framework.ui.actions.SaveColumnFileEditorAction;
import fable.framework.ui.editors.ColumnFileEditorInput;
import fable.framework.ui.editors.IColumnFileEditor;
import fable.framework.ui.views.ColFileXYPlot;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class ColumnFilePlotEditor
extends EditorPart
implements ISelectionListener,
IPropertyChangeListener,
IColumnFileEditor {
    private ColFileXYPlot xyplot;
    private static final String ID = "fable.framework.ui.ColumnFilePlotEditor";
    private ColumnFileEditorInput columnInput;
    private boolean dirty = false;
    private SaveColumnFileEditorAction saveAction;
    private SaveAsColumnFileEditorAction saveasAction;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.columnInput = (ColumnFileEditorInput)input;
        this.setPartName(this.columnInput.getColumn().getFileName());
        this.columnInput.getColumn().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.xyplot = new ColFileXYPlot(parent, "", "X", "Y");
        this.xyplot.addColumnFile(this.columnInput.getColumn());
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.makeActions();
    }

    private void contributetoActionBar() {
        IActionBars bars = this.getEditorSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.saveAction);
        toolBarManager.add((IAction)this.saveasAction);
    }

    private void makeActions() {
        this.saveAction = new SaveColumnFileEditorAction(){

            @Override
            public void run(IColumnFileEditor editor) {
                ((ColumnFilePlotEditor)editor).doSave(null);
            }
        };
        this.saveAction.setProps("Save column file");
        this.saveasAction = new SaveAsColumnFileEditorAction(){

            @Override
            public void run(IColumnFileEditor editor) {
                ((ColumnFilePlotEditor)editor).doSaveAs();
            }
        };
        this.saveasAction.setProps("Save column file as...");
    }

    public void setFocus() {
    }

    public ColFileXYPlot getxyPlot() {
        return this.xyplot;
    }

    public void dispose() {
        try {
            this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
            this.columnInput.getColumn().removePropertyrChangeListener((IPropertyChangeListener)this);
            if (this.xyplot != null) {
                this.xyplot.dispose();
            }
            this.xyplot = null;
        }
        finally {
            super.dispose();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part != this && selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            Object first = sSelection.getFirstElement();
            Object[] list = sSelection.toArray();
            if (first instanceof float[]) {
                float[] r = (float[])first;
                double[] indices = null;
                if (this.columnInput.getColumn() != null) {
                    int indexColumnId = this.columnInput.getColumn().getColumnIDIndex();
                    if (list.length > 1 && indexColumnId >= 0) {
                        indices = new double[list.length];
                        int j = 0;
                        while (j < list.length) {
                            indices[j] = ((float[])list[j])[indexColumnId];
                            ++j;
                        }
                    } else if (indexColumnId >= 0) {
                        indices = new double[]{r[indexColumnId]};
                    }
                    if (indices != null && indices.length > 0) {
                        this.xyplot.markSelectedRows(indices, this.columnInput.getColumn().getColumnfileId());
                    }
                }
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.columnInput.save();
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
        if (this.columnInput.saveAs()) {
            this.dirty = false;
            this.firePropertyChange(257);
            this.setPartName(this.columnInput.getColumn().getFileName());
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return this.dirty;
    }

    public static String getId() {
        return ID;
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void propertyChange(PropertyChangeEvent arg0) {
        if (arg0.getProperty().equals("updateColumn")) {
            this.dirty = true;
            this.firePropertyChange(257);
            this.xyplot.updateChart();
        } else if (arg0.getProperty().equals("propdirty")) {
            this.dirty = (Boolean)arg0.getNewValue();
            this.firePropertyChange(257);
            this.setPartName(this.columnInput.getColumn().getFileName());
        } else if (arg0.getProperty().equals("AddColumn")) {
            this.xyplot.addColumnFile(this.columnInput.getColumn());
        }
    }
}

