/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.SWTUtils;
import fable.imageviewer.actions.ImageViewActions;
import fable.imageviewer.internal.Coordinates;
import fable.imageviewer.internal.CustomCoordinatesDialog;
import fable.imageviewer.internal.IImagesVarKeys;
import fable.imageviewer.internal.ZoomSelection;
import fable.imageviewer.rcp.Activator;
import fable.imageviewer.views.ImageView;
import fable.imageviewer.views.ImageViewImage;
import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;

public class ImageViewControls
implements IImagesVarKeys {
    private static final int TEXT_COLS_LARGE = 12;
    private static final int TEXT_COLS_SMALL = 3;
    public static final int DEFAULT_MARKER_SIZE = 3;
    ImageView iv = null;
    private ImageViewImage image = null;
    private Composite controlComposite = null;
    private boolean controlCompositeShowing = true;
    private Display display;
    private Combo coordCombo;
    private Combo orientCombo;
    private Combo lutCombo;
    private Button aspectButton = null;
    private Button peaksButton = null;
    private Button autoscaleButton = null;
    private Text peakMarkerSizeText = null;
    private Text minimumText = null;
    private Text maximumText = null;
    private Text fileNumberText = null;
    private Label statusLabel = null;
    private Canvas imageCanvas;
    private Composite statusGroup;
    private static NumberFormat decimalFormat = NumberFormat.getNumberInstance();
    static boolean customSavedParametersInitialized = false;
    private ImageViewActions actions;

    public ImageViewControls(ImageView imageView) {
        this.iv = imageView;
    }

    public void createControls(Composite parent) {
        if (this.iv == null) {
            return;
        }
        this.image = new ImageViewImage(this.iv, this);
        this.actions = new ImageViewActions(this.iv, this, this.image);
        this.iv.setZoomSelection(ZoomSelection.AREA);
        this.display = this.iv.getDisplay();
        GridLayout parentField = new GridLayout();
        parentField.numColumns = 1;
        parent.setLayout((Layout)parentField);
        this.iv.getController().addPropertyChangeListener((IPropertyChangeListener)this.iv);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.controlComposite = new Composite(parent, 0);
        this.controlComposite.setLayout((Layout)gridLayout);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).exclude(!this.controlCompositeShowing).applyTo((Control)this.controlComposite);
        Composite row1 = new Composite(this.controlComposite, 0);
        GridDataFactory.fillDefaults().align(16384, 4).grab(false, false).applyTo((Control)row1);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        row1.setLayout((Layout)gridLayout);
        Composite row2 = new Composite(this.controlComposite, 0);
        GridDataFactory.fillDefaults().align(16384, 4).grab(false, false).applyTo((Control)row2);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        row2.setLayout((Layout)gridLayout);
        Composite row3 = new Composite(this.controlComposite, 0);
        GridDataFactory.fillDefaults().align(16384, 4).grab(false, false).applyTo((Control)row3);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        row3.setLayout((Layout)gridLayout);
        this.orientCombo = new Combo(row1, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)this.orientCombo);
        String[] items = new String[8];
        int i = 0;
        while (i < 8) {
            items[i] = orientNameValues[i][0];
            ++i;
        }
        this.orientCombo.setItems(items);
        this.orientCombo.setToolTipText("Adjust the orientation with O parameters (o11 o12 o21 o22)");
        this.orientCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = ImageViewControls.this.orientCombo.getSelectionIndex();
                ImageViewControls.this.iv.setOrientation(idx);
            }
        });
        Preferences prefs = Activator.getDefault().getPluginPreferences();
        int orientation = prefs.getInt("orientationPreference");
        this.iv.setOrientation(orientation);
        this.orientCombo.select(orientation);
        if (!customSavedParametersInitialized) {
            String processing = "xName";
            try {
                this.iv.setXNameSave(prefs.getString("coordinatesXNamePreference"));
                processing = "yName";
                this.iv.setYNameSave(prefs.getString("coordinatesYNamePreference"));
                processing = "x0";
                this.iv.setX0Save(Double.parseDouble(prefs.getString("coordinatesX0Preference")));
                processing = "y0";
                this.iv.setY0Save(Double.parseDouble(prefs.getString("coordinatesY0Preference")));
                processing = "pixelHeight";
                this.iv.setPixelWidthSave(Double.parseDouble(prefs.getString("coordinatesPixelWidthPreference")));
                processing = "pixelHeight";
                this.iv.setPixelHeightSave(Double.parseDouble(prefs.getString("coordinatesPixelHeightPreference")));
                customSavedParametersInitialized = true;
            }
            catch (NumberFormatException ex) {
                FableUtils.excMsg((Object)this, (String)("Error setting custom coordinates from preferences for " + processing), (Throwable)ex);
            }
        }
        this.coordCombo = new Combo(row1, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)this.coordCombo);
        items = new String[5];
        int i2 = 0;
        while (i2 < 5) {
            items[i2] = coordNameValues[i2][0];
            ++i2;
        }
        this.coordCombo.setItems(items);
        this.coordCombo.setToolTipText("Select the origin of the coordinate system for mouse movement");
        this.coordCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = ImageViewControls.this.coordCombo.getSelectionIndex();
                int coordOriginSave = ImageViewControls.this.iv.getCoordOrigin();
                ImageViewControls.this.iv.setCoordOrigin(idx);
                if (idx == 4) {
                    Coordinates coordinates = ImageViewControls.this.iv.getCoordinates();
                    CustomCoordinatesDialog dlg = coordinates.getType() == 4 ? new CustomCoordinatesDialog(ImageViewControls.this.display.getActiveShell(), coordinates.getX0(), coordinates.getY0(), coordinates.getPixelWidth(), coordinates.getPixelHeight(), coordinates.getXName(), coordinates.getYName()) : new CustomCoordinatesDialog(ImageViewControls.this.display.getActiveShell(), ImageViewControls.this.iv.getX0Save(), ImageViewControls.this.iv.getY0Save(), ImageViewControls.this.iv.getPixelWidthSave(), ImageViewControls.this.iv.getPixelHeightSave(), ImageViewControls.this.iv.getXNameSave(), ImageViewControls.this.iv.getYNameSave());
                    boolean result = dlg.open();
                    if (result) {
                        ImageViewControls.this.iv.setX0Save(dlg.getX0());
                        ImageViewControls.this.iv.setY0Save(dlg.getY0());
                        ImageViewControls.this.iv.setPixelWidthSave(dlg.getPixelWidth());
                        ImageViewControls.this.iv.setPixelHeightSave(dlg.getPixelHeight());
                        ImageViewControls.this.iv.setXNameSave(dlg.getXName());
                        ImageViewControls.this.iv.setYNameSave(dlg.getYName());
                        coordinates.reset(ImageViewControls.this.iv.getCoordOrigin(), ImageViewControls.this.iv.getX0Save(), ImageViewControls.this.iv.getY0Save(), ImageViewControls.this.iv.getPixelWidthSave(), ImageViewControls.this.iv.getPixelHeightSave(), ImageViewControls.this.iv.getXNameSave(), ImageViewControls.this.iv.getYNameSave());
                    } else {
                        ImageViewControls.this.iv.setCoordOrigin(coordOriginSave);
                    }
                } else {
                    ImageViewControls.this.iv.resetCoordinates();
                }
            }
        });
        int coordOrigin = prefs.getInt("coordinatesPreference");
        this.coordCombo.select(coordOrigin);
        if (coordOrigin == 4) {
            Coordinates coordinates = this.iv.getCoordinates();
            try {
                coordinates.reset(coordOrigin, this.iv.getX0Save(), this.iv.getY0Save(), this.iv.getPixelWidthSave(), this.iv.getPixelHeightSave(), this.iv.getXNameSave(), this.iv.getYNameSave());
            }
            catch (NumberFormatException ex) {
                FableUtils.excMsg((Object)this, (String)"Error setting custom coordinates", (Throwable)ex);
                coordinates.resetToDefault();
            }
        } else {
            this.iv.resetCoordinates();
        }
        this.lutCombo = new Combo(row1, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)this.lutCombo);
        int len = paletteNameValues.length;
        items = new String[len];
        int i3 = 0;
        while (i3 < len) {
            items[i3] = paletteNameValues[i3][0];
            ++i3;
        }
        this.lutCombo.setItems(items);
        this.lutCombo.setToolTipText("Set the Color Map");
        this.lutCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int paletteIndex = ImageViewControls.this.lutCombo.getSelectionIndex();
                ImageViewControls.this.iv.setPalette(paletteIndex);
            }
        });
        int paletteIndex = prefs.getInt("palettePreference");
        this.iv.setPalette(paletteIndex);
        this.autoscaleButton = new Button(row2, 0x1000020);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)this.autoscaleButton);
        this.autoscaleButton.setText("Autoscale Intensity");
        this.autoscaleButton.setToolTipText("Scale the palette between the minimum and maximum intensity in the data");
        this.autoscaleButton.setSelection(this.iv.isAutoscale());
        this.autoscaleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageViewControls.this.resetAutoscale();
                ImageViewControls.this.image.displayImage();
            }
        });
        Composite composite = new Composite(row2, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)composite);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setText("Min Intensity:");
        label.setToolTipText("The minimum intensity used by the palette");
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)label);
        this.minimumText = new Text(composite, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).hint(new Point(SWTUtils.getTextWidth((Text)this.minimumText, (int)12), -1)).applyTo((Control)this.minimumText);
        this.minimumText.setText("0");
        this.minimumText.setToolTipText("The minimum intensity used by the palette");
        this.minimumText.setBackground(this.display.getSystemColor(1));
        this.minimumText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                ImageViewControls.this.resetAutoscale();
                ImageViewControls.this.image.displayImage();
            }
        });
        this.minimumText.setEnabled(!this.iv.isAutoscale());
        composite = new Composite(row2, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)composite);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        label = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)label);
        label.setText("Max Intensity:");
        label.setToolTipText("The maximum intensity used by the palette");
        this.maximumText = new Text(composite, 0);
        this.maximumText.setToolTipText("The maximum intensity used by the palette");
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).hint(new Point(SWTUtils.getTextWidth((Text)this.maximumText, (int)12), -1)).applyTo((Control)this.maximumText);
        this.maximumText.setText("0");
        this.maximumText.setBackground(this.display.getSystemColor(1));
        this.maximumText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                ImageViewControls.this.resetAutoscale();
                ImageViewControls.this.image.displayImage();
            }
        });
        this.maximumText.setEnabled(!this.iv.isAutoscale());
        this.aspectButton = new Button(row3, 0x1000020);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)this.aspectButton);
        this.aspectButton.setText("Keep Aspect");
        this.aspectButton.setToolTipText("Keep aspect ratio when displaying image");
        this.aspectButton.setSelection(this.iv.isKeepAspect());
        this.aspectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageViewControls.this.iv.setKeepAspect(ImageViewControls.this.aspectButton.getSelection());
                ImageViewControls.this.image.clearCanvas();
                ImageViewControls.this.image.displayImage();
            }
        });
        this.peaksButton = new Button(row3, 0x1000020);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)this.peaksButton);
        this.peaksButton.setText("Show Peaks");
        this.peaksButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.peaksButton.setToolTipText("Display peaks");
        this.peaksButton.setSelection(this.iv.isPeaksOn());
        this.peaksButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageViewControls.this.iv.setPeaksOn(ImageViewControls.this.peaksButton.getSelection());
                ImageViewControls.this.image.displayImage();
            }
        });
        composite = new Composite(row3, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)composite);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        label = new Label(composite, 0);
        label.setText("Marker Size:");
        label.setToolTipText("Set the size of the markers used to mark peaks (must be odd)");
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)label);
        this.peakMarkerSizeText = new Text(composite, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).hint(new Point(SWTUtils.getTextWidth((Text)this.peakMarkerSizeText, (int)3), -1)).applyTo((Control)this.peakMarkerSizeText);
        this.peakMarkerSizeText.setText(Integer.toString(this.iv.getPeakMarkerSize()));
        this.peakMarkerSizeText.setToolTipText("Set the size of the markers used to mark peaks (must be odd)");
        this.peakMarkerSizeText.setBackground(this.display.getSystemColor(1));
        this.peakMarkerSizeText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                try {
                    int val = Integer.parseInt(ImageViewControls.this.peakMarkerSizeText.getText());
                    if (val <= 0) {
                        SWTUtils.errMsg((Shell)ImageViewControls.this.display.getActiveShell(), (String)"Marker size must be positive");
                        ImageViewControls.this.iv.setPeakMarkerSize(val);
                        ImageViewControls.this.peakMarkerSizeText.setText(Integer.toString(3));
                        return;
                    }
                    if (val % 2 == 0) {
                        SWTUtils.errMsg((Shell)ImageViewControls.this.display.getActiveShell(), (String)"Marker size must be odd to center the marker");
                        ImageViewControls.this.iv.setPeakMarkerSize(3);
                        ImageViewControls.this.peakMarkerSizeText.setText(Integer.toString(3));
                        return;
                    }
                    ImageViewControls.this.iv.setPeakMarkerSize(val);
                }
                catch (NumberFormatException ex) {
                    FableUtils.excNoTraceMsg((Object)this, (String)"Unable to parse peak marker size", (Throwable)ex);
                }
                ImageViewControls.this.image.displayImage();
            }
        });
        GridLayout grid2Cols = new GridLayout();
        Composite canvasComposite = new Composite(parent, 0);
        canvasComposite.setLayout((Layout)grid2Cols);
        canvasComposite.setLayoutData((Object)new GridData(1808));
        this.imageCanvas = new Canvas(canvasComposite, 0);
        this.image.initializeCanvas();
        Composite statusGroup = new Composite(parent, 0);
        GridLayout statusGridLayout = new GridLayout();
        statusGridLayout.numColumns = 8;
        statusGroup.setLayout((Layout)statusGridLayout);
        statusGroup.setLayoutData((Object)new GridData(768));
        this.statusLabel = new Label(statusGroup, 0);
        this.statusLabel.setLayoutData((Object)new GridData(768));
        this.contributeToActionBars();
        this.createContextMenu();
        this.iv.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this.iv);
    }

    public void resetAutoscale() {
        this.iv.setAutoscale(this.autoscaleButton.getSelection());
        if (this.iv.isAutoscale()) {
            this.minimumText.setEnabled(false);
            this.maximumText.setEnabled(false);
            this.iv.setCurrentMinimum(this.iv.getMinimum());
            this.iv.setCurrentMaximum(this.iv.getMaximum());
        } else {
            this.minimumText.setEnabled(true);
            this.maximumText.setEnabled(true);
            try {
                this.iv.setCurrentMinimum(decimalFormat.parse(this.minimumText.getText()).floatValue());
            }
            catch (ParseException ex) {
                FableUtils.excNoTraceMsg((Object)this, (String)"Unable to parse minimum value", (Throwable)ex);
            }
            try {
                this.iv.setCurrentMaximum(decimalFormat.parse(this.maximumText.getText()).floatValue());
            }
            catch (ParseException ex) {
                FableUtils.excNoTraceMsg((Object)this, (String)"Unable to parse maximum value", (Throwable)ex);
            }
        }
    }

    public void createFileNumberText() {
        if (this.fileNumberText == null) {
            this.fileNumberText = new Text(this.statusGroup, 2048);
            this.fileNumberText.setToolTipText("Go to image number");
            this.fileNumberText.setEnabled(true);
            this.fileNumberText.addListener(14, new Listener(){

                public void handleEvent(Event event) {
                    int size;
                    int fileIndex = Integer.parseInt(ImageViewControls.this.fileNumberText.getText());
                    if (fileIndex > (size = ImageViewControls.this.iv.getController().getCurrentsample().getFilteredfiles().size())) {
                        fileIndex = size - 1;
                    }
                    ImageViewControls.this.iv.getController().setCurrentFileIndex(fileIndex);
                }
            });
        }
    }

    private void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actions.controlPanelAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actions.zoomAreaAction);
        manager.add((IAction)this.actions.zoomLineAction);
        manager.add((IAction)this.actions.zoomProfileAction);
        manager.add((IAction)this.actions.zoomReliefAction);
        manager.add((IAction)this.actions.zoomRockingAction);
        manager.add((IAction)this.actions.resetZoomAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actions.copyImageAction);
        manager.add((IAction)this.actions.setDifferenceAction);
        manager.add((IAction)this.actions.displayDifferenceAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actions.slice1DAction);
        manager.add((IAction)this.actions.slice2DAction);
        MenuManager subMenuManager = new MenuManager("Print");
        manager.add((IContributionItem)subMenuManager);
        subMenuManager.add((IAction)this.actions.printSetupAction);
        subMenuManager.add((IAction)this.actions.printPreviewAction);
        subMenuManager.add((IAction)this.actions.printAction);
        subMenuManager = new MenuManager("Edit");
        manager.add((IContributionItem)subMenuManager);
        subMenuManager.add((IAction)this.actions.copyAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actions.resetMinMaxAction);
        manager.add((IAction)this.actions.imageInfoAction);
        manager.add((IAction)this.actions.inputSummaryAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actions.controlPanelAction);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.iv.getViewSite().getActionBars();
        this.fillLocalMenu(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ImageViewControls.this.fillLocalMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.imageCanvas.getAccessible().getControl());
        this.imageCanvas.getAccessible().getControl().setMenu(menu);
    }

    public void setFileNumberText(String text) {
        if (this.fileNumberText != null) {
            this.fileNumberText.setText(text);
        }
    }

    public void setMinMaxText(float[] minmax) {
        this.minimumText.setText(Float.toString(minmax[0]));
        this.maximumText.setText(Float.toString(minmax[1]));
    }

    public float[] getMinMaxText() {
        float[] vals = new float[2];
        try {
            vals[0] = decimalFormat.parse(this.minimumText.getText()).floatValue();
            vals[1] = decimalFormat.parse(this.maximumText.getText()).floatValue();
        }
        catch (ParseException ex) {
            FableUtils.excNoTraceMsg((Object)this, (String)"Unable to read minimum and/or maximum", (Throwable)ex);
            vals[1] = Float.NaN;
            vals[0] = Float.NaN;
        }
        return vals;
    }

    public Combo getCoordCombo() {
        return this.coordCombo;
    }

    public Combo getOrientCombo() {
        return this.orientCombo;
    }

    public Combo getLutCombo() {
        return this.lutCombo;
    }

    public void setStatusText(String text) {
        if (this.statusLabel != null && !this.statusLabel.isDisposed()) {
            this.statusLabel.setText(text);
        }
    }

    public Button getAspectButton() {
        return this.aspectButton;
    }

    public Button getAutoscaleButton() {
        return this.autoscaleButton;
    }

    public Button getPeaksButton() {
        return this.peaksButton;
    }

    public Canvas getImageCanvas() {
        return this.imageCanvas;
    }

    public ImageViewImage getImage() {
        return this.image;
    }

    public void setImage(ImageViewImage image) {
        this.image = image;
    }

    public Composite getControlComposite() {
        return this.controlComposite;
    }

    public boolean getControlCompositeShowing() {
        return this.controlCompositeShowing;
    }

    public void setControlCompositeShowing(boolean controlCompositeShowing) {
        this.controlCompositeShowing = controlCompositeShowing;
    }
}

