/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.actions;

import fable.framework.toolbox.SWTUtils;
import fable.framework.views.FableMessageConsole;
import fable.grainspotter.internal.IVarKeys;
import fable.grainspotter.view.Grains3DView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class OpenGveFileAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction arg0) {
        this.launchAction();
    }

    private void launchAction() {
        if (this.window != null) {
            try {
                if (this.window != null) {
                    this.window.getWorkbench().showPerspective("fable.grainspotter.perspective.grainspotterperspective", this.window);
                }
            }
            catch (PartInitException partInitException) {
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayError("Grainspotter perspective can not be displayed.");
                }
            }
            catch (WorkbenchException e) {
                e.printStackTrace();
            }
            FileDialog fileDlg = new FileDialog(new Shell(), 4096);
            fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_GVE);
            fileDlg.setFilterNames(IVarKeys.FILTER_NAMES_GVE);
            fileDlg.setText("Select an existing g-vector file.");
            String file = fileDlg.open();
            if (file != null && this.window != null) {
                Grains3DView view = (Grains3DView)this.window.getActivePage().findView("fable.grainspotter.grains3dview");
                try {
                    this.window.getActivePage().showView("fable.grainspotter.grains3dview");
                }
                catch (PartInitException e) {
                    SWTUtils.excMsgAsync((String)"Error opening Grains3DView", (Exception)((Object)e));
                }
                view.loadGVectors(file);
            }
        }
    }

    public void selectionChanged(IAction arg0, ISelection arg1) {
    }

    public OpenGveFileAction() {
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"));
        this.setToolTipText("Select g-vector file (.gve)");
        this.setText("Open G-Vector file (.gve)");
    }

    public void run() {
        this.launchAction();
    }
}

