/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class CfFileReader {
    Vector prop = new Vector();
    FileReader file = null;
    String cfStr = null;
    char currentChar;

    private char getCurrentChar() throws IOException {
        if (this.file != null) {
            return (char)this.file.read();
        }
        if (this.cfStr != null) {
            char c = this.cfStr.charAt(0);
            this.cfStr = this.cfStr.substring(1);
            return c;
        }
        return '\u0000';
    }

    private boolean eof() throws IOException {
        if (this.file != null) {
            return !this.file.ready();
        }
        if (this.cfStr != null) {
            return this.cfStr.length() == 0;
        }
        return true;
    }

    private String readWord() throws IOException {
        boolean found = this.currentChar > ' ';
        String ret = "";
        while (!this.eof() && !found) {
            this.currentChar = this.getCurrentChar();
            boolean bl = found = this.currentChar > ' ';
        }
        if (!found) {
            return null;
        }
        if (this.currentChar == '\'') {
            found = false;
            while (!this.eof() && !found) {
                this.currentChar = this.getCurrentChar();
                boolean bl = found = this.currentChar == '\'';
                if (found) continue;
                ret = String.valueOf(ret) + this.currentChar;
            }
            if (!found) {
                System.out.println("CfFileReader.parse: ''' is missing");
                return null;
            }
            this.currentChar = this.getCurrentChar();
            return ret;
        }
        ret = String.valueOf(ret) + this.currentChar;
        if (this.currentChar == ',' || this.currentChar == ':') {
            this.currentChar = this.getCurrentChar();
            return ret;
        }
        found = false;
        while (!this.eof() && !found) {
            this.currentChar = this.getCurrentChar();
            boolean bl = found = this.currentChar == ',' || this.currentChar == ':' || this.currentChar <= ' ';
            if (found) continue;
            ret = String.valueOf(ret) + this.currentChar;
        }
        return ret;
    }

    private boolean parse() throws IOException {
        this.prop.clear();
        this.currentChar = '\u0000';
        String word = this.readWord();
        while (word != null) {
            Item it = new Item(word);
            word = this.readWord();
            if (!word.equals(":")) {
                System.out.println("CfFileReader.parse: ':' expected instead of " + word);
                return false;
            }
            boolean sameItem = true;
            while (sameItem) {
                sameItem = false;
                word = this.readWord();
                if (word != null) {
                    it.addProp(word);
                }
                if ((word = this.readWord()) == null) continue;
                sameItem = word.equals(",");
            }
            this.prop.add(it);
        }
        return true;
    }

    public boolean parseText(String text) {
        boolean ok = false;
        try {
            this.cfStr = text;
            ok = this.parse();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ok;
    }

    public boolean readFile(String filename) {
        boolean ok = false;
        try {
            this.file = new FileReader(filename);
            ok = this.parse();
            this.file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ok;
    }

    public Vector getNames() {
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < this.prop.size()) {
            v.add(this.prop.get(i).toString());
            ++i;
        }
        return v;
    }

    public Vector getParam(String name) {
        boolean found = false;
        int i = 0;
        while (!found && i < this.prop.size()) {
            found = name.equals(this.prop.get(i).toString());
            if (found) continue;
            ++i;
        }
        if (found) {
            Item it = (Item)this.prop.get(i);
            return it.items;
        }
        return null;
    }

    public static void main(String[] args) {
        CfFileReader cf = new CfFileReader();
        if (cf.readFile("test.cfg")) {
            Vector names = cf.getNames();
            System.out.println("Read " + names.size() + " params");
            int i = 0;
            while (i < names.size()) {
                System.out.println(names.get(i).toString());
                Vector values = cf.getParam(names.get(i).toString());
                int j = 0;
                while (j < values.size()) {
                    System.out.println("   " + values.get(j).toString());
                    ++j;
                }
                ++i;
            }
        } else {
            System.out.println("Error while reading config file");
        }
    }

    class Item {
        public Vector items = new Vector();
        String name;

        public Item(String name) {
            this.name = name;
        }

        public void addProp(String value) {
            this.items.add(value);
        }

        public String toString() {
            return this.name;
        }
    }
}

