/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondIterator;
import org.jmol.shape.Shape;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;

public class Sticks
extends Shape {
    short myMask;
    boolean reportAll;
    BitSet bsOrderSet;
    BitSet bsSizeSet;
    BitSet bsColixSet;
    BitSet selectedBonds;

    public void initShape() {
        super.initShape();
        this.myMask = (short)1023;
        this.reportAll = false;
    }

    public void setSize(int n, BitSet bitSet) {
        if (n == Integer.MAX_VALUE) {
            this.selectedBonds = bitSet == null ? null : BitSetUtil.copy(bitSet);
            return;
        }
        if (n == Integer.MIN_VALUE) {
            if (this.bsOrderSet == null) {
                this.bsOrderSet = new BitSet();
            }
            this.bsOrderSet.or(bitSet);
            return;
        }
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BitSet();
        }
        BondIterator bondIterator = this.selectedBonds != null ? this.modelSet.getBondIterator(this.selectedBonds) : this.modelSet.getBondIterator(this.myMask, bitSet);
        short s = (short)n;
        while (bondIterator.hasNext()) {
            this.bsSizeSet.set(bondIterator.nextIndex());
            bondIterator.next().setMad(s);
        }
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if (Logger.debugging) {
            Logger.debug(string + " " + object + " " + bitSet);
        }
        if ("type" == string) {
            this.myMask = ((Integer)object).shortValue();
            return;
        }
        if ("reportAll" == string) {
            this.reportAll = true;
            return;
        }
        if ("reset" == string) {
            this.bsOrderSet = null;
            this.bsSizeSet = null;
            this.bsColixSet = null;
            this.selectedBonds = null;
            return;
        }
        if ("bondOrder" == string) {
            BondIterator bondIterator;
            if (this.bsOrderSet == null) {
                this.bsOrderSet = new BitSet();
            }
            short s = (Short)object;
            BondIterator bondIterator2 = bondIterator = this.selectedBonds != null ? this.modelSet.getBondIterator(this.selectedBonds) : this.modelSet.getBondIterator((short)-2, bitSet);
            while (bondIterator.hasNext()) {
                this.bsOrderSet.set(bondIterator.nextIndex());
                bondIterator.next().setOrder(s);
            }
            return;
        }
        if ("color" == string) {
            BondIterator bondIterator;
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            short s = Graphics3D.getColix(object);
            byte by = JmolConstants.pidOf(object);
            if (by == 18) {
                BondIterator bondIterator3;
                BondIterator bondIterator4 = bondIterator3 = this.selectedBonds != null ? this.modelSet.getBondIterator(this.selectedBonds) : this.modelSet.getBondIterator(this.myMask, bitSet);
                while (bondIterator3.hasNext()) {
                    this.bsColixSet.set(bondIterator3.nextIndex());
                    Bond bond = bondIterator3.next();
                    bond.setColix(Graphics3D.getColix(JmolConstants.getArgbHbondType(bond.getOrder())));
                }
                return;
            }
            if (s == 2 && by != 1) {
                return;
            }
            BondIterator bondIterator5 = bondIterator = this.selectedBonds != null ? this.modelSet.getBondIterator(this.selectedBonds) : this.modelSet.getBondIterator(this.myMask, bitSet);
            while (bondIterator.hasNext()) {
                int n = bondIterator.nextIndex();
                Bond bond = bondIterator.next();
                bond.setColix(s);
                this.bsColixSet.set(n, s != 0);
            }
            return;
        }
        if ("translucency" == string) {
            BondIterator bondIterator;
            if (this.bsColixSet == null) {
                this.bsColixSet = new BitSet();
            }
            boolean bl = ((String)object).equals("translucent");
            BondIterator bondIterator6 = bondIterator = this.selectedBonds != null ? this.modelSet.getBondIterator(this.selectedBonds) : this.modelSet.getBondIterator(this.myMask, bitSet);
            while (bondIterator.hasNext()) {
                this.bsColixSet.set(bondIterator.nextIndex());
                bondIterator.next().setTranslucent(bl, this.translucentLevel);
            }
            return;
        }
        if ("delete" == string) {
            BitSet bitSet2 = (BitSet)object;
            BitSetUtil.deleteBits(this.bsColixSet, bitSet2);
            BitSetUtil.deleteBits(this.bsSizeSet, bitSet2);
            return;
        }
        super.setProperty(string, object, bitSet);
    }

    public Object getProperty(String string, int n) {
        if (string.equals("selectionState")) {
            return this.selectedBonds != null ? "select BONDS " + Escape.escape(this.selectedBonds) + "\n" : "";
        }
        return null;
    }

    public void setModelClickability() {
        Bond[] bondArray = this.modelSet.getBonds();
        int n = this.modelSet.getBondCount();
        while (--n >= 0) {
            Bond bond = bondArray[n];
            if ((bond.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0 || this.modelSet.isAtomHidden(bond.getAtomIndex1()) || this.modelSet.isAtomHidden(bond.getAtomIndex2())) continue;
            bond.getAtom1().setClickable(this.myVisibilityFlag);
            bond.getAtom2().setClickable(this.myVisibilityFlag);
        }
    }

    public String getShapeState() {
        Hashtable hashtable = new Hashtable();
        Bond[] bondArray = this.modelSet.getBonds();
        int n = this.modelSet.getBondCount();
        while (--n >= 0) {
            Bond bond = bondArray[n];
            if (this.reportAll || this.bsSizeSet != null && this.bsSizeSet.get(n)) {
                short s;
                Sticks.setStateInfo(hashtable, n, "wireframe " + ((s = bond.getMad()) == 1 ? "on" : "" + (float)s / 2000.0f));
            }
            if (this.reportAll || this.bsOrderSet != null && this.bsOrderSet.get(n)) {
                Sticks.setStateInfo(hashtable, n, "bondOrder " + JmolConstants.getBondOrderNameFromOrder(bond.getOrder()));
            }
            if (this.bsColixSet == null || !this.bsColixSet.get(n)) continue;
            short s = bond.getColix();
            if ((s & 0xFFFF87FF) == 2) {
                Sticks.setStateInfo(hashtable, n, this.getColorCommand("bonds", (byte)1, s));
                continue;
            }
            Sticks.setStateInfo(hashtable, n, this.getColorCommand("bonds", s));
        }
        return Sticks.getShapeCommands(hashtable, null, -1, "select BONDS") + "\n";
    }
}

