/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.api.MepCalculationInterface;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.quantum.QuantumCalculation;

public class MepCalculation
extends QuantumCalculation
implements MepCalculationInterface {
    float[] charges;

    public void calculate(VolumeData volumeData, BitSet bitSet, Point3f[] point3fArray, float[] fArray) {
        this.atomCoordAngstroms = point3fArray;
        this.charges = fArray;
        this.initialize(40);
        this.setVolume(volumeData, bitSet);
        this.processMep();
    }

    private void processMep() {
        int n;
        this.setMinMax();
        int n2 = 0;
        int n3 = this.atomCoordBohr.length;
        for (n = 0; n < n3; ++n) {
            if (!this.atomSet.get(n)) continue;
            n2 = n;
            break;
        }
        n = n3;
        while (--n >= n2) {
            if (!this.atomSet.get(n)) continue;
            n3 = n + 1;
            break;
        }
        for (n = n2; n < n3; ++n) {
            if (!this.atomSet.get(n)) continue;
            float f = this.atomCoordBohr[n].x;
            float f2 = this.atomCoordBohr[n].y;
            float f3 = this.atomCoordBohr[n].z;
            float f4 = this.charges[n];
            int n4 = this.countsXYZ[0];
            while (--n4 >= 0) {
                this.X2[n4] = this.X[n4] = this.xyzBohr[n4][0] - f;
                int n5 = n4;
                this.X2[n5] = this.X2[n5] * this.X[n4];
            }
            n4 = this.countsXYZ[1];
            while (--n4 >= 0) {
                this.Y2[n4] = this.Y[n4] = this.xyzBohr[n4][1] - f2;
                int n6 = n4;
                this.Y2[n6] = this.Y2[n6] * this.Y[n4];
            }
            n4 = this.countsXYZ[2];
            while (--n4 >= 0) {
                this.Z2[n4] = this.Z[n4] = this.xyzBohr[n4][2] - f3;
                int n7 = n4;
                this.Z2[n7] = this.Z2[n7] * this.Z[n4];
            }
            n4 = this.xMax;
            while (--n4 >= this.xMin) {
                int n8 = this.yMax;
                while (--n8 >= this.yMin) {
                    int n9 = this.zMax;
                    while (--n9 >= this.zMin) {
                        float f5 = this.X2[n4] + this.Y2[n8] + this.Z2[n9];
                        float[] fArray = this.voxelData[n4][n8];
                        int n10 = n9;
                        fArray[n10] = fArray[n10] + (f5 == 0.0f ? f4 * Float.POSITIVE_INFINITY : f4 / (float)Math.sqrt(f5));
                    }
                }
            }
        }
    }
}

