/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.modelviewer;

import fable.grainspotter.modelviewer.GrainGvectorModel;
import fable.grainspotter.modelviewer.GrainInfoModel;
import fable.grainspotter.modelviewer.GrainMeanModel;
import fable.grainspotter.modelviewer.GrainModel;
import fable.grainspotter.modelviewer.GrainOrientationEulerAngleModel;
import fable.grainspotter.modelviewer.GrainOrientationQuaternionModel;
import fable.grainspotter.modelviewer.GrainOrientationRModel;
import fable.grainspotter.modelviewer.GrainUBIMatrixModel;
import fable.grainspotter.modelviewer.GrainUMatrixModel;
import fable.grainspotter.modelviewer.IModelVisitor;
import java.util.ArrayList;
import java.util.List;

public class GrainSyntaxModel
extends GrainModel {
    protected List<GrainSyntaxModel> grains = new ArrayList<GrainSyntaxModel>();
    protected List<GrainInfoModel> info = new ArrayList<GrainInfoModel>();
    protected List<GrainMeanModel> mean = new ArrayList<GrainMeanModel>();
    protected List<GrainUMatrixModel> Umatrix = new ArrayList<GrainUMatrixModel>();
    protected List<GrainUBIMatrixModel> UBImatrix = new ArrayList<GrainUBIMatrixModel>();
    protected List<GrainOrientationRModel> orientationRodrigues = new ArrayList<GrainOrientationRModel>();
    protected List<GrainOrientationQuaternionModel> orientationQuaternion = new ArrayList<GrainOrientationQuaternionModel>();
    protected List<GrainOrientationEulerAngleModel> orientationEuler = new ArrayList<GrainOrientationEulerAngleModel>();
    protected List<GrainGvectorModel> gvectors = new ArrayList<GrainGvectorModel>();
    private int gvecsMeasured = 0;
    private int gvecExpected = 0;
    private static IModelVisitor adder = new Adder();

    public GrainSyntaxModel(String id) {
        this();
        this.id = id;
        this.setName();
    }

    public void setName() {
        this.setName("Grain #" + this.id);
    }

    public GrainSyntaxModel() {
    }

    private void addInfo(GrainInfoModel infotoadd) {
        this.info.add(infotoadd);
        infotoadd.parent = this;
    }

    private void addMean(GrainMeanModel meantoAdd) {
        this.mean.add(meantoAdd);
        meantoAdd.parent = this;
    }

    private void addUMatrix(GrainUMatrixModel i) {
        this.Umatrix.add(i);
        i.parent = this;
    }

    private void addUBIMatrix(GrainUBIMatrixModel i) {
        this.UBImatrix.add(i);
        i.parent = this;
    }

    private void addOrientationR(GrainOrientationRModel i) {
        this.orientationRodrigues.add(i);
        i.parent = this;
    }

    private void addOrientationQ(GrainOrientationQuaternionModel i) {
        this.orientationQuaternion.add(i);
        i.parent = this;
    }

    private void addOrientationEuler(GrainOrientationEulerAngleModel i) {
        this.orientationEuler.add(i);
        i.parent = this;
    }

    private void addGvector(GrainGvectorModel i) {
        this.gvectors.add(i);
        i.parent = this;
    }

    private void addGrain(GrainSyntaxModel grain) {
        this.grains.add(grain);
        grain.parent = this;
    }

    public List<GrainInfoModel> getInfo() {
        return this.info;
    }

    public List<GrainMeanModel> getmean() {
        return this.mean;
    }

    public List<GrainUMatrixModel> getUMatrix() {
        return this.Umatrix;
    }

    public List<GrainUBIMatrixModel> getUBIMatrix() {
        return this.UBImatrix;
    }

    public List<GrainOrientationRModel> getOrientationRodrigues() {
        return this.orientationRodrigues;
    }

    public List<GrainOrientationQuaternionModel> getOrientationQuaternion() {
        return this.orientationQuaternion;
    }

    public List<GrainOrientationEulerAngleModel> getOrientationEuList() {
        return this.orientationEuler;
    }

    public List<GrainSyntaxModel> getGrains() {
        return this.grains;
    }

    public List<GrainGvectorModel> getGVectors() {
        return this.gvectors;
    }

    public void add(GrainModel toAdd) {
        toAdd.accept(adder, this);
    }

    public void add(GrainGvectorModel toAdd) {
        toAdd.accept(adder, this);
    }

    @Override
    public void accept(IModelVisitor visitor, Object passAlongArgument) {
        visitor.visitSyntax(this, passAlongArgument);
    }

    public String toString() {
        return this.getName();
    }

    public void add(GrainInfoModel infosModel, String string) {
    }

    public void addGveMeasured(String string) {
        try {
            int value = Integer.valueOf(string);
            this.gvecsMeasured += value;
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public int getGvecsMeasured() {
        return this.gvecsMeasured;
    }

    public void setGvecsMeasured(int gvecsMeasured) {
        this.gvecsMeasured = gvecsMeasured;
    }

    public int getgvecExpected() {
        return this.gvecExpected;
    }

    public void setgvecExpected(int gVectExpected) {
        this.gvecExpected = gVectExpected;
    }

    public void addGveExpected(String string) {
        try {
            int value = Integer.valueOf(string);
            this.gvecExpected += value;
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private static class Adder
    implements IModelVisitor {
        private Adder() {
        }

        @Override
        public void visitGrainInfo(GrainInfoModel infos, Object passAlongArgument) {
            ((GrainSyntaxModel)passAlongArgument).addInfo(infos);
        }

        @Override
        public void visitGrainUMatrix(GrainUMatrixModel matrix, Object passAlongArgument) {
            ((GrainSyntaxModel)passAlongArgument).addUMatrix(matrix);
        }

        @Override
        public void visitSyntax(GrainSyntaxModel grain, Object passAlongArgument) {
            ((GrainSyntaxModel)passAlongArgument).addGrain(grain);
        }

        @Override
        public void visitGVector(GrainGvectorModel grainGvectorModel, Object passAlongArgument) {
            ((GrainSyntaxModel)passAlongArgument).addGvector(grainGvectorModel);
        }

        @Override
        public void visitGrainMeanIA(GrainMeanModel mean, Object passAlongArgument) {
            ((GrainSyntaxModel)passAlongArgument).addMean(mean);
        }

        @Override
        public void visitGrainPhiOrientation(GrainOrientationEulerAngleModel euler, Object passAlongArgument) {
            ((GrainSyntaxModel)passAlongArgument).addOrientationEuler(euler);
        }

        @Override
        public void visitGrainQorienation(GrainOrientationQuaternionModel orienation, Object passAlongArgument) {
            ((GrainSyntaxModel)passAlongArgument).addOrientationQ(orienation);
        }

        @Override
        public void visitGrainRorientation(GrainOrientationRModel orientation, Object passAlongArgument) {
            ((GrainSyntaxModel)passAlongArgument).addOrientationR(orientation);
        }

        @Override
        public void visitGrainUBIMatrix(GrainUBIMatrixModel matrix, Object passAlongArgument) {
            ((GrainSyntaxModel)passAlongArgument).addUBIMatrix(matrix);
        }
    }
}

