/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.editors;

import fable.framework.logging.FableLogger;
import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.FloatText;
import fable.framework.toolbox.IntegerText;
import fable.framework.toolbox.LookAndFeel;
import fable.framework.toolbox.SWTUtils;
import fable.framework.toolbox.StringText;
import fable.framework.toolbox.ToolBox;
import fable.framework.toolbox.TypedText;
import fable.framework.views.FableMessageConsole;
import fable.grainspotter.actions.RunAction;
import fable.grainspotter.actions.SaveAsInifile;
import fable.grainspotter.actions.SaveInifile;
import fable.grainspotter.editors.GrainspotterIniInput;
import fable.grainspotter.editors.GrainspotterTextEditor;
import fable.grainspotter.internal.IVarKeys;
import fable.grainspotter.rcp.Activator;
import fable.grainspotter.run.GrainSpotter;
import fable.grainspotter.run.GrainSpotterException;
import java.io.File;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Vector;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.examples.rcp.texteditor.editors.SimpleEditor;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.part.MultiPageEditorPart;

public class GrainspotterInputEditor
extends MultiPageEditorPart
implements IResourceChangeListener,
IPropertyChangeListener,
IReusableEditor {
    private static final String ID = "fable.grainspotter.editors.GrainspotterInputEditor";
    private SimpleEditor editor;
    private GrainspotterIniInput input;
    private boolean dirty = false;
    private Spinner spaceGroupSpinner;
    private Combo spaceGroupCombo;
    private Combo spaceGroupTypeCombo;
    private Table dsRange;
    private Table tthRange;
    private Table etaRange;
    private Table omegaRange;
    private StringText txtFilegve;
    private StringText txtFilelog;
    private IntegerText cutsMinMeasurement;
    private FloatText cutsMinCompletenessText;
    private FloatText cutsMinUniqueness;
    private FloatText eulerStep;
    private FloatText minfracg;
    private IntegerText random;
    private Button fitpositionYes;
    private Button fitpositionFalse;
    private FloatText sigmaTth;
    private FloatText sigmaEta;
    private FloatText sigmaOmega;
    private FloatText nsigma;
    private int spaceGroup = 1;
    private int spaceGroupType = 0;
    private static String command = "GrainSpotter";
    public static GrainSpotter grainSpotter;
    private static final int numColIniGroup = 2;
    private static final int MAXROWS = 1;
    private Shell shell;
    private Display display;
    private Composite parent;
    private IMemento memento = null;
    private static String initialDirIni;
    private static String initialDirGve;
    private static String initialDirLog;
    protected int activeColumn;
    private FloatText omegaDeltaText;
    private Group tthRangeGroup;
    private Group dsGroup;
    ImageDescriptor deleteDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.grainspotter", (String)"images/delete.gif");
    ImageDescriptor addDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.grainspotter", (String)"images/add.gif");
    private IntegerText hklRingsText;
    private Button chooseDspacing;
    private Button chooseTthRange;
    private SaveInifile save;
    private SaveAsInifile saveas;

    static {
        initialDirIni = null;
        initialDirGve = null;
        initialDirLog = null;
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
    }

    public void doSave(IProgressMonitor arg0) {
        this.save();
    }

    public void save() {
        this.getEditorSite().getWorkbenchWindow();
        if (this.setOptions()) {
            block3: {
                this.dirty = false;
                this.firePropertyChange(257);
                try {
                    this.input.getInputFile().save();
                }
                catch (GrainSpotterException e) {
                    if (FableMessageConsole.console == null) break block3;
                    FableMessageConsole.console.displayError(e.get_message());
                    SWTUtils.errMsgAsync((String)e.get_message());
                }
            }
            this.firePropertyChange(258);
            this.setInput((IEditorInput)this.input);
            GrainSpotter.getInstance().setInput((IEditorInput)this.input);
        }
    }

    public void doSaveAs() {
        if (this.setOptions()) {
            FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 8192);
            String file = dialog.open();
            boolean confirm = true;
            if (file != null && ToolBox.checkIfFileExists((String)file)) {
                confirm = FableUtils.confirmMsg((Object)((Object)this), (String)(String.valueOf(file) + " already exists. Do you want to overwrite it?"));
            }
            if (confirm) {
                this.doSaveAs(file);
            }
        }
    }

    public void doSaveAs(String file) {
        block2: {
            this.firePropertyChange(258);
            try {
                this.input.getInputFile().saveAs(file);
            }
            catch (GrainSpotterException e) {
                if (FableMessageConsole.console == null) break block2;
                FableMessageConsole.console.displayError(e.get_message());
                SWTUtils.errMsgAsync((String)e.get_message());
            }
        }
        this.dirty = false;
        this.firePropertyChange(257);
        this.setPageText(0, this.input.getName());
        this.input.getInputFile().setFile(file);
        File newFile = new File(file);
        Path location = new Path(newFile.getAbsolutePath());
        this.input = new GrainspotterIniInput((IPath)location);
        grainSpotter.setInput((IEditorInput)this.input);
        this.firePropertyChange(258);
        this.setInput((IEditorInput)this.input);
        this.setPartName(this.input.getName());
        GrainSpotter.getInstance().setInput((IEditorInput)this.input);
        this.setPageText(0, this.input.inputFile.iniFileName);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        block3: {
            if (!(editorInput instanceof GrainspotterIniInput)) {
                throw new PartInitException("Invalid Input: Must be ini file");
            }
            super.init(site, editorInput);
            try {
                this.setSite((IWorkbenchPartSite)site);
                this.setInput(editorInput);
                this.input = (GrainspotterIniInput)editorInput;
                this.input.inputFile.parseIniFile(this.input.getName());
            }
            catch (GrainSpotterException e) {
                if (FableMessageConsole.console == null) break block3;
                FableMessageConsole.console.displayError(e.get_message());
                SWTUtils.errMsgAsync((String)e.get_message());
            }
        }
        this.setPartName(this.input.getName());
        GrainSpotter.getInstance().setInput((IEditorInput)this.input);
        this.getEditorSite().getActionBars().setGlobalActionHandler("fable.grainspotter.actions.RunAction", (IAction)new RunAction());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public GrainspotterInputEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    void createPage0() {
        this.parent = this.getContainer();
        this.shell = this.parent.getShell();
        this.display = this.parent.getDisplay();
        if (grainSpotter == null) {
            grainSpotter = GrainSpotter.getInstance();
        }
        if (this.memento != null) {
            initialDirIni = this.memento.getString("initialDirIni");
            initialDirGve = this.memento.getString("initialDirGve");
            initialDirLog = this.memento.getString("initialDirLog");
        }
        GridLayout oneColGridLayout = new GridLayout();
        oneColGridLayout.numColumns = 1;
        oneColGridLayout.makeColumnsEqualWidth = true;
        GridLayout twoColGridLayout = new GridLayout();
        twoColGridLayout.numColumns = 2;
        twoColGridLayout.makeColumnsEqualWidth = true;
        GridLayout threeColGridLayout = new GridLayout();
        threeColGridLayout.numColumns = 3;
        threeColGridLayout.makeColumnsEqualWidth = true;
        GridLayout forColGridLayout = new GridLayout();
        forColGridLayout.numColumns = 4;
        forColGridLayout.makeColumnsEqualWidth = true;
        GridLayout sixColGridLayout = new GridLayout();
        sixColGridLayout.numColumns = 6;
        sixColGridLayout.makeColumnsEqualWidth = true;
        ScrolledComposite sc = new ScrolledComposite(this.parent, 768);
        this.parent.setLayout((Layout)oneColGridLayout);
        Composite container = new Composite((Composite)sc, 16);
        sc.setContent((Control)container);
        container.setLayout((Layout)forColGridLayout);
        container.setLayoutData((Object)new GridData(16384, 16, false, false));
        this.createGroupDataSpecs(container);
        this.createGroupSpacegrp(container);
        this.createGroupThree(container);
        this.createGroupCuts(container);
        this.createGroupUncertainties(container);
        Group chooseBetween = new Group(container, 0);
        chooseBetween.setText("");
        chooseBetween.setLayout((Layout)new GridLayout(2, false));
        chooseBetween.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.chooseDspacing = new Button((Composite)chooseBetween, 16);
        this.chooseDspacing.setText("Define d-spacing range");
        this.chooseDspacing.setSelection(true);
        this.chooseTthRange = new Button((Composite)chooseBetween, 16);
        this.chooseTthRange.setText("or tth range");
        this.chooseDspacing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrainspotterInputEditor.this.setEnableGroup((Composite)GrainspotterInputEditor.this.dsGroup, ((Button)e.widget).getSelection());
                GrainspotterInputEditor.this.setEnableGroup((Composite)GrainspotterInputEditor.this.tthRangeGroup, !((Button)e.widget).getSelection());
            }
        });
        this.chooseTthRange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrainspotterInputEditor.this.setEnableGroup((Composite)GrainspotterInputEditor.this.dsGroup, !((Button)e.widget).getSelection());
                GrainspotterInputEditor.this.setEnableGroup((Composite)GrainspotterInputEditor.this.tthRangeGroup, ((Button)e.widget).getSelection());
            }
        });
        String[] columnsProperties = new String[]{"Minimum", "Maximum"};
        this.createGroupDsRange((Composite)chooseBetween, columnsProperties);
        this.createGroupTthrange((Composite)chooseBetween, columnsProperties);
        this.createGroupEtaRange(container, columnsProperties);
        this.createGroupOmegaRange(container, columnsProperties);
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        sc.setMinSize(container.computeSize(-1, -1));
        int index = this.addPage((Control)sc);
        this.setPageText(index, "View");
        this.setEnableGroup((Composite)this.dsGroup, this.chooseDspacing.getSelection());
        this.setEnableGroup((Composite)this.tthRangeGroup, !this.chooseDspacing.getSelection());
        this.setHelpContextToChildren(container);
    }

    private void setHelpContextToChildren(Composite parent2) {
        Control[] children = parent2.getChildren();
        int i = 0;
        while (i < children.length) {
            IWorkbenchHelpSystem helpSystem;
            if (children[i] instanceof Group) {
                this.setHelpContextToChildren((Composite)((Group)children[i]));
            } else if (children[i] instanceof TypedText) {
                TypedText text = (TypedText)children[i];
                if (text.getTextField().getToolTipText() == null) {
                    text.getTextField().setToolTipText("Press " + ToolBox.getHelpContextTooltip() + " for Focus.");
                } else {
                    text.getTextField().setToolTipText(String.valueOf(text.getTextField().getToolTipText()) + " \n\nPress " + ToolBox.getHelpContextTooltip() + " for Focus");
                }
                IWorkbenchHelpSystem helpSystem2 = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
                helpSystem2.setHelp((Control)text.getTextField(), "fable.grainspotter.inifile");
            } else if (children[i] instanceof Text) {
                helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
                helpSystem.setHelp((Control)((Text)children[i]), "fable.grainspotter.inifile");
                Text text = (Text)children[i];
                if (text.getToolTipText() == null) {
                    text.setToolTipText("Press " + ToolBox.getHelpContextTooltip() + " for Focus.");
                } else {
                    text.setToolTipText(String.valueOf(text.getToolTipText()) + " \n\nPress " + ToolBox.getHelpContextTooltip() + " for Focus");
                }
            } else if (children[i] instanceof Table) {
                helpSystem = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
                helpSystem.setHelp((Control)((Table)children[i]), "fable.grainspotter.inifile");
            }
            ++i;
        }
    }

    private void createGroupOmegaRange(Composite container, String[] columnsProperties) {
        Group omegaGroup = LookAndFeel.getGroup((Composite)container, (String)"Omegaspecs [-180/180 deg.]", (int)2, (int)1);
        GridData gdForOmega = new GridData(4, 4, true, false);
        omegaGroup.setLayoutData((Object)gdForOmega);
        omegaGroup.setToolTipText("The active interval in the omega angle.");
        this.omegaDeltaText = new FloatText((Composite)omegaGroup, 4, "Delta");
        this.omegaDeltaText.setMaxValue(new Float(1.0).floatValue(), true);
        this.omegaDeltaText.setMinValue(new Float(0.0).floatValue(), false);
        this.omegaDeltaText.setToolTipText("defines the omega step sizes for each diffraction used in the data collection");
        this.omegaDeltaText.getTextField().setToolTipText("defines the omega step sizes for each diffraction used in the data collection");
        this.omegaDeltaText.set_isRequiredField(false);
        GridData deltaGridData = new GridData(4, 2, false, true, 2, 1);
        this.omegaDeltaText.setLayoutData((Object)deltaGridData);
        this.omegaRange = new Table((Composite)omegaGroup, 68352);
        this.omegaRange.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 2));
        this.omegaRange.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int x = 0;
                int i = 0;
                while (i < GrainspotterInputEditor.this.omegaRange.getColumnCount()) {
                    if (e.x <= (x += GrainspotterInputEditor.this.omegaRange.getColumn(i).getWidth())) {
                        GrainspotterInputEditor.this.activeColumn = i;
                        break;
                    }
                    ++i;
                }
            }
        });
        this.createMinMaxColumnOmegaRange(columnsProperties);
        this.createRows(this.omegaRange, 1);
        this.createAddButtonOmegaRange((Composite)omegaGroup);
        this.createRemoveItemButtonOmegarange((Composite)omegaGroup);
        this.omegaRange.setToolTipText("You can add several range for omega.");
        this.triggerTableSelectionOmegaRange();
    }

    private void createGroupEtaRange(Composite container, String[] columnsProperties) {
        Group grp_EtatSpec = LookAndFeel.getGroup((Composite)container, (String)"Eta range [0-360 deg.]", (int)2, (int)1);
        grp_EtatSpec.setLayoutData((Object)new GridData(4, 4, true, false));
        grp_EtatSpec.setToolTipText("etarange [min max], multiple ranges can be specified.");
        this.etaRange = new Table((Composite)grp_EtatSpec, 68352);
        this.etaRange.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 2));
        this.etaRange.setToolTipText("etarange [min max], eta angle range ");
        this.etaRange.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int x = 0;
                int i = 0;
                while (i < GrainspotterInputEditor.this.etaRange.getColumnCount()) {
                    if (e.x <= (x += GrainspotterInputEditor.this.etaRange.getColumn(i).getWidth())) {
                        GrainspotterInputEditor.this.activeColumn = i;
                        break;
                    }
                    ++i;
                }
            }
        });
        this.createMinMaxColumnEtaRange(columnsProperties);
        this.createRows(this.etaRange, 1);
        this.createAddButtonEtaRange((Composite)grp_EtatSpec);
        this.createRemoveItemButtonEtaRange((Composite)grp_EtatSpec);
        ((GridData)this.etaRange.getLayoutData()).grabExcessVerticalSpace = true;
        ((GridData)this.etaRange.getLayoutData()).verticalSpan = 2;
        ((GridData)this.etaRange.getLayoutData()).verticalAlignment = 4;
        this.etaRange.setToolTipText("You can add several range for eta.");
        this.triggerTableSelectionEtaRange();
    }

    public void setEnableGroup(Composite parent, boolean benable) {
        Control[] element = parent.getChildren();
        parent.setEnabled(benable);
        int i = 0;
        while (i < element.length) {
            if (element[i] instanceof Composite) {
                if (element[i] instanceof Group) {
                    this.setEnableGroup((Composite)element[i], benable);
                } else if (benable) {
                    element[i].setBackground(this.display.getSystemColor(1));
                } else {
                    element[i].setBackground(this.display.getSystemColor(22));
                }
            } else {
                element[i].setEnabled(benable);
            }
            ++i;
        }
    }

    private void createGroupTthrange(Composite container, String[] columnsProperties) {
        this.tthRangeGroup = LookAndFeel.getGroup((Composite)container, (String)"tth range [0-360 deg.]", (int)2, (int)1);
        this.tthRangeGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.tthRangeGroup.setToolTipText("tth range. Multiple ranges can be specified.");
        this.tthRange = new Table((Composite)this.tthRangeGroup, 68352);
        this.tthRange.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 2));
        this.tthRange.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int x = 0;
                int i = 0;
                while (i < GrainspotterInputEditor.this.tthRange.getColumnCount()) {
                    if (e.x <= (x += GrainspotterInputEditor.this.tthRange.getColumn(i).getWidth())) {
                        GrainspotterInputEditor.this.activeColumn = i;
                        break;
                    }
                    ++i;
                }
            }
        });
        this.createMinMaxColumntthRange(columnsProperties);
        this.createRows(this.tthRange, 1);
        this.createAddButtonTthrange((Composite)this.tthRangeGroup);
        this.createRemoveItemButtonTthRange((Composite)this.tthRangeGroup);
        this.tthRange.setToolTipText("You can add several range for tth.");
        this.triggerTableSelectionTthRange();
    }

    private void createGroupDsRange(Composite container, String[] columnsProperties) {
        this.dsGroup = LookAndFeel.getGroup((Composite)container, (String)"D-spacing in \u00c5", (int)2, (int)1);
        GridData gdfords = new GridData(4, 4, true, false);
        this.dsGroup.setLayoutData((Object)gdfords);
        this.dsGroup.setToolTipText("d-spacing range, multiple ranges can be specified.");
        this.dsRange = new Table((Composite)this.dsGroup, 68352);
        this.dsRange.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 2));
        this.dsRange.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int x = 0;
                int i = 0;
                while (i < GrainspotterInputEditor.this.dsRange.getColumnCount()) {
                    if (e.x <= (x += GrainspotterInputEditor.this.dsRange.getColumn(i).getWidth())) {
                        GrainspotterInputEditor.this.activeColumn = i;
                        break;
                    }
                    ++i;
                }
            }
        });
        this.createMinMaxColumnDsRange(columnsProperties);
        this.createRows(this.dsRange, 1);
        this.createAddButtonDsRange((Composite)this.dsGroup);
        this.createRemoveItemButtonDsRange((Composite)this.dsGroup);
        this.dsRange.setToolTipText("You can add several range for d-spacing.");
        this.triggerTableSelectionDsRange();
    }

    private void createGroupDataSpecs(Composite container) {
        Group grp_dataSpec = LookAndFeel.getGroup((Composite)container, (String)"Filespecs", (int)3, (int)2);
        grp_dataSpec.setToolTipText("filespecs");
        new Label((Composite)grp_dataSpec, 0).setText("gve file");
        this.txtFilegve = new StringText((Composite)grp_dataSpec, 0, "");
        this.txtFilegve.setToolTipText("Path and filenames of the input g-vector file (from ImageD11).");
        this.txtFilegve.getTextField().setToolTipText("Path and filenames of the input g-vector file (from ImageD11).");
        this.txtFilegve.set_isRequiredField(true);
        this.txtFilegve.setLayoutData((Object)new GridData(4, 16, true, false));
        this.txtFilegve.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    String filename = GrainspotterInputEditor.this.txtFilegve.getText();
                    File file = new File(filename);
                    GrainspotterInputEditor.this.loadGve(filename, file.getAbsolutePath());
                }
            }
        });
        Button btnBrowsegve = new Button((Composite)grp_dataSpec, 8);
        btnBrowsegve.setText("Browse");
        btnBrowsegve.setToolTipText("Select or enter a gve file.");
        btnBrowsegve.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDlg = new FileDialog(GrainspotterInputEditor.this.shell, 0);
                fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_GVE);
                fileDlg.setFilterNames(IVarKeys.FILTER_NAMES_GVE);
                fileDlg.setFilterPath(initialDirGve);
                fileDlg.setText("Select an existing gve file or enter a new file name");
                String file = fileDlg.open();
                if (file != null) {
                    GrainspotterInputEditor.this.txtFilegve.set_Text(file);
                    GrainspotterInputEditor.this.loadGve(file, fileDlg.getFilterPath());
                }
            }
        });
        new Label((Composite)grp_dataSpec, 0).setText("log file");
        this.txtFilelog = new StringText((Composite)grp_dataSpec, 0, "");
        this.txtFilelog.setToolTipText("Set output grains file containing the crystallographic orientations, \ninformation about fitting reflections etc..");
        this.txtFilelog.set_isRequiredField(true);
        this.txtFilelog.getTextField().setToolTipText("Set output grains file containing the crystallographic orientations,\ninformation about fitting reflections etc..");
        this.txtFilelog.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    File myFile = new File(GrainspotterInputEditor.this.txtFilelog.getText());
                    String path = "";
                    if (myFile != null) {
                        path = myFile.getPath();
                    }
                    GrainspotterInputEditor.this.setLogFile(GrainspotterInputEditor.this.txtFilelog.getText(), path);
                }
            }
        });
        this.txtFilelog.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String file = GrainspotterInputEditor.this.txtFilelog.getText();
                File myFile = new File(file);
                String path = "";
                if (myFile != null) {
                    path = myFile.getPath();
                }
                GrainspotterInputEditor.this.setLogFile(file, path);
            }
        });
        this.txtFilelog.setLayoutData((Object)new GridData(4, 16, false, false));
        Button btnBrowselog = new Button((Composite)grp_dataSpec, 8);
        btnBrowselog.setText("Browse");
        btnBrowselog.setToolTipText("Select or enter a log file");
        btnBrowselog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDlg = new FileDialog(GrainspotterInputEditor.this.shell, 8192);
                fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_LOG);
                fileDlg.setFilterNames(IVarKeys.FILTER_NAMES_LOG);
                fileDlg.setFilterPath(initialDirLog);
                fileDlg.setText("Select an existing log file or enter a new file name");
                String file = fileDlg.open();
                GrainspotterInputEditor.this.txtFilelog.set_Text(file);
                if (file != null) {
                    GrainspotterInputEditor.this.setLogFile(file, new File(file).getPath());
                }
            }
        });
    }

    private void setLogFile(String file, String filePath) {
        initialDirLog = filePath;
        grainSpotter.setLogFilePath(initialDirLog);
        this.input.inputFile.setLogFilePath(initialDirLog);
        GrainspotterInputEditor.synchronizeInitialDirectories(initialDirLog);
        if (!file.endsWith(".log")) {
            file = String.valueOf(file) + ".log";
        }
    }

    private void loadGve(String file, String gveDirectory) {
        initialDirGve = gveDirectory;
        grainSpotter.setGveFilePath(initialDirGve);
        GrainspotterInputEditor.synchronizeInitialDirectories(initialDirGve);
        if (!file.endsWith(".gve")) {
            file = String.valueOf(file) + ".gve";
        }
        this.dirty = true;
        this.firePropertyChange(257);
        this.input.getInputFile().setGveFileName(file);
        grainSpotter.setgVectorFile(file);
    }

    private void createGroupSpacegrp(Composite container) {
        Group grp_spaceGroup = LookAndFeel.getGroup((Composite)container, (String)"", (int)6, (int)2);
        grp_spaceGroup.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        grp_spaceGroup.setToolTipText("The space group id (number) is needed to calculate transform a determined orientation \ninto the unique part of orientation space. \nHence the same solution will always have the same U matrix, \nnot one of the other possible transformations allowed by the space group symmetry.");
        new Label((Composite)grp_spaceGroup, 0).setText("Crystal system");
        this.spaceGroupTypeCombo = new Combo((Composite)grp_spaceGroup, 28);
        this.spaceGroupTypeCombo.setLayoutData((Object)new GridData(16384, 16, true, false));
        int i = 0;
        while (i < IVarKeys.SPACE_GROUP_TYPES.length) {
            this.spaceGroupTypeCombo.add(IVarKeys.SPACE_GROUP_TYPES[i]);
            ++i;
        }
        this.spaceGroupTypeCombo.setToolTipText("The space group id (number) is needed to calculate transform a determined orientation \ninto the unique part of orientation space. \nHence the same solution will always have the same U matrix, \nnot one of the other possible transformations allowed by the space group symmetry.");
        this.spaceGroupTypeCombo.select(0);
        this.spaceGroupTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GrainspotterInputEditor.this.spaceGroupType = GrainspotterInputEditor.this.spaceGroupTypeCombo.getSelectionIndex();
                GrainspotterInputEditor.this.spaceGroupCombo.setItems(IVarKeys.SPACE_GROUPS[GrainspotterInputEditor.this.spaceGroupType]);
                GrainspotterInputEditor.this.spaceGroupCombo.select(0);
                GrainspotterInputEditor.this.spaceGroup = IVarKeys.SPACE_GROUP_MINIMUM[GrainspotterInputEditor.this.spaceGroupType];
                GrainspotterInputEditor.this.spaceGroupSpinner.setSelection(GrainspotterInputEditor.this.spaceGroup);
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        new Label((Composite)grp_spaceGroup, 0).setText("Space group");
        this.spaceGroupCombo = new Combo((Composite)grp_spaceGroup, 28);
        this.spaceGroupCombo.setLayoutData((Object)new GridData(4, 16, true, false));
        this.spaceGroupCombo.setToolTipText("The space group id (number) is needed to calculate transform a determined orientation \ninto the unique part of orientation space. \nHence the same solution will always have the same U matrix, \nnot one of the other possible transformations allowed by the space group symmetry.");
        i = 0;
        while (i < IVarKeys.SPACE_GROUPS[this.spaceGroupType].length) {
            this.spaceGroupCombo.add(IVarKeys.SPACE_GROUPS[this.spaceGroupType][i]);
            ++i;
        }
        this.spaceGroupTypeCombo.select(0);
        this.spaceGroupCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GrainspotterInputEditor.this.spaceGroup = IVarKeys.SPACE_GROUP_MINIMUM[GrainspotterInputEditor.this.spaceGroupType] + GrainspotterInputEditor.this.spaceGroupCombo.getSelectionIndex();
                GrainspotterInputEditor.this.spaceGroupSpinner.setSelection(GrainspotterInputEditor.this.spaceGroup);
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        new Label((Composite)grp_spaceGroup, 0).setText("Number in the IUCr tables");
        this.spaceGroupSpinner = new Spinner((Composite)grp_spaceGroup, 2068);
        this.spaceGroupSpinner.setToolTipText("The space group id (number) is needed to calculate transform a determined orientation \ninto the unique part of orientation space. \nHence the same solution will always have the same U matrix, \nnot one of the other possible transformations allowed by the space group symmetry.");
        this.spaceGroupSpinner.setLayoutData((Object)new GridData(16384, 16, true, false));
        this.spaceGroupSpinner.setMaximum(230);
        this.spaceGroupSpinner.setMinimum(1);
        this.spaceGroupSpinner.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GrainspotterInputEditor.this.spaceGroup = GrainspotterInputEditor.this.spaceGroupSpinner.getSelection();
                GrainspotterInputEditor.this.setSpaceGroup(GrainspotterInputEditor.this.spaceGroup);
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
    }

    private void createGroupCuts(Composite container) {
        Group cutseulerComposite = LookAndFeel.getGroup((Composite)container, (String)"Cuts", (int)2, (int)1);
        cutseulerComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        cutseulerComposite.setToolTipText("cuts [min_measuments min_completeness min_uniqueness] :\nMinimum requirement for accepting a grain solution");
        new Label((Composite)cutseulerComposite, 0).setText("Min. measurement");
        this.cutsMinMeasurement = new IntegerText((Composite)cutseulerComposite, 4, "");
        this.cutsMinMeasurement.getTextField().setToolTipText("min_no_measurements: \nMinimum number of g-vectors assigned to the grain (integer value > 3)");
        this.cutsMinMeasurement.setMinValue(new Integer(3).intValue(), false);
        this.cutsMinMeasurement.setToolTipText("min_no_measurements: \nMinimum number of g-vectors assigned to the grain (integer value > 3)");
        this.cutsMinMeasurement.set_isRequiredField(false);
        new Label((Composite)cutseulerComposite, 0).setText("Min. completeness");
        this.cutsMinMeasurement.getTextField().setToolTipText("cuts [min_measuments min_completeness min_uniqueness] :Minimum requirement for accepting a grain solution");
        this.cutsMinCompletenessText = new FloatText((Composite)cutseulerComposite, 4, "");
        this.cutsMinCompletenessText.setMaxValue(new Float(1.0).floatValue(), true);
        this.cutsMinCompletenessText.setToolTipText("min_completeness: \nThe minimum fraction of expected reflections assigned (#assigned relfections/#theretical reflections) to the grain,\n (floating number between 0 and 1).");
        this.cutsMinCompletenessText.set_isRequiredField(false);
        this.cutsMinCompletenessText.getTextField().setToolTipText("min_completeness: \nThe minimum fraction of expected reflections assigned (#assigned relfections/#theretical reflections) to the grain,\n (floating number between 0 and 1) .");
        new Label((Composite)cutseulerComposite, 0).setText("Min. uniqueness");
        this.cutsMinUniqueness = new FloatText((Composite)cutseulerComposite, 4, "");
        this.cutsMinUniqueness.setMaxValue(new Float(1.0).floatValue(), true);
        this.cutsMinUniqueness.setToolTipText("min_uniqueness: \nMinimum fraction of expected reflections assigned to the grain (0<min completeness<1); \noption cuts [min_measuments min_completeness min_uniqueness] .");
        this.cutsMinUniqueness.set_isRequiredField(false);
    }

    private void createGroupUncertainties(Composite container) {
        Group uncertGroup = LookAndFeel.getGroup((Composite)container, (String)"Uncertainties (in degrees)", (int)2, (int)2);
        uncertGroup.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        uncertGroup.setToolTipText("uncertainties [sigma_tth sigma_eta sigma_omega]: Until full error estimation \nis available on the gvectors in the input gvector file, \nsigma_tth, sigma_eta and sigma_omega give YOUR estimation on \nthe uncertainties in degrees on eta, omega and tth.");
        new Label((Composite)uncertGroup, 0).setText("Sigma tth");
        this.sigmaTth = new FloatText((Composite)uncertGroup, 0, "");
        this.sigmaTth.setToolTipText("uncertainties sigma_twotheta[degrees]: \nUntil full error estimation is available on the g-vectors in the input g-vector file, sigma_twotheta, sigma_eta and sigma_omega give YOUR estimation on the uncertainties in degrees on eta, omega and twotheta. \nSince these are estimated by the user and since they \"decide\" whether a theoretical gvector match an observed, \nthese parameters are important to vary a bit to obtain a set making GrainSpotter able to determine the grain orientations. ");
        this.sigmaTth.getTextField().setToolTipText("uncertainties sigma_twotheta[degrees]: \nUntil full error estimation is available on the g-vectors in the input g-vector file, sigma_twotheta, sigma_eta and sigma_omega give YOUR estimation on the uncertainties in degrees on eta, omega and twotheta. \nSince these are estimated by the user and since they \"decide\" whether a theoretical gvector match an observed, \nthese parameters are important to vary a bit to obtain a set making GrainSpotter able to determine the grain orientations. ");
        this.sigmaTth.setMinValue(new Float(0.0).floatValue(), false);
        this.sigmaTth.set_isRequiredField(false);
        new Label((Composite)uncertGroup, 0).setText("Sigma eta");
        this.sigmaEta = new FloatText((Composite)uncertGroup, 0, "");
        this.sigmaEta.setToolTipText("uncertainties sigma_eta[degrees]: \nUntil full error estimation is available on the g-vectors in the input g-vector file, sigma_twotheta, sigma_eta and sigma_omega give YOUR estimation on the uncertainties in degrees on eta, omega and twotheta. \nSince these are estimated by the user and since they \"decide\" whether a theoretical gvector match an observed, \nthese parameters are important to vary a bit to obtain a set making GrainSpotter able to determine the grain orientations. ");
        this.sigmaEta.getTextField().setToolTipText("uncertainties sigma_eta[degrees]: \nUntil full error estimation is available on the g-vectors in the input g-vector file, sigma_twotheta, sigma_eta and sigma_omega give YOUR estimation on the uncertainties in degrees on eta, omega and twotheta. \nSince these are estimated by the user and since they \"decide\" whether a theoretical gvector match an observed, \nthese parameters are important to vary a bit to obtain a set making GrainSpotter able to determine the grain orientations. ");
        this.sigmaEta.setMinValue(new Float(0.0).floatValue(), false);
        this.sigmaEta.set_isRequiredField(false);
        new Label((Composite)uncertGroup, 0).setText("uncertainties: sigma omega");
        this.sigmaOmega = new FloatText((Composite)uncertGroup, 0, "");
        this.sigmaOmega.setMinValue(new Float(0.0).floatValue(), false);
        this.sigmaOmega.setToolTipText("uncertainties sigma_omega[degrees]: Until full error estimation is available on the g-vectors in the input g-vector file, sigma_twotheta, sigma_eta and sigma_omega give YOUR estimation on the uncertainties in degrees on eta, omega and twotheta. \nSince these are estimated by the user and since they \"decide\" whether a theoretical gvector match an observed, \nthese parameters are important to vary a bit to obtain a set making GrainSpotter able to determine the grain orientations. ");
        this.sigmaOmega.getTextField().setToolTipText("uncertainties sigma_omega[degrees]: \nUntil full error estimation is available on the g-vectors in the input g-vector file, sigma_twotheta, sigma_eta and sigma_omega give YOUR estimation on the uncertainties in degrees on eta, omega and twotheta. \nSince these are estimated by the user and since they \"decide\" whether a theoretical gvector match an observed, \nthese parameters are important to vary a bit to obtain a set making GrainSpotter able to determine the grain orientations. ");
        this.sigmaOmega.set_isRequiredField(false);
        new Label((Composite)uncertGroup, 0).setText("Sigmas (maximal deviation)");
        this.nsigma = new FloatText((Composite)uncertGroup, 0, "");
        this.nsigma.setToolTipText("sigma (float >0).");
        this.nsigma.setMinValue(new Float(0.0).floatValue(), false);
        this.nsigma.set_isRequiredField(false);
        this.nsigma.getTextField().setToolTipText("nsigmas: Gives the maximal deviation when comparing two quantities. \nGenerally, |d_quantity| < nsigmas * sig_quantity.");
    }

    private void createGroupThree(Composite container) {
        Group grp = LookAndFeel.getGroup((Composite)container, (String)"", (int)3, (int)2);
        grp.setLayoutData((Object)new GridData(16384, 4, true, false, 1, 1));
        Label l = new Label((Composite)grp, 0);
        l.setText("Step Size in Euler space [0/180 deg.]");
        grp.setToolTipText("eulerstep.");
        this.eulerStep = new FloatText((Composite)grp, 0, "", 0.0f, 180.0f);
        this.eulerStep.setToolTipText("eulerstep : \nThe Euler angles are sampled according to the metric (Linear in phi1 and phi2, not linear in PHI). \n\nNOTICE: If the the keyword random is used eulerstep has a diffent meaning than in scanning mode. \nIn this case the number defines a small volume around the random orientation in which a possible match can be found. \nBy making eulerstep small the possible solutions for each step are reduced, which makes it faster. \nHowever, you might also need more random steps to find all grains. \n\nA sensible value for eulerstep is around 3-6 degrees.");
        this.eulerStep.getTextField().setToolTipText("eulerstep : \nThe Euler angles are sampled according to the metric (Linear in phi1 and phi2, not linear in PHI). \n\nNOTICE: If the the keyword random is used eulerstep has a diffent meaning than in scanning mode. \nIn this case the number defines a small volume around the random orientation in which a possible match can be found. \nBy making eulerstep small the possible solutions for each step are reduced, which makes it faster. \nHowever, you might also need more random steps to find all grains. \n\nA sensible value for eulerstep is around 3-6 degrees.");
        this.eulerStep.set_isRequiredField(false);
        this.eulerStep.setLayoutData((Object)new GridData(16384, 2, false, false, 2, 1));
        Label labelHkl = new Label((Composite)grp, 0);
        labelHkl.setText("NHkls : Number hkl families used");
        this.hklRingsText = new IntegerText((Composite)grp, 0, "");
        this.hklRingsText.setMinValue(new Integer(0).intValue(), false);
        this.hklRingsText.setToolTipText("Nhkls_in_indexing: \nUses the first Nhkls_in_indexing hklfamilies to recover the crystallographic orientations. \nAfterwards the search for additional gvectors belonging to the grain is done on the remaining rings. hkl rings (integer > 0).");
        this.hklRingsText.getTextField().setToolTipText("Nhkls_in_indexing: \nUses the first Nhkls_in_indexing hklfamilies to recover the crystallographic orientations. \nAfterwards the search for additional gvectors belonging to the grain is done on the remaining rings. hkl rings (integer > 0).");
        this.hklRingsText.set_isRequiredField(false);
        this.hklRingsText.setLayoutData((Object)new GridData(16384, 2, false, false, 2, 1));
        new Label((Composite)grp, 0).setText("Minfracg");
        this.minfracg = new FloatText((Composite)grp, 0, "");
        this.minfracg.setToolTipText("minfracg: \nStop search when minfracg (0..1) of the gvectors have been assigned to grains.");
        this.minfracg.getTextField().setToolTipText("minfracg: \nStop search when minfracg (0..1) of the gvectors have been assigned to grains.");
        this.minfracg.set_isRequiredField(false);
        this.minfracg.setLayoutData((Object)new GridData(16384, 2, false, false, 2, 1));
        new Label((Composite)grp, 0).setText("Random : Number of trial orientation");
        this.random = new IntegerText((Composite)grp, 0);
        this.random.setToolTipText("Instead of stepping through all orientation space systematically, sampling randomly is possible using the random keyword. \nThe number following random is the number of orientations tried. If this method is used the parameter given with the keyword eulerstep has a diffent meaning than in scanning mode: \nin this case the number defines a small volume around the random orientation in which a possible match can be found. By making eulerstep small the possible solutions for each step are reduced, which makes it faster. \nHowever, you might also need more random steps to find all grains. \n\nA sensible value for eulerstep is around 3-6 degrees.");
        this.random.getTextField().setToolTipText("Instead of stepping through all orientation space systematically, sampling randomly is possible using the random keyword. \nThe number following random is the number of orientations tried. If this method is used the parameter given with the keyword eulerstep has a diffent meaning than in scanning mode: \nin this case the number defines a small volume around the random orientation in which a possible match can be found. By making eulerstep small the possible solutions for each step are reduced, which makes it faster. \nHowever, you might also need more random steps to find all grains. \n\nA sensible value for eulerstep is around 3-6 degrees.");
        this.random.setLayoutData((Object)new GridData(16384, 2, false, false, 2, 1));
        new Label((Composite)grp, 0).setText("Fit position ?");
        this.fitpositionFalse = new Button((Composite)grp, 16);
        this.fitpositionFalse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.fitpositionFalse.setText("No");
        this.fitpositionFalse.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.fitpositionYes = new Button((Composite)grp, 16);
        this.fitpositionYes.setText("Yes");
        this.fitpositionYes.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.fitpositionYes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.fitpositionFalse.setSelection(true);
        this.fitpositionFalse.setToolTipText("positionfit: \nWhen a grain is found the spatial position of the grain is fitted simultaneously with the orientation matrix if this keyword is added.");
        this.fitpositionYes.setToolTipText("positionfit: \nWhen a grain is found the spatial position of the grain is fitted simultaneously with the orientation matrix if this keyword is added.");
    }

    private void createRows(Table table, int maxrows) {
        int i = 0;
        while (i < maxrows) {
            new TableItem(table, 0);
            ++i;
        }
    }

    private void triggerTableSelectionDsRange() {
        final TableEditor rangeEditor = new TableEditor(this.dsRange);
        rangeEditor.horizontalAlignment = 16384;
        rangeEditor.grabHorizontal = true;
        rangeEditor.minimumWidth = 50;
        this.dsRange.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = GrainspotterInputEditor.this.dsRange.getClientArea();
                Point pt = new Point(event.x, event.y);
                int index = GrainspotterInputEditor.this.dsRange.getTopIndex();
                while (index < GrainspotterInputEditor.this.dsRange.getItemCount()) {
                    boolean visible = false;
                    final TableItem item = GrainspotterInputEditor.this.dsRange.getItem(index);
                    int i = 0;
                    while (i < GrainspotterInputEditor.this.dsRange.getColumnCount()) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt)) {
                            final int column = i;
                            final Text text = new Text((Composite)GrainspotterInputEditor.this.dsRange, 0);
                            Listener textListener = new Listener(){

                                public void handleEvent(Event e) {
                                    switch (e.type) {
                                        case 16: {
                                            item.setText(column, text.getText());
                                            GrainspotterInputEditor.this.dirty = true;
                                            GrainspotterInputEditor.this.firePropertyChange(257);
                                            text.dispose();
                                            break;
                                        }
                                        case 31: {
                                            switch (e.detail) {
                                                case 4: {
                                                    item.setText(column, text.getText());
                                                    GrainspotterInputEditor.this.dirty = true;
                                                    GrainspotterInputEditor.this.firePropertyChange(257);
                                                }
                                                case 2: {
                                                    text.dispose();
                                                    e.doit = false;
                                                }
                                            }
                                        }
                                    }
                                }
                            };
                            text.addListener(16, textListener);
                            text.addListener(31, textListener);
                            rangeEditor.setEditor((Control)text, item, i);
                            text.setText(item.getText(i));
                            text.setFocus();
                            return;
                        }
                        if (!visible && rect.intersects(clientArea)) {
                            visible = true;
                        }
                        ++i;
                    }
                    if (!visible) {
                        return;
                    }
                    ++index;
                }
            }
        });
    }

    private void triggerTableSelectionTthRange() {
        final TableEditor tthRangeEditor = new TableEditor(this.tthRange);
        tthRangeEditor.horizontalAlignment = 16384;
        tthRangeEditor.grabHorizontal = true;
        tthRangeEditor.minimumWidth = 50;
        this.tthRange.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = GrainspotterInputEditor.this.tthRange.getClientArea();
                Point pt = new Point(event.x, event.y);
                int index = GrainspotterInputEditor.this.tthRange.getTopIndex();
                while (index < GrainspotterInputEditor.this.tthRange.getItemCount()) {
                    boolean visible = false;
                    final TableItem item = GrainspotterInputEditor.this.tthRange.getItem(index);
                    int i = 0;
                    while (i < GrainspotterInputEditor.this.tthRange.getColumnCount()) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt)) {
                            final int column = i;
                            final Text text = new Text((Composite)GrainspotterInputEditor.this.tthRange, 0);
                            Listener textListener = new Listener(){

                                public void handleEvent(Event e) {
                                    switch (e.type) {
                                        case 16: {
                                            item.setText(column, text.getText());
                                            GrainspotterInputEditor.this.dirty = true;
                                            GrainspotterInputEditor.this.firePropertyChange(257);
                                            text.dispose();
                                            break;
                                        }
                                        case 31: {
                                            switch (e.detail) {
                                                case 4: {
                                                    item.setText(column, text.getText());
                                                    GrainspotterInputEditor.this.dirty = true;
                                                    GrainspotterInputEditor.this.firePropertyChange(257);
                                                }
                                                case 2: {
                                                    text.dispose();
                                                    e.doit = false;
                                                }
                                            }
                                        }
                                    }
                                }
                            };
                            text.addListener(16, textListener);
                            text.addListener(31, textListener);
                            tthRangeEditor.setEditor((Control)text, item, i);
                            text.setText(item.getText(i));
                            text.selectAll();
                            text.setFocus();
                            return;
                        }
                        if (!visible && rect.intersects(clientArea)) {
                            visible = true;
                        }
                        ++i;
                    }
                    if (!visible) {
                        return;
                    }
                    ++index;
                }
            }
        });
    }

    private void triggerTableSelectionEtaRange() {
        final TableEditor etaRangeEditor = new TableEditor(this.etaRange);
        etaRangeEditor.horizontalAlignment = 16384;
        etaRangeEditor.grabHorizontal = true;
        etaRangeEditor.minimumWidth = 50;
        this.etaRange.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = GrainspotterInputEditor.this.etaRange.getClientArea();
                Point pt = new Point(event.x, event.y);
                int index = GrainspotterInputEditor.this.etaRange.getTopIndex();
                while (index < GrainspotterInputEditor.this.etaRange.getItemCount()) {
                    boolean visible = false;
                    final TableItem item = GrainspotterInputEditor.this.etaRange.getItem(index);
                    int i = 0;
                    while (i < GrainspotterInputEditor.this.etaRange.getColumnCount()) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt)) {
                            final int column = i;
                            final Text text = new Text((Composite)GrainspotterInputEditor.this.etaRange, 0);
                            Listener textListener = new Listener(){

                                public void handleEvent(Event e) {
                                    switch (e.type) {
                                        case 16: {
                                            item.setText(column, text.getText());
                                            GrainspotterInputEditor.this.dirty = true;
                                            GrainspotterInputEditor.this.firePropertyChange(257);
                                            text.dispose();
                                            break;
                                        }
                                        case 31: {
                                            switch (e.detail) {
                                                case 4: {
                                                    item.setText(column, text.getText());
                                                    GrainspotterInputEditor.this.dirty = true;
                                                    GrainspotterInputEditor.this.firePropertyChange(257);
                                                }
                                                case 2: {
                                                    text.dispose();
                                                    e.doit = false;
                                                }
                                            }
                                        }
                                    }
                                }
                            };
                            text.addListener(16, textListener);
                            text.addListener(31, textListener);
                            etaRangeEditor.setEditor((Control)text, item, i);
                            text.setText(item.getText(i));
                            text.selectAll();
                            text.setFocus();
                            return;
                        }
                        if (!visible && rect.intersects(clientArea)) {
                            visible = true;
                        }
                        ++i;
                    }
                    if (!visible) {
                        return;
                    }
                    ++index;
                }
            }
        });
    }

    private void triggerTableSelectionOmegaRange() {
        final TableEditor omegaRangeEditor = new TableEditor(this.omegaRange);
        omegaRangeEditor.horizontalAlignment = 16384;
        omegaRangeEditor.grabHorizontal = true;
        omegaRangeEditor.minimumWidth = 50;
        this.omegaRange.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Rectangle clientArea = GrainspotterInputEditor.this.omegaRange.getClientArea();
                Point pt = new Point(event.x, event.y);
                int index = GrainspotterInputEditor.this.omegaRange.getTopIndex();
                while (index < GrainspotterInputEditor.this.omegaRange.getItemCount()) {
                    boolean visible = false;
                    final TableItem item = GrainspotterInputEditor.this.omegaRange.getItem(index);
                    int i = 0;
                    while (i < GrainspotterInputEditor.this.omegaRange.getColumnCount()) {
                        Rectangle rect = item.getBounds(i);
                        if (rect.contains(pt)) {
                            final int column = i;
                            final Text text = new Text((Composite)GrainspotterInputEditor.this.omegaRange, 0);
                            Listener textListener = new Listener(){

                                public void handleEvent(Event e) {
                                    switch (e.type) {
                                        case 16: {
                                            item.setText(column, text.getText());
                                            GrainspotterInputEditor.this.dirty = true;
                                            GrainspotterInputEditor.this.firePropertyChange(257);
                                            text.dispose();
                                            break;
                                        }
                                        case 31: {
                                            switch (e.detail) {
                                                case 4: {
                                                    item.setText(column, text.getText());
                                                    GrainspotterInputEditor.this.dirty = true;
                                                    GrainspotterInputEditor.this.firePropertyChange(257);
                                                }
                                                case 2: {
                                                    text.dispose();
                                                    e.doit = false;
                                                }
                                            }
                                        }
                                    }
                                }
                            };
                            text.addListener(16, textListener);
                            text.addListener(31, textListener);
                            omegaRangeEditor.setEditor((Control)text, item, i);
                            text.setText(item.getText(i));
                            text.selectAll();
                            text.setFocus();
                            return;
                        }
                        if (!visible && rect.intersects(clientArea)) {
                            visible = true;
                        }
                        ++i;
                    }
                    if (!visible) {
                        return;
                    }
                    ++index;
                }
            }
        });
    }

    private void createMinMaxColumnOmegaRange(String[] columnsProperties) {
        TableColumn columnMin = new TableColumn(this.omegaRange, 0);
        columnMin.setText(columnsProperties[0]);
        columnMin.setWidth(100);
        columnMin.setData("index", (Object)0);
        TableColumn columnMax = new TableColumn(this.omegaRange, 0);
        columnMax.setText(columnsProperties[1]);
        columnMax.setWidth(100);
        columnMax.setData("index", (Object)1);
        this.omegaRange.setHeaderVisible(true);
        columnMin.pack();
        columnMax.pack();
        this.omegaRange.pack();
    }

    private void createMinMaxColumntthRange(String[] columnsProperties) {
        TableColumn columnMin = new TableColumn(this.tthRange, 0);
        columnMin.setText(columnsProperties[0]);
        columnMin.setWidth(100);
        columnMin.setData("index", (Object)0);
        TableColumn columnMax = new TableColumn(this.tthRange, 0);
        columnMax.setText(columnsProperties[1]);
        columnMax.setWidth(100);
        columnMax.setData("index", (Object)1);
        this.tthRange.setHeaderVisible(true);
        columnMin.pack();
        columnMax.pack();
        this.tthRange.pack();
    }

    private void createMinMaxColumnEtaRange(String[] columnsProperties) {
        TableColumn columnMin = new TableColumn(this.etaRange, 0);
        columnMin.setText(columnsProperties[0]);
        columnMin.setWidth(100);
        columnMin.setData("index", (Object)0);
        TableColumn columnMax = new TableColumn(this.etaRange, 0);
        columnMax.setText(columnsProperties[1]);
        columnMax.setWidth(100);
        columnMax.setData("index", (Object)1);
        this.etaRange.setHeaderVisible(true);
        columnMin.pack();
        columnMax.pack();
        this.etaRange.pack();
    }

    private void createMinMaxColumnDsRange(String[] columnsProperties) {
        TableColumn columnMin = new TableColumn(this.dsRange, 0);
        columnMin.setText(columnsProperties[0]);
        columnMin.setWidth(100);
        columnMin.setData("index", (Object)0);
        TableColumn columnMax = new TableColumn(this.dsRange, 0);
        columnMax.setText(columnsProperties[1]);
        columnMax.setWidth(100);
        columnMax.setData("index", (Object)1);
        this.dsRange.setHeaderVisible(true);
        columnMin.pack();
        columnMax.pack();
        this.dsRange.pack();
    }

    private void createRemoveItemButtonDsRange(Composite container) {
        Button removeButton = new Button(container, 8);
        final Image imageremove = this.deleteDescriptor.createImage();
        removeButton.setImage(imageremove);
        removeButton.setLayoutData((Object)new GridData(16384, 1024, false, false));
        removeButton.setToolTipText("remove a range for this option.");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = GrainspotterInputEditor.this.dsRange.getSelectionIndex();
                if (index != -1) {
                    TableItem tableItem = GrainspotterInputEditor.this.dsRange.getItem(index);
                    tableItem.dispose();
                }
            }
        });
        removeButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (imageremove != null && !imageremove.isDisposed()) {
                    imageremove.dispose();
                }
            }
        });
    }

    private void createRemoveItemButtonTthRange(Composite container) {
        Button removeButton = new Button(container, 8);
        final Image imageremove = this.deleteDescriptor.createImage();
        removeButton.setImage(imageremove);
        removeButton.setLayoutData((Object)new GridData(16384, 1024, false, false));
        removeButton.setToolTipText("remove a range for this option.");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = GrainspotterInputEditor.this.tthRange.getSelectionIndex();
                if (index != -1) {
                    TableItem tableItem = GrainspotterInputEditor.this.tthRange.getItem(index);
                    tableItem.dispose();
                }
            }
        });
        removeButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (imageremove != null && !imageremove.isDisposed()) {
                    imageremove.dispose();
                }
            }
        });
    }

    private void createRemoveItemButtonEtaRange(Composite container) {
        Button removeButton = new Button(container, 8);
        final Image imageremove = this.deleteDescriptor.createImage();
        removeButton.setImage(imageremove);
        removeButton.setLayoutData((Object)new GridData(16384, 1024, false, false));
        removeButton.setToolTipText("remove a range for this option.");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = GrainspotterInputEditor.this.etaRange.getSelectionIndex();
                if (index != -1) {
                    TableItem tableItem = GrainspotterInputEditor.this.etaRange.getItem(index);
                    tableItem.dispose();
                }
            }
        });
        removeButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (imageremove != null && !imageremove.isDisposed()) {
                    imageremove.dispose();
                }
            }
        });
    }

    private void createRemoveItemButtonOmegarange(Composite container) {
        Button removeButton = new Button(container, 8);
        final Image imageremove = this.deleteDescriptor.createImage();
        removeButton.setImage(imageremove);
        removeButton.setLayoutData((Object)new GridData(16384, 1024, false, false));
        removeButton.setToolTipText("remove a range for this option.");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = GrainspotterInputEditor.this.omegaRange.getSelectionIndex();
                if (index != -1) {
                    TableItem tableItem = GrainspotterInputEditor.this.omegaRange.getItem(index);
                    tableItem.dispose();
                }
            }
        });
        removeButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (imageremove != null && !imageremove.isDisposed()) {
                    imageremove.dispose();
                }
            }
        });
    }

    private void createAddButtonTthrange(Composite container) {
        Button addButton = new Button(container, 8);
        addButton.setLayoutData((Object)new GridData(16384, 1024, false, true));
        final Image imageAdd = this.addDescriptor.createImage();
        addButton.setImage(imageAdd);
        addButton.setToolTipText("Add a new range in table for this option.");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new TableItem(GrainspotterInputEditor.this.tthRange, 0);
            }
        });
        addButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (imageAdd != null && !imageAdd.isDisposed()) {
                    imageAdd.dispose();
                }
            }
        });
    }

    private void createAddButtonOmegaRange(Composite container) {
        Button addButton = new Button(container, 8);
        addButton.setLayoutData((Object)new GridData(16384, 1024, false, true));
        final Image imageAdd = this.addDescriptor.createImage();
        addButton.setImage(imageAdd);
        addButton.setToolTipText("Add a new range in table for this option.");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new TableItem(GrainspotterInputEditor.this.omegaRange, 0);
            }
        });
        addButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (imageAdd != null && !imageAdd.isDisposed()) {
                    imageAdd.dispose();
                }
            }
        });
    }

    private void createAddButtonEtaRange(Composite container) {
        Button addButton = new Button(container, 8);
        addButton.setLayoutData((Object)new GridData(16384, 1024, false, true));
        final Image imageAdd = this.addDescriptor.createImage();
        addButton.setImage(imageAdd);
        addButton.setToolTipText("Add a new range in table for this option.");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new TableItem(GrainspotterInputEditor.this.etaRange, 0);
            }
        });
        addButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (imageAdd != null && !imageAdd.isDisposed()) {
                    imageAdd.dispose();
                }
            }
        });
    }

    private void createAddButtonDsRange(Composite container) {
        Button addButton = new Button(container, 8);
        addButton.setLayoutData((Object)new GridData(16384, 1024, false, true));
        final Image imageAdd = this.addDescriptor.createImage();
        addButton.setImage(imageAdd);
        addButton.setToolTipText("Add a new range in table for this option.");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new TableItem(GrainspotterInputEditor.this.dsRange, 0);
            }
        });
        addButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (imageAdd != null && !imageAdd.isDisposed()) {
                    imageAdd.dispose();
                }
            }
        });
    }

    public void setFocus() {
        GrainSpotter.getInstance().setInput((IEditorInput)this.input);
    }

    public static String getID() {
        return ID;
    }

    private void setModifyListener() {
        this.txtFilelog.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.txtFilegve.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
                String file = GrainspotterInputEditor.this.txtFilegve.getText();
                if (ToolBox.checkIfFileExists((String)file)) {
                    grainSpotter.setgVectorFile(file);
                    GrainspotterInputEditor.this.input.getInputFile().setGveFileName(file);
                }
            }
        });
        this.minfracg.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.omegaDeltaText.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.eulerStep.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.cutsMinMeasurement.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.hklRingsText.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
        this.cutsMinCompletenessText.getTextField().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GrainspotterInputEditor.this.dirty = true;
                GrainspotterInputEditor.this.firePropertyChange(257);
            }
        });
    }

    private void initFields() {
        if (this.input.inputFile.isIgnoreOptionDsRange()) {
            this.chooseTthRange.setSelection(true);
            this.chooseDspacing.setSelection(false);
        } else {
            this.chooseTthRange.setSelection(false);
            this.chooseDspacing.setSelection(true);
        }
        this.setEnableGroup((Composite)this.dsGroup, this.chooseDspacing.getSelection());
        this.setEnableGroup((Composite)this.tthRangeGroup, !this.chooseDspacing.getSelection());
        this.setGveFile(this.input.inputFile.getGveFileName());
        this.setLogFile(this.input.inputFile.getLogFileName());
        this.setSpaceGroup(this.input.inputFile.getSpaceGroup());
        this.setDsRange(this.input.inputFile.getDsRange());
        this.setOmegaRange(this.input.inputFile.getOmegaRange());
        if (!this.input.inputFile.isIgnoreOptionDeltaOmegaSpec()) {
            this.setDeltaOmega(this.input.inputFile.getDeltaOmegaSpecs());
        }
        if (!this.input.inputFile.isIgnoreOptionUncertainties()) {
            this.set_uncertTthText(this.input.inputFile.getTtUncertainties());
            this.set_uncertEtaText(this.input.inputFile.getEtaUncertainties());
            this.set_uncertOmegaText(this.input.inputFile.getOmegaUncertainties());
        }
        this.setTthRange(this.input.inputFile.getTthRange());
        this.setEtaRange(this.input.inputFile.getEtaRange());
        if (!this.input.inputFile.isIgnoreOptionCuts()) {
            this.set_cutsMinCompletenessText(this.input.inputFile.getMinCompletenessCuts());
            this.set_cutsMinMeasurement(this.input.inputFile.getMinMeasurementCuts());
            this.set_cutsMinUniqueness(this.input.inputFile.getMinMeasurementUniqueness());
        }
        if (!this.input.inputFile.isIgnoreOptionEuler()) {
            this.set_eulerStep(this.input.inputFile.getStepEuler());
        }
        if (!this.input.inputFile.isIgnoreOptionNSigma()) {
            this.set_sigmaText(this.input.inputFile.getNSigmas());
        }
        if (!this.input.inputFile.isIgnoreOptionHKL()) {
            this.setNHkls(this.input.inputFile.getNHKLs());
        }
        if (!this.input.inputFile.isIgnoreOptionMinfracg()) {
            this.setMinfracg(this.input.inputFile.getMinfracg());
        }
        if (!this.input.inputFile.isIgnoreOptionRandom()) {
            this.setRandom(this.input.inputFile.getRandom());
        }
        this.setPositionFit(this.input.inputFile.isPositionFit());
        GrainspotterInputEditor.synchronizeInitialDirectories(this.input.inputFile.getIniFilePath());
        grainSpotter.setLogFilePath(initialDirLog);
        grainSpotter.setGveFilePath(initialDirGve);
        this.setPageText(0, this.input.inputFile.iniFileName);
    }

    public void setLogFile(String logFileName) {
        this.txtFilelog.set_Text(logFileName);
        File f = new File(logFileName);
        this.setLogFile(f.getName(), f.getPath());
    }

    public void setGveFile(String gveFileName) {
        this.txtFilegve.set_Text(gveFileName);
        grainSpotter.setgVectorFile(gveFileName);
    }

    private void setRandom(int sigmas) {
        this.random.set_Text(String.valueOf(sigmas));
    }

    private void setDeltaOmega(float deltaOmegaSpecs) {
        this.omegaDeltaText.set_Text(String.valueOf(deltaOmegaSpecs));
    }

    private void setPositionFit(boolean positionFit) {
        this.fitpositionYes.setSelection(positionFit);
        this.fitpositionFalse.setSelection(!positionFit);
    }

    private void setDsRange(Vector<float[]> dsRange2) {
        int i = 0;
        while (i < dsRange2.size()) {
            TableItem item = new TableItem(this.dsRange, 0, 0);
            item.setText(0, this.setTableItemText(dsRange2.elementAt(i)[0]));
            item.setText(1, this.setTableItemText(dsRange2.elementAt(i)[1]));
            ++i;
        }
    }

    public String setTableItemText(float f) {
        DecimalFormat form = new DecimalFormat();
        String txt = "0";
        try {
            txt = form.format(f);
        }
        catch (NumberFormatException e) {
            FableLogger.error((Object)e.getMessage());
        }
        return txt;
    }

    public String getItemText(String s) {
        DecimalFormat d = new DecimalFormat();
        if (!s.trim().equals("")) {
            try {
                Number n = d.parse(s);
                s = n.toString();
            }
            catch (ParseException e) {
                FableLogger.getLogger().error((Object)e.getMessage());
            }
        }
        FableLogger.debug((Object)(((Object)((Object)this)).getClass() + " getItemText :" + s));
        return s;
    }

    private void setTthRange(Vector<float[]> dsRange2) {
        int i = 0;
        while (i < dsRange2.size()) {
            TableItem item = new TableItem(this.tthRange, 0, 0);
            item.setText(0, this.setTableItemText(dsRange2.elementAt(i)[0]));
            item.setText(1, this.setTableItemText(dsRange2.elementAt(i)[1]));
            ++i;
        }
    }

    private void setEtaRange(Vector<float[]> dsRange2) {
        int i = 0;
        while (i < dsRange2.size()) {
            TableItem item = new TableItem(this.etaRange, 0, 0);
            item.setText(0, this.setTableItemText(dsRange2.elementAt(i)[0]));
            item.setText(1, this.setTableItemText(dsRange2.elementAt(i)[1]));
            ++i;
        }
    }

    private void setOmegaRange(Vector<float[]> dsRange2) {
        int i = 0;
        while (i < dsRange2.size()) {
            TableItem item = new TableItem(this.omegaRange, 0, 0);
            item.setText(0, this.setTableItemText(dsRange2.elementAt(i)[0]));
            item.setText(1, this.setTableItemText(dsRange2.elementAt(i)[1]));
            ++i;
        }
    }

    public boolean setOptions() {
        boolean bok = true;
        try {
            TableItem item;
            this.input.getInputFile().setSpaceGroup(this.spaceGroupSpinner.getSelection());
            if (!this.omegaDeltaText.getText().equals("")) {
                this.input.getInputFile().ignoreOptionDeltaOmegaSpecs(false);
                this.input.getInputFile().set_deltaOmegaSpecs(this.omegaDeltaText.getText());
            } else {
                this.input.getInputFile().ignoreOptionDeltaOmegaSpecs(true);
            }
            this.input.getInputFile().getOmegaRange().removeAllElements();
            int i = 0;
            while (i < this.omegaRange.getItemCount()) {
                item = this.omegaRange.getItem(i);
                if (item.getText(0) != null && !item.getText(0).equals("") && item.getText(1) != null && !item.getText(1).equals("")) {
                    this.input.getInputFile().addOmegaRange(this.getItemText(item.getText(0)), this.getItemText(item.getText(1)));
                }
                ++i;
            }
            this.input.getInputFile().getEtaRange().removeAllElements();
            i = 0;
            while (i < this.etaRange.getItemCount()) {
                item = this.etaRange.getItem(i);
                if (item.getText(0) != null && !item.getText(0).equals("") && item.getText(1) != null && !item.getText(1).equals("")) {
                    this.input.getInputFile().addEtaRange(this.getItemText(item.getText(0)), this.getItemText(item.getText(1)));
                }
                ++i;
            }
            this.input.getInputFile().getTthRange().removeAllElements();
            i = 0;
            while (this.chooseTthRange.getSelection() && i < this.tthRange.getItemCount()) {
                item = this.tthRange.getItem(i);
                if (item.getText(0) != null && !item.getText(0).equals("") && item.getText(1) != null && !item.getText(1).equals("")) {
                    this.input.getInputFile().addtthRange(this.getItemText(item.getText(0)), this.getItemText(item.getText(1)));
                }
                ++i;
            }
            this.input.getInputFile().getDsRange().removeAllElements();
            i = 0;
            while (this.chooseDspacing.getSelection() && i < this.dsRange.getItemCount()) {
                item = this.dsRange.getItem(i);
                if (item.getText(0) != null && !item.getText(0).equals("") && item.getText(1) != null && !item.getText(1).equals("")) {
                    this.input.getInputFile().addDsRange(this.getItemText(item.getText(0)), this.getItemText(item.getText(1)));
                }
                ++i;
            }
            if (!(this.cutsMinCompletenessText.getText().trim().equals("") || this.cutsMinMeasurement.getText().trim().equals("") || this.cutsMinUniqueness.getText().trim().equals(""))) {
                this.input.getInputFile().set_minCompletenessCuts(this.cutsMinCompletenessText.getText());
                this.input.getInputFile().set_minMeasurementCuts(this.cutsMinMeasurement.getText());
                this.input.getInputFile().setMinMeasurementUniqueness(this.cutsMinUniqueness.getText());
                this.input.getInputFile().ignoreOptionCuts(false);
            } else {
                this.input.getInputFile().ignoreOptionCuts(true);
            }
            if (!this.eulerStep.getText().trim().equals("")) {
                this.input.getInputFile().set_stepEuler(this.eulerStep.getText());
                this.input.getInputFile().ignoreOptionEuler(false);
            } else {
                this.input.getInputFile().ignoreOptionEuler(true);
            }
            if (!(this.sigmaTth.getText().trim().equals("") || this.sigmaEta.getText().trim().equals("") || this.sigmaOmega.getText().trim().equals(""))) {
                this.input.getInputFile().set_ttUncertanties(this.sigmaTth.getText());
                this.input.getInputFile().set_etaUncertanties(this.sigmaEta.getText());
                this.input.getInputFile().set_omegaUncertanties(this.sigmaOmega.getText());
                this.input.getInputFile().ignoreOptionUncertainties(false);
            } else {
                this.input.getInputFile().ignoreOptionUncertainties(true);
            }
            this.input.getInputFile().setGveFileName(this.txtFilegve.getText());
            this.input.getInputFile().setLogFileName(this.txtFilelog.getText());
            if (!this.nsigma.getText().trim().equals("")) {
                this.input.getInputFile().set_nSigmas(this.nsigma.getText());
                this.input.getInputFile().ignoreOptionNSigma(false);
            } else {
                this.input.getInputFile().ignoreOptionNSigma(true);
            }
            if (!this.hklRingsText.getText().trim().equals("")) {
                this.input.getInputFile().set_nHKLs(this.hklRingsText.getText());
                this.input.getInputFile().ignoreOptionHKL(false);
            } else {
                this.input.getInputFile().ignoreOptionHKL(true);
            }
            if (!this.minfracg.getText().trim().equals("")) {
                this.input.getInputFile().setMinfracg(this.minfracg.getText());
                this.input.getInputFile().ignoreOptionMinfracg(false);
            } else {
                this.input.getInputFile().ignoreOptionMinfracg(true);
            }
            if (!this.random.getText().trim().equals("")) {
                this.input.getInputFile().setRandom(this.random.getText());
                this.input.getInputFile().ignoreOptionRandom(false);
            } else {
                this.input.getInputFile().ignoreOptionRandom(true);
            }
            this.input.getInputFile().setPositionFit(this.fitpositionYes.getSelection());
        }
        catch (GrainSpotterException e) {
            FableMessageConsole.console.displayIn(e.get_message());
            bok = false;
        }
        return bok;
    }

    public void setSpaceGroup(int _spaceGroup) {
        int newspaceGroupType = 0;
        this.spaceGroup = _spaceGroup;
        int i = 0;
        while (i < IVarKeys.SPACE_GROUP_MAXIMUM.length) {
            if (this.spaceGroup <= IVarKeys.SPACE_GROUP_MAXIMUM[i]) {
                newspaceGroupType = i;
                break;
            }
            ++i;
        }
        if (newspaceGroupType != this.spaceGroupType) {
            this.spaceGroupCombo.setItems(IVarKeys.SPACE_GROUPS[newspaceGroupType]);
            this.spaceGroupType = newspaceGroupType;
        }
        this.spaceGroupSpinner.setSelection(this.spaceGroup);
        this.spaceGroupTypeCombo.select(this.spaceGroupType);
        this.spaceGroupCombo.select(this.spaceGroup - IVarKeys.SPACE_GROUP_MINIMUM[this.spaceGroupType]);
    }

    private void set_eulerStep(float step) {
        this.eulerStep.set_Text(String.valueOf(step));
    }

    private void set_cutsMinCompletenessText(float f) {
        this.cutsMinCompletenessText.set_Text(String.valueOf(f));
    }

    private void set_cutsMinMeasurement(int minText) {
        this.cutsMinMeasurement.set_Text(String.valueOf(minText));
    }

    private void set_cutsMinUniqueness(float minText) {
        this.cutsMinUniqueness.set_Text(String.valueOf(minText));
    }

    private void set_sigmaText(float text) {
        this.nsigma.set_Text(String.valueOf(text));
    }

    private void set_uncertEtaText(float etaText) {
        this.sigmaEta.set_Text(String.valueOf(etaText));
    }

    private void set_uncertOmegaText(float omegaText) {
        this.sigmaOmega.set_Text(String.valueOf(omegaText));
    }

    private void set_uncertTthText(float thetaText) {
        this.sigmaTth.set_Text(String.valueOf(thetaText));
    }

    public void setNHkls(int hkl) {
        this.hklRingsText.set_Text(String.valueOf(hkl));
    }

    public void setMinfracg(float minfracg) {
        this.minfracg.set_Text(String.valueOf(minfracg));
    }

    public static void synchronizeInitialDirectories(String dir) {
        if (dir == null) {
            return;
        }
        if (initialDirIni == null) {
            initialDirIni = dir;
        }
        if (initialDirGve == null) {
            initialDirGve = dir;
        }
        if (initialDirLog == null) {
            initialDirLog = dir;
        }
    }

    protected void createPages() {
        this.createPage0();
        this.getEditorSite().getActionBars().setGlobalActionHandler(SaveInifile.ID, (IAction)this.save);
        this.getEditorSite().getActionBars().updateActionBars();
        this.initFields();
        this.setModifyListener();
        GrainSpotter.getInstance().addPropertyChangeListener(this);
        this.makeActions();
        this.contributetoActionBar();
    }

    public void makeActions() {
        this.save = new SaveInifile(){

            @Override
            public void run(GrainspotterInputEditor editor) {
                editor.doSave(null);
            }
        };
        this.save.setProps("Save ini file");
        this.save.setToolTipText("Save ini file");
        this.saveas = new SaveAsInifile(){

            @Override
            public void run(GrainspotterInputEditor editor) {
                editor.doSaveAs();
            }
        };
        this.saveas.setProps("Save ini file as...");
        this.saveas.setToolTipText("Save ini file as...");
    }

    public void resourceChanged(IResourceChangeEvent event) {
        event.getType();
    }

    private void fillLocalToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.save);
        toolBarManager.add((IAction)this.saveas);
    }

    private void contributetoActionBar() {
        IActionBars bars = this.getEditorSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    void createPage1() {
        try {
            this.editor = new GrainspotterTextEditor();
            int index = this.addPage((IEditorPart)this.editor, this.getEditorInput());
            this.setPageText(index, this.editor.getTitle());
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        GrainSpotter.getInstance().removePropertyChangeListener(this);
        super.dispose();
    }

    public boolean runGrainSpotter() {
        boolean fieldsOk = true;
        if (this.checkFields(this.parent, true)) {
            FableMessageConsole.console.displayOut("start running grainspotter with command : ");
            FableMessageConsole.console.displayOut(command);
            if (this.isDirty()) {
                boolean confirm = FableUtils.confirmMsg((Object)((Object)this), (String)"Your ini file has changed. Do you want to overwrite it?\n\nIf not, cancel operation.\n\nAfter that, you can save this new input file as in Menu File/Save as...");
                if (confirm) {
                    this.save();
                    grainSpotter.run();
                }
            } else {
                this.setOptions();
                grainSpotter.run();
            }
        } else {
            fieldsOk = false;
            if (FableMessageConsole.console != null) {
                FableMessageConsole.console.displayOut("Fields are not correct ");
                FableMessageConsole.console.activate();
            }
        }
        return fieldsOk;
    }

    private boolean checkFields(Composite parent2, boolean bok) {
        Control[] element = parent2.getChildren();
        int i = 0;
        while (bok && i < element.length) {
            if (element[i] instanceof Composite) {
                if (element[i] instanceof TypedText && !((TypedText)element[i]).is_bValide()) {
                    bok = false;
                    ((TypedText)element[i]).showDecoration();
                } else {
                    bok = this.checkFields((Composite)element[i], bok);
                }
            }
            ++i;
        }
        return bok;
    }

    public static String getInitialDirLog() {
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String val;
        if (event.getProperty().equals("grainspotter") && GrainSpotter.getInstance().getInput().equals((Object)this.input) && (val = (String)event.getNewValue()).equals("launch")) {
            this.runGrainSpotter();
        }
    }

    public String getLogFileName() {
        return this.txtFilelog.getText();
    }

    public String getGVE() {
        return this.txtFilegve.getText();
    }

    class CellModifier
    implements ICellModifier {
        private TableViewer tableviewer;

        public CellModifier(TableViewer viewer) {
            this.tableviewer = viewer;
        }

        public boolean canModify(Object arg0, String arg1) {
            return true;
        }

        public Object getValue(Object arg0, String arg1) {
            this.tableviewer.getTable().getSelectionIndex();
            return null;
        }

        public void modify(Object element, String property, Object value) {
        }
    }
}

