/*
 * Decompiled with CFR 0.152.
 */
package fable.grainspotter.actions;

import fable.framework.views.FableMessageConsole;
import fable.grainspotter.editors.GrainspotterIniInput;
import fable.grainspotter.editors.GrainspotterInputEditor;
import fable.grainspotter.internal.IVarKeys;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class OpenIniFileAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private IEditorInput input;

    public void dispose() {
    }

    public void init(IWorkbenchWindow arg0) {
        this.window = arg0;
    }

    public void run(IAction arg0) {
        if (this.window != null) {
            FileDialog fileDlg = new FileDialog(new Shell(), 4096);
            try {
                IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (activeWindow != null) {
                    activeWindow.getWorkbench().showPerspective("fable.grainspotter.perspective.grainspotterperspective", activeWindow);
                }
            }
            catch (PartInitException partInitException) {
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayError("Grainspotter perspective can not be displayed.");
                }
            }
            catch (WorkbenchException e) {
                MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening perspective Grainspotter: " + e.getMessage()));
            }
            fileDlg.setFilterExtensions(IVarKeys.FILTER_EXTS_INI);
            fileDlg.setFilterNames(IVarKeys.FILTER_NAMES_INI);
            fileDlg.setText("Select an ini file.");
            String file = fileDlg.open();
            if (file != null) {
                File theInputFile;
                if (!file.endsWith(".ini")) {
                    file = String.valueOf(file) + ".ini";
                }
                if ((theInputFile = new File(file)).exists()) {
                    this.input = OpenIniFileAction.createEditorInput(theInputFile);
                    String editorId = GrainspotterInputEditor.getID();
                    try {
                        this.window.getActivePage().openEditor(this.input, editorId);
                    }
                    catch (PartInitException e) {
                        MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening ini file: " + e.getMessage()));
                    }
                } else {
                    MessageDialog.openError((Shell)this.window.getShell(), (String)"Error", (String)("Error opening ini file: " + theInputFile.getName()));
                }
            }
        }
    }

    public void selectionChanged(IAction arg0, ISelection arg1) {
    }

    public static GrainspotterIniInput createEditorInput(File file) {
        Path location = new Path(file.getAbsolutePath());
        GrainspotterIniInput input = new GrainspotterIniInput((IPath)location);
        return input;
    }
}

