/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.view;

import fable.framework.logging.FableLogger;
import fable.framework.navigator.controller.SampleController;
import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.ToolBox;
import fable.framework.toolbox.TypedText;
import fable.framework.views.FableMessageConsole;
import fable.framework.writer.Xmlwriter;
import fable.framework.writer.XmlwriterException;
import fable.framework.xmlparser.object.XmlParserException;
import fable.framework.xmlparser.object.Xmloption;
import fable.framework.xmlparser.views.Options;
import fable.peaksearch.Activator;
import fable.peaksearch.actions.LoadXmlOption;
import fable.peaksearch.actions.RunAction;
import fable.peaksearch.actions.SaveXmlOptions;
import fable.peaksearch.object.Peaksearch;
import fable.peaksearch.object.PeaksearchException;
import fable.python.Sample;
import java.util.Vector;
import jep.JepException;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class PeaksearchView
extends ViewPart
implements IPropertyChangeListener {
    public static final String ID = "fable.peaksearch.view.PeaksearchView";
    public static PeaksearchView view;
    private IPropertyChangeListener preferencesListener;
    private Peaksearch peaksearch;
    private Options guiOptionsBuilder;
    private Logger logger = FableLogger.getLogger(PeaksearchView.class);
    private Sample currentDirectory;
    private Action setDefaultvalues;
    private Action loadOptions;
    private Action saveOptions;
    private RunAction runAction;
    private ImageDescriptor imageDefault = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/revert.gif");
    private ImageDescriptor imageLoad = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/loadOptions.gif");
    private ImageDescriptor saveImgDesc = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/saveoptions.gif");
    private SampleController controller = SampleController.getController();

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.preferencesListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("pref_ini_peaksearch")) {
                    try {
                        String iniFileName = Activator.getDefault().getPreferenceStore().getString("pref_ini_peaksearch");
                        PeaksearchView.this.peaksearch.loadIniFile(iniFileName);
                        Vector<Xmloption> v_options = PeaksearchView.this.peaksearch.getOptions();
                        int i = 0;
                        while (i < v_options.size()) {
                            Xmloption xmloption = v_options.elementAt(i);
                            PeaksearchView.this.guiOptionsBuilder.updateFields(null, (String)xmloption.getNode().get("option"), (String)xmloption.getNode().get("default"));
                            ++i;
                        }
                    }
                    catch (PeaksearchException e) {
                        PeaksearchView.this.logger.error((Object)e.getMessage());
                    }
                }
            }
        };
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferencesListener);
    }

    public void createPartControl(Composite parent) {
        block6: {
            view = this;
            this.controller.addPropertyChangeListener((IPropertyChangeListener)this);
            try {
                this.peaksearch = Peaksearch.getPeaksearch();
                this.peaksearch.setSamples(this.controller.getSamples());
            }
            catch (PeaksearchException e) {
                FableMessageConsole.console.displayIn(e.getMessage());
            }
            catch (JepException e) {
                FableMessageConsole.console.displayIn(e.getMessage());
            }
            this.peaksearch.addPropertyChangeListener(this);
            if (FableMessageConsole.console != null) {
                FableMessageConsole.console.displayOut("Welcome to Peaksearch " + ToolBox.getPluginVersion((String)"fable.peaksearch"));
            }
            try {
                this.guiOptionsBuilder = new Options(parent, this.peaksearch.getOptions());
                this.guiOptionsBuilder.addListener((IPropertyChangeListener)this);
            }
            catch (XmlParserException e) {
                if (FableMessageConsole.console == null) break block6;
                FableMessageConsole.console.displayIn("Peaksearch is not able to load its preferred  file to build option view.");
                this.logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.makeActions();
        this.contributeToActionBars();
    }

    public void setFocus() {
        if (this.controller != null) {
            this.currentDirectory = this.controller.getCurrentsample();
            if (this.currentDirectory != null) {
                this.updateGuiWithCurrentSelection();
            }
        }
    }

    public void initFields() {
    }

    public void dispose() {
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferencesListener);
        this.controller.removePropertyChangeListener((IPropertyChangeListener)this);
        this.peaksearch.removePropertyrChangeListener(this);
        super.dispose();
    }

    private void makeActions() {
        this.setDefaultvalues = new Action(){

            public void run() {
                PeaksearchView.this.guiOptionsBuilder.resetFields();
            }
        };
        this.setDefaultvalues.setText("Restore default values");
        this.setDefaultvalues.setToolTipText("Restore default values");
        this.setDefaultvalues.setImageDescriptor(this.imageDefault);
        this.saveOptions = new SaveXmlOptions();
        this.saveOptions.setText("Save current options");
        this.saveOptions.setToolTipText("Save current options");
        this.saveOptions.setImageDescriptor(this.saveImgDesc);
        this.loadOptions = new LoadXmlOption();
        this.loadOptions.setText("Load options");
        this.loadOptions.setToolTipText("Load options by selecting an XML file");
        this.loadOptions.setImageDescriptor(this.imageLoad);
        this.runAction = new RunAction();
        this.runAction.setImageDescriptor(Activator.getImageDescriptor("images/peaksearch_run.gif"));
        this.runAction.setText("Start peak searching");
        this.runAction.setToolTipText("Start peak searching");
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.peaksearch.actions.RunAction", (IAction)this.runAction);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.loadOptions);
        manager.add((IAction)this.saveOptions);
        manager.add((IAction)this.setDefaultvalues);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.runAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.loadOptions);
        manager.add((IAction)this.saveOptions);
        manager.add((IAction)this.setDefaultvalues);
        manager.add((IAction)this.runAction);
    }

    public void propertyChange(PropertyChangeEvent event) {
        block15: {
            block27: {
                block26: {
                    block25: {
                        block24: {
                            block18: {
                                String val;
                                String property_label;
                                block23: {
                                    block22: {
                                        block21: {
                                            block20: {
                                                block19: {
                                                    block17: {
                                                        block16: {
                                                            block14: {
                                                                if (!event.getProperty().equals("start")) break block14;
                                                                if (this.validateView()) {
                                                                    this.peaksearch.run();
                                                                    this.runAction.setImageDescriptor(Activator.getImageDescriptor("images/peaksearch_stop.gif"));
                                                                    this.runAction.setText("Stop peak searching");
                                                                    this.runAction.setToolTipText("Stop peak searching");
                                                                    this.logger.info((Object)"PeakSearch running test from PeakSearchView");
                                                                    FableMessageConsole.console.displayOut("PeakSearch is running.");
                                                                } else {
                                                                    this.logger.warn((Object)"PeakSearch is not valid");
                                                                    String error = String.valueOf((String)this.getUnValidField().getData("option")) + ": " + this.getUnValidField().getErrorMessage();
                                                                    FableMessageConsole.console.displayError("Peaksearch option contains at least one wrong value :\n" + error);
                                                                }
                                                                break block15;
                                                            }
                                                            if (!event.getProperty().equals("quit")) break block16;
                                                            if (!this.peaksearch.isRunning()) break block15;
                                                            this.peaksearch.forceQuit();
                                                            break block15;
                                                        }
                                                        this.runAction.setImageDescriptor(Activator.getImageDescriptor("images/peaksearch_run.gif"));
                                                        this.runAction.setText("Start peak searching");
                                                        this.runAction.setToolTipText("Start peak searching");
                                                        if (!event.getProperty().equals("stop")) break block17;
                                                        if (this.peaksearch.hasBeenCanceled()) {
                                                            this.logger.info((Object)"PeakSearch has been cancelled.");
                                                            FableMessageConsole.console.displayOut("Peaksearch has been cancelled.");
                                                            this.guiOptionsBuilder.stop();
                                                        } else {
                                                            this.guiOptionsBuilder.stop();
                                                            this.logger.info((Object)"PeakSearch has finished.");
                                                            FableMessageConsole.console.displayInfo("PeakSearch has finished.");
                                                            FableMessageConsole.console.displayInfo("For each search, one filtered Peak file (.flt) per threshold and one 2D Peak");
                                                            FableMessageConsole.console.displayInfo("file (.spt) per threshold have been created in the image directory or in your");
                                                            FableMessageConsole.console.displayInfo("Outfile directory, depending on your options.  You can either calibrate the");
                                                            FableMessageConsole.console.displayInfo("filtered Peak file in Transformation, plot spots using the PeakSearch/Open");
                                                            FableMessageConsole.console.displayInfo("3D Peak file(.flt) menu, or display 2D peaks on images using the");
                                                            FableMessageConsole.console.displayInfo("PeakSearch/Open 2D Peak file(.spt) menu.");
                                                        }
                                                        break block15;
                                                    }
                                                    if (!event.getProperty().equals("fieldChanged")) break block18;
                                                    if (this.currentDirectory == null) break block15;
                                                    property_label = (String)event.getOldValue();
                                                    val = (String)event.getNewValue();
                                                    if (!property_label.equals("first")) break block19;
                                                    try {
                                                        int nval = Integer.valueOf(val);
                                                        this.currentDirectory.setFirst(nval);
                                                    }
                                                    catch (NumberFormatException numberFormatException) {}
                                                    break block15;
                                                }
                                                if (!property_label.equals("last")) break block20;
                                                try {
                                                    int nval = Integer.valueOf(val);
                                                    this.currentDirectory.setlast(Integer.valueOf(nval).intValue());
                                                }
                                                catch (NumberFormatException numberFormatException) {}
                                                break block15;
                                            }
                                            if (!property_label.equals("stem")) break block21;
                                            this.currentDirectory.setStem(val);
                                            break block15;
                                        }
                                        if (!property_label.equals("format")) break block22;
                                        this.currentDirectory.setFileFormat(val);
                                        break block15;
                                    }
                                    if (!property_label.equals("ndigits")) break block23;
                                    this.currentDirectory.setNDigits(val);
                                    break block15;
                                }
                                if (!property_label.equals("outfile")) break block15;
                                this.currentDirectory.setPeaksearchOutfile(val);
                                break block15;
                            }
                            if (!event.getProperty().equals("currentSample")) break block24;
                            this.currentDirectory = this.controller.getCurrentsample();
                            if (this.currentDirectory != null) {
                                this.updateGuiWithCurrentSelection();
                            } else {
                                this.guiOptionsBuilder.setCurrentPath("");
                                this.guiOptionsBuilder.updateFields("stem", null);
                                this.guiOptionsBuilder.updateFields("first", null);
                                this.guiOptionsBuilder.updateFields("last", null);
                                this.guiOptionsBuilder.updateFields("format", null);
                                this.guiOptionsBuilder.updateFields("ndigits", null);
                                this.guiOptionsBuilder.updateFields("outfile", null);
                            }
                            break block15;
                        }
                        if (!event.getProperty().equals("setOptions")) break block25;
                        this.guiOptionsBuilder.setOptions();
                        break block15;
                    }
                    if (!event.getProperty().equals("unvalidate")) break block26;
                    this.peaksearch.firePeakSearchStops();
                    TypedText field = (TypedText)event.getNewValue();
                    FableMessageConsole.console.displayIn("Please check options :" + ((Xmloption)field.getData()).getOption());
                    break block15;
                }
                if (!event.getProperty().equals("load_ini")) break block27;
                Vector<Xmloption> v_options = this.peaksearch.getOptions();
                int i = 0;
                while (i < v_options.size()) {
                    Xmloption xmloption = v_options.elementAt(i);
                    this.guiOptionsBuilder.loadOptions(null, xmloption);
                    ++i;
                }
                break block15;
            }
            if (!event.getProperty().equals("save_ini")) break block15;
            this.guiOptionsBuilder.storeDefaultOptions();
            String value = (String)event.getNewValue();
            if (value != null) {
                try {
                    new Xmlwriter("root", "option", value, this.peaksearch.getOptions());
                    FableUtils.infoMsg((Object)((Object)this), (String)("Your options file " + value + " has been saved.\n\n For the next peak search, you can load these options using the \"PeakSearch/Options/Load Options\" menu or you can set this file as the default in PeakSearch preferences (\"Window|Preferences\" menu)."));
                }
                catch (XmlwriterException e) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)e.getMessage());
                }
            }
        }
    }

    public void updateGuiWithCurrentSelection() {
        this.guiOptionsBuilder.updateFields(null, "stem", this.currentDirectory != null ? this.currentDirectory.getStem() : null);
        this.guiOptionsBuilder.setCurrentPath(this.currentDirectory.getDirectoryPath());
        this.guiOptionsBuilder.updateFields(null, "first", this.currentDirectory != null ? String.valueOf(this.currentDirectory.getFirst()) : null);
        this.guiOptionsBuilder.updateFields(null, "last", this.currentDirectory != null ? String.valueOf(this.currentDirectory.getLast()) : null);
        this.guiOptionsBuilder.updateFields(null, "format", this.currentDirectory != null ? this.currentDirectory.getFileFormat() : null);
        this.guiOptionsBuilder.updateFields("ndigits", this.currentDirectory != null ? this.currentDirectory.getNDigits() : null);
        String defaultOutFile = this.guiOptionsBuilder.getdefaultValue("outfile");
        if (this.currentDirectory.getPeaksearchoutStem().equals("")) {
            this.currentDirectory.setPeaksearchOutfile(defaultOutFile);
        } else {
            this.guiOptionsBuilder.updateFields("outfile", this.currentDirectory != null ? this.currentDirectory.getPeaksearchoutStem() : defaultOutFile);
        }
    }

    public boolean validateView() {
        return this.guiOptionsBuilder.launch();
    }

    public void iniFields(String iniFile) throws PeaksearchException {
        this.peaksearch.loadIniFile(iniFile);
    }

    public Vector<Xmloption> getValues() {
        return this.guiOptionsBuilder.getOptions();
    }

    public TypedText getUnValidField() {
        return this.guiOptionsBuilder.getCurrentNonValidField();
    }

    public Vector<Xmloption> getOptions() {
        return this.guiOptionsBuilder.getOptions();
    }

    public Options getGuiBuilder() {
        return this.guiOptionsBuilder;
    }

    public Sample getCurrentDirectory() {
        return this.currentDirectory;
    }
}

