/*
 * Decompiled with CFR 0.152.
 */
package fable.peaksearch.view;

import fable.framework.navigator.controller.SampleController;
import fable.framework.views.FableMessageConsole;
import fable.peaksearch.Activator;
import fable.peaksearch.actions.OpensptFile;
import fable.peaksearch.object.PeakSelectionProvider;
import fable.peaksearch.object.Peaksearch;
import fable.python.FabioFileException;
import fable.python.Peak;
import fable.python.PeakSearchSpt;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.part.ViewPart;

public class PeaksSptView
extends ViewPart
implements IPropertyChangeListener {
    private static final String ID = "fable.peaksearch.PeaksSptView";
    public static PeaksSptView view;
    private TableViewer table;
    private TableViewer tableHeaderSpt;
    private String sptFile;
    private Vector<PeakSearchSpt> filePeaks;
    private PeakSearchSpt currentPeaks = null;
    private SashForm sash;
    final Color light_blue = new Color((Device)Display.getCurrent(), 228, 247, 248);
    private Logger logger;
    private ImageDescriptor check_imageDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/check.gif");
    private ImageDescriptor uncheck_imageDescriptor = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/uncheck.gif");
    private Listener sortListener;
    String[] titles = new String[]{"#", "Number_of_pixels", "Average_counts", "f", "s", "fc", "sc", "sig_f", "sig_s", "cov_fs"};
    Text directoryTextField;
    String currentDirectory = "";
    FableMessageConsole console;
    PeakSelectionProvider selectionProvider;
    private SampleController controller = SampleController.getController();
    private Button browse;
    private OpensptFile loadAction;
    private ImageDescriptor openFile = Activator.getImageDescriptor("images/openFiles.gif");

    public void createPartControl(Composite parent) {
        this.logger = Logger.getLogger(Peaksearch.class);
        this.selectionProvider = new PeakSelectionProvider();
        this.sortListener = new Listener(){

            public void handleEvent(Event e) {
                TableColumn sortColumn = PeaksSptView.this.table.getTable().getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = PeaksSptView.this.table.getTable().getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    PeaksSptView.this.table.getTable().setSortColumn(currentColumn);
                    dir = 1024;
                }
                TableColumn[] cols = PeaksSptView.this.table.getTable().getColumns();
                TableColumn column = (TableColumn)e.widget;
                int index = 0;
                int x = 0;
                while (index == 0 && x < cols.length) {
                    if (cols[x].getText().equals(column.getText())) {
                        index = x;
                    }
                    ++x;
                }
                PeaksSptView.this.currentPeaks.setComparator(column.getText(), dir);
                PeaksSptView.this.table.getTable().setSortDirection(dir);
                PeaksSptView.this.table.getTable().setSortColumn(column);
                PeaksSptView.this.updatePeaksTable();
            }
        };
        view = this;
        this.controller.addPropertyChangeListener((IPropertyChangeListener)this);
        this.filePeaks = new Vector();
        parent.setLayout((Layout)new GridLayout(3, false));
        this.console = (FableMessageConsole)ConsolePlugin.getDefault().getConsoleManager().getConsoles()[0];
        boolean bok = false;
        int i = 0;
        while (!bok && i < ConsolePlugin.getDefault().getConsoleManager().getConsoles().length) {
            if (ConsolePlugin.getDefault().getConsoleManager().getConsoles()[i] instanceof FableMessageConsole) {
                bok = true;
                this.console = (FableMessageConsole)ConsolePlugin.getDefault().getConsoleManager().getConsoles()[i];
            }
            ++i;
        }
        if (this.console == null) {
            this.console = new FableMessageConsole("Peaksearch console");
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
        }
        GridData gdExplorer = new GridData(4, 4, true, true);
        gdExplorer.horizontalAlignment = 4;
        gdExplorer.verticalAlignment = 4;
        gdExplorer.horizontalSpan = 3;
        Label l = new Label(parent, 0);
        l.setText("Images directory path");
        l.setToolTipText("If your images haven't been found, please set the images directory here.");
        this.directoryTextField = new Text(parent, 2048);
        this.directoryTextField.setEnabled(false);
        this.directoryTextField.setLayoutData((Object)new GridData(4, 2, true, false));
        this.directoryTextField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    PeaksSptView.this.currentDirectory = PeaksSptView.this.directoryTextField.getText();
                    PeaksSptView.this.updateImageSelected();
                }
            }
        });
        this.browse = new Button(parent, 8);
        this.browse.setText("Browse...");
        this.browse.setEnabled(false);
        this.browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dlg = new DirectoryDialog(Display.getCurrent().getActiveShell());
                dlg.setFilterPath(PeaksSptView.this.currentDirectory);
                String returnString = dlg.open();
                if (returnString != null) {
                    PeaksSptView.this.currentDirectory = String.valueOf(returnString) + System.getProperty("file.separator");
                    if (!PeaksSptView.this.currentDirectory.equals("")) {
                        PeaksSptView.this.directoryTextField.setText(PeaksSptView.this.currentDirectory);
                        PeaksSptView.this.updateImageSelected();
                    }
                }
            }
        });
        this.sash = new SashForm(parent, 256);
        this.sash.setLayoutData((Object)gdExplorer);
        this.createleftTable();
        this.createTable();
        this.sash.setWeights(new int[]{20, 50});
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        if (this.tableHeaderSpt != null) {
            this.selectionProvider.setSelectionProviderDelegate((ISelectionProvider)this.tableHeaderSpt);
        }
        this.makeActions();
        this.contributeToActionBars();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.loadAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.loadAction);
    }

    private void makeActions() {
        this.loadAction = new OpensptFile();
        this.loadAction.setText("Load a 2D peak file (.spt)");
        this.loadAction.setToolTipText("Load a 2D peak file (.spt)");
        this.loadAction.setImageDescriptor(this.openFile);
    }

    protected void updatePeaksTable() {
        Object[] peaks = this.currentPeaks.getSortedpeaks().toArray();
        this.table.setInput((Object)peaks);
        this.table.setItemCount(this.currentPeaks.getNbPeaks());
    }

    public void dispose() {
        if (this.currentPeaks != null) {
            this.currentPeaks.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.getSite().setSelectionProvider(null);
        this.controller.removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public final void loadSptFile(String sname) {
        this.sptFile = sname;
        if (this.sptFile != null) {
            this.browse.setEnabled(true);
            this.directoryTextField.setEnabled(true);
            String name = this.getSptFileName();
            this.setPartName("2D peaks: " + name);
        }
        this.filePeaks.removeAllElements();
        Job job = new Job("Loading " + this.sptFile){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    monitor.beginTask("Please, wait while loading peaks in table....", -1);
                    FileInputStream inputFileReader = new FileInputStream(PeaksSptView.this.sptFile);
                    long elapsed = System.currentTimeMillis();
                    Scanner scanner = new Scanner(inputFileReader);
                    try {
                        Pattern p = Pattern.compile("#\\s+File\\s+");
                        scanner.useDelimiter(p);
                        Pattern skip = Pattern.compile("[\t\r\n]*");
                        scanner.skip(skip);
                        while (scanner.hasNextLine()) {
                            try {
                                long blockElapse = System.currentTimeMillis();
                                String line = scanner.next();
                                Scanner getFileNameScan = new Scanner(line);
                                getFileNameScan.useDelimiter("[\n\r]+");
                                String filename = getFileNameScan.next();
                                getFileNameScan.close();
                                PeakSearchSpt peak = new PeakSearchSpt(PeaksSptView.this.sptFile);
                                PeaksSptView.this.currentPeaks = peak;
                                peak.setFabioFileName(filename);
                                PeaksSptView.this.currentPeaks.addPropertyChangeListener((IPropertyChangeListener)view);
                                PeaksSptView.this.filePeaks.add(peak);
                                peak.setKeys(PeaksSptView.this.titles);
                                peak.setNbPeaks(PeaksSptView.this.getNnPeaksInfo(line));
                                peak.setPeaks(PeaksSptView.this.getBlockPeaks(line));
                                blockElapse = System.currentTimeMillis() - blockElapse;
                                if (!monitor.isCanceled()) continue;
                                scanner.close();
                                try {
                                    inputFileReader.close();
                                }
                                catch (IOException e) {
                                    PeaksSptView.this.logger.error((Object)("initfabioFile: Problem closing input file reader after monitor cancel: " + e.getMessage()));
                                }
                                return Status.CANCEL_STATUS;
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                if (FableMessageConsole.console == null) continue;
                                FableMessageConsole.console.displayError("Fable cannot parse " + PeaksSptView.this.sptFile + " Pattern File not found.");
                            }
                        }
                        elapsed = System.currentTimeMillis() - elapsed;
                        PeaksSptView.this.populateLeftTable();
                        scanner.close();
                        try {
                            inputFileReader.close();
                        }
                        catch (IOException e) {
                            PeaksSptView.this.logger.error((Object)("initfabioFile: Problem closing input file reader: " + e.getMessage()));
                        }
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        scanner.close();
                        try {
                            inputFileReader.close();
                        }
                        catch (IOException e) {
                            PeaksSptView.this.logger.error((Object)("initfabioFile: Problem closing input file reader after PatternSyntaxException: " + e.getMessage()));
                        }
                        FableMessageConsole.console.displayIn("Peaks cannot be retrieved from this file. Make sure you have chosen a spt file.");
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    FableMessageConsole.console.displayIn("File " + PeaksSptView.this.sptFile + " not found.");
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        PeaksSptView.this.selectImageAt(0);
                    }
                });
            }
        });
    }

    private String getSptFileName() {
        assert (this.sptFile != null);
        int index = this.sptFile.lastIndexOf(System.getProperty("file.separator"));
        if (index + 1 <= this.sptFile.length()) {
            ++index;
        }
        String name = this.sptFile.substring(index);
        return name;
    }

    private void selectImageAt(int index) {
        if (this.tableHeaderSpt.getTable().getItemCount() > 0) {
            if (index >= this.tableHeaderSpt.getTable().getItemCount()) {
                index = 0;
            } else if (index < 0) {
                index = this.tableHeaderSpt.getTable().getItemCount() - 1;
            }
            this.tableHeaderSpt.getTable().setFocus();
            TableItem item = this.tableHeaderSpt.getTable().getItem(index);
            Event e = new Event();
            e.item = item;
            e.widget = this.tableHeaderSpt.getTable();
            e.type = 13;
            this.tableHeaderSpt.setSelection((ISelection)new StructuredSelection(item.getData()));
        }
    }

    private int getNnPeaksInfo(String line) {
        String np;
        String[] nbP;
        int nbPeaks = 0;
        String[] split = line.split("(#\\s+npks\\s+=)");
        if (split.length > 1 && (nbP = (np = split[1]).split("\\n")).length > 0) {
            try {
                String s = nbP[0].trim();
                nbPeaks = Integer.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return nbPeaks;
    }

    private String getBlockPeaks(String line) {
        String blockcontainingAllPeaks;
        Scanner scanner;
        block5: {
            scanner = null;
            blockcontainingAllPeaks = "";
            try {
                scanner = new Scanner(line);
                Pattern p = Pattern.compile("(#(.+)\\r*\\n)+");
                scanner.useDelimiter(p);
                if (scanner.hasNext()) {
                    scanner.next();
                    if (scanner.hasNext()) {
                        blockcontainingAllPeaks = scanner.next();
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                if (scanner == null) break block5;
                scanner.close();
            }
        }
        if (scanner != null) {
            scanner.close();
        }
        return blockcontainingAllPeaks;
    }

    private void populatePeaksTable() {
        if (this.table != null && !this.table.getTable().isDisposed()) {
            this.table.getTable().clearAll();
            this.table.getTable().removeAll();
            int nItem = 0;
            nItem = this.currentPeaks.getNbPeaks();
            this.table.setItemCount(nItem);
            this.table.setInput((Object)this.currentPeaks.getChildren().toArray());
        }
    }

    public void setFocus() {
    }

    public void createleftTable() {
        this.tableHeaderSpt = new TableViewer((Composite)this.sash);
        this.tableHeaderSpt.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableHeaderSpt.setLabelProvider((IBaseLabelProvider)new TableSptLabelProvider());
        this.tableHeaderSpt.setUseHashlookup(true);
        this.initTableHeaderSpt();
        this.tableHeaderSpt.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PeaksSptView.this.selectionProvider.setSelectionProviderDelegate(null);
                IStructuredSelection selection = (IStructuredSelection)PeaksSptView.this.tableHeaderSpt.getSelection();
                PeaksSptView.this.selectionProvider.setSelectionProviderDelegate((ISelectionProvider)PeaksSptView.this.tableHeaderSpt);
                if (selection != null && !selection.isEmpty()) {
                    PeakSearchSpt domain = (PeakSearchSpt)selection.getFirstElement();
                    PeaksSptView.this.currentPeaks = domain;
                    if (PeaksSptView.this.currentPeaks.getImageFile() == null || !PeaksSptView.this.currentPeaks.getImageFile().getFullFilename().equals(String.valueOf(PeaksSptView.this.currentDirectory) + PeaksSptView.this.currentPeaks.getFabioFileName())) {
                        PeaksSptView.this.initfabioFile();
                    }
                    this.doParsing();
                }
            }

            private void doParsing() {
                if (!$assertionsDisabled && PeaksSptView.this.currentPeaks == null) {
                    throw new AssertionError();
                }
                if (!PeaksSptView.this.currentPeaks.isParsed()) {
                    PeaksSptView.this.currentPeaks.parse();
                } else {
                    PeaksSptView.this.updatePeaksTable();
                }
            }
        });
    }

    private void initTableHeaderSpt() {
        Table leftT = this.tableHeaderSpt.getTable();
        String[] LeftColumn = new String[]{"File", "NbPeaks"};
        int i = 0;
        while (i < LeftColumn.length) {
            TableColumn tbl = new TableColumn(leftT, 16384);
            tbl.setText(LeftColumn[i]);
            ++i;
        }
        i = 0;
        while (i < LeftColumn.length) {
            leftT.getColumn(i).pack();
            ++i;
        }
        leftT.setLinesVisible(false);
        leftT.setHeaderVisible(true);
    }

    public void populateLeftTable() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PeaksSptView.this.tableHeaderSpt.getTable().removeAll();
                PeaksSptView.this.tableHeaderSpt.getTable().clearAll();
                PeaksSptView.this.tableHeaderSpt.setInput((Object)PeaksSptView.this.filePeaks.toArray());
                int i = 0;
                while (i < PeaksSptView.this.tableHeaderSpt.getTable().getColumnCount()) {
                    PeaksSptView.this.tableHeaderSpt.getTable().getColumn(i).pack();
                    ++i;
                }
            }
        });
    }

    public void createTable() {
        this.table = new TableViewer((Composite)this.sash, 268503074);
        this.table.getTable().setLinesVisible(false);
        this.table.getTable().setHeaderVisible(true);
        this.table.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.table.setLabelProvider((IBaseLabelProvider)new PeakLabelProvider());
        int i = 0;
        while (i < this.titles.length) {
            TableColumn column = new TableColumn(this.table.getTable(), 0);
            column.setText(this.titles[i]);
            column.addListener(13, this.sortListener);
            ++i;
        }
        i = 0;
        while (i < this.titles.length) {
            this.table.getTable().getColumn(i).pack();
            ++i;
        }
        this.table.getTable().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 3 && PeaksSptView.this.table.getTable().getSelectionIndex() > 0) {
                    Menu menu = new Menu((Decorations)Display.getCurrent().getActiveShell(), 8);
                    MenuItem mitemAdd = new MenuItem(menu, 8);
                    mitemAdd.setText("Check");
                    final Image imgCheck = PeaksSptView.this.check_imageDescriptor.createImage();
                    final Image imgunCheck = PeaksSptView.this.uncheck_imageDescriptor.createImage();
                    mitemAdd.setImage(imgCheck);
                    mitemAdd.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            int i = 0;
                            while (i < PeaksSptView.this.table.getTable().getSelectionCount()) {
                                PeaksSptView.this.table.getTable().getItem(PeaksSptView.this.table.getTable().getSelectionIndices()[i]).setChecked(true);
                                ++i;
                            }
                            PeaksSptView.this.table.getTable().notifyListeners(13, new Event());
                        }
                    });
                    MenuItem mitemUncheck = new MenuItem(menu, 8);
                    mitemUncheck.setText("Uncheck");
                    mitemUncheck.setImage(imgunCheck);
                    mitemUncheck.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            int i = 0;
                            while (i < PeaksSptView.this.table.getTable().getSelectionCount()) {
                                PeaksSptView.this.table.getTable().getItem(PeaksSptView.this.table.getTable().getSelectionIndices()[i]).setChecked(false);
                                ++i;
                            }
                            PeaksSptView.this.table.getTable().notifyListeners(13, new Event());
                        }
                    });
                    menu.setVisible(true);
                    while (!menu.isDisposed() && menu.isVisible()) {
                        if (Display.getCurrent().readAndDispatch()) continue;
                        Display.getCurrent().sleep();
                    }
                    menu.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            if (imgCheck != null) {
                                imgCheck.dispose();
                            }
                            if (imgunCheck != null) {
                                imgunCheck.dispose();
                            }
                        }
                    });
                    menu.dispose();
                }
            }
        });
        Listener checkSelection = new Listener(){

            public void handleEvent(Event event) {
                TableItem it = null;
                TableItem[] tableItem = PeaksSptView.this.tableHeaderSpt.getTable().getSelection();
                if (tableItem != null && tableItem.length > 0) {
                    PeaksSptView.this.currentPeaks = (PeakSearchSpt)tableItem[0].getData();
                }
                if (event.detail == 32 && (it = (TableItem)event.item).getData() != null) {
                    PeaksSptView.this.table.setSelection((ISelection)new StructuredSelection(it.getData()), true);
                }
            }
        };
        this.table.getTable().addListener(13, checkSelection);
        this.table.getTable().addListener(32, checkSelection);
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)PeaksSptView.this.table.getSelection();
                if (selection != null && !selection.isEmpty()) {
                    Object[] selections = selection.toArray();
                    int i = 0;
                    while (i < selections.length) {
                        Peak peak = (Peak)selections[i];
                        if (peak != null) {
                            peak.show(PeaksSptView.this.table.getTable().getSelection()[i].getChecked());
                        }
                        ++i;
                    }
                }
                PeaksSptView.this.selectionProvider.setSelectionProviderDelegate((ISelectionProvider)PeaksSptView.this.table);
            }
        });
        this.table.getTable().addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                int j = event.index;
                int i = PeaksSptView.this.tableHeaderSpt.getTable().getSelectionIndex();
                if (i < 0) {
                    i = 0;
                }
                PeakSearchSpt peaksSpt = (PeakSearchSpt)PeaksSptView.this.filePeaks.elementAt(i);
                Color curColor = j % 2 == 0 ? Display.getCurrent().getSystemColor(1) : PeaksSptView.this.light_blue;
                Vector peaks = peaksSpt.getChildren();
                Peak spot = (Peak)peaks.elementAt(j);
                item.setChecked(spot.isVisible());
                item.setData((Object)spot);
                item.setBackground(curColor);
            }
        });
    }

    public void initfabioFile() {
        assert (this.currentPeaks != null);
        try {
            this.currentPeaks.initFabioFile(String.valueOf(this.currentDirectory) + this.currentPeaks.getFabioFileName());
        }
        catch (FabioFileException e) {
            this.currentPeaks.setFabioFile(null);
            if (FableMessageConsole.console != null) {
                if (this.currentDirectory != null && this.currentPeaks != null && this.currentPeaks.getFabioFileName() != null) {
                    FableMessageConsole.console.displayError("Image file " + this.currentDirectory + this.currentPeaks.getFabioFileName() + " not found. ");
                }
                FableMessageConsole.console.displayInfo(" Please check image file directory is correct.");
            }
            this.logger.debug((Object)("PeaksSptView.initfabioFile: Problem with PeakSearchSpt.initFabioFile: " + e.getMessage()));
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty() != null) {
            if (event.getProperty().equals("Parsing_working")) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        PeaksSptView.this.populatePeaksTable();
                    }
                });
            } else if (event.getProperty().equals("Parsing_completed")) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        PeaksSptView.this.populatePeaksTable();
                        PeaksSptView.this.updateImageSelected();
                    }
                });
            } else if (event.getProperty().equals("next image")) {
                final int index = (Integer)event.getNewValue();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        int selectionIndex = PeaksSptView.this.tableHeaderSpt.getTable().getSelectionIndex();
                        PeaksSptView.this.selectImageAt(selectionIndex += index);
                    }
                });
            } else if (event.getProperty().equals("last image")) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        int selectionIndex = PeaksSptView.this.tableHeaderSpt.getTable().getItemCount();
                        PeaksSptView.this.selectImageAt(--selectionIndex);
                    }
                });
            } else if (event.getProperty().equals("first image")) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        PeaksSptView.this.selectImageAt(0);
                    }
                });
            }
        }
    }

    private void updateImageSelected() {
        int index = this.tableHeaderSpt.getTable().getSelectionIndex();
        if (index == -1) {
            index = 0;
        }
        if (index >= 0) {
            this.selectImageAt(index);
        }
    }

    public static String getID() {
        return ID;
    }

    class PeakLabelProvider
    implements ITableLabelProvider {
        PeakLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = "";
            if (element instanceof Peak) {
                Peak peak = (Peak)element;
                String keyWord = PeaksSptView.this.table.getTable().getColumn(columnIndex).getText();
                text = peak.getValue(keyWord);
            }
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class TableSptLabelProvider
    implements ITableLabelProvider {
        private ImageDescriptor IDgreen = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/greendot.gif");
        private ImageDescriptor IDred = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/darkred.gif");
        private ImageDescriptor IDbigGreen = Activator.imageDescriptorFromPlugin((String)"fable.peaksearch", (String)"images/greendot_big.gif");
        private Image imggreen = this.IDgreen.createImage();
        private Image bigGreen = this.IDbigGreen.createImage();
        private Image red = this.IDred.createImage();

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof PeakSearchSpt && columnIndex == 0) {
                PeakSearchSpt p = (PeakSearchSpt)element;
                if (p.getNbPeaks() <= 100) {
                    return this.imggreen;
                }
                if (p.getNbPeaks() <= 1000) {
                    return this.bigGreen;
                }
                return this.red;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = null;
            if (element instanceof PeakSearchSpt) {
                PeakSearchSpt p = (PeakSearchSpt)element;
                switch (columnIndex) {
                    case 0: {
                        text = p.getFabioFileName();
                        break;
                    }
                    case 1: {
                        text = String.valueOf(p.getNbPeaks());
                        break;
                    }
                    case 2: {
                        text = String.valueOf(p.getTreshold());
                        break;
                    }
                }
            }
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            if (this.imggreen != null) {
                this.imggreen.dispose();
            }
            if (this.bigGreen != null) {
                this.bigGreen.dispose();
            }
            if (this.red != null) {
                this.red.dispose();
            }
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

