/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.views;

import fable.framework.toolbox.FableUtils;
import fable.framework.ui.rcp.Activator;
import fable.framework.ui.views.ColFileXYPlot;
import fable.python.ColumnFile;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import jep.JepException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ColumnFilePlotView
extends ViewPart
implements IPropertyChangeListener {
    private ColFileXYPlot xyplot;
    public static ColumnFilePlotView view;
    public static final String ID = "fable.framework.ui.views.ColumnFilePlotView";
    public static int viewCount;
    private JLDataView dataViewForUniccells;
    private ColumnFile columnFile = null;
    private Action showOptionsAction;

    static {
        viewCount = 0;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        view = this;
        this.setPartName("Column File Plot " + Integer.toString(viewCount));
        this.xyplot = new ColFileXYPlot(parent, "Column File Plot " + Integer.toString(viewCount), "X", "Y");
        this.makeActions();
        this.contributeToActionBars();
    }

    private void makeActions() {
        this.showOptionsAction = new Action("Toggle Plot Options"){

            public void run() {
                if (ColumnFilePlotView.this.xyplot == null) {
                    return;
                }
                ColumnFilePlotView.this.xyplot.setOptionsShowing(!ColumnFilePlotView.this.xyplot.getOptionsShowing());
            }
        };
        this.showOptionsAction.setToolTipText("Toggle showing plot options or having plot occupy entire area");
        this.showOptionsAction.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"fable.framework.ui", (String)"images/settings.gif"));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalMenu(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.showOptionsAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.showOptionsAction);
    }

    public void dispose() {
        if (this.xyplot != null) {
            this.xyplot.dispose();
        }
        this.xyplot = null;
        if (this.columnFile != null) {
            this.columnFile.removePropertyrChangeListener((IPropertyChangeListener)this);
        }
    }

    public void setFocus() {
    }

    public ColFileXYPlot getxyPlot() {
        return this.xyplot;
    }

    public void addData(final float[] x) {
        if (!Display.getCurrent().isDisposed()) {
            Display.getCurrent().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (x != null) {
                        if (!ColumnFilePlotView.this.xyplot.getChart().getY1Axis().equals("") && !ColumnFilePlotView.this.xyplot.getChart().getXAxis().equals("")) {
                            if (ColumnFilePlotView.this.dataViewForUniccells == null) {
                                ColumnFilePlotView.this.dataViewForUniccells = new JLDataView();
                                ColumnFilePlotView.this.xyplot.getVectordataview().add(ColumnFilePlotView.this.dataViewForUniccells);
                                ColumnFilePlotView.this.dataViewForUniccells.setMarker(6);
                                ColumnFilePlotView.this.dataViewForUniccells.setLineWidth(0);
                                ColumnFilePlotView.this.dataViewForUniccells.setMarkerColor(Color.MAGENTA);
                            } else {
                                ColumnFilePlotView.this.dataViewForUniccells.reset();
                                if (!ColumnFilePlotView.this.xyplot.getVectordataview().contains(ColumnFilePlotView.this.dataViewForUniccells)) {
                                    ColumnFilePlotView.this.xyplot.getVectordataview().add(ColumnFilePlotView.this.dataViewForUniccells);
                                }
                            }
                            int i = 0;
                            while (i < x.length) {
                                ColumnFilePlotView.this.dataViewForUniccells.add(new Point2D.Double(x[i], 0.0));
                                ColumnFilePlotView.this.dataViewForUniccells.setMarkerSize(10);
                                ColumnFilePlotView.this.dataViewForUniccells.setName("Unit cell");
                                ++i;
                            }
                            ColumnFilePlotView.this.xyplot.getChart().getY1Axis().addDataView(ColumnFilePlotView.this.dataViewForUniccells);
                            ColumnFilePlotView.this.xyplot.getChart().getXAxis().setName("tth");
                            String[] label = new String[]{"tth", ""};
                            ColumnFilePlotView.this.xyplot.plotData(label);
                            ColumnFilePlotView.this.xyplot.getChart().getY1Axis().setName("");
                        }
                    } else {
                        ColumnFilePlotView.this.xyplot.getChart().setNoValueString("No value to display");
                    }
                    ColumnFilePlotView.this.xyplot.repaint();
                }
            });
        }
    }

    public void openColumnFile(String fileName) {
        try {
            this.columnFile = new ColumnFile(fileName);
            this.columnFile.addPropertyChangeListener((IPropertyChangeListener)this);
            this.xyplot.addColumnFile(this.columnFile);
        }
        catch (JepException ex) {
            FableUtils.excMsg((Object)((Object)this), (String)"Error creating ColumnFile", (Throwable)ex);
        }
    }

    public void setColumnFile(ColumnFile _columnFile) {
        this.columnFile = _columnFile;
        this.columnFile.addPropertyChangeListener((IPropertyChangeListener)this);
        if (this.columnFile.getFileName() != null) {
            this.xyplot.addColumnFile(this.columnFile);
            this.setPartName(this.columnFile.getFileName());
        }
    }

    public void browseColumnFile() {
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null) {
            try {
                FileDialog fileDlg = new FileDialog(new Shell(), 2);
                fileDlg.setText("Select one or more file(s) containing columns of data to plot");
                String file = fileDlg.open();
                if (file != null) {
                    String[] files = fileDlg.getFileNames();
                    int i = 0;
                    while (i < files.length) {
                        file = String.valueOf(fileDlg.getFilterPath()) + File.separatorChar + files[i];
                        this.openColumnFile(file);
                        ++i;
                    }
                }
            }
            catch (Exception ex) {
                FableUtils.excMsg((Object)((Object)this), (String)"Error opening view", (Throwable)ex);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("AddColumn")) {
            this.xyplot.addColumnFile((ColumnFile)event.getNewValue());
        } else if (event.getProperty().equals("updateColumn")) {
            this.xyplot.updateColumnFile((ColumnFile)event.getNewValue());
        } else if (event.getProperty().equals("AddUnitCell")) {
            this.addData(((ColumnFile)event.getNewValue()).getUnitCell());
        } else if (event.getProperty().equals("PlotData")) {
            String[] xyLabel = (String[])event.getNewValue();
            this.xyplot.plotData(xyLabel);
        } else if (event.getProperty().equals("removeAll")) {
            this.xyplot.clearAllPlots();
        }
    }

    public void saveAs() {
        FileDialog fileDlg = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        String[] filterExt = new String[]{"*.flt", "*.*"};
        String[] filterNames = new String[]{"filtered files (*.flt)", "All Files (*.*)"};
        fileDlg.setFilterExtensions(filterExt);
        fileDlg.setFilterNames(filterNames);
        fileDlg.setText("Save file");
        String file = fileDlg.open();
        if (file != null && !this.xyplot.currentColumnFile.saveColumnFile(file = String.valueOf(fileDlg.getFilterPath()) + System.getProperty("file.separator") + fileDlg.getFileName())) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Save file", (String)"Column file couldn't be saved");
        }
    }
}

