/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.TangoApi.ApiDefs;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AsynReplyNotArrived;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.CallBack;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;

public class AttributeProxy
implements ApiDefs {
    private String full_attname = null;
    private String attname = null;
    private String alias = null;
    private DeviceProxy dev;
    private int idl_version = -1;

    public AttributeProxy(String string) throws DevFailed {
        if (string.indexOf(47) < 0) {
            this.alias = string;
            string = ApiUtil.get_db_obj().get_attribute_alias(this.alias);
        }
        String string2 = string.substring(0, string.lastIndexOf("/", string.length() - 1));
        this.full_attname = string;
        this.attname = string.substring(string.lastIndexOf("/", string.length() - 1) + 1);
        this.dev = new DeviceProxy(string2);
    }

    public int get_idl_version() throws DevFailed {
        if (this.idl_version < 0) {
            this.idl_version = this.dev.get_idl_version();
        }
        return this.idl_version;
    }

    public String fullName() {
        return this.full_attname;
    }

    public String name() {
        return this.attname;
    }

    public long ping() throws DevFailed {
        return this.dev.ping();
    }

    public DevState state() throws DevFailed {
        return this.dev.state();
    }

    public String status() throws DevFailed {
        return this.dev.status();
    }

    public DbAttribute get_property() throws DevFailed {
        return this.dev.get_attribute_property(this.attname);
    }

    public void put_property(DbDatum dbDatum) throws DevFailed {
        DbAttribute dbAttribute = new DbAttribute(this.attname);
        dbAttribute.add(dbDatum);
        this.dev.put_attribute_property(dbAttribute);
    }

    public void put_property(DbDatum[] dbDatumArray) throws DevFailed {
        DbAttribute dbAttribute = new DbAttribute(this.attname);
        for (int i = 0; i < dbDatumArray.length; ++i) {
            dbAttribute.add(dbDatumArray[i]);
        }
        this.dev.put_attribute_property(dbAttribute);
    }

    public void delete_property(String string) throws DevFailed {
        this.dev.delete_attribute_property(this.attname, string);
    }

    public void delete_property(String[] stringArray) throws DevFailed {
        this.dev.delete_attribute_property(this.attname, stringArray);
    }

    public AttributeInfo get_info() throws DevFailed {
        return this.dev.get_attribute_info(this.attname);
    }

    public AttributeInfoEx get_info_ex() throws DevFailed {
        return this.dev.get_attribute_info_ex(this.attname);
    }

    public void set_info(AttributeInfo[] attributeInfoArray) throws DevFailed {
        this.dev.set_attribute_info(attributeInfoArray);
    }

    public void set_info(AttributeInfoEx[] attributeInfoExArray) throws DevFailed {
        this.dev.set_attribute_info(attributeInfoExArray);
    }

    public DeviceAttribute read() throws DevFailed {
        return this.dev.read_attribute(this.attname);
    }

    public void write(DeviceAttribute deviceAttribute) throws DevFailed {
        this.dev.write_attribute(deviceAttribute);
    }

    public DeviceDataHistory[] history(int n) throws DevFailed {
        return this.dev.attribute_history(this.attname, n);
    }

    public DeviceDataHistory[] history() throws DevFailed {
        return this.dev.attribute_history(this.attname);
    }

    public void poll(int n) throws DevFailed {
        this.dev.poll_attribute(this.attname, n);
    }

    public void stop_poll() throws DevFailed {
        this.dev.stop_poll_attribute(this.attname);
    }

    public int read_asynch() throws DevFailed {
        return this.dev.read_attribute_asynch(this.attname);
    }

    public void read_asynch(CallBack callBack) throws DevFailed {
        this.dev.read_attribute_asynch(this.attname, callBack);
    }

    public DeviceAttribute[] read_reply(int n, int n2) throws DevFailed, AsynReplyNotArrived {
        return this.dev.read_attribute_reply(n, n2);
    }

    public DeviceAttribute[] read_reply(int n) throws DevFailed, AsynReplyNotArrived {
        return this.dev.read_attribute_reply(n);
    }

    public int write_asynch(DeviceAttribute deviceAttribute) throws DevFailed {
        return this.dev.write_attribute_asynch(deviceAttribute);
    }

    public int write_asynch(DeviceAttribute deviceAttribute, boolean bl) throws DevFailed {
        return this.dev.write_attribute_asynch(deviceAttribute, bl);
    }

    public void write_asynch(DeviceAttribute deviceAttribute, CallBack callBack) throws DevFailed {
        this.dev.write_attribute_asynch(deviceAttribute, callBack);
    }

    public void write_reply(int n) throws DevFailed, AsynReplyNotArrived {
        this.dev.write_attribute_reply(n);
    }

    public void write_reply(int n, int n2) throws DevFailed, AsynReplyNotArrived {
        this.dev.write_attribute_reply(n, n2);
    }

    public int subscribe_event(int n, CallBack callBack, String[] stringArray) throws DevFailed {
        return this.dev.subscribe_event(this.attname, n, callBack, stringArray);
    }

    public static void main(String[] stringArray) {
        String string = "tango/admin/corvus/hoststate";
        try {
            AttributeProxy attributeProxy = new AttributeProxy(string);
            attributeProxy.ping();
            System.out.println(attributeProxy.name() + " is alive");
            DbAttribute dbAttribute = attributeProxy.get_property();
            for (int i = 0; i < dbAttribute.size(); ++i) {
                DbDatum dbDatum = dbAttribute.datum(i);
                System.out.println(dbDatum.name + " : " + dbDatum.extractString());
            }
            DeviceAttribute deviceAttribute = attributeProxy.read();
            System.out.println(attributeProxy.name() + " : " + deviceAttribute.extractShort());
            System.out.println(attributeProxy.name() + " state  : " + ApiUtil.stateName(attributeProxy.state()));
            System.out.println(attributeProxy.name() + " status : " + attributeProxy.status());
        }
        catch (DevFailed devFailed) {
            Except.print_exception(devFailed);
        }
    }
}

