/*
 * Decompiled with CFR 0.152.
 */
package fable.transformation.views;

import fable.framework.toolbox.FileText;
import fable.framework.toolbox.FloatText;
import fable.framework.toolbox.StringText;
import fable.framework.toolbox.ToolBox;
import fable.framework.toolbox.TypedText;
import fable.framework.views.FableMessageConsole;
import fable.python.ColumnFile;
import fable.transformation.Activator;
import fable.transformation.actions.AddUnitCellPeaksAction;
import fable.transformation.actions.ComputeHistProbAction;
import fable.transformation.actions.ComputeTthEtaAction;
import fable.transformation.actions.ComputegveAction;
import fable.transformation.object.Transform;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.part.ViewPart;

public class TransformView
extends ViewPart
implements IPropertyChangeListener {
    public static final String ID = "fable.transformation.views.transformView";
    public static TransformView view;
    String currentFilteredFileName = "";
    Button computettheta;
    Button addUnitCell;
    Button tthHisto;
    Button fit;
    Button btn_savegve;
    Button btn_saveflt;
    FileText fileFilteredPeaks;
    StringText gvectorfilename;
    StringText filteredFiletoSave;
    double[] x;
    double[] y;
    public String currentPath;
    private IMemento memento = null;
    Transform transformer;
    Button editParam;
    Button gvector;
    JLDataView current_dataView = null;
    JLDataView dataViewForUniccells;
    FableMessageConsole console;
    Group grpFit;
    Group grpComputation;
    Button btn_browseFiltered;
    boolean bComputeTTH = false;
    boolean bComputeUnitCell = false;
    boolean bComputeTthHisto = false;
    boolean bComputegVectors = false;
    FloatText tthmin;
    FloatText tthmax;
    private boolean fieldsAreOk = true;
    Job job;
    Job jobTthEta;
    Job jobHisto;
    Job jobUnitcell;
    Job jobGve;
    Job jobFit;
    Display display;
    private final ImageDescriptor saveAsFlt = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"images/saveAsflt.gif");
    private final ImageDescriptor saveAsGvec = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"images/saveAsGve.gif");
    private final ImageDescriptor step1ImgDesc = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"images/step1.gif");
    private final ImageDescriptor step2ImgDesc = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"images/step2.gif");
    private final ImageDescriptor step3ImgDesc = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"images/step3.gif");
    private final ImageDescriptor stepGveImgDesc = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"images/stepGve.gif");
    private final ImageDescriptor stepFit = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"images/fit.gif");
    private Image imagestep1;
    private Image imageStep2;
    private Image imageStep3;
    private Image imageGve;
    private Image imageFit;
    private IAction fitAction;
    private IAction computeTthEtaAction;
    private IAction computeHistProbAction;
    private IAction AddUnitCellPeaksAction;
    private IAction saveGveAction;
    private IAction savefilteredPeaksAction;
    private IAction computeGveAction;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.memento = memento;
    }

    public void createPartControl(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        Composite mainComposite = new Composite((Composite)scrolledComposite, 20);
        scrolledComposite.setContent((Control)mainComposite);
        mainComposite.setLayout((Layout)new GridLayout(1, false));
        mainComposite.setLayoutData((Object)new GridData());
        mainComposite.pack();
        this.display = Display.getCurrent();
        this.makeActions();
        if (FableMessageConsole.console == null) {
            this.console = new FableMessageConsole("Calibration");
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
        } else {
            this.console = FableMessageConsole.console;
        }
        this.console.displayOut("Welcome to transformation " + ToolBox.getPluginVersion((String)"fable.transformation"));
        IOConsoleOutputStream stream = this.console.newOutputStream();
        System.setOut(new PrintStream((OutputStream)stream, true));
        System.setErr(new PrintStream((OutputStream)stream));
        this.transformer = Transform.getTransformer();
        this.transformer.addPropertyChangeListener(this);
        view = this;
        if (this.memento != null) {
            this.currentPath = this.memento.getString("FILTERED_FILE_PATH");
        }
        this.grpComputation = new Group(mainComposite, 0);
        this.grpComputation.setLayout((Layout)new GridLayout());
        ((GridLayout)this.grpComputation.getLayout()).numColumns = 5;
        this.grpComputation.setLayoutData((Object)new GridData(4, 4, true, false, 1, 2));
        this.grpComputation.setText("");
        this.fileFilteredPeaks = new FileText((Composite)this.grpComputation, 0, "Filtered peaks file");
        this.fileFilteredPeaks.setToolTipText("Load filtered file .flt, output file from Peaksearch");
        this.fileFilteredPeaks.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.fileFilteredPeaks.set_isRequiredField(true);
        this.fileFilteredPeaks.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    TransformView.this.actionOnFilteredFieldChanges();
                }
            }
        });
        this.btn_browseFiltered = new Button((Composite)this.grpComputation, 8);
        this.btn_browseFiltered.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.btn_browseFiltered.setText("Browse...");
        this.btn_browseFiltered.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(((Button)e.widget).getParent().getShell(), 64);
                dlg.setFilterNames(new String[]{"*.flt", "All Files (*.*)"});
                dlg.setFilterExtensions(new String[]{"*.flt", "*.*"});
                dlg.setFilterPath(TransformView.this.currentPath);
                String sFile = dlg.open();
                TransformView.this.currentFilteredFileName = dlg.getFileName();
                if (sFile != null) {
                    TransformView.this.fileFilteredPeaks.set_Text(sFile);
                    TransformView.this.currentPath = dlg.getFilterPath();
                    TransformView.this.actionOnFilteredFieldChanges();
                }
            }
        });
        this.computettheta = new Button((Composite)this.grpComputation, 8);
        this.computettheta.setText("Compute tth eta");
        this.computettheta.setToolTipText("Compute tth eta");
        this.imagestep1 = this.step1ImgDesc.createImage();
        this.computettheta.setImage(this.imagestep1);
        this.computettheta.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransformView.this.jobcompute_tthEta();
            }
        });
        this.computettheta.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TransformView.this.imagestep1 != null && !TransformView.this.imagestep1.isDisposed()) {
                    TransformView.this.imagestep1.dispose();
                }
            }
        });
        this.computettheta.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        this.addUnitCell = new Button((Composite)this.grpComputation, 8);
        this.addUnitCell.setText("Plot unit cell peaks");
        this.addUnitCell.setToolTipText("Adds unit cell peak and plots them. Computes tth if it has not been done");
        this.imageStep2 = this.step2ImgDesc.createImage();
        this.addUnitCell.setImage(this.imageStep2);
        this.addUnitCell.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransformView.this.jobAddUnitCell();
            }
        });
        this.addUnitCell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TransformView.this.imageStep2 != null && !TransformView.this.imageStep2.isDisposed()) {
                    TransformView.this.imageStep2.dispose();
                }
            }
        });
        this.addUnitCell.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        this.gvector = new Button((Composite)this.grpComputation, 8);
        this.gvector.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        this.gvector.setText("Compute gv");
        this.imageGve = this.stepGveImgDesc.createImage();
        this.gvector.setImage(this.imageGve);
        this.gvector.setToolTipText("Computes g-vectors  ; adds unit cell peaks if it has not been done");
        this.gvector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransformView.this.jobCompute_computeGve();
            }
        });
        this.gvector.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TransformView.this.imageGve != null && !TransformView.this.imageGve.isDisposed()) {
                    TransformView.this.imageGve.dispose();
                }
            }
        });
        this.tthHisto = new Button((Composite)this.grpComputation, 8);
        this.tthHisto.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        this.tthHisto.setText("Tth histogram");
        this.imageStep3 = this.step3ImgDesc.createImage();
        this.tthHisto.setImage(this.imageStep3);
        this.tthHisto.setToolTipText("Compute the histogram over twotheta for peaks previously read in ");
        this.tthHisto.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransformView.this.jobCompute_tthHisto();
            }
        });
        this.tthHisto.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TransformView.this.imageStep3 != null && !TransformView.this.imageStep3.isDisposed()) {
                    TransformView.this.imageStep3.dispose();
                }
            }
        });
        this.grpFit = new Group(mainComposite, 0);
        this.grpFit.setLayout((Layout)new GridLayout());
        this.grpFit.setToolTipText("Fit between tthmin and tthmax. Enabled if parameters have vary values checked, tth and eta have been computed,  and unit cell have been added to an existing filtered peaks file");
        this.grpFit.setLayoutData((Object)new GridData(4, 4, true, false, 1, 2));
        ((GridLayout)this.grpFit.getLayout()).numColumns = 3;
        this.grpFit.setText("Fit");
        this.tthmin = new FloatText((Composite)this.grpFit, 0, "tth min");
        this.tthmin.set_isRequiredField(true);
        this.tthmin.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.tthmax = new FloatText((Composite)this.grpFit, 0, "tth max");
        this.tthmax.set_isRequiredField(true);
        this.tthmax.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.tthmax.set_Text("180");
        this.tthmin.set_Text("0");
        this.fit = new Button((Composite)this.grpFit, 8);
        this.fit.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.imageFit = this.stepFit.createImage();
        this.fit.setImage(this.imageFit);
        this.fit.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TransformView.this.imageFit != null && !TransformView.this.imageFit.isDisposed()) {
                    TransformView.this.imageFit.dispose();
                }
            }
        });
        this.fit.setText("Fit");
        this.fit.setToolTipText("Fit between tthmin and tthmax");
        this.fit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransformView.this.fit();
            }
        });
        Group grp_gvect = new Group(mainComposite, 0);
        grp_gvect.setLayout((Layout)new GridLayout());
        grp_gvect.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ((GridLayout)grp_gvect.getLayout()).numColumns = 2;
        ((GridLayout)grp_gvect.getLayout()).makeColumnsEqualWidth = false;
        grp_gvect.setText("Save files");
        this.gvectorfilename = new StringText((Composite)grp_gvect, 0, "G-vectors file name");
        this.gvectorfilename.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        final Image saveGveImage = this.saveAsGvec.createImage();
        this.btn_savegve = new Button((Composite)grp_gvect, 8);
        this.btn_savegve.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.btn_savegve.setImage(saveGveImage);
        this.btn_savegve.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (saveGveImage != null && !saveGveImage.isDisposed()) {
                    saveGveImage.dispose();
                }
            }
        });
        this.btn_savegve.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransformView.this.saveGveAs();
            }
        });
        this.filteredFiletoSave = new StringText((Composite)grp_gvect, 0, "Filtered peaks file name");
        this.filteredFiletoSave.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btn_saveflt = new Button((Composite)grp_gvect, 8);
        final Image imagesaveAsFlt = this.saveAsFlt.createImage();
        this.btn_saveflt.setImage(imagesaveAsFlt);
        this.btn_saveflt.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (imagesaveAsFlt != null && !imagesaveAsFlt.isDisposed()) {
                    imagesaveAsFlt.dispose();
                }
            }
        });
        this.btn_saveflt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransformView.this.saveAsFilteredPeaksFile();
            }
        });
        String filteredFileName = this.transformer.getColumnfile().getFileName();
        if (filteredFileName != null && !filteredFileName.equals("")) {
            this.fileFilteredPeaks.set_Text(filteredFileName);
            this.actionOnFilteredFieldChanges();
        }
        scrolledComposite.setMinHeight(this.display.getPrimaryMonitor().getBounds().height);
        scrolledComposite.setMinWidth(this.display.getPrimaryMonitor().getBounds().width);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setMinSize(mainComposite.computeSize(-1, -1));
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.ComputeTthEtaAction", (IAction)new ComputeTthEtaAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.AddUnitCellPeaksAction", (IAction)new AddUnitCellPeaksAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.ComputeHistProbAction", (IAction)new ComputeHistProbAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.ComputegveAction", (IAction)new ComputegveAction());
    }

    private void makeActions() {
        this.fitAction = new Action(){

            public void run() {
                TransformView.this.fit();
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.fitAction", this.fitAction);
        this.fitAction.setId("fable.transformation.actions.fitAction");
        this.computeTthEtaAction = new Action(){

            public void run() {
                TransformView.this.jobcompute_tthEta();
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.ComputeTthEtaAction", this.computeTthEtaAction);
        this.computeTthEtaAction.setId("fable.transformation.actions.ComputeTthEtaAction");
        this.computeHistProbAction = new Action(){

            public void run() {
                TransformView.this.jobCompute_tthHisto();
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.computeHistProbAction", this.computeHistProbAction);
        this.computeHistProbAction.setId("fable.transformation.actions.ComputeHistProbAction");
        this.AddUnitCellPeaksAction = new Action(){

            public void run() {
                TransformView.this.jobAddUnitCell();
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.AddUnitCellPeaksAction", this.AddUnitCellPeaksAction);
        this.AddUnitCellPeaksAction.setId("fable.transformation.actions.AddUnitCellPeaksAction");
        this.saveGveAction = new Action(){

            public void run() {
                TransformView.this.saveGveAs();
            }
        };
        this.saveGveAction.setId("fable.transformation.actions.saveGve");
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.saveGve", this.saveGveAction);
        this.savefilteredPeaksAction = new Action(){

            public void run() {
                TransformView.this.saveAsFilteredPeaksFile();
            }
        };
        this.savefilteredPeaksAction.setId("fable.transformation.actions.savefilteredPeaksAction");
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.savefilteredPeaksAction", this.savefilteredPeaksAction);
        this.computeGveAction = new Action(){

            public void run() {
                TransformView.this.jobCompute_computeGve();
            }
        };
        this.computeGveAction.setId("fable.transformation.actions.ComputegveAction");
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.ComputegveAction", this.computeGveAction);
    }

    private boolean isFittingIsEnabled() {
        return this.bComputeTTH && this.bComputeUnitCell && !this.fileFilteredPeaks.equals("") && this.fileFilteredPeaks.is_bValide() && this.transformer.getvaryList() > 0;
    }

    private void resetAllButtonsPressed() {
        this.bComputeTTH = false;
        this.bComputeTthHisto = false;
        this.bComputegVectors = false;
        this.bComputeUnitCell = false;
    }

    private void actionOnFilteredFieldChanges() {
        String filteredFieldtext = this.fileFilteredPeaks.getText();
        int lastIndexOfSep = filteredFieldtext.lastIndexOf(System.getProperty("file.separator"));
        this.currentFilteredFileName = lastIndexOfSep + 1 < filteredFieldtext.length() ? filteredFieldtext.substring(lastIndexOfSep + 1) : filteredFieldtext;
        this.currentPath = lastIndexOfSep >= 0 && lastIndexOfSep < filteredFieldtext.length() && lastIndexOfSep > 0 ? filteredFieldtext.substring(0, lastIndexOfSep) : "";
        this.resetAllButtonsPressed();
        this.loadfilteredPeaks();
        this.updateFields();
    }

    public void jobcompute_tthEta() {
        if (this.jobTthEta == null) {
            this.jobTthEta = new Job("Compute tth, eta"){

                protected IStatus run(final IProgressMonitor monitor) {
                    if (TransformView.this.fieldsAreOk) {
                        monitor.beginTask("Compute tth, eta", -1);
                        TransformView.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).TransformView.this.fileFilteredPeaks.is_bValide()) {
                                    monitor.subTask("Compute tth, eta");
                                    if (!(this).TransformView.this.transformer.compute_tth_eta()) {
                                        monitor.setCanceled(true);
                                    } else {
                                        (this).TransformView.this.console.displayOut("Compute tth, eta done");
                                    }
                                }
                            }
                        });
                    } else {
                        TransformView.this.fileFilteredPeaks.showDecoration();
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        this.jobTthEta.setUser(true);
        this.bComputeTTH = true;
        this.jobTthEta.schedule();
    }

    public void jobAddUnitCell() {
        if (this.jobUnitcell == null) {
            this.jobUnitcell = new Job("Add unit cell peak"){

                protected IStatus run(final IProgressMonitor monitor) {
                    if (TransformView.this.fieldsAreOk) {
                        monitor.beginTask("Add unit cell peak", -1);
                        TransformView.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).TransformView.this.fileFilteredPeaks.is_bValide()) {
                                    monitor.subTask("Add unit cell peak");
                                    if (!(this).TransformView.this.transformer.addUnitCellPeaks()) {
                                        monitor.setCanceled(true);
                                    } else {
                                        (this).TransformView.this.console.displayOut("Adding unit cell peak done");
                                    }
                                }
                            }
                        });
                    } else {
                        TransformView.this.fileFilteredPeaks.showDecoration();
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        this.jobUnitcell.setUser(true);
        this.bComputeUnitCell = true;
        this.jobUnitcell.schedule();
    }

    public void jobCompute_tthHisto() {
        if (this.jobHisto == null) {
            this.jobHisto = new Job("Compute tth histogram"){

                protected IStatus run(final IProgressMonitor monitor) {
                    if (TransformView.this.fieldsAreOk) {
                        monitor.beginTask("Compute tth histogram", -1);
                        TransformView.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                monitor.subTask("Compute tth histogram");
                                if (!(this).TransformView.this.transformer.compute_tth_histo()) {
                                    monitor.setCanceled(true);
                                } else {
                                    (this).TransformView.this.console.displayOut("Computing tth histogram done");
                                }
                            }
                        });
                    } else {
                        TransformView.this.fileFilteredPeaks.showDecoration();
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        this.jobHisto.setUser(true);
        this.bComputeTthHisto = true;
        this.jobHisto.schedule();
    }

    public void jobCompute_computeGve() {
        if (this.jobGve == null) {
            this.jobGve = new Job("Compute g-vectors"){

                protected IStatus run(final IProgressMonitor monitor) {
                    if (TransformView.this.fieldsAreOk) {
                        monitor.beginTask("Compute g-vectors", -1);
                        TransformView.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                monitor.subTask("Compute g-vectors");
                                if (!(this).TransformView.this.transformer.computegv()) {
                                    monitor.setCanceled(true);
                                } else {
                                    (this).TransformView.this.console.displayOut("Computing g-vectors done");
                                }
                            }
                        });
                    } else {
                        TransformView.this.fileFilteredPeaks.showDecoration();
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
        }
        this.jobGve.setUser(true);
        this.bComputegVectors = true;
        this.jobGve.schedule();
    }

    public void fit() {
        if (this.jobFit == null) {
            this.jobFit = new Job("Fit"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (TransformView.this.fieldsAreOk) {
                        monitor.beginTask("Wait while transformer is fitting", -1);
                        TransformView.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).TransformView.this.tthmin.is_bValide() && (this).TransformView.this.tthmax.is_bValide()) {
                                    if (Float.valueOf((this).TransformView.this.tthmin.getText()).floatValue() < Float.valueOf((this).TransformView.this.tthmax.getText()).floatValue()) {
                                        if ((this).TransformView.this.transformer.fit(Float.valueOf((this).TransformView.this.tthmin.getText()).floatValue(), Float.valueOf((this).TransformView.this.tthmax.getText()).floatValue())) {
                                            (this).TransformView.this.console.displayOut("Fit done");
                                        } else {
                                            (this).TransformView.this.console.displayIn("Fit not done");
                                        }
                                    } else {
                                        (this).TransformView.this.console.displayIn("Tth max should be greater than tth min ");
                                        (this).TransformView.this.tthmin.set_bValide(false);
                                        (this).TransformView.this.tthmax.set_bValide(false);
                                    }
                                } else {
                                    (this).TransformView.this.tthmin.showDecoration();
                                    (this).TransformView.this.tthmax.showDecoration();
                                }
                            }
                        });
                    } else {
                        TransformView.this.fileFilteredPeaks.showDecoration();
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        this.jobFit.setUser(true);
        this.jobFit.schedule();
    }

    private void createJob() {
        this.job = new Job("Compute values for calibration"){

            protected IStatus run(final IProgressMonitor monitor) {
                monitor.beginTask("Compute selected options again", 100);
                if (monitor.isCanceled()) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                TransformView.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).TransformView.this.fileFilteredPeaks.getText().equals("")) {
                            (this).TransformView.this.fileFilteredPeaks.showDecoration();
                            TransformView.this.fieldsAreOk = false;
                        }
                    }
                });
                monitor.worked(5);
                if (monitor.isCanceled()) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                if (TransformView.this.fieldsAreOk) {
                    TransformView.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).TransformView.this.fileFilteredPeaks.is_bValide()) {
                                if ((this).TransformView.this.bComputeTTH) {
                                    monitor.subTask("Compute tth, eta");
                                    if (!(this).TransformView.this.transformer.compute_tth_eta()) {
                                        monitor.setCanceled(true);
                                    } else if ((this).TransformView.this.console != null) {
                                        (this).TransformView.this.console.displayOut("Tth and eta have been computed again with new parameters");
                                    }
                                }
                            } else {
                                (this).TransformView.this.fileFilteredPeaks.showDecoration();
                            }
                        }
                    });
                    monitor.worked(20);
                    if (monitor.isCanceled()) {
                        monitor.done();
                        return Status.CANCEL_STATUS;
                    }
                    TransformView.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).TransformView.this.fileFilteredPeaks.is_bValide()) {
                                if ((this).TransformView.this.bComputeUnitCell) {
                                    monitor.subTask("Add unit cell peak");
                                    if (!(this).TransformView.this.transformer.addUnitCellPeaks()) {
                                        monitor.setCanceled(true);
                                    } else if ((this).TransformView.this.console != null) {
                                        (this).TransformView.this.console.displayOut("Unit cell peaks have been computed again");
                                    }
                                }
                            } else {
                                (this).TransformView.this.fileFilteredPeaks.showDecoration();
                            }
                        }
                    });
                    monitor.worked(25);
                    if (monitor.isCanceled()) {
                        monitor.done();
                        return Status.CANCEL_STATUS;
                    }
                    TransformView.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).TransformView.this.fileFilteredPeaks.is_bValide()) {
                                if ((this).TransformView.this.bComputegVectors) {
                                    monitor.subTask("Compute g-vectors");
                                    if (!(this).TransformView.this.transformer.computegv()) {
                                        monitor.setCanceled(true);
                                    } else if ((this).TransformView.this.console != null) {
                                        (this).TransformView.this.console.displayOut("G-vectors have been computed again");
                                    }
                                }
                            } else {
                                (this).TransformView.this.fileFilteredPeaks.showDecoration();
                            }
                        }
                    });
                    monitor.worked(25);
                    if (monitor.isCanceled()) {
                        monitor.done();
                        return Status.CANCEL_STATUS;
                    }
                    TransformView.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).TransformView.this.fileFilteredPeaks.is_bValide()) {
                                if ((this).TransformView.this.bComputeTthHisto) {
                                    monitor.subTask("Compute tth histogram");
                                    if (!(this).TransformView.this.transformer.compute_tth_histo()) {
                                        monitor.setCanceled(true);
                                    } else if ((this).TransformView.this.console != null) {
                                        (this).TransformView.this.console.displayOut("Tth histogram has been computed again");
                                    }
                                } else {
                                    (this).TransformView.this.fileFilteredPeaks.showDecoration();
                                }
                            }
                        }
                    });
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        this.job.setUser(true);
    }

    private void compute() {
        if (this.job == null) {
            this.createJob();
        }
        this.job.schedule();
    }

    private void updateFields() {
        if (this.fileFilteredPeaks.is_bValide() && this.fileFilteredPeaks.getText().length() > 0) {
            int index;
            int n = index = this.fileFilteredPeaks.getText().lastIndexOf(".flt") > -1 ? this.fileFilteredPeaks.getText().lastIndexOf(".flt") : this.fileFilteredPeaks.getText().lastIndexOf(".");
            if (index > 0) {
                String name = String.valueOf(this.fileFilteredPeaks.getText().substring(0, index)) + ".gve";
                this.gvectorfilename.set_Text(name);
            } else if (!this.fileFilteredPeaks.getText().trim().equals("")) {
                this.gvectorfilename.set_Text(String.valueOf(this.fileFilteredPeaks.getText()) + ".gve");
            }
            this.filteredFiletoSave.set_Text(this.fileFilteredPeaks.getText());
        } else {
            this.gvectorfilename.set_Text("");
            this.filteredFiletoSave.set_Text("");
        }
        this.fileFilteredPeaks.getTextField().setFocus();
    }

    public void setFocus() {
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString("FILTERED_FILE_PATH", this.currentPath);
    }

    private void loadfilteredPeaks() {
        new Job("Wait while loading filtered peaks file : " + this.fileFilteredPeaks.getText()){

            protected IStatus run(IProgressMonitor monitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        int index = (this).TransformView.this.fileFilteredPeaks.getText().lastIndexOf(System.getProperty("file.separator")) > -1 ? (this).TransformView.this.fileFilteredPeaks.getText().lastIndexOf(System.getProperty("file.separator")) : 0;
                        (this).TransformView.this.currentPath = (this).TransformView.this.fileFilteredPeaks.getText().substring(index);
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.framework.ui.views.ColumnFilePlotView");
                        }
                        catch (PartInitException partInitException) {
                            (this).TransformView.this.console.displayOut("Plot view not found");
                        }
                        if ((this).TransformView.this.fileFilteredPeaks.is_bValide() && !(this).TransformView.this.fileFilteredPeaks.getText().equals("")) {
                            if (!(this).TransformView.this.transformer.loadFiltered((this).TransformView.this.fileFilteredPeaks.getText())) {
                                if ((this).TransformView.this.console != null) {
                                    (this).TransformView.this.console.displayIn("Filtered peaks file has not been loaded");
                                    (this).TransformView.this.fileFilteredPeaks.set_bValide(false);
                                }
                            } else {
                                (this).TransformView.this.fileFilteredPeaks.set_bValide(true);
                            }
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void dispose() {
        this.transformer.removePropertyChangeListener(this);
    }

    public void loadfilteredPeaks(String fileName) {
        this.fileFilteredPeaks.set_Text(fileName);
        this.updateFields();
        this.loadfilteredPeaks();
    }

    private void enableGroup(Composite grp, boolean enable) {
        Control[] widgets = grp.getChildren() != null ? grp.getChildren() : null;
        int i = 0;
        while (widgets != null && i < widgets.length) {
            if (widgets[i] instanceof TypedText || widgets[i] instanceof Button || widgets[i] instanceof Text) {
                widgets[i].setEnabled(enable);
            } else if (widgets[i] instanceof Composite) {
                this.enableGroup((Composite)widgets[i], enable);
            }
            ++i;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("refresh")) {
            this.console.displayOut("Parameters have been updated. ");
            if (!this.fileFilteredPeaks.getText().equals("")) {
                this.compute();
            }
        } else if (event.getProperty().equals("currentProjectPath")) {
            this.currentPath = (String)event.getNewValue();
        } else if (event.getProperty().equals("varyList")) {
            if ((Integer)event.getNewValue() > 0) {
                this.grpFit.setToolTipText("Fit with variable parameters checked");
            } else {
                this.grpFit.setToolTipText("Please, check at least one variable parameter before fitting");
            }
        } else if (event.getProperty().equals("updateFields")) {
            String name;
            System.out.println("Transformer has a new column file. We are going to update fields");
            ColumnFile colFile = this.transformer.getColumnfile();
            if (colFile != null && (name = colFile.getFullFileName()) != null && name.length() > 0) {
                this.fileFilteredPeaks.set_Text(name);
                this.resetAllButtonsPressed();
                this.updateFields();
            }
        }
    }

    public void saveGveAs() {
        FileDialog fileDlg = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        String[] filterExt = new String[]{"*.gve", "*.*"};
        String[] filterNames = new String[]{"gve files (*.gve)", "All Files (*.*)"};
        fileDlg.setFilterExtensions(filterExt);
        fileDlg.setFilterNames(filterNames);
        fileDlg.setFileName(this.gvectorfilename.getText());
        fileDlg.setFilterPath(this.gvectorfilename.getText().equals("") ? this.currentPath : this.gvectorfilename.getText());
        fileDlg.setText("Save gve file as...");
        String file = fileDlg.open();
        if (file != null) {
            file = String.valueOf(fileDlg.getFilterPath()) + System.getProperty("file.separator") + fileDlg.getFileName();
            this.gvectorfilename.set_Text(file);
            if (this.transformer.savegv(file)) {
                if (FableMessageConsole.console != null) {
                    this.console.displayOut("G-vectors have been saved in " + file);
                }
            } else if (FableMessageConsole.console != null) {
                this.console.displayIn("An error occured ; G-vectors in " + file + " have not been saved.");
            }
        }
    }

    public void saveAsFilteredPeaksFile() {
        FileDialog fileDlg = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        String[] filterExt = new String[]{"*.flt", "*.*"};
        String[] filterNames = new String[]{"flt files (*.flt)", "All Files (*.*)"};
        fileDlg.setFilterExtensions(filterExt);
        fileDlg.setFilterNames(filterNames);
        fileDlg.setFileName(this.filteredFiletoSave.getText());
        fileDlg.setFilterPath(this.filteredFiletoSave.getText().equals("") ? this.currentPath : this.filteredFiletoSave.getText());
        fileDlg.setText("Save flt file as...");
        String file = fileDlg.open();
        if (file != null) {
            file = String.valueOf(fileDlg.getFilterPath()) + System.getProperty("file.separator") + fileDlg.getFileName();
            this.filteredFiletoSave.set_Text(file);
            if (this.transformer.saveFilteredPeaks(file)) {
                if (FableMessageConsole.console != null) {
                    this.console.displayOut("Selected filtered peaks have been saved in " + file);
                }
            } else if (FableMessageConsole.console != null) {
                this.console.displayIn("An error occured ; filtered peaks in " + file + " have not been saved.");
            }
        }
    }
}

