/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.toolbox.FableUtils;
import fable.imageviewer.actions.ImageViewActions;
import fable.imageviewer.internal.Coordinates;
import fable.imageviewer.internal.CustomCoordinatesDialog;
import fable.imageviewer.internal.IImagesVarKeys;
import fable.imageviewer.internal.ZoomSelection;
import fable.imageviewer.rcp.Activator;
import fable.imageviewer.views.ImageView;
import fable.imageviewer.views.ImageViewImage;
import java.text.NumberFormat;
import java.text.ParseException;
import jep.JepException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;

public class ImageViewControls
implements IImagesVarKeys {
    ImageView iv = null;
    private ImageViewImage image = null;
    private Composite controlComposite = null;
    private boolean controlCompositeShowing = true;
    private Display display;
    private Combo coordCombo;
    private Combo orientCombo;
    private Combo lutCombo;
    private Button aspectButton = null;
    private Button peaksButton = null;
    private Button autoscaleButton = null;
    private Text minimumText = null;
    private Text maximumText = null;
    private Text fileNumberText = null;
    private Label statusLabel = null;
    private Canvas imageCanvas;
    private Composite statusGroup;
    private static NumberFormat decimalFormat = NumberFormat.getNumberInstance();
    static boolean customSavedParametersInitialized = false;
    private ImageViewActions actions;

    public ImageViewControls(ImageView imageView) {
        this.iv = imageView;
    }

    public void createControls(Composite parent) {
        if (this.iv == null) {
            return;
        }
        this.image = new ImageViewImage(this.iv, this);
        this.actions = new ImageViewActions(this.iv, this, this.image);
        this.display = this.iv.getDisplay();
        GridLayout parentField = new GridLayout();
        parentField.numColumns = 1;
        parent.setLayout((Layout)parentField);
        this.iv.getController().addPropertyChangeListener((IPropertyChangeListener)this.iv);
        GridLayout grid5Cols = new GridLayout();
        grid5Cols.numColumns = 5;
        this.controlComposite = new Composite(parent, 0);
        this.controlComposite.setLayout((Layout)grid5Cols);
        GridData gd = new GridData(4, 4, true, false);
        gd.exclude = !this.controlCompositeShowing;
        this.controlComposite.setLayoutData((Object)gd);
        this.controlComposite.getAccessible().getControl();
        this.orientCombo = new Combo(this.controlComposite, 0);
        String[] items = new String[8];
        int i = 0;
        while (i < 8) {
            items[i] = orientNameValues[i][0];
            ++i;
        }
        this.orientCombo.setItems(items);
        this.orientCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.orientCombo.setToolTipText("Adjust the orientation with O parameters (o11 o12 o21 o22)");
        this.orientCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = ImageViewControls.this.orientCombo.getSelectionIndex();
                ImageViewControls.this.iv.setOrientation(idx);
            }
        });
        Preferences prefs = Activator.getDefault().getPluginPreferences();
        int orientation = prefs.getInt("orientationPreference");
        this.iv.setOrientation(orientation);
        this.orientCombo.select(orientation);
        if (!customSavedParametersInitialized) {
            String processing = "xName";
            try {
                this.iv.setXNameSave(prefs.getString("coordinatesXNamePreference"));
                processing = "yName";
                this.iv.setYNameSave(prefs.getString("coordinatesYNamePreference"));
                processing = "x0";
                this.iv.setX0Save(Double.parseDouble(prefs.getString("coordinatesX0Preference")));
                processing = "y0";
                this.iv.setY0Save(Double.parseDouble(prefs.getString("coordinatesY0Preference")));
                processing = "pixelHeight";
                this.iv.setPixelWidthSave(Double.parseDouble(prefs.getString("coordinatesPixelWidthPreference")));
                processing = "pixelHeight";
                this.iv.setPixelHeightSave(Double.parseDouble(prefs.getString("coordinatesPixelHeightPreference")));
                customSavedParametersInitialized = true;
            }
            catch (NumberFormatException ex) {
                FableUtils.excMsg((Object)this, (String)("Error setting custom coordinates from preferences for " + processing), (Throwable)ex);
            }
        }
        this.coordCombo = new Combo(this.controlComposite, 0);
        items = new String[5];
        int i2 = 0;
        while (i2 < 5) {
            items[i2] = coordNameValues[i2][0];
            ++i2;
        }
        this.coordCombo.setItems(items);
        this.coordCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.coordCombo.setToolTipText("Select the origin of the coordinate system for mouse movement");
        this.coordCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int idx = ImageViewControls.this.coordCombo.getSelectionIndex();
                int coordOriginSave = ImageViewControls.this.iv.getCoordOrigin();
                ImageViewControls.this.iv.setCoordOrigin(idx);
                if (idx == 4) {
                    Coordinates coordinates = ImageViewControls.this.iv.getCoordinates();
                    CustomCoordinatesDialog dlg = coordinates.getType() == 4 ? new CustomCoordinatesDialog(ImageViewControls.this.display.getActiveShell(), coordinates.getX0(), coordinates.getY0(), coordinates.getPixelWidth(), coordinates.getPixelHeight(), coordinates.getXName(), coordinates.getYName()) : new CustomCoordinatesDialog(ImageViewControls.this.display.getActiveShell(), ImageViewControls.this.iv.getX0Save(), ImageViewControls.this.iv.getY0Save(), ImageViewControls.this.iv.getPixelWidthSave(), ImageViewControls.this.iv.getPixelHeightSave(), ImageViewControls.this.iv.getXNameSave(), ImageViewControls.this.iv.getYNameSave());
                    boolean result = dlg.open();
                    if (result) {
                        ImageViewControls.this.iv.setX0Save(dlg.getX0());
                        ImageViewControls.this.iv.setY0Save(dlg.getY0());
                        ImageViewControls.this.iv.setPixelWidthSave(dlg.getPixelWidth());
                        ImageViewControls.this.iv.setPixelHeightSave(dlg.getPixelHeight());
                        ImageViewControls.this.iv.setXNameSave(dlg.getXName());
                        ImageViewControls.this.iv.setYNameSave(dlg.getYName());
                        coordinates.reset(ImageViewControls.this.iv.getCoordOrigin(), ImageViewControls.this.iv.getX0Save(), ImageViewControls.this.iv.getY0Save(), ImageViewControls.this.iv.getPixelWidthSave(), ImageViewControls.this.iv.getPixelHeightSave(), ImageViewControls.this.iv.getXNameSave(), ImageViewControls.this.iv.getYNameSave());
                    } else {
                        ImageViewControls.this.iv.setCoordOrigin(coordOriginSave);
                    }
                } else {
                    ImageViewControls.this.iv.resetCoordinates();
                }
            }
        });
        int coordOrigin = prefs.getInt("coordinatesPreference");
        this.coordCombo.select(coordOrigin);
        if (coordOrigin == 4) {
            Coordinates coordinates = this.iv.getCoordinates();
            try {
                coordinates.reset(coordOrigin, this.iv.getX0Save(), this.iv.getY0Save(), this.iv.getPixelWidthSave(), this.iv.getPixelHeightSave(), this.iv.getXNameSave(), this.iv.getYNameSave());
            }
            catch (NumberFormatException ex) {
                FableUtils.excMsg((Object)this, (String)"Error setting custom coordinates", (Throwable)ex);
                coordinates.resetToDefault();
            }
        } else {
            this.iv.resetCoordinates();
        }
        this.lutCombo = new Combo(this.controlComposite, 0);
        int len = paletteNameValues.length;
        items = new String[len];
        int i3 = 0;
        while (i3 < len) {
            items[i3] = paletteNameValues[i3][0];
            ++i3;
        }
        this.lutCombo.setItems(items);
        this.lutCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.lutCombo.setToolTipText("Set the Color Map");
        this.lutCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int paletteIndex = ImageViewControls.this.lutCombo.getSelectionIndex();
                ImageViewControls.this.iv.setPalette(paletteIndex);
            }
        });
        int paletteIndex = prefs.getInt("palettePreference");
        this.iv.setPalette(paletteIndex);
        this.iv.setZoomSelection(ZoomSelection.AREA);
        this.peaksButton = new Button(this.controlComposite, 0x1000020);
        this.peaksButton.setText("Show Peaks");
        this.peaksButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.peaksButton.setToolTipText("Display peaks");
        this.peaksButton.setSelection(false);
        this.peaksButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ImageViewControls.this.peaksButton.getSelection()) {
                    ImageViewControls.this.iv.setPeaksOn(true);
                    ImageViewControls.this.image.displayImage();
                    ImageViewControls.this.image.showPeaks();
                } else {
                    ImageViewControls.this.iv.setPeaksOn(false);
                    ImageViewControls.this.image.displayImage();
                }
            }
        });
        this.aspectButton = new Button(this.controlComposite, 0x1000020);
        this.aspectButton.setText("Keep Aspect Ratio");
        this.aspectButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.aspectButton.setToolTipText("Keep aspect ratio when displaying image");
        this.aspectButton.setSelection(this.iv.isKeepAspect());
        this.aspectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ImageViewControls.this.aspectButton.getSelection()) {
                    ImageViewControls.this.iv.setKeepAspect(true);
                    ImageViewControls.this.image.clearCanvas();
                    ImageViewControls.this.image.displayImage();
                } else {
                    ImageViewControls.this.iv.setKeepAspect(false);
                    ImageViewControls.this.image.clearCanvas();
                    ImageViewControls.this.image.displayImage();
                }
            }
        });
        this.autoscaleButton = new Button(this.controlComposite, 0x1000020);
        this.autoscaleButton.setText("Autoscale Intensity");
        this.autoscaleButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.autoscaleButton.setSelection(true);
        this.autoscaleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ImageViewControls.this.autoscaleButton.getSelection()) {
                    ImageViewControls.this.iv.setAutoscale(true);
                    if (!ImageViewControls.this.iv.isImageDiffOn() && ImageViewControls.this.iv.getFabioFile() != null) {
                        try {
                            ImageViewControls.this.iv.setMinimum(ImageViewControls.this.iv.getFabioFile().getMinimum());
                            ImageViewControls.this.iv.setMean(ImageViewControls.this.iv.getFabioFile().getMean());
                            ImageViewControls.this.iv.setMaximum(ImageViewControls.this.iv.getMinimum() + 2.0f * (ImageViewControls.this.iv.getMean() - ImageViewControls.this.iv.getMinimum()));
                        }
                        catch (JepException ex) {
                            FableUtils.excMsg((Object)((Object)this), (String)"Error setting maximum and minimum", (Throwable)ex);
                        }
                    }
                    ImageViewControls.this.minimumText.setEnabled(false);
                    ImageViewControls.this.maximumText.setEnabled(false);
                    ImageViewControls.this.iv.setCurrentMinimum(ImageViewControls.this.iv.getMinimum());
                    ImageViewControls.this.iv.setCurrentMaximum(ImageViewControls.this.iv.getMaximum());
                } else {
                    ImageViewControls.this.iv.setAutoscale(false);
                    ImageViewControls.this.minimumText.setEnabled(true);
                    ImageViewControls.this.maximumText.setEnabled(true);
                    try {
                        ImageViewControls.this.iv.setCurrentMinimum(decimalFormat.parse(ImageViewControls.this.minimumText.getText()).floatValue());
                        ImageViewControls.this.iv.setCurrentMaximum(decimalFormat.parse(ImageViewControls.this.maximumText.getText()).floatValue());
                    }
                    catch (ParseException ex) {
                        FableUtils.excMsg((Object)((Object)this), (String)"Unable to read minimum and/or maximum", (Throwable)ex);
                    }
                }
                ImageViewControls.this.image.displayImage();
            }
        });
        Label minimumLabel = new Label(this.controlComposite, 0);
        minimumLabel.setText("Minimum Intensity");
        minimumLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.minimumText = new Text(this.controlComposite, 0);
        this.minimumText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.minimumText.setText("0");
        this.minimumText.setBackground(this.display.getSystemColor(1));
        this.minimumText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                try {
                    ImageViewControls.this.iv.setCurrentMinimum(decimalFormat.parse(ImageViewControls.this.minimumText.getText()).floatValue());
                }
                catch (ParseException ex) {
                    FableUtils.excMsg((Object)this, (String)"Unable to read minimum", (Throwable)ex);
                }
                ImageViewControls.this.image.displayImage();
            }
        });
        this.minimumText.setEnabled(false);
        Label maximumLabel = new Label(this.controlComposite, 0);
        maximumLabel.setText("Maximum Intensity");
        maximumLabel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.maximumText = new Text(this.controlComposite, 0);
        this.maximumText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.maximumText.setText("0");
        this.maximumText.setBackground(this.display.getSystemColor(1));
        this.maximumText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                try {
                    ImageViewControls.this.iv.setCurrentMaximum(decimalFormat.parse(ImageViewControls.this.maximumText.getText()).floatValue());
                }
                catch (ParseException ex) {
                    FableUtils.excMsg((Object)this, (String)"Unable to read maximum", (Throwable)ex);
                }
                ImageViewControls.this.image.displayImage();
            }
        });
        this.maximumText.setEnabled(false);
        GridLayout grid2Cols = new GridLayout();
        grid2Cols.numColumns = 2;
        Composite canvasComposite = new Composite(parent, 0);
        canvasComposite.setLayout((Layout)grid2Cols);
        canvasComposite.setLayoutData((Object)new GridData(1808));
        this.imageCanvas = new Canvas(canvasComposite, 0);
        this.image.initializeCanvas();
        Composite statusGroup = new Composite(parent, 0);
        GridLayout statusGridLayout = new GridLayout();
        statusGridLayout.numColumns = 8;
        statusGroup.setLayout((Layout)statusGridLayout);
        statusGroup.setLayoutData((Object)new GridData(768));
        this.statusLabel = new Label(statusGroup, 0);
        this.statusLabel.setLayoutData((Object)new GridData(768));
        this.contributeToActionBars();
        this.createContextMenu();
        this.iv.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this.iv);
    }

    public void createFileNumberText() {
        if (this.fileNumberText == null) {
            this.fileNumberText = new Text(this.statusGroup, 2048);
            this.fileNumberText.setToolTipText("Go to image number");
            this.fileNumberText.setEnabled(true);
            this.fileNumberText.addListener(14, new Listener(){

                public void handleEvent(Event event) {
                    int size;
                    int fileIndex = Integer.parseInt(ImageViewControls.this.fileNumberText.getText());
                    if (fileIndex > (size = ImageViewControls.this.iv.getController().getCurrentsample().getFilteredfiles().size())) {
                        fileIndex = size - 1;
                    }
                    ImageViewControls.this.iv.getController().setCurrentFileIndex(fileIndex);
                }
            });
        }
    }

    private void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actions.controlPanelAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actions.zoomAreaAction);
        manager.add((IAction)this.actions.zoomLineAction);
        manager.add((IAction)this.actions.zoomProfileAction);
        manager.add((IAction)this.actions.zoomReliefAction);
        manager.add((IAction)this.actions.zoomRockingAction);
        manager.add((IAction)this.actions.resetZoomAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actions.copyImageAction);
        manager.add((IAction)this.actions.setBackgroundAction);
        manager.add((IAction)this.actions.slice1DAction);
        manager.add((IAction)this.actions.slice2DAction);
        MenuManager subMenuManager = new MenuManager("Print");
        manager.add((IContributionItem)subMenuManager);
        subMenuManager.add((IAction)this.actions.printSetupAction);
        subMenuManager.add((IAction)this.actions.printPreviewAction);
        subMenuManager.add((IAction)this.actions.printAction);
        subMenuManager = new MenuManager("Edit");
        manager.add((IContributionItem)subMenuManager);
        subMenuManager.add((IAction)this.actions.copyAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actions.imageInfoAction);
        manager.add((IAction)this.actions.inputSummaryAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actions.controlPanelAction);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.iv.getViewSite().getActionBars();
        this.fillLocalMenu(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ImageViewControls.this.fillLocalMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.imageCanvas.getAccessible().getControl());
        this.imageCanvas.getAccessible().getControl().setMenu(menu);
    }

    public void setFileNumberText(String text) {
        if (this.fileNumberText != null) {
            this.fileNumberText.setText(text);
        }
    }

    public void setMinMaxText(float[] minmax) {
        this.minimumText.setText(Float.toString(minmax[0]));
        this.maximumText.setText(Float.toString(minmax[1]));
    }

    public float[] getMinMaxText() {
        float[] vals = new float[2];
        try {
            vals[0] = decimalFormat.parse(this.minimumText.getText()).floatValue();
            vals[1] = decimalFormat.parse(this.maximumText.getText()).floatValue();
        }
        catch (ParseException ex) {
            FableUtils.excMsg((Object)this, (String)"Unable to read minimum and/or maximum", (Throwable)ex);
            vals[1] = Float.NaN;
            vals[0] = Float.NaN;
        }
        return vals;
    }

    public Combo getCoordCombo() {
        return this.coordCombo;
    }

    public Combo getOrientCombo() {
        return this.orientCombo;
    }

    public Combo getLutCombo() {
        return this.lutCombo;
    }

    public void setStatusText(String text) {
        if (this.statusLabel != null) {
            this.statusLabel.setText(text);
        }
    }

    public Button getAutoscaleButton() {
        return this.autoscaleButton;
    }

    public Button getPeaksButton() {
        return this.peaksButton;
    }

    public Canvas getImageCanvas() {
        return this.imageCanvas;
    }

    public ImageViewImage getImage() {
        return this.image;
    }

    public void setImage(ImageViewImage image) {
        this.image = image;
    }

    public Composite getControlComposite() {
        return this.controlComposite;
    }

    public boolean getControlCompositeShowing() {
        return this.controlCompositeShowing;
    }

    public void setControlCompositeShowing(boolean controlCompositeShowing) {
        this.controlCompositeShowing = controlCompositeShowing;
    }
}

