/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.actions;

import fable.framework.navigator.views.SampleNavigatorView;
import fable.framework.toolbox.FableUtils;
import fable.imageviewer.internal.ImageUtils;
import fable.imageviewer.internal.ZoomSelection;
import fable.imageviewer.views.ImageView;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class Slice2DAction
extends Action
implements IViewActionDelegate {
    ImageView imageView = null;

    public Slice2DAction() {
    }

    public Slice2DAction(String string) {
        super(string, 1);
        this.setEnabled(true);
    }

    public void init(IViewPart view) {
        this.imageView = (ImageView)view;
    }

    public void run(IAction action) {
        this.slice2D();
    }

    public void run() {
        this.slice2D();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void slice2D() {
        try {
            Vector selectedFiles = SampleNavigatorView.view.getSelectedFilesIndex();
            if (selectedFiles.size() <= 1) {
                this.imageView.updateStatusLabel("select at least 2 files to make a slice");
            } else {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", Integer.toString(200), 1);
                ImageView imageSlice2DView = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ImageView", Integer.toString(200)).getView(true);
                imageSlice2DView.stopListening();
                Rectangle selectionArea = this.imageView.getImage().getSelectedArea();
                Rectangle imageArea = this.imageView.getImage().screenRectangleToImageRectangle(selectionArea, true);
                if (this.imageView.getZoomSelection() == ZoomSelection.AREA) {
                    ImageUtils.Slice2DArea(imageArea.x, imageArea.y, imageArea.x + imageArea.width, imageArea.y + imageArea.height);
                } else {
                    this.imageView.updateStatusLabel("zoom on a 2D area to make a slice");
                }
                imageSlice2DView.setOrientation(this.imageView.getOrientation());
                imageSlice2DView.setCoordOrigin(this.imageView.getCoordOrigin());
                imageSlice2DView.setPalette(this.imageView.getPalette());
                imageSlice2DView.setMinMax(this.imageView.getMinMax());
                imageSlice2DView.setName("2D Slice " + this.imageView.getFileName());
            }
        }
        catch (PartInitException ex) {
            FableUtils.excMsg((Object)((Object)this), (String)"Error opening view", (Throwable)ex);
        }
    }
}

