#!/bin/bash
#
# script to run fable on Linux
#
# some advanced bash and unix tricks to find the fable install directory
# (will not work on all distributions of Linux e.g. needs tweaking for lsof
# if you have problems replace the with the home directory of FABLE_HOME like this 
# FABLE_HOME=/directory_where_fable_gui_is_installed
#
## Linux
LSOF=$(lsof -p $$ | grep -E "/"$(basename $0)"$")
FABLE_SCRIPT=$(echo $LSOF | sed -r s/'^([^\/]+)\/'/'\/'/1 2>/dev/null)
if [ $? -ne 0 ]; then
## OSX
  FABLE_SCRIPT=$(echo $LSOF | sed -E s/'^([^\/]+)\/'/'\/'/1 2>/dev/null)
fi
FABLE_HOME=$(dirname $FABLE_SCRIPT)

#
# ADD to PYTHONPATH the directory where you have installed the Fable python modules 
#			(leave empty if they are installed in the standard python area)
# 
#export PYTHONPATH=$FABLE_HOME/python/linux_x86:$PYTHONPATH
echo "PYTHONPATH = " $PYTHONPATH
export LD_PRELOAD=/usr/lib/libpython2.5.so.1.0
$FABLE_HOME/fable
