/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.toolbox.Activator;
import java.awt.Color;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Dictionary;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ToolBox {
    public static String getPluginPath(String string, String string2) throws IOException {
        Bundle bundle = Platform.getBundle((String)string2);
        IPath iPath = Platform.getStateLocation((Bundle)bundle);
        String string3 = iPath.toString();
        int n = string3.lastIndexOf(string);
        if (n >= 0 && n < string3.length()) {
            string3 = string3.substring(0, n);
        }
        return string3;
    }

    public static boolean checkIfFileExists(String string) {
        File file;
        boolean bl = false;
        if (string != null && !string.equals("") && (file = new File(string)).exists()) {
            bl = true;
        }
        return bl;
    }

    public static boolean checkExtension(String string, String string2) {
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        return string3.endsWith(string4);
    }

    public static boolean checkIfIsDirectory(String string) {
        boolean bl = false;
        File file = new File(string);
        if (file.isDirectory()) {
            bl = true;
        }
        return bl;
    }

    public static String[] getFilesFromDirectory(String string, String string2) {
        File file = new File(string);
        final String string3 = string2.toLowerCase();
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                File file2 = new File(file, string);
                if (file2.isDirectory()) {
                    return false;
                }
                string = string.toLowerCase();
                return string.endsWith(string3);
            }
        };
        return file.list(filenameFilter);
    }

    public static void quicksort(File[] fileArray, int n, int n2) {
        if (n2 > n) {
            int n3 = ToolBox.partition(fileArray, n, n2);
            ToolBox.quicksort(fileArray, n, n3);
            ToolBox.quicksort(fileArray, n3 + 1, n2);
        }
    }

    private static int partition(File[] fileArray, int n, int n2) {
        File file;
        int n3 = n + (n2 - n) / 2;
        File file2 = fileArray[n3];
        int n4 = n;
        int n5 = n;
        while (n5 < n2) {
            if (fileArray[n5].getAbsolutePath().compareTo(file2.getAbsolutePath()) < 0) {
                file = fileArray[n5];
                fileArray[n5] = fileArray[n4];
                fileArray[n4] = file;
                if (n4 == n3) {
                    n3 = n5;
                }
                ++n4;
            }
            ++n5;
        }
        if (n4 < n2) {
            file = fileArray[n4];
            fileArray[n4] = file2;
            fileArray[n3] = file;
        }
        return n4;
    }

    public static void quicksort(String[] stringArray, int n, int n2) {
        if (n2 > n) {
            int n3 = ToolBox.partition(stringArray, n, n2);
            ToolBox.quicksort(stringArray, n, n3);
            ToolBox.quicksort(stringArray, n3 + 1, n2);
        }
    }

    private static int partition(String[] stringArray, int n, int n2) {
        String string;
        int n3 = n + (n2 - n) / 2;
        String string2 = stringArray[n3];
        int n4 = n;
        int n5 = n;
        while (n5 < n2) {
            if (stringArray[n5].compareTo(string2) < 0) {
                string = stringArray[n5];
                stringArray[n5] = stringArray[n4];
                stringArray[n4] = string;
                if (n4 == n3) {
                    n3 = n5;
                }
                ++n4;
            }
            ++n5;
        }
        if (n4 < n2) {
            string = stringArray[n4];
            stringArray[n4] = string2;
            stringArray[n3] = string;
        }
        return n4;
    }

    public static File[] getFilesByEntireRegex(String string, String string2, boolean bl) {
        File file = new File(string);
        String string3 = string2;
        final boolean bl2 = bl;
        try {
            final Pattern pattern = Pattern.compile(string3);
            FilenameFilter filenameFilter = new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    File file2 = new File(file, string);
                    if (file2.isDirectory()) {
                        return false;
                    }
                    return pattern.matcher(file2.getName()).matches() == bl2;
                }
            };
            return file.listFiles(filenameFilter);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            Logger.getLogger(ToolBox.class).error((Object)patternSyntaxException.getMessage());
            System.out.println(patternSyntaxException.getMessage());
            return null;
        }
    }

    public static String[] getFileNamesByEntireRegex(String string, String string2, boolean bl) {
        File file = new File(string);
        String string3 = string2;
        final boolean bl2 = bl;
        try {
            final Pattern pattern = Pattern.compile(string3);
            FilenameFilter filenameFilter = new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    File file2 = new File(file, string);
                    if (file2.isDirectory()) {
                        return false;
                    }
                    return pattern.matcher(file2.getName()).matches() == bl2;
                }
            };
            return file.list(filenameFilter);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return null;
        }
    }

    public static String[] getFilesByEntireRegexAndTime(String string, String string2, boolean bl, long l) {
        File file = new File(string);
        String string3 = string2;
        final boolean bl2 = bl;
        final long l2 = l;
        try {
            final Pattern pattern = Pattern.compile(string3);
            FilenameFilter filenameFilter = new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    File file2 = new File(file, string);
                    if (file2.isDirectory()) {
                        return false;
                    }
                    if (l2 > file2.lastModified()) {
                        return false;
                    }
                    return pattern.matcher(file2.getName()).matches() == bl2;
                }
            };
            return file.list(filenameFilter);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return null;
        }
    }

    public static Color getRandomColor() {
        return new Color((int)(Math.random() * 256.0), (int)(Math.random() * 256.0), (int)(Math.random() * 256.0));
    }

    public static String addQuotesForSpacesInName(String string, String string2, String string3) {
        String[] stringArray = string.split(string2);
        String string4 = "";
        int n = 0;
        while (n < stringArray.length - 1) {
            if (stringArray[n].contains(" ")) {
                stringArray[n] = "\"" + stringArray[n] + "\"";
            }
            string4 = String.valueOf(string4) + stringArray[n] + string3;
            ++n;
        }
        string4 = String.valueOf(string4) + stringArray[stringArray.length - 1];
        return string4;
    }

    public static Date stringToDate(String string, String string2) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        return simpleDateFormat.parse(string);
    }

    public static String getPluginName(String string) {
        String string2 = "Unknown-Name";
        Bundle bundle = Platform.getBundle((String)string);
        if (bundle == null) {
            return string2;
        }
        String string3 = bundle.getSymbolicName();
        if (string3 != null) {
            string2 = string3;
        }
        return string2;
    }

    public static String getPluginVersion(String string) {
        String string2 = "Unknown-Version";
        Bundle bundle = Platform.getBundle((String)string);
        if (bundle == null) {
            return string2;
        }
        Dictionary dictionary = bundle.getHeaders();
        if (dictionary == null) {
            return string2;
        }
        String string3 = (String)dictionary.get("Bundle-Version");
        if (string3 != null) {
            string2 = string3;
        }
        return string2;
    }

    public static String getStem(String string) {
        String string2 = new String();
        int n = string.indexOf(".");
        int n2 = 0;
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        if (!ToolBox.getFileType(string).equals("bruker")) {
            Pattern pattern = Pattern.compile("\\d+");
            Matcher matcher = pattern.matcher(string2);
            while (matcher.find()) {
                n2 = matcher.start();
            }
            string2 = string2.substring(0, n2);
        }
        return string2;
    }

    public static String getFileType(String string) {
        String string2 = ".+\\.\\d+.*";
        String string3 = "";
        Pattern pattern = Pattern.compile(string2);
        if (pattern.matcher(string).matches()) {
            string3 = "bruker";
        } else {
            int n = string.indexOf(".");
            if (n > -1 && n + 1 < string.length()) {
                string3 = string.substring(n + 1);
            }
        }
        return string3;
    }

    public static String getFileNumber(String string) {
        int n;
        String string2 = new String();
        int n2 = string.indexOf(".");
        int n3 = 0;
        if (!ToolBox.getFileType(string).equals("bruker")) {
            string2 = string.substring(0, n2);
            Pattern pattern = Pattern.compile("\\d+");
            Matcher matcher = pattern.matcher(string2);
            while (matcher.find()) {
                n3 = matcher.start();
            }
            string2 = string2.substring(n3);
        } else if (n2 > -1 && n2 + 1 < string.length() && (string2 = string.substring(n2 + 1)).contains(".") && (n = string2.indexOf(".")) > -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    public static boolean isSmallPerspectiveSet() {
        boolean bl = true;
        String string = Activator.getDefault().getPreferenceStore().getString("configuration.perspective");
        if (string != null && string.equals("configuration.perspective.LargeScreen")) {
            bl = false;
        }
        return bl;
    }

    public static boolean isOsLinux() {
        return System.getProperty("os.name").toLowerCase().contains("linux");
    }

    public static boolean isOsWindows() {
        return System.getProperty("os.name").toLowerCase().contains("window");
    }

    public static String getHelpContextTooltip() {
        if (ToolBox.isOsLinux()) {
            return "CTRL+F1";
        }
        if (ToolBox.isOsWindows()) {
            return "F1";
        }
        return "Help";
    }
}

