/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.toolbox.SWTUtils;
import fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartActionEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class JLChartMemoryUsage
extends JPanel {
    private static final boolean verbose = false;
    private static final boolean debug = false;
    private static final long serialVersionUID = 1L;
    private static final double SCALE = 9.5367431640625E-7;
    public static final int DEFAULT_INTERVAL = 1000;
    public static final int DEFAULT_AGE = 60000;
    public static final boolean DEFAULT_SHOW_MAX = true;
    public static final boolean DEFAULT_SHOW_LEGEND = true;
    private IJLChartActionListener chartActionListener;
    private boolean showMax = true;
    private boolean showLegend = true;
    private JLChart chart = null;
    private JLDataView total;
    private JLDataView used;
    private JLDataView max;
    private Timer timer = null;
    private int interval = 1000;
    private int maxAge = 60000;
    private String header = null;

    public JLChartMemoryUsage() {
        this(60000);
    }

    public JLChartMemoryUsage(int n) {
        super(new BorderLayout());
        this.maxAge = n;
        this.chart = new JLChart();
        this.chart.setHeader(this.getName());
        this.chart.setHeaderFont(new Font("Dialog", 1, 18));
        this.chart.setDisplayDuration((double)n);
        this.chart.getXAxis().setName("Time");
        this.chart.getXAxis().setAutoScale(true);
        this.chart.getXAxis().setGridVisible(true);
        this.chart.getXAxis().setSubGridVisible(true);
        this.chart.getXAxis().setAnnotation(1);
        this.chart.getXAxis().setAxisDuration((double)n);
        this.chart.getXAxis().setFitXAxisToDisplayDuration(true);
        this.chart.getY1Axis().setName("Memory, MB");
        this.chart.getY1Axis().setAutoScale(true);
        this.chart.getY1Axis().setGridVisible(true);
        this.chart.getY1Axis().setSubGridVisible(true);
        this.total = new JLDataView();
        this.total.setColor(new Color(0, 0, 255));
        this.total.setName("Total Memory");
        this.used = new JLDataView();
        this.used.setColor(new Color(0, 0, 0));
        this.used.setName("Used Memory");
        this.max = new JLDataView();
        this.max.setColor(new Color(255, 0, 0));
        this.max.setName("Max Memory");
        this.chart.getY1Axis().addDataView(this.total);
        this.chart.getY1Axis().addDataView(this.used);
        this.chart.getY1Axis().addDataView(this.max);
        this.extendPopupMenu();
        this.add((Component)this.chart, "Center");
    }

    public String getConfiguration() {
        String string = System.getProperty("line.separator");
        String string2 = "";
        string2 = String.valueOf(string2) + "Chart Configuration" + string;
        string2 = String.valueOf(string2) + this.chart.getConfiguration() + string;
        JLAxis jLAxis = this.chart.getXAxis();
        string2 = String.valueOf(string2) + "X Axis: " + jLAxis.getAxeName() + string;
        string2 = String.valueOf(string2) + jLAxis.getConfiguration("  ") + string;
        string2 = String.valueOf(string2) + "  JLDataViews:" + string;
        Vector vector = jLAxis.getViews();
        int n = 0;
        for (JLDataView jLDataView : vector) {
            string2 = String.valueOf(string2) + "    DataView " + n + " " + jLDataView.getName() + string;
            string2 = String.valueOf(string2) + jLDataView.getConfiguration("      ") + string;
        }
        jLAxis = this.chart.getY1Axis();
        string2 = String.valueOf(string2) + "Y1 Axis: " + jLAxis.getAxeName() + string;
        string2 = String.valueOf(string2) + jLAxis.getConfiguration("  ") + string;
        string2 = String.valueOf(string2) + "  JLDataViews:" + string;
        vector = jLAxis.getViews();
        n = 0;
        for (JLDataView jLDataView : vector) {
            string2 = String.valueOf(string2) + "    DataView " + n + " " + jLDataView.getName() + string;
            string2 = String.valueOf(string2) + jLDataView.getConfiguration("      ") + string;
        }
        return string2;
    }

    private void extendPopupMenu() {
        if (this.chart == null) {
            return;
        }
        this.chart.removeMenuItem(2);
        this.chart.removeMenuItem(5);
        this.chart.removeMenuItem(3);
        this.chart.addUserAction("Toggle Max Memory");
        this.chart.addUserAction("Toggle Legend");
        this.chart.addUserAction("Set Max Age...");
        this.chartActionListener = new IJLChartActionListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(JLChartActionEvent jLChartActionEvent) {
                if (jLChartActionEvent.getName().equals("Toggle Max Memory")) {
                    JLChartMemoryUsage.this.toggleMax();
                } else if (jLChartActionEvent.getName().equals("Toggle Legend")) {
                    JLChartMemoryUsage.this.chart.setLabelVisible(!JLChartMemoryUsage.this.chart.isLabelVisible());
                } else if (jLChartActionEvent.getName().equals("Set Max Age...")) {
                    JLChartMemoryUsage.this.queryResetMaxAge();
                }
            }

            public boolean getActionState(JLChartActionEvent jLChartActionEvent) {
                return false;
            }
        };
        this.chart.addJLChartActionListener(this.chartActionListener);
    }

    public void update() {
        double d = 9.5367431640625E-7 * (double)Runtime.getRuntime().totalMemory();
        double d2 = 9.5367431640625E-7 * (double)Runtime.getRuntime().freeMemory();
        double d3 = 9.5367431640625E-7 * (double)Runtime.getRuntime().maxMemory();
        long l = System.currentTimeMillis();
        this.chart.addData(this.total, (double)l, d);
        this.chart.addData(this.used, (double)l, d - d2);
        this.chart.addData(this.max, (double)l, d3);
    }

    public void queryResetInterval() {
        String string = JOptionPane.showInputDialog("Enter update interval in ms", (Object)Integer.toString(this.interval));
        if (string != null) {
            int n = 0;
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                SWTUtils.errMsgAsync("MemoryUsage: Invalid interval");
                return;
            }
            this.setInterval(n);
        }
    }

    public void queryResetMaxAge() {
        String string = JOptionPane.showInputDialog("Enter maximum age in ms", (Object)Integer.toString(this.maxAge));
        if (string != null) {
            int n = 0;
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                SWTUtils.errMsgAsync("MemoryUsage: Invalid age");
                return;
            }
            this.setMaxAge(n);
        }
    }

    public void toggleMax() {
        if (this.max == null) {
            return;
        }
        if (this.showMax) {
            this.showMax = false;
            this.chart.getY1Axis().removeDataView(this.max);
        } else {
            this.showMax = true;
            this.chart.getY1Axis().addDataView(this.max);
        }
    }

    public void start() {
        this.stop();
        this.timer = new Timer(this.interval, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JLChartMemoryUsage.this.update();
            }
        });
        this.timer.start();
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public void finish() {
        if (this.chart != null && this.chartActionListener != null) {
            this.chart.removeJLChartActionListener(this.chartActionListener);
        }
        this.chart = null;
        this.chartActionListener = null;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int n) {
        if (n == this.interval) {
            return;
        }
        this.interval = n;
        if (this.timer != null && this.timer.isRunning()) {
            this.start();
        }
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int n) {
        if (n == this.maxAge) {
            return;
        }
        this.maxAge = n;
        this.chart.setDisplayDuration((double)n);
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean bl) {
        this.showLegend = bl;
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String string) {
        if (string == this.header) {
            return;
        }
        this.header = string;
        if (this.chart != null) {
            this.chart.setHeader(string);
        }
    }

    public JLChart getChart() {
        return this.chart;
    }

    public boolean getShowMax() {
        return this.showMax;
    }

    public void setShowMax(boolean bl) {
        this.showMax = bl;
    }

    public static void main(String[] stringArray) {
        try {
            JFrame.setDefaultLookAndFeelDecorated(true);
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JLChartMemoryUsage jLChartMemoryUsage = new JLChartMemoryUsage(600000);
                    jLChartMemoryUsage.setInterval(1000);
                    jLChartMemoryUsage.setHeader("JVM Memory Usage");
                    jLChartMemoryUsage.start();
                    JFrame jFrame = new JFrame("JLChart Memory Usage");
                    jFrame.getContentPane().add((Component)jLChartMemoryUsage, "Center");
                    jFrame.setBounds(200, 120, 600, 280);
                    jFrame.setDefaultCloseOperation(3);
                    jFrame.setVisible(true);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

