/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.toolbox;

import fable.framework.clipboard.FableClipboard;
import fable.framework.imageprint.FableImagePrinter;
import fable.framework.internal.IVarKeys;
import fable.framework.logging.FableLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.swt.SWTException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin
implements IVarKeys {
    private boolean loggerLevelSet = false;
    private Preferences prefs = null;
    private Preferences.IPropertyChangeListener listener = null;
    public static final String PLUGIN_ID = "fable.framework.toolbox";
    private static Activator plugin;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.prefs = Activator.getDefault().getPluginPreferences();
        int n = this.prefs.getInt("fableLoggerLevelPreference");
        Logger logger = FableLogger.getLogger();
        this.setLoggerLevel(logger, n);
        String string = this.prefs.getString("imagePrintUnitsPreference");
        FableImagePrinter.settings.setUnits(string);
        string = this.prefs.getString("imagePrintLeftPreference");
        FableImagePrinter.settings.setLeftString(string);
        string = this.prefs.getString("imagePrintRightPreference");
        FableImagePrinter.settings.setRightString(string);
        string = this.prefs.getString("imagePrintTopPreference");
        FableImagePrinter.settings.setTopString(string);
        string = this.prefs.getString("imagePrintBottomPreference");
        FableImagePrinter.settings.setBottomString(string);
        n = this.prefs.getInt("imagePrintHAlignPreference");
        FableImagePrinter.settings.setHorizontalAlign(n);
        n = this.prefs.getInt("imagePrintVAlignPreference");
        FableImagePrinter.settings.setVerticalAlign(n);
        string = this.prefs.getString("imagePrintOrientationPreference");
        FableImagePrinter.settings.setOrientation(string);
        if (!this.loggerLevelSet) {
            this.loggerLevelSet = true;
            logger.info((Object)"Fable Starting");
            logger.info((Object)("Setting " + logger.getName() + " to " + logger.getLevel()));
        }
        n = this.prefs.getInt("rootLoggerLevelPreference");
        Logger logger2 = Logger.getRootLogger();
        this.setLoggerLevel(logger2, n);
        this.prefs.addPropertyChangeListener(new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getProperty();
                if (string.equals("fableLoggerLevelPreference")) {
                    String string2 = (String)propertyChangeEvent.getNewValue();
                    int n = Integer.parseInt(string2);
                    Logger logger = FableLogger.getLogger();
                    Activator.this.setLoggerLevel(logger, n);
                } else if (string.equals("rootLoggerLevelPreference")) {
                    String string3 = (String)propertyChangeEvent.getNewValue();
                    int n = Integer.parseInt(string3);
                    Logger logger = Logger.getRootLogger();
                    Activator.this.setLoggerLevel(logger, n);
                } else if (string.equals("imagePrintUnitsPreference")) {
                    String string4 = (String)propertyChangeEvent.getNewValue();
                    FableImagePrinter.settings.setUnits(string4);
                } else if (string.equals("imagePrintLeftPreference")) {
                    String string5 = (String)propertyChangeEvent.getNewValue();
                    FableImagePrinter.settings.setLeftString(string5);
                } else if (string.equals("imagePrintRightPreference")) {
                    String string6 = (String)propertyChangeEvent.getNewValue();
                    FableImagePrinter.settings.setRightString(string6);
                } else if (string.equals("imagePrintTopPreference")) {
                    String string7 = (String)propertyChangeEvent.getNewValue();
                    FableImagePrinter.settings.setTopString(string7);
                } else if (string.equals("imagePrintBottomPreference")) {
                    String string8 = (String)propertyChangeEvent.getNewValue();
                    FableImagePrinter.settings.setBottomString(string8);
                } else if (string.equals("imagePrintHAlignPreference")) {
                    String string9 = (String)propertyChangeEvent.getNewValue();
                    int n = Integer.parseInt(string9);
                    FableImagePrinter.settings.setHorizontalAlign(n);
                } else if (string.equals("imagePrintVAlignPreference")) {
                    String string10 = (String)propertyChangeEvent.getNewValue();
                    int n = Integer.parseInt(string10);
                    FableImagePrinter.settings.setVerticalAlign(n);
                } else if (string.equals("imagePrintOrientationPreference")) {
                    String string11 = (String)propertyChangeEvent.getNewValue();
                    FableImagePrinter.settings.setOrientation(string11);
                }
            }
        });
    }

    public void setLoggerLevel(Logger logger, int n) {
        switch (n) {
            case 0: {
                logger.setLevel(Level.ALL);
                break;
            }
            case 1: {
                logger.setLevel(Level.TRACE);
                break;
            }
            case 2: {
                logger.setLevel(Level.DEBUG);
                break;
            }
            case 3: {
                logger.setLevel(Level.INFO);
                break;
            }
            case 4: {
                logger.setLevel(Level.WARN);
                break;
            }
            case 5: {
                logger.setLevel(Level.ERROR);
                break;
            }
            case 6: {
                logger.setLevel(Level.FATAL);
                break;
            }
            case 7: {
                logger.setLevel(Level.OFF);
            }
        }
        if (this.loggerLevelSet) {
            logger.info((Object)("Setting " + logger.getName() + " to " + logger.getLevel()));
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        try {
            plugin = null;
            if (this.prefs != null && this.listener != null) {
                this.prefs.removePropertyChangeListener(this.listener);
            }
            this.prefs = null;
            this.listener = null;
            try {
                if (FableClipboard.clipboard != null && !FableClipboard.clipboard.isDisposed()) {
                    FableClipboard.clipboard.dispose();
                }
            }
            catch (SWTException sWTException) {
            }
            catch (Throwable throwable) {}
            FableLogger.info("Fable shutting down");
        }
        finally {
            super.stop(bundleContext);
        }
    }

    public static Activator getDefault() {
        return plugin;
    }
}

