/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.imageprint.test;

import fable.framework.imageprint.ImagePrintPreviewDialog;
import fable.framework.imageprint.ImagePrintSetupDialog;
import fable.framework.imageprint.ImagePrintUtils;
import fable.framework.imageprint.PrintSettings;
import fable.framework.toolbox.SWTUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class SWTImageViewer {
    private static final boolean useStartImage = true;
    private static final String startImageName1 = "C:/Documents and Settings/evans/My Documents/My Pictures/DAZ.Dogfight.15017.jpg";
    private static final String startImageName2 = "C:/users/evans/Pictures/DAZ.Dogfight.15017.jpg";
    private String startImageName;
    private Display display;
    private Shell shell;
    private PrintSettings settings;
    private Canvas canvas;
    private ScrollBar hBar;
    private ScrollBar vBar;
    private Point origin;
    private Image image;
    private String fileName;

    public SWTImageViewer() {
        block7: {
            this.startImageName = startImageName2;
            this.display = new Display();
            this.shell = new Shell(this.display);
            this.shell.setText("SWT Image Viewer");
            this.shell.setLayout((Layout)new GridLayout(1, true));
            this.settings = new PrintSettings();
            if (System.getProperty("os.name", "Windows XP").equalsIgnoreCase("Windows XP")) {
                this.startImageName = startImageName1;
            }
            ToolBar toolBar = new ToolBar((Composite)this.shell, 0x800000);
            ToolItem toolItem = new ToolItem(toolBar, 8);
            toolItem.setText("Open");
            toolItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    FileDialog fileDialog = new FileDialog(SWTImageViewer.this.shell, 4096);
                    String string = fileDialog.open();
                    if (string != null) {
                        if (SWTImageViewer.this.image != null) {
                            SWTImageViewer.this.image.dispose();
                        }
                        SWTImageViewer.this.image = null;
                        try {
                            SWTImageViewer.this.image = new Image((Device)SWTImageViewer.this.display, string);
                        }
                        catch (RuntimeException runtimeException) {
                            SWTUtils.excMsgAsync("Failed to load image from file: " + string, runtimeException);
                        }
                        if (SWTImageViewer.this.image != null) {
                            SWTImageViewer.this.fileName = string;
                            SWTImageViewer.this.shell.setText("SWT Image Viewer " + SWTImageViewer.this.fileName);
                            SWTImageViewer.this.canvas.redraw();
                        }
                    }
                }
            });
            ToolItem toolItem2 = new ToolItem(toolBar, 8);
            toolItem2.setText("Print Setup");
            toolItem2.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ImagePrintSetupDialog imagePrintSetupDialog = new ImagePrintSetupDialog(SWTImageViewer.this.shell, SWTImageViewer.this.image, SWTImageViewer.this.settings);
                    SWTImageViewer.this.settings = imagePrintSetupDialog.open();
                }
            });
            ToolItem toolItem3 = new ToolItem(toolBar, 8);
            toolItem3.setText("Preview");
            toolItem3.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ImagePrintPreviewDialog imagePrintPreviewDialog = new ImagePrintPreviewDialog(SWTImageViewer.this.shell, SWTImageViewer.this.image, SWTImageViewer.this.settings);
                    SWTImageViewer.this.settings = imagePrintPreviewDialog.open();
                }
            });
            ToolItem toolItem4 = new ToolItem(toolBar, 8);
            toolItem4.setText("Print");
            toolItem4.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    SWTImageViewer.this.print();
                }
            });
            this.origin = new Point(0, 0);
            this.canvas = new Canvas((Composite)this.shell, 0x100300);
            this.canvas.setBackground(this.display.getSystemColor(1));
            this.canvas.setLayoutData((Object)new GridData(1808));
            this.hBar = this.canvas.getHorizontalBar();
            this.hBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    int n = SWTImageViewer.this.hBar.getSelection();
                    int n2 = -n - ((SWTImageViewer)SWTImageViewer.this).origin.x;
                    Rectangle rectangle = SWTImageViewer.this.image.getBounds();
                    SWTImageViewer.this.canvas.scroll(n2, 0, 0, 0, rectangle.width, rectangle.height, false);
                    ((SWTImageViewer)SWTImageViewer.this).origin.x = -n;
                }
            });
            this.vBar = this.canvas.getVerticalBar();
            this.vBar.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    int n = SWTImageViewer.this.vBar.getSelection();
                    int n2 = -n - ((SWTImageViewer)SWTImageViewer.this).origin.y;
                    Rectangle rectangle = SWTImageViewer.this.image.getBounds();
                    SWTImageViewer.this.canvas.scroll(0, n2, 0, 0, rectangle.width, rectangle.height, false);
                    ((SWTImageViewer)SWTImageViewer.this).origin.y = -n;
                }
            });
            this.canvas.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    if (SWTImageViewer.this.image == null || SWTImageViewer.this.image.isDisposed()) {
                        return;
                    }
                    Rectangle rectangle = SWTImageViewer.this.image.getBounds();
                    Rectangle rectangle2 = SWTImageViewer.this.canvas.getClientArea();
                    SWTImageViewer.this.hBar.setMaximum(rectangle.width);
                    SWTImageViewer.this.vBar.setMaximum(rectangle.height);
                    SWTImageViewer.this.hBar.setThumb(Math.min(rectangle.width, rectangle2.width));
                    SWTImageViewer.this.vBar.setThumb(Math.min(rectangle.height, rectangle2.height));
                    int n = rectangle.width - rectangle2.width;
                    int n2 = rectangle.height - rectangle2.height;
                    int n3 = SWTImageViewer.this.hBar.getSelection();
                    int n4 = SWTImageViewer.this.vBar.getSelection();
                    if (n3 >= n) {
                        if (n <= 0) {
                            n3 = 0;
                        }
                        ((SWTImageViewer)SWTImageViewer.this).origin.x = -n3;
                    }
                    if (n4 >= n2) {
                        if (n2 <= 0) {
                            n4 = 0;
                        }
                        ((SWTImageViewer)SWTImageViewer.this).origin.y = -n4;
                    }
                    SWTImageViewer.this.canvas.redraw();
                }
            });
            this.canvas.addListener(9, new Listener(){

                public void handleEvent(Event event) {
                    int n;
                    if (SWTImageViewer.this.image == null || SWTImageViewer.this.image.isDisposed()) {
                        return;
                    }
                    GC gC = event.gc;
                    gC.drawImage(SWTImageViewer.this.image, ((SWTImageViewer)SWTImageViewer.this).origin.x, ((SWTImageViewer)SWTImageViewer.this).origin.y);
                    Rectangle rectangle = SWTImageViewer.this.image.getBounds();
                    Rectangle rectangle2 = SWTImageViewer.this.canvas.getClientArea();
                    int n2 = rectangle2.width - rectangle.width;
                    if (n2 > 0) {
                        gC.fillRectangle(rectangle.width, 0, n2, rectangle2.height);
                    }
                    if ((n = rectangle2.height - rectangle.height) > 0) {
                        gC.fillRectangle(0, rectangle.height, rectangle2.width, n);
                    }
                }
            });
            try {
                try {
                    this.fileName = this.startImageName;
                    this.image = new Image((Device)this.display, this.startImageName);
                    this.shell.setText("SWT Image Viewer " + this.fileName);
                }
                catch (RuntimeException runtimeException) {
                    this.canvas.redraw();
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.canvas.redraw();
                throw throwable;
            }
            this.canvas.redraw();
        }
        this.shell.setSize(800, 600);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
    }

    void print() {
        PrintDialog printDialog = new PrintDialog(this.shell);
        PrinterData printerData = printDialog.open();
        if (printerData == null) {
            return;
        }
        ImagePrintUtils.printImage(this.image, this.shell.getDisplay().getDPI(), null);
    }

    public static void main(String[] stringArray) {
        new SWTImageViewer();
    }
}

