/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.imageprint;

import fable.framework.imageprint.PrintSettings;
import fable.framework.toolbox.SWTUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ImagePrintUtils {
    private static final boolean debug = false;

    public static boolean printControl(Control control) {
        return ImagePrintUtils.printControl(control, null);
    }

    public static boolean printControl(Control control, PrintSettings printSettings) {
        if (control == null) {
            return false;
        }
        if (printSettings == null) {
            printSettings = new PrintSettings();
        }
        Point point = control.getSize();
        Image image = new Image((Device)control.getDisplay(), point.x, point.y);
        if (image == null) {
            return false;
        }
        GC gC = new GC((Drawable)control);
        gC.copyArea(image, 0, 0);
        gC.dispose();
        boolean bl = ImagePrintUtils.dialogPrintImage(control.getShell(), image, control.getDisplay().getDPI(), printSettings);
        if (image != null && !image.isDisposed()) {
            image.dispose();
        }
        return bl;
    }

    public static boolean dialogPrintImage(Shell shell, Image image, Point point, PrintSettings printSettings) {
        Printer printer;
        PrinterData printerData;
        if (image == null || image.isDisposed()) {
            return false;
        }
        if (printSettings == null) {
            printSettings = new PrintSettings();
        }
        Image image2 = new Image(image.getDevice(), image, 0);
        PrintDialog printDialog = new PrintDialog(shell, 0);
        PrinterData printerData2 = printSettings.getPrinterData();
        if (printerData2 != null) {
            printDialog.setPrinterData(printerData2);
        }
        if ((printerData = printDialog.open()) == null) {
            if (image2 != null && !image2.isDisposed()) {
                image2.dispose();
            }
            return false;
        }
        if (printerData.printToFile) {
            printer = new FileDialog(shell, 4096);
            String string = printer.open();
            if (string != null) {
                printerData.fileName = string;
            } else {
                if (image2 != null && !image2.isDisposed()) {
                    image2.dispose();
                }
                return false;
            }
        }
        if ((printer = new Printer(printerData)) == null) {
            return false;
        }
        printSettings.setPrinterData(printerData);
        ImagePrintUtils.printImage(image2, shell.getDisplay().getDPI(), printSettings);
        if (!printer.isDisposed()) {
            printer.dispose();
        }
        return true;
    }

    public static void printImage(Image image, final Point point, PrintSettings printSettings) {
        if (image == null || image.isDisposed()) {
            return;
        }
        final PrintSettings printSettings2 = printSettings == null ? new PrintSettings() : printSettings;
        final Printer printer = new Printer(printSettings2.getPrinterData());
        if (printer == null) {
            return;
        }
        final Image image2 = new Image(image.getDevice(), image, 0);
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (!printer.startJob("JavaImagePrinting")) {
                    SWTUtils.errMsgAsync("Failed to start print job!");
                    if (!printer.isDisposed()) {
                        printer.dispose();
                    }
                    return;
                }
                ImagePrintUtils.drawImage((Drawable)printer, printer.getDPI(), printer.getBounds(), image2, point, printSettings2);
                if (image2 != null && !image2.isDisposed()) {
                    image2.dispose();
                }
                printer.endPage();
                printer.endJob();
                if (!printer.isDisposed()) {
                    printer.dispose();
                }
            }
        };
        thread.start();
    }

    public static void drawImage(Drawable drawable, Point point, Rectangle rectangle, Image image, Point point2, PrintSettings printSettings) {
        if (drawable == null || image == null || image.isDisposed()) {
            return;
        }
        if (printSettings == null) {
            printSettings = new PrintSettings();
        }
        if (point == null) {
            point = new Point(72, 72);
        }
        if (point2 == null) {
            point2 = new Point(72, 72);
        }
        int n = image.getBounds().width;
        int n2 = image.getBounds().height;
        double d = (double)point.x * 1.0 / (double)point2.x;
        double d2 = (double)point.y * 1.0 / (double)point2.y;
        double d3 = printSettings.getLeft() * (double)point.x;
        double d4 = printSettings.getRight() * (double)point.x;
        double d5 = printSettings.getTop() * (double)point.y;
        double d6 = printSettings.getBottom() * (double)point.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        Rectangle rectangle2 = drawable instanceof Printer ? ((Printer)drawable).computeTrim(0, 0, 0, 0) : new Rectangle(0, 0, 0, 0);
        int n5 = (int)d3 + rectangle2.x;
        int n6 = n3 - (int)d4 + rectangle2.x;
        int n7 = (int)d5 + rectangle2.y;
        int n8 = n4 - (int)d6 + rectangle2.y;
        int n9 = n6 - n5;
        int n10 = n8 - n7;
        if (n9 <= 0) {
            SWTUtils.errMsgAsync("Horizontal margins are too large!");
            return;
        }
        if (n10 <= 0) {
            SWTUtils.errMsgAsync("Vertical margins are too large!");
            return;
        }
        double d7 = Math.min(1.0, (double)(n6 - n5) * 1.0 / (d * (double)n));
        d7 = Math.min(d7, (double)(n8 - n7) * 1.0 / (d2 * (double)n2));
        int n11 = (int)(d * d7 * (double)n);
        int n12 = (int)(d * d7 * (double)n2);
        if (printSettings.getHorizontalAlign() == 4) {
            n11 = n9;
        }
        if (printSettings.getVerticalAlign() == 4) {
            n12 = n10;
        }
        if (n11 < n9) {
            switch (printSettings.getHorizontalAlign()) {
                case 16384: {
                    break;
                }
                case 0x1000000: {
                    n5 += (n9 - n11) / 2;
                    break;
                }
                case 131072: {
                    n5 += n9 - n11;
                }
            }
        }
        if (n12 < n10) {
            switch (printSettings.getVerticalAlign()) {
                case 128: {
                    break;
                }
                case 0x1000000: {
                    n7 += (n10 - n12) / 2;
                    break;
                }
                case 1024: {
                    n7 += n10 - n12;
                }
            }
        }
        GC gC = new GC(drawable);
        gC.drawImage(image, 0, 0, n, n2, rectangle.x + n5, rectangle.y + n7, n11, n12);
        gC.dispose();
    }

    public static void paintPreview(GC gC, Canvas canvas, Rectangle rectangle, Image image, PrintSettings printSettings) {
        int n;
        double d;
        double d2;
        if (canvas == null || canvas.isDisposed() || image == null || image.isDisposed() || printSettings == null || rectangle == null) {
            return;
        }
        if (printSettings == null) {
            printSettings = new PrintSettings();
        }
        Printer printer = new Printer(printSettings.getPrinterData());
        Display display = canvas.getDisplay();
        Point point = display.getDPI();
        Point point2 = printer.getDPI();
        Rectangle rectangle2 = printer.getBounds();
        if (printSettings.getOrientation() == PrintSettings.Orientation.LANDSCAPE) {
            rectangle2 = new Rectangle(rectangle2.y, rectangle2.x, rectangle2.height, rectangle2.width);
            point2.x = printer.getDPI().y;
            point2.y = printer.getDPI().x;
        }
        if ((d2 = (double)rectangle.height / (double)rectangle.width) > (d = (double)rectangle2.height / (double)rectangle2.width)) {
            n = (int)((double)rectangle.height * d / d2 + 0.5);
            rectangle.y += (rectangle.height - n) / 2;
            rectangle.height = n;
        } else {
            n = (int)((double)rectangle.width * d2 / d + 0.5);
            rectangle.x += (rectangle.width - n) / 2;
            rectangle.width = n;
        }
        double d3 = (double)rectangle.width / (double)rectangle2.width * (double)point2.x / (double)point.x;
        PrintSettings printSettings2 = printSettings.clone();
        printSettings2.setLeft(d3 * printSettings2.getLeft());
        printSettings2.setRight(d3 * printSettings2.getRight());
        printSettings2.setTop(d3 * printSettings2.getTop());
        printSettings2.setBottom(d3 * printSettings2.getBottom());
        gC.setBackground(display.getSystemColor(1));
        gC.fillRectangle(rectangle);
        ImagePrintUtils.drawImage((Drawable)canvas, point, rectangle, image, display.getDPI(), printSettings2);
        if (!printer.isDisposed()) {
            printer.dispose();
        }
    }
}

