/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.imageprint;

import fable.framework.imageprint.ImagePrintUtils;
import fable.framework.imageprint.PrintSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImagePrintSetupDialog
extends Dialog {
    private static final int TEXT_WIDTH = 75;
    private static final int CANVAS_BORDER = 10;
    private static final Point CANVAS_SIZE = new Point(300, 300);
    private Point canvasSize = CANVAS_SIZE;
    public static final String[][] hAlignNames = new String[][]{{"Left", Integer.toString(16384)}, {"Center", Integer.toString(0x1000000)}, {"Right", Integer.toString(131072)}, {"Fill", Integer.toString(4)}};
    public static final String[][] vAlignNames = new String[][]{{"Top", Integer.toString(128)}, {"Center", Integer.toString(0x1000000)}, {"Bottom", Integer.toString(1024)}, {"Fill", Integer.toString(4)}};
    private PrintSettings settings;
    private Image image;
    private Canvas canvas;
    private Text leftText;
    private Text rightText;
    private Text topText;
    private Text bottomText;
    private Combo hAlignCombo;
    private Combo vAlignCombo;
    private Button landscapeButton;
    private Button portraitButton;
    private boolean success = false;

    public ImagePrintSetupDialog(Shell shell, Image image, PrintSettings printSettings) {
        this(shell, 2144, image, printSettings);
    }

    public ImagePrintSetupDialog(Shell shell, int n, Image image, PrintSettings printSettings) {
        super(shell, n);
        this.image = image != null ? new Image(image.getDevice(), image, 0) : null;
        this.settings = printSettings != null ? printSettings.clone() : new PrintSettings();
    }

    public PrintSettings open() {
        Display display = this.getParent().getDisplay();
        Shell shell = new Shell(this.getParent(), this.getStyle() | 0x10);
        shell.setText("Print Setup");
        this.createContents(shell);
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
            this.image = null;
        }
        if (this.success) {
            return this.settings;
        }
        return null;
    }

    private void createContents(final Shell shell) {
        int n;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        shell.setLayout((Layout)gridLayout);
        Composite composite = new Composite((Composite)shell, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Composite composite2 = new Composite(composite, 0);
        GridDataFactory.fillDefaults().applyTo((Control)composite2);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        Composite composite3 = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite3);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite3.setLayout((Layout)gridLayout);
        if (this.image != null) {
            this.canvas = new Canvas(composite3, 2048);
            GridDataFactory.fillDefaults().grab(true, true).hint(this.canvasSize).applyTo((Control)this.canvas);
            this.canvas.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    ImagePrintSetupDialog.this.paint(paintEvent);
                }
            });
        }
        Group group = new Group(composite2, 0);
        group.setText("Margins");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        group.setLayout((Layout)gridLayout);
        GridDataFactory.fillDefaults().applyTo((Control)group);
        Label label = new Label((Composite)group, 0);
        label.setText("Left");
        this.leftText = new Text((Composite)group, 133124);
        this.leftText.setText(this.settings.getLeftString());
        this.leftText.setToolTipText("Set the left margin");
        GridDataFactory.fillDefaults().hint(75, -1).applyTo((Control)this.leftText);
        this.leftText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                String string = ImagePrintSetupDialog.this.leftText.getText();
                PrintSettings.ValueWithUnits valueWithUnits = ImagePrintSetupDialog.this.settings.parseUnitsString(string);
                PrintSettings.ValueWithUnits valueWithUnits2 = ImagePrintSetupDialog.this.settings.scaleToInches(valueWithUnits);
                ImagePrintSetupDialog.this.settings.setLeft(valueWithUnits2.getVal());
                ImagePrintSetupDialog.this.leftText.setText(ImagePrintSetupDialog.this.settings.getLeftString());
                ImagePrintSetupDialog.this.canvas.redraw();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Right");
        this.rightText = new Text((Composite)group, 133124);
        this.rightText.setText(this.settings.getRightString());
        this.rightText.setToolTipText("Set the right margin");
        GridDataFactory.fillDefaults().hint(75, -1).applyTo((Control)this.rightText);
        this.rightText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                String string = ImagePrintSetupDialog.this.rightText.getText();
                PrintSettings.ValueWithUnits valueWithUnits = ImagePrintSetupDialog.this.settings.parseUnitsString(string);
                PrintSettings.ValueWithUnits valueWithUnits2 = ImagePrintSetupDialog.this.settings.scaleToInches(valueWithUnits);
                ImagePrintSetupDialog.this.settings.setRight(valueWithUnits2.getVal());
                ImagePrintSetupDialog.this.rightText.setText(ImagePrintSetupDialog.this.settings.getRightString());
                ImagePrintSetupDialog.this.canvas.redraw();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Top");
        this.topText = new Text((Composite)group, 133124);
        this.topText.setText(this.settings.getTopString());
        this.topText.setToolTipText("Set the top margin");
        GridDataFactory.fillDefaults().hint(75, -1).applyTo((Control)this.topText);
        this.topText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                String string = ImagePrintSetupDialog.this.topText.getText();
                PrintSettings.ValueWithUnits valueWithUnits = ImagePrintSetupDialog.this.settings.parseUnitsString(string);
                PrintSettings.ValueWithUnits valueWithUnits2 = ImagePrintSetupDialog.this.settings.scaleToInches(valueWithUnits);
                ImagePrintSetupDialog.this.settings.setTop(valueWithUnits2.getVal());
                ImagePrintSetupDialog.this.topText.setText(ImagePrintSetupDialog.this.settings.getTopString());
                ImagePrintSetupDialog.this.canvas.redraw();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Bottom");
        this.bottomText = new Text((Composite)group, 133124);
        this.bottomText.setText(this.settings.getBottomString());
        this.bottomText.setToolTipText("Set the bottom margin");
        GridDataFactory.fillDefaults().hint(75, -1).applyTo((Control)this.bottomText);
        this.bottomText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                String string = ImagePrintSetupDialog.this.bottomText.getText();
                PrintSettings.ValueWithUnits valueWithUnits = ImagePrintSetupDialog.this.settings.parseUnitsString(string);
                PrintSettings.ValueWithUnits valueWithUnits2 = ImagePrintSetupDialog.this.settings.scaleToInches(valueWithUnits);
                ImagePrintSetupDialog.this.settings.setBottom(valueWithUnits2.getVal());
                ImagePrintSetupDialog.this.bottomText.setText(ImagePrintSetupDialog.this.settings.getBottomString());
                ImagePrintSetupDialog.this.canvas.redraw();
            }
        });
        group = new Group(composite2, 0);
        group.setText("Alignment");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        GridDataFactory.fillDefaults().applyTo((Control)group);
        label = new Label((Composite)group, 0);
        label.setText("Horizontal");
        this.hAlignCombo = new Combo((Composite)group, 0);
        this.hAlignCombo.setToolTipText("Set the horizontal alignment");
        GridDataFactory.fillDefaults().hint(75, -1).applyTo((Control)this.hAlignCombo);
        int n2 = hAlignNames.length;
        int n3 = -1;
        String[] stringArray = new String[n2];
        int n4 = 0;
        while (n4 < n2) {
            stringArray[n4] = hAlignNames[n4][0];
            n = Integer.parseInt(hAlignNames[n4][1]);
            if (n == this.settings.getHorizontalAlign()) {
                n3 = n4;
            }
            ++n4;
        }
        this.hAlignCombo.setItems(stringArray);
        this.hAlignCombo.select(n3);
        this.hAlignCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = ImagePrintSetupDialog.this.hAlignCombo.getSelectionIndex();
                int n2 = Integer.parseInt(hAlignNames[n][1]);
                ImagePrintSetupDialog.this.settings.setHorizontalAlign(n2);
                ImagePrintSetupDialog.this.canvas.redraw();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Vertical");
        this.vAlignCombo = new Combo((Composite)group, 0);
        this.vAlignCombo.setToolTipText("Set the horizontal alignment");
        GridDataFactory.fillDefaults().hint(75, -1).applyTo((Control)this.vAlignCombo);
        n2 = vAlignNames.length;
        stringArray = new String[n2];
        n4 = 0;
        while (n4 < n2) {
            stringArray[n4] = vAlignNames[n4][0];
            n = Integer.parseInt(vAlignNames[n4][1]);
            if (n == this.settings.getVerticalAlign()) {
                n3 = n4;
            }
            ++n4;
        }
        this.vAlignCombo.setItems(stringArray);
        this.vAlignCombo.select(n3);
        this.vAlignCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = ImagePrintSetupDialog.this.vAlignCombo.getSelectionIndex();
                int n2 = Integer.parseInt(vAlignNames[n][1]);
                ImagePrintSetupDialog.this.settings.setVerticalAlign(n2);
                ImagePrintSetupDialog.this.canvas.redraw();
            }
        });
        group = new Group(composite2, 0);
        group.setText("Units");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group.setLayout((Layout)gridLayout);
        GridDataFactory.fillDefaults().applyTo((Control)group);
        Button button = new Button((Composite)group, 16);
        button.setText("in");
        button.setToolTipText("Set default units to inches");
        button.setSelection(this.settings.getUnits() == PrintSettings.Units.INCH);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImagePrintSetupDialog.this.settings.setUnits(PrintSettings.Units.INCH);
                ImagePrintSetupDialog.this.resetMarginStrings();
            }
        });
        button = new Button((Composite)group, 16);
        button.setText("cm");
        button.setToolTipText("Set default units to centimeters");
        button.setSelection(this.settings.getUnits() == PrintSettings.Units.CENTIMETER);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImagePrintSetupDialog.this.settings.setUnits(PrintSettings.Units.CENTIMETER);
                ImagePrintSetupDialog.this.resetMarginStrings();
            }
        });
        button = new Button((Composite)group, 16);
        button.setText("mm");
        button.setSelection(this.settings.getUnits() == PrintSettings.Units.MILLIMETER);
        button.setToolTipText("Set default units to millimeters");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImagePrintSetupDialog.this.settings.setUnits(PrintSettings.Units.MILLIMETER);
                ImagePrintSetupDialog.this.resetMarginStrings();
            }
        });
        group = new Group(composite2, 0);
        group.setText("Orientation");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        GridDataFactory.fillDefaults().applyTo((Control)group);
        this.portraitButton = new Button((Composite)group, 16);
        this.portraitButton.setText("Portrait");
        this.portraitButton.setToolTipText("Use Portrait for the preview");
        this.portraitButton.setSelection(this.settings.getOrientation() != PrintSettings.Orientation.LANDSCAPE);
        this.portraitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImagePrintSetupDialog.this.settings.setOrientation(PrintSettings.Orientation.PORTRAIT);
                ImagePrintSetupDialog.this.canvas.redraw();
            }
        });
        this.landscapeButton = new Button((Composite)group, 16);
        this.landscapeButton.setText("Landscape");
        this.landscapeButton.setToolTipText("Use Portrait for the preview");
        this.landscapeButton.setSelection(this.settings.getOrientation() == PrintSettings.Orientation.LANDSCAPE);
        this.landscapeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImagePrintSetupDialog.this.settings.setOrientation(PrintSettings.Orientation.LANDSCAPE);
                ImagePrintSetupDialog.this.canvas.redraw();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText("Note: The orientation is for the preview\nThe printer orientation will still have to\nbe set for the printer when you print.");
        GridDataFactory.fillDefaults().span(new Point(2, 1)).applyTo((Control)label);
        Composite composite4 = new Composite(composite2, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite4.setLayout((Layout)gridLayout);
        GridDataFactory.fillDefaults().applyTo((Control)composite4);
        button = new Button(composite4, 8);
        button.setText("Select Printer");
        button.setToolTipText("Select a printer (Will not actually print)");
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)composite4);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PrintDialog printDialog = new PrintDialog(shell);
                PrinterData printerData = printDialog.open();
                if (printerData == null) {
                    return;
                }
                ImagePrintSetupDialog.this.settings.setPrinterData(printerData);
                ImagePrintSetupDialog.this.canvas.redraw();
            }
        });
        button = new Button(composite4, 8);
        button.setText("Print");
        button.setToolTipText("Print now");
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)composite4);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImagePrintUtils.dialogPrintImage(shell, ImagePrintSetupDialog.this.image, shell.getDisplay().getDPI(), ImagePrintSetupDialog.this.settings);
            }
        });
        Composite composite5 = new Composite((Composite)shell, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite5);
        FormLayout formLayout = new FormLayout();
        composite5.setLayout((Layout)formLayout);
        Button button2 = new Button(composite5, 8);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)group, 8);
        formData.right = new FormAttachment(100, -4);
        button2.setLayoutData((Object)formData);
        button2.setText("&Cancel");
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImagePrintSetupDialog.this.success = false;
                shell.close();
            }
        });
        Button button3 = new Button(composite5, 8);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment((Control)group, 8);
        formData2.right = new FormAttachment((Control)button2, -8);
        button3.setLayoutData((Object)formData2);
        button3.setText("&OK");
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImagePrintSetupDialog.this.success = true;
                shell.close();
            }
        });
    }

    private void resetMarginStrings() {
        this.leftText.setText(this.settings.getLeftString());
        this.rightText.setText(this.settings.getRightString());
        this.topText.setText(this.settings.getTopString());
        this.bottomText.setText(this.settings.getBottomString());
    }

    private void paint(PaintEvent paintEvent) {
        GC gC = paintEvent.gc;
        Rectangle rectangle = this.canvas.getClientArea();
        rectangle.x += 10;
        rectangle.y += 10;
        rectangle.width -= 20;
        rectangle.height -= 20;
        ImagePrintUtils.paintPreview(gC, this.canvas, rectangle, this.image, this.settings);
    }

    public Point getCanvasSize() {
        return this.canvasSize;
    }

    public void setCanvasSize(Point point) {
        this.canvasSize = point;
    }
}

