/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.views;

import fable.framework.toolbox.ToolBox;
import fable.framework.views.FableMessageConsole;
import fable.python.ChiFile;
import java.io.OutputStream;
import java.io.PrintStream;
import jep.JepException;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.part.ViewPart;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class chiPlotView
extends ViewPart {
    public FableMessageConsole console;
    public static final String ID = "fable.framework.ui.views.chiPlotView";
    public static chiPlotView thisView = null;
    public static GLContext context = null;
    private static SceneGrip grip = null;
    private static GLCanvas canvas = null;
    private Spinner minimumSpinner;
    private Spinner maximumSpinner;
    private Button freezeButton;
    private Button autoscaleButton;
    private static boolean freeze = false;
    private static boolean autoscale = true;
    private Button updateButton;
    private Button resetButton;
    private static float[] blue = new float[]{1.0f, 0.333f, 0.666f, 0.999f, 0.833f, 0.666f, 0.5f, 0.333f, 0.166f, 0.0f, 0.0f};
    private static float[] green = new float[]{1.0f, 0.0f, 0.111f, 0.222f, 0.333f, 0.666f, 0.999f, 0.666f, 0.333f, 0.0f, 0.0f};
    private static float[] red = new float[]{1.0f, 0.0f, 0.055f, 0.11f, 0.165f, 0.22f, 0.275f, 0.333f, 0.666f, 0.999f, 1.0f};
    private static int COLOR_INDEX_MAX = 10;
    private float scaleMinimum;
    private float scaleMaximum;
    private static int pointSize = 4;
    private static float[] image = null;
    private static int imageWidth = 0;
    private static int imageHeight = 0;
    private float[] dots = null;
    private float minimum;
    private float mean;
    private String fileName;
    private static int canvasWidth = 0;
    private static int canvasHeight = 0;
    private static float zscale;
    private static boolean reliefListFirst;
    private static int reliefList;
    static boolean firstImage;

    static {
        reliefListFirst = true;
        firstImage = true;
    }

    public void createPartControl(Composite composite) {
        this.console = new FableMessageConsole("Peaksearch console");
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
        this.console.displayOut("Welcome to chiplotview " + ToolBox.getPluginVersion((String)"fable.framework.ui"));
        IOConsoleOutputStream iOConsoleOutputStream = this.console.newOutputStream();
        System.setOut(new PrintStream((OutputStream)iOConsoleOutputStream, true));
        System.setErr(new PrintStream((OutputStream)iOConsoleOutputStream));
        thisView = this;
        composite.setLayout((Layout)new GridLayout());
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 8;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 0, true, false));
        this.freezeButton = new Button(composite2, 32);
        this.freezeButton.setText("Freeze");
        this.freezeButton.setToolTipText("freeze 3d relief, disable rotation");
        this.freezeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (chiPlotView.this.freezeButton.getSelection()) {
                    freeze = true;
                } else {
                    freeze = false;
                }
            }
        });
        this.resetButton = new Button(composite2, 0);
        this.resetButton.setText("Reset");
        this.resetButton.setToolTipText("reset 3d projection to be flat and fill the canvas");
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                grip.init();
            }
        });
        this.autoscaleButton = new Button(composite2, 32);
        this.autoscaleButton.setText("Autoscale");
        this.autoscaleButton.setToolTipText("autoscale 3d relief between minimum and mean");
        this.autoscaleButton.setSelection(true);
        this.autoscaleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (chiPlotView.this.autoscaleButton.getSelection()) {
                    if (!autoscale) {
                        autoscale = true;
                        chiPlotView.this.scaleImage();
                        chiPlotView.drawReliefList();
                    }
                    chiPlotView.this.minimumSpinner.setEnabled(false);
                    chiPlotView.this.maximumSpinner.setEnabled(false);
                } else {
                    if (autoscale) {
                        autoscale = false;
                        chiPlotView.this.scaleImage();
                        chiPlotView.drawReliefList();
                    }
                    chiPlotView.this.minimumSpinner.setEnabled(true);
                    chiPlotView.this.maximumSpinner.setEnabled(true);
                }
            }
        });
        Label label = new Label(composite2, 0);
        label.setText("Minimum");
        this.minimumSpinner = new Spinner(composite2, 0);
        this.minimumSpinner.setLayoutData((Object)new GridData(4, 0, true, false));
        this.minimumSpinner.setMinimum(0);
        this.minimumSpinner.setMaximum(Integer.MAX_VALUE);
        this.minimumSpinner.setEnabled(false);
        Label label2 = new Label(composite2, 0);
        label2.setText("Maximum");
        this.maximumSpinner = new Spinner(composite2, 0);
        this.maximumSpinner.setLayoutData((Object)new GridData(4, 0, true, false));
        this.maximumSpinner.setMinimum(0);
        this.maximumSpinner.setMaximum(Integer.MAX_VALUE);
        this.maximumSpinner.setEnabled(false);
        this.updateButton = new Button(composite2, 0);
        this.updateButton.setText("Update");
        this.updateButton.setToolTipText("redraw 3d relief plot");
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                chiPlotView.this.scaleImage();
                chiPlotView.drawReliefList();
                chiPlotView.drawRelief();
            }
        });
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayoutData((Object)new GridData(4, 4, true, true));
        composite3.setLayout((Layout)new FillLayout());
        GLData gLData = new GLData();
        gLData.doubleBuffer = true;
        canvas = new GLCanvas(composite3, 0, gLData);
        canvas.setSize(composite3.getSize());
        canvas.setCurrent();
        canvas.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rectangle = canvas.getBounds();
                canvas.setCurrent();
                try {
                    GLContext.useContext((Object)canvas);
                }
                catch (LWJGLException lWJGLException) {
                    lWJGLException.printStackTrace();
                }
                GL11.glViewport((int)0, (int)0, (int)rectangle.width, (int)rectangle.height);
                GL11.glMatrixMode((int)5889);
                GL11.glLoadIdentity();
                chiPlotView.drawRelief();
                canvas.swapBuffers();
            }
        });
        try {
            GLContext.useContext((Object)canvas);
        }
        catch (LWJGLException lWJGLException) {
            lWJGLException.printStackTrace();
        }
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)-1.0, (double)1.0);
        grip = new SceneGrip();
        canvas.addMouseListener((MouseListener)grip);
        canvas.addMouseMoveListener((MouseMoveListener)grip);
        canvas.addListener(37, (Listener)grip);
        canvas.addKeyListener((KeyListener)grip);
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!canvas.isDisposed()) {
                    canvas.setCurrent();
                    chiPlotView.drawRelief();
                    canvas.swapBuffers();
                }
            }
        });
    }

    static void drawRelief() {
        canvas.setCurrent();
        try {
            GLContext.useContext((Object)canvas);
        }
        catch (LWJGLException lWJGLException) {
            lWJGLException.printStackTrace();
        }
        GL11.glClear((int)16640);
        if (!freeze) {
            grip.adjust();
        }
        if (image != null) {
            GL11.glClear((int)16640);
            GL11.glDisable((int)2896);
            GL11.glCallList((int)reliefList);
            GL11.glEnable((int)2896);
        }
    }

    private static void drawReliefList() {
        if (!reliefListFirst) {
            GL11.glDeleteLists((int)reliefList, (int)1);
        }
        reliefListFirst = false;
        reliefList = GL11.glGenLists((int)1);
        GL11.glNewList((int)reliefList, (int)4864);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPointSize((float)pointSize);
        int n = 0;
        while (n < imageWidth - 1) {
            GL11.glBegin((int)3);
            int n2 = n + 1;
            int n3 = (int)image[n];
            if (n3 < 0) {
                n3 = 0;
            }
            if (n3 > COLOR_INDEX_MAX) {
                n3 = COLOR_INDEX_MAX;
            }
            GL11.glColor3f((float)red[n3], (float)green[n3], (float)blue[n3]);
            GL11.glVertex3f((float)n, (float)image[n], (float)image[n2]);
            GL11.glEnd();
            ++n;
        }
        GL11.glEndList();
        GL11.glFlush();
    }

    public void plot(float[] fArray, int n, int n2, float f, float f2, float f3, String string) {
        this.dots = fArray;
        image = new float[n * n2];
        imageWidth = n;
        imageHeight = n2;
        this.minimum = f;
        this.mean = f3;
        if (autoscale) {
            this.scaleMinimum = f;
            this.scaleMaximum = f3;
        }
        this.fileName = string;
        this.setPartName("Plot " + this.fileName);
        if (firstImage) {
            grip.init();
            firstImage = false;
        }
        this.scaleImage();
        chiPlotView.drawReliefList();
    }

    public void scaleImage() {
        if (autoscale) {
            this.scaleMinimum = this.minimum;
            this.scaleMaximum = this.mean;
            this.minimumSpinner.setSelection((int)this.scaleMinimum);
            this.maximumSpinner.setSelection((int)this.scaleMaximum);
        } else {
            this.scaleMinimum = this.minimumSpinner.getSelection();
            this.scaleMaximum = this.maximumSpinner.getSelection();
        }
        if (this.scaleMinimum == this.scaleMaximum) {
            this.scaleMaximum = this.scaleMinimum + 1.0f;
        }
        zscale = 10.0f / (2.0f * (this.scaleMaximum - this.scaleMinimum));
        int n = 0;
        while (n < imageWidth) {
            float f = this.dots[n];
            chiPlotView.image[n] = (f - this.scaleMinimum) * zscale;
            ++n;
        }
    }

    public void setFocus() {
    }

    public void openFile(String string) {
        try {
            ChiFile chiFile = new ChiFile();
            chiFile.loadfile(string);
        }
        catch (JepException jepException) {
            jepException.printStackTrace();
        }
    }

    public class SceneGrip
    extends MouseAdapter
    implements MouseMoveListener,
    Listener,
    KeyListener {
        private float xrot;
        private float yrot;
        private float zoff;
        private float xoff;
        private float yoff;
        private float xcpy;
        private float ycpy;
        private float xscale;
        private float yscale;
        private boolean move;
        private int xdown;
        private int ydown;
        private int mouseDown;

        public SceneGrip() {
            this.init();
        }

        protected void init() {
            canvas.setCurrent();
            Rectangle rectangle = canvas.getBounds();
            canvasWidth = rectangle.width;
            canvasHeight = rectangle.height;
            this.yrot = 0.0f;
            this.xrot = 0.0f;
            this.yoff = 0.0f;
            this.xoff = 0.0f;
            if (imageWidth != 0) {
                this.xscale = canvasWidth / imageWidth;
            }
            if (imageHeight != 0) {
                this.yscale = canvasHeight / imageHeight;
            }
            this.zoff = 1.0f;
            this.zoff = this.xscale < this.yscale ? this.xscale : this.yscale;
        }

        public void mouseDown(MouseEvent mouseEvent) {
            if (++this.mouseDown == 1) {
                this.move = mouseEvent.button == 3;
                if (this.move) {
                    this.xcpy = this.xoff;
                    this.ycpy = this.yoff;
                    ((Control)mouseEvent.widget).setCursor(mouseEvent.widget.getDisplay().getSystemCursor(21));
                } else {
                    this.xcpy = this.xrot;
                    this.ycpy = this.yrot;
                    ((Control)mouseEvent.widget).setCursor(mouseEvent.widget.getDisplay().getSystemCursor(5));
                }
                this.xdown = mouseEvent.x;
                this.ydown = mouseEvent.y;
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
            if (--this.mouseDown == 0) {
                ((Control)mouseEvent.widget).setCursor(mouseEvent.widget.getDisplay().getSystemCursor(0));
            }
        }

        public void mouseMove(MouseEvent mouseEvent) {
            Point point = ((Control)mouseEvent.widget).getSize();
            if (this.mouseDown > 0) {
                int n = mouseEvent.x - this.xdown;
                int n2 = mouseEvent.y - this.ydown;
                if (this.move) {
                    this.yoff = this.ycpy + (float)canvasHeight / 2.0f * (float)n2 / (2.0f * (float)point.y);
                    this.xoff = this.xcpy + (float)canvasWidth / 2.0f * (float)n / (2.0f * (float)point.x);
                } else {
                    this.xrot = this.xcpy + (float)n2 / 2.0f;
                    this.yrot = this.ycpy + (float)n / 2.0f;
                }
            }
        }

        public void handleEvent(Event event) {
            this.zoff *= 1.1f;
        }

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.keyCode) {
                case 0x1000001: {
                    if ((keyEvent.stateMask & 0x40000) != 0) {
                        this.xrot -= 5.0f;
                        break;
                    }
                    this.yoff -= (float)canvasHeight / 10.0f;
                    break;
                }
                case 0x1000002: {
                    if ((keyEvent.stateMask & 0x40000) != 0) {
                        this.xrot += 5.0f;
                        break;
                    }
                    this.yoff += (float)canvasHeight / 10.0f;
                    break;
                }
                case 0x1000003: {
                    if ((keyEvent.stateMask & 0x40000) != 0) {
                        this.yrot -= 5.0f;
                        break;
                    }
                    this.xoff -= (float)canvasWidth / 10.0f;
                    break;
                }
                case 0x1000004: {
                    if ((keyEvent.stateMask & 0x40000) != 0) {
                        this.yrot += 5.0f;
                        break;
                    }
                    this.xoff += (float)canvasWidth / 10.0f;
                    break;
                }
                case 0x1000005: {
                    this.zoff *= 1.05f;
                    break;
                }
                case 0x1000006: {
                    this.zoff *= 0.95f;
                    break;
                }
                case 0x1000007: {
                    this.init();
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void adjust() {
            try {
                GLContext.useContext((Object)canvas);
            }
            catch (LWJGLException lWJGLException) {
                lWJGLException.printStackTrace();
            }
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)canvasWidth, (double)canvasHeight, (double)0.0, (double)-100000.0, (double)100000.0);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)((float)(canvasWidth / 2) + this.xoff), (float)((float)(canvasHeight / 2) + this.yoff), (float)0.0f);
            GL11.glScalef((float)this.zoff, (float)this.zoff, (float)this.zoff);
            GL11.glRotatef((float)this.xrot, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)this.yrot, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)(-imageWidth / 2), (float)(-imageHeight / 2), (float)0.0f);
        }

        public void setOffsets(float f, float f2, float f3) {
            this.xoff = f;
            this.yoff = f2;
            this.zoff = f3;
        }

        public void setRotation(float f, float f2) {
            this.xrot = f;
            this.yrot = f2;
        }
    }
}

