/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.views;

import fable.framework.toolbox.FableUtils;
import fable.framework.ui.rcp.Activator;
import fable.framework.ui.views.ColFileXYPlot;
import fable.python.ColumnFile;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import jep.JepException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ColumnFilePlotView
extends ViewPart
implements IPropertyChangeListener {
    private ColFileXYPlot xyplot;
    public static ColumnFilePlotView view;
    public static final String ID = "fable.framework.ui.views.ColumnFilePlotView";
    public static int viewCount;
    private JLDataView dataViewForUniccells;
    private ColumnFile columnFile = null;
    private Action showOptionsAction;

    static {
        viewCount = 0;
    }

    public void createPartControl(Composite composite) {
        composite.setLayout((Layout)new GridLayout(2, false));
        view = this;
        this.setPartName("Column File Plot " + Integer.toString(viewCount));
        this.xyplot = new ColFileXYPlot(composite, "Column File Plot " + Integer.toString(viewCount), "X", "Y");
        this.makeActions();
        this.contributeToActionBars();
    }

    private void makeActions() {
        this.showOptionsAction = new Action("Toggle Plot Options"){

            public void run() {
                if (ColumnFilePlotView.this.xyplot == null) {
                    return;
                }
                ColumnFilePlotView.this.xyplot.setOptionsShowing(!ColumnFilePlotView.this.xyplot.getOptionsShowing());
            }
        };
        this.showOptionsAction.setToolTipText("Toggle showing plot options or having plot occupy entire area");
        this.showOptionsAction.setImageDescriptor(Activator.imageDescriptorFromPlugin((String)"fable.framework.ui", (String)"images/settings.gif"));
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalMenu(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.showOptionsAction);
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.showOptionsAction);
    }

    public void dispose() {
        if (this.xyplot != null) {
            this.xyplot.dispose();
        }
        this.xyplot = null;
        if (this.columnFile != null) {
            this.columnFile.removePropertyrChangeListener((IPropertyChangeListener)this);
        }
    }

    public void setFocus() {
    }

    public ColFileXYPlot getxyPlot() {
        return this.xyplot;
    }

    public void addData(final float[] fArray) {
        if (!Display.getCurrent().isDisposed()) {
            Display.getCurrent().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (fArray != null) {
                        if (!ColumnFilePlotView.this.xyplot.getChart().getY1Axis().equals("") && !ColumnFilePlotView.this.xyplot.getChart().getXAxis().equals("")) {
                            if (ColumnFilePlotView.this.dataViewForUniccells == null) {
                                ColumnFilePlotView.this.dataViewForUniccells = new JLDataView();
                                ColumnFilePlotView.this.xyplot.getVectordataview().add(ColumnFilePlotView.this.dataViewForUniccells);
                                ColumnFilePlotView.this.dataViewForUniccells.setMarker(6);
                                ColumnFilePlotView.this.dataViewForUniccells.setLineWidth(0);
                                ColumnFilePlotView.this.dataViewForUniccells.setMarkerColor(Color.MAGENTA);
                            } else {
                                ColumnFilePlotView.this.dataViewForUniccells.reset();
                                if (!ColumnFilePlotView.this.xyplot.getVectordataview().contains(ColumnFilePlotView.this.dataViewForUniccells)) {
                                    ColumnFilePlotView.this.xyplot.getVectordataview().add(ColumnFilePlotView.this.dataViewForUniccells);
                                }
                            }
                            int n = 0;
                            while (n < fArray.length) {
                                ColumnFilePlotView.this.dataViewForUniccells.add(new Point2D.Double(fArray[n], 0.0));
                                ColumnFilePlotView.this.dataViewForUniccells.setMarkerSize(10);
                                ColumnFilePlotView.this.dataViewForUniccells.setName("Unit cell");
                                ++n;
                            }
                            ColumnFilePlotView.this.xyplot.getChart().getY1Axis().addDataView(ColumnFilePlotView.this.dataViewForUniccells);
                            ColumnFilePlotView.this.xyplot.getChart().getXAxis().setName("tth");
                            String[] stringArray = new String[]{"tth", ""};
                            ColumnFilePlotView.this.xyplot.plotData(stringArray);
                            ColumnFilePlotView.this.xyplot.getChart().getY1Axis().setName("");
                        }
                    } else {
                        ColumnFilePlotView.this.xyplot.getChart().setNoValueString("No value to display");
                    }
                    ColumnFilePlotView.this.xyplot.repaint();
                }
            });
        }
    }

    public void openColumnFile(String string) {
        try {
            this.columnFile = new ColumnFile(string);
            this.columnFile.addPropertyChangeListener((IPropertyChangeListener)this);
            this.xyplot.addColumnFile(this.columnFile);
        }
        catch (JepException jepException) {
            FableUtils.excMsg((Object)((Object)this), (String)"Error creating ColumnFile", (Throwable)jepException);
        }
    }

    public void setColumnFile(ColumnFile columnFile) {
        this.columnFile = columnFile;
        this.columnFile.addPropertyChangeListener((IPropertyChangeListener)this);
        if (this.columnFile.getFileName() != null) {
            this.xyplot.addColumnFile(this.columnFile);
            this.setPartName(this.columnFile.getFileName());
        }
    }

    public void browseColumnFile() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            try {
                FileDialog fileDialog = new FileDialog(new Shell(), 2);
                fileDialog.setText("Select one or more file(s) containing columns of data to plot");
                String string = fileDialog.open();
                if (string != null) {
                    String[] stringArray = fileDialog.getFileNames();
                    int n = 0;
                    while (n < stringArray.length) {
                        string = String.valueOf(fileDialog.getFilterPath()) + File.separatorChar + stringArray[n];
                        this.openColumnFile(string);
                        ++n;
                    }
                }
            }
            catch (Exception exception) {
                FableUtils.excMsg((Object)((Object)this), (String)"Error opening view", (Throwable)exception);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("AddColumn")) {
            this.xyplot.addColumnFile((ColumnFile)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getProperty().equals("updateColumn")) {
            this.xyplot.updateColumnFile((ColumnFile)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getProperty().equals("AddUnitCell")) {
            this.addData(((ColumnFile)propertyChangeEvent.getNewValue()).getUnitCell());
        } else if (propertyChangeEvent.getProperty().equals("PlotData")) {
            String[] stringArray = (String[])propertyChangeEvent.getNewValue();
            this.xyplot.plotData(stringArray);
        } else if (propertyChangeEvent.getProperty().equals("removeAll")) {
            this.xyplot.clearAllPlots();
        }
    }

    public void saveAs() {
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        String[] stringArray = new String[]{"*.flt", "*.*"};
        String[] stringArray2 = new String[]{"filtered files (*.flt)", "All Files (*.*)"};
        fileDialog.setFilterExtensions(stringArray);
        fileDialog.setFilterNames(stringArray2);
        fileDialog.setText("Save file");
        String string = fileDialog.open();
        if (string != null && !this.xyplot.currentColumnFile.saveColumnFile(string = String.valueOf(fileDialog.getFilterPath()) + System.getProperty("file.separator") + fileDialog.getFileName())) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Save file", (String)"Column file couldn't be saved");
        }
    }
}

