/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.editors;

import fable.framework.toolbox.Activator;
import fable.framework.ui.editors.ColumnFileContentProvider;
import fable.framework.ui.editors.ColumnFileEditorInput;
import fable.framework.ui.editors.ColumnFileLabelProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class ColumnFileEditor
extends EditorPart
implements IPropertyChangeListener {
    private static final String ID = "fable.framework.ui.ColumnFileEditor";
    private ColumnFileEditorInput columnInput;
    private boolean dirty = false;
    private TableViewer tableViewer;
    final Color light_blue = new Color((Device)Display.getCurrent(), 228, 247, 248);
    private Table table;
    private Listener sortListener;
    private Image imgMenuRemove;
    private ImageDescriptor GifDelete = Activator.imageDescriptorFromPlugin((String)"fable.framework.toolbox", (String)"images/delete.gif");
    private ImageDescriptor keep_descriptor = Activator.imageDescriptorFromPlugin((String)"fable.framework.toolbox", (String)"images/check.gif");
    private Image imageKeep;

    public void doSave(IProgressMonitor iProgressMonitor) {
        this.columnInput.getColumn().saveColumnFile(this.columnInput.getColumn().getFileName());
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
        if (this.columnInput.saveAs()) {
            this.dirty = false;
            this.firePropertyChange(257);
            this.setPartName(this.columnInput.getColumn().getFileName());
        }
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        this.columnInput = (ColumnFileEditorInput)iEditorInput;
        this.setPartName(this.columnInput.getColumn().getFileName());
        this.initSortListener();
        this.columnInput.getColumn().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return this.dirty;
    }

    public void createPartControl(Composite composite) {
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 1;
        this.tableViewer = new TableViewer(composite, 268503042);
        this.tableViewer.setContentProvider((IContentProvider)new ColumnFileContentProvider(this.tableViewer));
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ColumnFileLabelProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.tableViewer.setInput((Object)this.columnInput.getColumn());
        this.table = this.tableViewer.getTable();
        this.table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
                if (mouseEvent.button == 3) {
                    Menu menu = new Menu((Decorations)Display.getCurrent().getActiveShell(), 8);
                    MenuItem menuItem = new MenuItem(menu, 8);
                    MenuItem menuItem2 = new MenuItem(menu, 8);
                    ColumnFileEditor.this.imgMenuRemove = ColumnFileEditor.this.GifDelete.createImage();
                    menuItem.setImage(ColumnFileEditor.this.imgMenuRemove);
                    menuItem.setText("Throw");
                    menuItem.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent disposeEvent) {
                            if (ColumnFileEditor.this.imgMenuRemove != null && !ColumnFileEditor.this.imgMenuRemove.isDisposed()) {
                                ColumnFileEditor.this.imgMenuRemove.dispose();
                            }
                        }
                    });
                    menuItem.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            TableItem[] tableItemArray = ColumnFileEditor.this.table.getSelection();
                            if (tableItemArray.length > 0 && ColumnFileEditor.this.table.getItemCount() > 0) {
                                ColumnFileEditor.this.table.getColumnCount();
                                Object[] objectArray = new Object[tableItemArray.length];
                                int n = 0;
                                while (n < tableItemArray.length) {
                                    objectArray[n] = tableItemArray[n].getText(ColumnFileEditor.this.table.getColumnCount() - 1);
                                    ++n;
                                }
                                ColumnFileEditor.this.columnInput.getColumn().removeRow(objectArray, ColumnFileEditor.this.columnInput.getColumn().getColumnfileId());
                                ColumnFileEditor.this.dirty = true;
                                ColumnFileEditor.this.firePropertyChange(257);
                            }
                        }
                    });
                    ColumnFileEditor.this.imageKeep = ColumnFileEditor.this.keep_descriptor.createImage();
                    menuItem2.setImage(ColumnFileEditor.this.imageKeep);
                    menuItem2.setText("Keep");
                    menuItem2.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent disposeEvent) {
                            if (ColumnFileEditor.this.imageKeep != null && !ColumnFileEditor.this.imageKeep.isDisposed()) {
                                ColumnFileEditor.this.imageKeep.dispose();
                            }
                        }
                    });
                    menuItem2.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            TableItem[] tableItemArray = ColumnFileEditor.this.table.getSelection();
                            if (tableItemArray.length > 0 && ColumnFileEditor.this.table.getItemCount() > 0) {
                                ColumnFileEditor.this.table.getColumnCount();
                                Object[] objectArray = new Object[tableItemArray.length];
                                int n = 0;
                                while (n < tableItemArray.length) {
                                    objectArray[n] = tableItemArray[n].getText(ColumnFileEditor.this.table.getColumnCount() - 1);
                                    ++n;
                                }
                                ColumnFileEditor.this.columnInput.getColumn().keepRow(objectArray, ColumnFileEditor.this.columnInput.getColumn().getColumnfileId());
                                ColumnFileEditor.this.dirty = true;
                                ColumnFileEditor.this.firePropertyChange(257);
                            }
                        }
                    });
                    menu.setVisible(true);
                    while (!menu.isDisposed() && menu.isVisible()) {
                        if (Display.getCurrent().readAndDispatch()) continue;
                        Display.getCurrent().sleep();
                    }
                    menu.dispose();
                }
            }

            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.table.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TableItem tableItem = (TableItem)event.item;
                int n = event.index;
                tableItem.setBackground(n % 2 == 0 ? Display.getCurrent().getSystemColor(1) : ColumnFileEditor.this.light_blue);
            }
        });
        this.populateTable();
        this.getEditorSite().getActionBarContributor().setActiveEditor((IEditorPart)this);
    }

    public void setFocus() {
    }

    public static String getId() {
        return ID;
    }

    private void populateTable() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ColumnFileEditor.this.table.removeAll();
                ColumnFileEditor.this.table.clearAll();
                while (ColumnFileEditor.this.table.getColumnCount() > 0) {
                    ColumnFileEditor.this.table.getColumn(0).removeListener(13, ColumnFileEditor.this.sortListener);
                    ColumnFileEditor.this.table.getColumn(0).dispose();
                }
                String[] stringArray = ColumnFileEditor.this.columnInput.getColumn().getTitles();
                int n = 0;
                while (n < ColumnFileEditor.this.columnInput.getColumn().getNCols()) {
                    TableColumn tableColumn = new TableColumn(ColumnFileEditor.this.table, 16384);
                    tableColumn.setText(stringArray[n]);
                    tableColumn.addListener(13, ColumnFileEditor.this.sortListener);
                    ++n;
                }
                ColumnFileEditor.this.table.setItemCount(ColumnFileEditor.this.columnInput.getColumn().getNRows());
                n = 0;
                while (n < ColumnFileEditor.this.table.getColumnCount()) {
                    ColumnFileEditor.this.table.getColumn(n).pack();
                    ++n;
                }
            }
        });
    }

    private void initSortListener() {
        this.sortListener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn tableColumn = ColumnFileEditor.this.table.getSortColumn();
                TableColumn tableColumn2 = (TableColumn)event.widget;
                TableColumn[] tableColumnArray = ColumnFileEditor.this.table.getColumns();
                TableColumn tableColumn3 = (TableColumn)event.widget;
                int n = 0;
                int n2 = 0;
                while (n == 0 && n2 < tableColumnArray.length) {
                    if (tableColumnArray[n2].getText().equals(tableColumn3.getText())) {
                        n = n2;
                    }
                    ++n2;
                }
                n2 = ColumnFileEditor.this.table.getSortDirection();
                if (tableColumn == tableColumn2) {
                    n2 = n2 == 128 ? 1024 : 128;
                } else {
                    ColumnFileEditor.this.table.setSortColumn(tableColumn2);
                    n2 = 128;
                }
                ColumnFileEditor.this.columnInput.getColumn().setSortedIndex(n, n2);
                ColumnFileEditor.this.tableViewer.setInput((Object)ColumnFileEditor.this.columnInput.getColumn());
                ColumnFileEditor.this.table.setSortDirection(n2);
                ColumnFileEditor.this.table.setSortColumn(tableColumn3);
            }
        };
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void dispose() {
        this.columnInput.getColumn().removePropertyrChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("updateColumn")) {
            this.dirty = true;
            this.firePropertyChange(257);
            this.table.setItemCount(this.columnInput.getColumn().getNRows());
            this.tableViewer.setInput((Object)this.columnInput.getColumn());
            this.populateTable();
        } else if (propertyChangeEvent.getProperty().equals("propdirty")) {
            this.dirty = (Boolean)propertyChangeEvent.getNewValue();
            this.firePropertyChange(257);
            this.setPartName(this.columnInput.getColumn().getFileName());
        }
    }
}

