/*
 * Decompiled with CFR 0.152.
 */
package fable.framework.ui.actions;

import fable.framework.toolbox.FableUtils;
import fable.framework.ui.editors.ColumnFileEditor;
import fable.framework.ui.editors.ColumnFileEditorInput;
import fable.framework.ui.editors.ColumnFilePlotEditor;
import fable.framework.views.FableIOConsole;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ColumnEditorAction
implements IWorkbenchWindowActionDelegate {
    public static final String ID = "fable.framework.ui.actions.ColumnEditorAction";
    private Display display;
    private IEditorInput input;
    private IWorkbenchPage page;

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
    }

    public void run(IAction iAction) {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        this.setDisplay(iWorkbenchWindow.getShell().getDisplay());
        if (iWorkbenchWindow != null) {
            this.page = iWorkbenchWindow.getActivePage();
            FileDialog fileDialog = new FileDialog(iWorkbenchWindow.getShell(), 2);
            fileDialog.setFilterNames(new String[]{"*.flt", "All Files (*.*)"});
            fileDialog.setFilterExtensions(new String[]{"*.flt", "*.*"});
            if (fileDialog.open() != null) {
                String string = fileDialog.getFilterPath();
                String[] stringArray = fileDialog.getFileNames();
                int n = 0;
                while (n < stringArray.length) {
                    final String string2 = stringArray[n];
                    final String string3 = String.valueOf(string) + File.separatorChar + stringArray[n];
                    Job job = new Job("Load column file job " + string2){

                        protected IStatus run(IProgressMonitor iProgressMonitor) {
                            iProgressMonitor.beginTask("Please wait while loading file in editor " + string2, -1);
                            if (iProgressMonitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            ColumnEditorAction.this.input = new ColumnFileEditorInput(string3);
                            iProgressMonitor.done();
                            ColumnEditorAction.this.openEditors(ColumnEditorAction.this.input, ColumnEditorAction.this.page);
                            return Status.OK_STATUS;
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                    job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent iJobChangeEvent) {
                            if (iJobChangeEvent.getResult().isOK()) {
                                if (FableIOConsole.console != null) {
                                    FableIOConsole.console.displayOut(String.valueOf(iJobChangeEvent.getJob().getName()) + " completed successfully");
                                }
                            } else if (FableIOConsole.console != null) {
                                FableIOConsole.console.displayOut(String.valueOf(iJobChangeEvent.getJob().getName()) + " did not complete successfully");
                            }
                        }
                    });
                    ++n;
                }
            }
        }
    }

    private void openEditors(final IEditorInput iEditorInput, final IWorkbenchPage iWorkbenchPage) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (iWorkbenchPage != null) {
                    String string = ColumnFileEditor.getId();
                    try {
                        iWorkbenchPage.openEditor(iEditorInput, string, true);
                    }
                    catch (PartInitException partInitException) {
                        FableUtils.errMsg((Object)this, (String)partInitException.getMessage());
                    }
                    String string2 = ColumnFilePlotEditor.getId();
                    try {
                        iWorkbenchPage.openEditor(iEditorInput, string2, true);
                    }
                    catch (PartInitException partInitException) {
                        FableUtils.errMsg((Object)this, (String)partInitException.getMessage());
                    }
                }
            }
        });
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public Display getDisplay() {
        return this.display;
    }
}

