/*
 * Decompiled with CFR 0.152.
 */
package fable.transformation.views;

import fable.framework.toolbox.FileText;
import fable.framework.toolbox.FloatText;
import fable.framework.toolbox.StringText;
import fable.framework.toolbox.ToolBox;
import fable.framework.toolbox.TypedText;
import fable.framework.views.FableMessageConsole;
import fable.python.ColumnFile;
import fable.transformation.Activator;
import fable.transformation.actions.AddUnitCellPeaksAction;
import fable.transformation.actions.ComputeHistProbAction;
import fable.transformation.actions.ComputeTthEtaAction;
import fable.transformation.actions.ComputegveAction;
import fable.transformation.object.Transform;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.part.ViewPart;

public class TransformView
extends ViewPart
implements IPropertyChangeListener {
    public static final String ID = "fable.transformation.views.transformView";
    public static TransformView view;
    String currentFilteredFileName = "";
    Button computettheta;
    Button addUnitCell;
    Button tthHisto;
    Button fit;
    Button btn_savegve;
    Button btn_saveflt;
    FileText fileFilteredPeaks;
    StringText gvectorfilename;
    StringText filteredFiletoSave;
    double[] x;
    double[] y;
    public String currentPath;
    private IMemento memento = null;
    Transform transformer;
    Button editParam;
    Button gvector;
    JLDataView current_dataView = null;
    JLDataView dataViewForUniccells;
    FableMessageConsole console;
    Group grpFit;
    Group grpComputation;
    Button btn_browseFiltered;
    boolean bComputeTTH = false;
    boolean bComputeUnitCell = false;
    boolean bComputeTthHisto = false;
    boolean bComputegVectors = false;
    FloatText tthmin;
    FloatText tthmax;
    private boolean fieldsAreOk = true;
    Job job;
    Job jobTthEta;
    Job jobHisto;
    Job jobUnitcell;
    Job jobGve;
    Job jobFit;
    Display display;
    private final ImageDescriptor saveAsFlt = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"images/saveAsflt.gif");
    private final ImageDescriptor saveAsGvec = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"images/saveAsGve.gif");
    private final ImageDescriptor step1ImgDesc = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"images/step1.gif");
    private final ImageDescriptor step2ImgDesc = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"images/step2.gif");
    private final ImageDescriptor step3ImgDesc = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"images/step3.gif");
    private final ImageDescriptor stepGveImgDesc = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"images/stepGve.gif");
    private final ImageDescriptor stepFit = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"images/fit.gif");
    private Image imagestep1;
    private Image imageStep2;
    private Image imageStep3;
    private Image imageGve;
    private Image imageFit;
    private IAction fitAction;
    private IAction computeTthEtaAction;
    private IAction computeHistProbAction;
    private IAction AddUnitCellPeaksAction;
    private IAction saveGveAction;
    private IAction savefilteredPeaksAction;
    private IAction computeGveAction;

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        this.memento = iMemento;
    }

    public void createPartControl(Composite composite) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 768);
        Composite composite2 = new Composite((Composite)scrolledComposite, 20);
        scrolledComposite.setContent((Control)composite2);
        composite2.setLayout((Layout)new GridLayout(1, false));
        composite2.setLayoutData((Object)new GridData());
        composite2.pack();
        this.display = Display.getCurrent();
        this.makeActions();
        if (FableMessageConsole.console == null) {
            this.console = new FableMessageConsole("Calibration");
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
        } else {
            this.console = FableMessageConsole.console;
        }
        this.console.displayOut("Welcome to transformation " + ToolBox.getPluginVersion((String)"fable.transformation"));
        IOConsoleOutputStream iOConsoleOutputStream = this.console.newOutputStream();
        System.setOut(new PrintStream((OutputStream)iOConsoleOutputStream, true));
        System.setErr(new PrintStream((OutputStream)iOConsoleOutputStream));
        this.transformer = Transform.getTransformer();
        this.transformer.addPropertyChangeListener(this);
        view = this;
        if (this.memento != null) {
            this.currentPath = this.memento.getString("FILTERED_FILE_PATH");
        }
        this.grpComputation = new Group(composite2, 0);
        this.grpComputation.setLayout((Layout)new GridLayout());
        ((GridLayout)this.grpComputation.getLayout()).numColumns = 5;
        this.grpComputation.setLayoutData((Object)new GridData(4, 4, true, false, 1, 2));
        this.grpComputation.setText("");
        this.fileFilteredPeaks = new FileText((Composite)this.grpComputation, 0, "Filtered peaks file");
        this.fileFilteredPeaks.setToolTipText("Load filtered file .flt, output file from Peaksearch");
        this.fileFilteredPeaks.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        this.fileFilteredPeaks.set_isRequiredField(true);
        this.fileFilteredPeaks.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 13 || keyEvent.keyCode == 0x1000050) {
                    TransformView.this.actionOnFilteredFieldChanges();
                }
            }
        });
        this.btn_browseFiltered = new Button((Composite)this.grpComputation, 8);
        this.btn_browseFiltered.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.btn_browseFiltered.setText("Browse...");
        this.btn_browseFiltered.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(((Button)selectionEvent.widget).getParent().getShell(), 64);
                fileDialog.setFilterNames(new String[]{"*.flt", "All Files (*.*)"});
                fileDialog.setFilterExtensions(new String[]{"*.flt", "*.*"});
                fileDialog.setFilterPath(TransformView.this.currentPath);
                String string = fileDialog.open();
                TransformView.this.currentFilteredFileName = fileDialog.getFileName();
                if (string != null) {
                    TransformView.this.fileFilteredPeaks.set_Text(string);
                    TransformView.this.currentPath = fileDialog.getFilterPath();
                    TransformView.this.actionOnFilteredFieldChanges();
                }
            }
        });
        this.computettheta = new Button((Composite)this.grpComputation, 8);
        this.computettheta.setText("Compute tth eta");
        this.computettheta.setToolTipText("Compute tth eta");
        this.imagestep1 = this.step1ImgDesc.createImage();
        this.computettheta.setImage(this.imagestep1);
        this.computettheta.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TransformView.this.jobcompute_tthEta();
            }
        });
        this.computettheta.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (TransformView.this.imagestep1 != null && !TransformView.this.imagestep1.isDisposed()) {
                    TransformView.this.imagestep1.dispose();
                }
            }
        });
        this.computettheta.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        this.addUnitCell = new Button((Composite)this.grpComputation, 8);
        this.addUnitCell.setText("Plot unit cell peaks");
        this.addUnitCell.setToolTipText("Adds unit cell peak and plots them. Computes tth if it has not been done");
        this.imageStep2 = this.step2ImgDesc.createImage();
        this.addUnitCell.setImage(this.imageStep2);
        this.addUnitCell.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TransformView.this.jobAddUnitCell();
            }
        });
        this.addUnitCell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (TransformView.this.imageStep2 != null && !TransformView.this.imageStep2.isDisposed()) {
                    TransformView.this.imageStep2.dispose();
                }
            }
        });
        this.addUnitCell.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        this.gvector = new Button((Composite)this.grpComputation, 8);
        this.gvector.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        this.gvector.setText("Compute gv");
        this.imageGve = this.stepGveImgDesc.createImage();
        this.gvector.setImage(this.imageGve);
        this.gvector.setToolTipText("Computes g-vectors  ; adds unit cell peaks if it has not been done");
        this.gvector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TransformView.this.jobCompute_computeGve();
            }
        });
        this.gvector.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (TransformView.this.imageGve != null && !TransformView.this.imageGve.isDisposed()) {
                    TransformView.this.imageGve.dispose();
                }
            }
        });
        this.tthHisto = new Button((Composite)this.grpComputation, 8);
        this.tthHisto.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        this.tthHisto.setText("Tth histogram");
        this.imageStep3 = this.step3ImgDesc.createImage();
        this.tthHisto.setImage(this.imageStep3);
        this.tthHisto.setToolTipText("Compute the histogram over twotheta for peaks previously read in ");
        this.tthHisto.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TransformView.this.jobCompute_tthHisto();
            }
        });
        this.tthHisto.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (TransformView.this.imageStep3 != null && !TransformView.this.imageStep3.isDisposed()) {
                    TransformView.this.imageStep3.dispose();
                }
            }
        });
        this.grpFit = new Group(composite2, 0);
        this.grpFit.setLayout((Layout)new GridLayout());
        this.grpFit.setToolTipText("Fit between tthmin and tthmax. Enabled if parameters have vary values checked, tth and eta have been computed,  and unit cell have been added to an existing filtered peaks file");
        this.grpFit.setLayoutData((Object)new GridData(4, 4, true, false, 1, 2));
        ((GridLayout)this.grpFit.getLayout()).numColumns = 3;
        this.grpFit.setText("Fit");
        this.tthmin = new FloatText((Composite)this.grpFit, 0, "tth min");
        this.tthmin.set_isRequiredField(true);
        this.tthmin.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.tthmax = new FloatText((Composite)this.grpFit, 0, "tth max");
        this.tthmax.set_isRequiredField(true);
        this.tthmax.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.tthmax.set_Text("180");
        this.tthmin.set_Text("0");
        this.fit = new Button((Composite)this.grpFit, 8);
        this.fit.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.imageFit = this.stepFit.createImage();
        this.fit.setImage(this.imageFit);
        this.fit.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (TransformView.this.imageFit != null && !TransformView.this.imageFit.isDisposed()) {
                    TransformView.this.imageFit.dispose();
                }
            }
        });
        this.fit.setText("Fit");
        this.fit.setToolTipText("Fit between tthmin and tthmax");
        this.fit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TransformView.this.fit();
            }
        });
        Group group = new Group(composite2, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ((GridLayout)group.getLayout()).numColumns = 2;
        ((GridLayout)group.getLayout()).makeColumnsEqualWidth = false;
        group.setText("Save files");
        this.gvectorfilename = new StringText((Composite)group, 0, "G-vectors file name");
        this.gvectorfilename.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        final Image image = this.saveAsGvec.createImage();
        this.btn_savegve = new Button((Composite)group, 8);
        this.btn_savegve.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.btn_savegve.setImage(image);
        this.btn_savegve.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        });
        this.btn_savegve.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TransformView.this.saveGveAs();
            }
        });
        this.filteredFiletoSave = new StringText((Composite)group, 0, "Filtered peaks file name");
        this.filteredFiletoSave.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btn_saveflt = new Button((Composite)group, 8);
        final Image image2 = this.saveAsFlt.createImage();
        this.btn_saveflt.setImage(image2);
        this.btn_saveflt.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (image2 != null && !image2.isDisposed()) {
                    image2.dispose();
                }
            }
        });
        this.btn_saveflt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TransformView.this.saveAsFilteredPeaksFile();
            }
        });
        String string = this.transformer.getColumnfile().getFileName();
        if (string != null && !string.equals("")) {
            this.fileFilteredPeaks.set_Text(string);
            this.actionOnFilteredFieldChanges();
        }
        scrolledComposite.setMinHeight(this.display.getPrimaryMonitor().getBounds().height);
        scrolledComposite.setMinWidth(this.display.getPrimaryMonitor().getBounds().width);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setMinSize(composite2.computeSize(-1, -1));
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.ComputeTthEtaAction", (IAction)new ComputeTthEtaAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.AddUnitCellPeaksAction", (IAction)new AddUnitCellPeaksAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.ComputeHistProbAction", (IAction)new ComputeHistProbAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.ComputegveAction", (IAction)new ComputegveAction());
    }

    private void makeActions() {
        this.fitAction = new Action(){

            public void run() {
                TransformView.this.fit();
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.fitAction", this.fitAction);
        this.fitAction.setId("fable.transformation.actions.fitAction");
        this.computeTthEtaAction = new Action(){

            public void run() {
                TransformView.this.jobcompute_tthEta();
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.ComputeTthEtaAction", this.computeTthEtaAction);
        this.computeTthEtaAction.setId("fable.transformation.actions.ComputeTthEtaAction");
        this.computeHistProbAction = new Action(){

            public void run() {
                TransformView.this.jobCompute_tthHisto();
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.computeHistProbAction", this.computeHistProbAction);
        this.computeHistProbAction.setId("fable.transformation.actions.ComputeHistProbAction");
        this.AddUnitCellPeaksAction = new Action(){

            public void run() {
                TransformView.this.jobAddUnitCell();
            }
        };
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.AddUnitCellPeaksAction", this.AddUnitCellPeaksAction);
        this.AddUnitCellPeaksAction.setId("fable.transformation.actions.AddUnitCellPeaksAction");
        this.saveGveAction = new Action(){

            public void run() {
                TransformView.this.saveGveAs();
            }
        };
        this.saveGveAction.setId("fable.transformation.actions.saveGve");
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.saveGve", this.saveGveAction);
        this.savefilteredPeaksAction = new Action(){

            public void run() {
                TransformView.this.saveAsFilteredPeaksFile();
            }
        };
        this.savefilteredPeaksAction.setId("fable.transformation.actions.savefilteredPeaksAction");
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.savefilteredPeaksAction", this.savefilteredPeaksAction);
        this.computeGveAction = new Action(){

            public void run() {
                TransformView.this.jobCompute_computeGve();
            }
        };
        this.computeGveAction.setId("fable.transformation.actions.ComputegveAction");
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.ComputegveAction", this.computeGveAction);
    }

    private boolean isFittingIsEnabled() {
        return this.bComputeTTH && this.bComputeUnitCell && !this.fileFilteredPeaks.equals("") && this.fileFilteredPeaks.is_bValide() && this.transformer.getvaryList() > 0;
    }

    private void resetAllButtonsPressed() {
        this.bComputeTTH = false;
        this.bComputeTthHisto = false;
        this.bComputegVectors = false;
        this.bComputeUnitCell = false;
    }

    private void actionOnFilteredFieldChanges() {
        String string = this.fileFilteredPeaks.getText();
        int n = string.lastIndexOf(System.getProperty("file.separator"));
        this.currentFilteredFileName = n + 1 < string.length() ? string.substring(n + 1) : string;
        this.currentPath = n >= 0 && n < string.length() && n > 0 ? string.substring(0, n) : "";
        this.resetAllButtonsPressed();
        this.loadfilteredPeaks();
        this.updateFields();
    }

    public void jobcompute_tthEta() {
        if (this.jobTthEta == null) {
            this.jobTthEta = new Job("Compute tth, eta"){

                protected IStatus run(final IProgressMonitor iProgressMonitor) {
                    if (TransformView.this.fieldsAreOk) {
                        iProgressMonitor.beginTask("Compute tth, eta", -1);
                        TransformView.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).TransformView.this.fileFilteredPeaks.is_bValide()) {
                                    iProgressMonitor.subTask("Compute tth, eta");
                                    if (!(this).TransformView.this.transformer.compute_tth_eta()) {
                                        iProgressMonitor.setCanceled(true);
                                    } else {
                                        (this).TransformView.this.console.displayOut("Compute tth, eta done");
                                    }
                                }
                            }
                        });
                    } else {
                        TransformView.this.fileFilteredPeaks.showDecoration();
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        this.jobTthEta.setUser(true);
        this.bComputeTTH = true;
        this.jobTthEta.schedule();
    }

    public void jobAddUnitCell() {
        if (this.jobUnitcell == null) {
            this.jobUnitcell = new Job("Add unit cell peak"){

                protected IStatus run(final IProgressMonitor iProgressMonitor) {
                    if (TransformView.this.fieldsAreOk) {
                        iProgressMonitor.beginTask("Add unit cell peak", -1);
                        TransformView.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).TransformView.this.fileFilteredPeaks.is_bValide()) {
                                    iProgressMonitor.subTask("Add unit cell peak");
                                    if (!(this).TransformView.this.transformer.addUnitCellPeaks()) {
                                        iProgressMonitor.setCanceled(true);
                                    } else {
                                        (this).TransformView.this.console.displayOut("Adding unit cell peak done");
                                    }
                                }
                            }
                        });
                    } else {
                        TransformView.this.fileFilteredPeaks.showDecoration();
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        this.jobUnitcell.setUser(true);
        this.bComputeUnitCell = true;
        this.jobUnitcell.schedule();
    }

    public void jobCompute_tthHisto() {
        if (this.jobHisto == null) {
            this.jobHisto = new Job("Compute tth histogram"){

                protected IStatus run(final IProgressMonitor iProgressMonitor) {
                    if (TransformView.this.fieldsAreOk) {
                        iProgressMonitor.beginTask("Compute tth histogram", -1);
                        TransformView.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                iProgressMonitor.subTask("Compute tth histogram");
                                if (!(this).TransformView.this.transformer.compute_tth_histo()) {
                                    iProgressMonitor.setCanceled(true);
                                } else {
                                    (this).TransformView.this.console.displayOut("Computing tth histogram done");
                                }
                            }
                        });
                    } else {
                        TransformView.this.fileFilteredPeaks.showDecoration();
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        this.jobHisto.setUser(true);
        this.bComputeTthHisto = true;
        this.jobHisto.schedule();
    }

    public void jobCompute_computeGve() {
        if (this.jobGve == null) {
            this.jobGve = new Job("Compute g-vectors"){

                protected IStatus run(final IProgressMonitor iProgressMonitor) {
                    if (TransformView.this.fieldsAreOk) {
                        iProgressMonitor.beginTask("Compute g-vectors", -1);
                        TransformView.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                iProgressMonitor.subTask("Compute g-vectors");
                                if (!(this).TransformView.this.transformer.computegv()) {
                                    iProgressMonitor.setCanceled(true);
                                } else {
                                    (this).TransformView.this.console.displayOut("Computing g-vectors done");
                                }
                            }
                        });
                    } else {
                        TransformView.this.fileFilteredPeaks.showDecoration();
                    }
                    iProgressMonitor.done();
                    return Status.OK_STATUS;
                }
            };
        }
        this.jobGve.setUser(true);
        this.bComputegVectors = true;
        this.jobGve.schedule();
    }

    public void fit() {
        if (this.jobFit == null) {
            this.jobFit = new Job("Fit"){

                protected IStatus run(IProgressMonitor iProgressMonitor) {
                    if (TransformView.this.fieldsAreOk) {
                        iProgressMonitor.beginTask("Wait while transformer is fitting", -1);
                        TransformView.this.display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if ((this).TransformView.this.tthmin.is_bValide() && (this).TransformView.this.tthmax.is_bValide()) {
                                    if (Float.valueOf((this).TransformView.this.tthmin.getText()).floatValue() < Float.valueOf((this).TransformView.this.tthmax.getText()).floatValue()) {
                                        if ((this).TransformView.this.transformer.fit(Float.valueOf((this).TransformView.this.tthmin.getText()).floatValue(), Float.valueOf((this).TransformView.this.tthmax.getText()).floatValue())) {
                                            (this).TransformView.this.console.displayOut("Fit done");
                                        } else {
                                            (this).TransformView.this.console.displayIn("Fit not done");
                                        }
                                    } else {
                                        (this).TransformView.this.console.displayIn("Tth max should be greater than tth min ");
                                        (this).TransformView.this.tthmin.set_bValide(false);
                                        (this).TransformView.this.tthmax.set_bValide(false);
                                    }
                                } else {
                                    (this).TransformView.this.tthmin.showDecoration();
                                    (this).TransformView.this.tthmax.showDecoration();
                                }
                            }
                        });
                    } else {
                        TransformView.this.fileFilteredPeaks.showDecoration();
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        this.jobFit.setUser(true);
        this.jobFit.schedule();
    }

    private void createJob() {
        this.job = new Job("Compute values for calibration"){

            protected IStatus run(final IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask("Compute selected options again", 100);
                if (iProgressMonitor.isCanceled()) {
                    iProgressMonitor.done();
                    return Status.CANCEL_STATUS;
                }
                TransformView.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).TransformView.this.fileFilteredPeaks.getText().equals("")) {
                            (this).TransformView.this.fileFilteredPeaks.showDecoration();
                            TransformView.this.fieldsAreOk = false;
                        }
                    }
                });
                iProgressMonitor.worked(5);
                if (iProgressMonitor.isCanceled()) {
                    iProgressMonitor.done();
                    return Status.CANCEL_STATUS;
                }
                if (TransformView.this.fieldsAreOk) {
                    TransformView.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).TransformView.this.fileFilteredPeaks.is_bValide()) {
                                if ((this).TransformView.this.bComputeTTH) {
                                    iProgressMonitor.subTask("Compute tth, eta");
                                    if (!(this).TransformView.this.transformer.compute_tth_eta()) {
                                        iProgressMonitor.setCanceled(true);
                                    } else if ((this).TransformView.this.console != null) {
                                        (this).TransformView.this.console.displayOut("Tth and eta have been computed again with new parameters");
                                    }
                                }
                            } else {
                                (this).TransformView.this.fileFilteredPeaks.showDecoration();
                            }
                        }
                    });
                    iProgressMonitor.worked(20);
                    if (iProgressMonitor.isCanceled()) {
                        iProgressMonitor.done();
                        return Status.CANCEL_STATUS;
                    }
                    TransformView.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).TransformView.this.fileFilteredPeaks.is_bValide()) {
                                if ((this).TransformView.this.bComputeUnitCell) {
                                    iProgressMonitor.subTask("Add unit cell peak");
                                    if (!(this).TransformView.this.transformer.addUnitCellPeaks()) {
                                        iProgressMonitor.setCanceled(true);
                                    } else if ((this).TransformView.this.console != null) {
                                        (this).TransformView.this.console.displayOut("Unit cell peaks have been computed again");
                                    }
                                }
                            } else {
                                (this).TransformView.this.fileFilteredPeaks.showDecoration();
                            }
                        }
                    });
                    iProgressMonitor.worked(25);
                    if (iProgressMonitor.isCanceled()) {
                        iProgressMonitor.done();
                        return Status.CANCEL_STATUS;
                    }
                    TransformView.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).TransformView.this.fileFilteredPeaks.is_bValide()) {
                                if ((this).TransformView.this.bComputegVectors) {
                                    iProgressMonitor.subTask("Compute g-vectors");
                                    if (!(this).TransformView.this.transformer.computegv()) {
                                        iProgressMonitor.setCanceled(true);
                                    } else if ((this).TransformView.this.console != null) {
                                        (this).TransformView.this.console.displayOut("G-vectors have been computed again");
                                    }
                                }
                            } else {
                                (this).TransformView.this.fileFilteredPeaks.showDecoration();
                            }
                        }
                    });
                    iProgressMonitor.worked(25);
                    if (iProgressMonitor.isCanceled()) {
                        iProgressMonitor.done();
                        return Status.CANCEL_STATUS;
                    }
                    TransformView.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).TransformView.this.fileFilteredPeaks.is_bValide()) {
                                if ((this).TransformView.this.bComputeTthHisto) {
                                    iProgressMonitor.subTask("Compute tth histogram");
                                    if (!(this).TransformView.this.transformer.compute_tth_histo()) {
                                        iProgressMonitor.setCanceled(true);
                                    } else if ((this).TransformView.this.console != null) {
                                        (this).TransformView.this.console.displayOut("Tth histogram has been computed again");
                                    }
                                } else {
                                    (this).TransformView.this.fileFilteredPeaks.showDecoration();
                                }
                            }
                        }
                    });
                }
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }
        };
        this.job.setUser(true);
    }

    private void compute() {
        if (this.job == null) {
            this.createJob();
        }
        this.job.schedule();
    }

    private void updateFields() {
        if (this.fileFilteredPeaks.is_bValide() && this.fileFilteredPeaks.getText().length() > 0) {
            int n;
            int n2 = n = this.fileFilteredPeaks.getText().lastIndexOf(".flt") > -1 ? this.fileFilteredPeaks.getText().lastIndexOf(".flt") : this.fileFilteredPeaks.getText().lastIndexOf(".");
            if (n > 0) {
                String string = String.valueOf(this.fileFilteredPeaks.getText().substring(0, n)) + ".gve";
                this.gvectorfilename.set_Text(string);
            } else if (!this.fileFilteredPeaks.getText().trim().equals("")) {
                this.gvectorfilename.set_Text(String.valueOf(this.fileFilteredPeaks.getText()) + ".gve");
            }
            this.filteredFiletoSave.set_Text(this.fileFilteredPeaks.getText());
        } else {
            this.gvectorfilename.set_Text("");
            this.filteredFiletoSave.set_Text("");
        }
        this.fileFilteredPeaks.getTextField().setFocus();
    }

    public void setFocus() {
    }

    public void saveState(IMemento iMemento) {
        super.saveState(iMemento);
        iMemento.putString("FILTERED_FILE_PATH", this.currentPath);
    }

    private void loadfilteredPeaks() {
        new Job("Wait while loading filtered peaks file : " + this.fileFilteredPeaks.getText()){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        int n = (this).TransformView.this.fileFilteredPeaks.getText().lastIndexOf(System.getProperty("file.separator")) > -1 ? (this).TransformView.this.fileFilteredPeaks.getText().lastIndexOf(System.getProperty("file.separator")) : 0;
                        (this).TransformView.this.currentPath = (this).TransformView.this.fileFilteredPeaks.getText().substring(n);
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.framework.ui.views.ColumnFilePlotView");
                        }
                        catch (PartInitException partInitException) {
                            (this).TransformView.this.console.displayOut("Plot view not found");
                        }
                        if ((this).TransformView.this.fileFilteredPeaks.is_bValide() && !(this).TransformView.this.fileFilteredPeaks.getText().equals("")) {
                            if (!(this).TransformView.this.transformer.loadFiltered((this).TransformView.this.fileFilteredPeaks.getText())) {
                                if ((this).TransformView.this.console != null) {
                                    (this).TransformView.this.console.displayIn("Filtered peaks file has not been loaded");
                                    (this).TransformView.this.fileFilteredPeaks.set_bValide(false);
                                }
                            } else {
                                (this).TransformView.this.fileFilteredPeaks.set_bValide(true);
                            }
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void dispose() {
        this.transformer.removePropertyChangeListener(this);
    }

    public void loadfilteredPeaks(String string) {
        this.fileFilteredPeaks.set_Text(string);
        this.updateFields();
        this.loadfilteredPeaks();
    }

    private void enableGroup(Composite composite, boolean bl) {
        Control[] controlArray = composite.getChildren() != null ? composite.getChildren() : null;
        int n = 0;
        while (controlArray != null && n < controlArray.length) {
            if (controlArray[n] instanceof TypedText || controlArray[n] instanceof Button || controlArray[n] instanceof Text) {
                controlArray[n].setEnabled(bl);
            } else if (controlArray[n] instanceof Composite) {
                this.enableGroup((Composite)controlArray[n], bl);
            }
            ++n;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("refresh")) {
            this.console.displayOut("Parameters have been updated. ");
            if (!this.fileFilteredPeaks.getText().equals("")) {
                this.compute();
            }
        } else if (propertyChangeEvent.getProperty().equals("currentProjectPath")) {
            this.currentPath = (String)propertyChangeEvent.getNewValue();
        } else if (propertyChangeEvent.getProperty().equals("varyList")) {
            if ((Integer)propertyChangeEvent.getNewValue() > 0) {
                this.grpFit.setToolTipText("Fit with variable parameters checked");
            } else {
                this.grpFit.setToolTipText("Please, check at least one variable parameter before fitting");
            }
        } else if (propertyChangeEvent.getProperty().equals("updateFields")) {
            String string;
            System.out.println("Transformer has a new column file. We are going to update fields");
            ColumnFile columnFile = this.transformer.getColumnfile();
            if (columnFile != null && (string = columnFile.getFullFileName()) != null && string.length() > 0) {
                this.fileFilteredPeaks.set_Text(string);
                this.resetAllButtonsPressed();
                this.updateFields();
            }
        }
    }

    public void saveGveAs() {
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        String[] stringArray = new String[]{"*.gve", "*.*"};
        String[] stringArray2 = new String[]{"gve files (*.gve)", "All Files (*.*)"};
        fileDialog.setFilterExtensions(stringArray);
        fileDialog.setFilterNames(stringArray2);
        fileDialog.setFileName(this.gvectorfilename.getText());
        fileDialog.setFilterPath(this.gvectorfilename.getText().equals("") ? this.currentPath : this.gvectorfilename.getText());
        fileDialog.setText("Save gve file as...");
        String string = fileDialog.open();
        if (string != null) {
            string = String.valueOf(fileDialog.getFilterPath()) + System.getProperty("file.separator") + fileDialog.getFileName();
            this.gvectorfilename.set_Text(string);
            if (this.transformer.savegv(string)) {
                if (FableMessageConsole.console != null) {
                    this.console.displayOut("G-vectors have been saved in " + string);
                }
            } else if (FableMessageConsole.console != null) {
                this.console.displayIn("An error occured ; G-vectors in " + string + " have not been saved.");
            }
        }
    }

    public void saveAsFilteredPeaksFile() {
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        String[] stringArray = new String[]{"*.flt", "*.*"};
        String[] stringArray2 = new String[]{"flt files (*.flt)", "All Files (*.*)"};
        fileDialog.setFilterExtensions(stringArray);
        fileDialog.setFilterNames(stringArray2);
        fileDialog.setFileName(this.filteredFiletoSave.getText());
        fileDialog.setFilterPath(this.filteredFiletoSave.getText().equals("") ? this.currentPath : this.filteredFiletoSave.getText());
        fileDialog.setText("Save flt file as...");
        String string = fileDialog.open();
        if (string != null) {
            string = String.valueOf(fileDialog.getFilterPath()) + System.getProperty("file.separator") + fileDialog.getFileName();
            this.filteredFiletoSave.set_Text(string);
            if (this.transformer.saveFilteredPeaks(string)) {
                if (FableMessageConsole.console != null) {
                    this.console.displayOut("Selected filtered peaks have been saved in " + string);
                }
            } else if (FableMessageConsole.console != null) {
                this.console.displayIn("An error occured ; filtered peaks in " + string + " have not been saved.");
            }
        }
    }
}

