/*
 * Decompiled with CFR 0.152.
 */
package fable.transformation.views;

import fable.transformation.Activator;
import fable.transformation.actions.AddUnitCellPeaksAction;
import fable.transformation.actions.ComputeHistProbAction;
import fable.transformation.actions.ComputeTthEtaAction;
import fable.transformation.actions.ComputegveAction;
import fable.transformation.actions.OpenParameterFile;
import fable.transformation.actions.SaveFltAction;
import fable.transformation.actions.SaveGveAction;
import fable.transformation.actions.fitAction;
import fable.transformation.object.Transform;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class ParamView
extends ViewPart
implements IPropertyChangeListener,
ISaveablePart {
    public static final String ID = "fable.transformation.views.paramview";
    Transform transform;
    private IMemento memento = null;
    public String currentPathParam;
    private Composite mainComposite;
    private IPropertyChangeListener preferencesListener;
    private Action saveAction;
    private Action applyParameters;
    private Action restoreValues;
    private ImageDescriptor apply_imageDescr = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"./images/check.gif");
    private ImageDescriptor save_imageDescr = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"./images/saveoptions.gif");
    private ImageDescriptor revert_imageDescr = Activator.imageDescriptorFromPlugin((String)"fable.transformation", (String)"./images/undo.gif");
    protected boolean dirty = false;
    private OpenParameterFile openParameters;

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        super.init(iViewSite, iMemento);
        this.memento = iMemento;
    }

    public void saveState(IMemento iMemento) {
        super.saveState(iMemento);
        iMemento.putString("PARS_FILE_PATH", this.currentPathParam);
    }

    public void createPartControl(Composite composite) {
        GridData gridData;
        this.preferencesListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("pref_parameters_file")) {
                    ParamView.this.loadfileParameter(Activator.getDefault().getPreferenceStore().getString("pref_parameters_file"));
                }
            }
        };
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferencesListener);
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 512);
        this.mainComposite = new Composite((Composite)scrolledComposite, 20);
        this.mainComposite.setLayout((Layout)new GridLayout(3, false));
        this.transform = Transform.getTransformer();
        this.transform.editParameters();
        this.transform.addPropertyChangeListener(this);
        if (this.memento != null) {
            this.currentPathParam = this.memento.getString("PARS_FILE_PATH");
        }
        if (this.transform.getpars() != null) {
            gridData = new TreeMap(this.transform.getpars());
            Set set = gridData.entrySet();
            Iterator iterator = set.iterator();
            int n = 30;
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                Label label = new Label(this.mainComposite, 0);
                String string2 = this.transform.getparsHelp().get((String)entry.getKey());
                label.setToolTipText(string2);
                label.setText((String)entry.getKey());
                Text text = new Text(this.mainComposite, 2048);
                GridData gridData2 = new GridData(16, 0x1000000, false, false);
                gridData2.widthHint = n * 6;
                text.setLayoutData((Object)gridData2);
                text.setData((Object)string);
                text.setData(string, entry.getValue());
                text.setData("restore", entry.getValue());
                text.setText(entry.getValue().toString());
                text.setToolTipText(string2);
                text.addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent keyEvent) {
                    }

                    public void keyReleased(KeyEvent keyEvent) {
                        ParamView.this.firePropertyChange(257);
                    }
                });
                if (this.transform.getPossVary().get(string) != null) {
                    Button button = new Button(this.mainComposite, 32);
                    button.setToolTipText("Possible vary for : " + string);
                    button.setSelection(this.transform.getPossVary().get(string).booleanValue());
                    button.setData((Object)((String)entry.getKey()));
                    button.setData("restore", (Object)this.transform.getPossVary().get(string));
                    button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                    continue;
                }
                new Label(this.mainComposite, 0);
            }
        }
        gridData = new GridData(4, 4, false, true);
        gridData.horizontalSpan = 3;
        scrolledComposite.setContent((Control)this.mainComposite);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setMinSize(this.mainComposite.computeSize(0, -1));
        this.makeActions();
        this.contributeToActionBars();
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.ComputeTthEtaAction", (IAction)new ComputeTthEtaAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.AddUnitCellPeaksAction", (IAction)new AddUnitCellPeaksAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.ComputeHistProbAction", (IAction)new ComputeHistProbAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.ComputegveAction", (IAction)new ComputegveAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.fitAction", (IAction)new fitAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.saveGve", (IAction)new SaveGveAction());
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.transformation.actions.savefilteredPeaksAction", (IAction)new SaveFltAction());
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.openParameters);
        iMenuManager.add((IAction)this.saveAction);
        iMenuManager.add((IAction)this.applyParameters);
        iMenuManager.add((IAction)this.restoreValues);
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.openParameters);
        iToolBarManager.add((IAction)this.applyParameters);
        iToolBarManager.add((IAction)this.saveAction);
        iToolBarManager.add((IAction)this.restoreValues);
    }

    private void makeActions() {
        this.openParameters = new OpenParameterFile();
        this.saveAction = new Action(){

            public void run() {
                ParamView.this.saveParameters();
            }
        };
        this.applyParameters = new Action(){

            public void run() {
                ParamView.this.applyParameters();
            }
        };
        this.saveAction.setText("Save parameters");
        this.saveAction.setToolTipText("Save parameters in a file (*.par, *.pars, *.prm)");
        this.saveAction.setImageDescriptor(this.save_imageDescr);
        this.applyParameters.setText("Apply parameters");
        this.applyParameters.setToolTipText("Apply parameters and compute again.  \nNew parameters are not saved in the file automatically.");
        this.applyParameters.setImageDescriptor(this.apply_imageDescr);
        this.restoreValues = new Action(){

            public void run() {
                ParamView.this.restoreValues();
            }
        };
        this.restoreValues.setText("Restore values ");
        this.restoreValues.setToolTipText("Restore last applied values ");
        this.restoreValues.setImageDescriptor(this.revert_imageDescr);
    }

    private void loadfileParameter(String string) {
        this.setPartName(string);
        this.transform.loadFileParameters(string);
        this.transform.editParameters();
    }

    public void setFocus() {
    }

    public boolean applyParameters() {
        boolean bl = false;
        Vector<String> vector = new Vector<String>(1);
        Control[] controlArray = this.mainComposite.getChildren();
        if (Transform.getTransformer().getpars() != null) {
            HashMap<String, Object> hashMap = this.transform.getpars();
            int n = 0;
            while (n < controlArray.length) {
                Text text;
                if (controlArray[n] instanceof Text) {
                    text = (Text)controlArray[n];
                    if (text.getData() != null) {
                        hashMap.put((String)text.getData(), new String(text.getText()));
                    }
                } else if (controlArray[n] instanceof Button && (text = (Button)controlArray[n]).getData() != null && text.getSelection()) {
                    vector.add((String)text.getData());
                }
                ++n;
            }
            bl = Transform.getTransformer().set_parameters(vector.toArray(), hashMap);
        }
        return bl;
    }

    private void restoreValues() {
        Control[] controlArray = this.mainComposite.getChildren();
        boolean bl = false;
        if (Transform.getTransformer().getpars() != null) {
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>(this.transform.getpars());
            Set set = treeMap.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                bl = false;
                Map.Entry entry = iterator.next();
                int n = 0;
                while (!bl && n < controlArray.length) {
                    Text text;
                    if (controlArray[n] instanceof Text) {
                        text = (Text)controlArray[n];
                        if (text.getData((String)entry.getKey()) != null) {
                            bl = true;
                            text.setText(text.getData("restore").toString());
                        }
                    } else if (controlArray[n] instanceof Button && ((text = (Button)controlArray[n]).getStyle() & 0x20) == 32) {
                        text.setSelection(((Boolean)text.getData("restore")).booleanValue());
                    }
                    ++n;
                }
            }
        }
    }

    private void updateFields() {
        if (!this.mainComposite.isDisposed()) {
            Control[] controlArray = this.mainComposite.getChildren();
            boolean bl = false;
            if (Transform.getTransformer().getpars() != null) {
                TreeMap<String, Object> treeMap = new TreeMap<String, Object>(this.transform.getpars());
                Set set = treeMap.entrySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    bl = false;
                    Map.Entry entry = iterator.next();
                    int n = 0;
                    while (!bl && n < controlArray.length) {
                        String string;
                        Text text;
                        if (controlArray[n] instanceof Text && (text = (Text)controlArray[n]).getData(string = (String)entry.getKey()) != null) {
                            bl = true;
                            text.setData((Object)string);
                            text.setData(string, entry.getValue());
                            text.setData("restore", entry.getValue());
                            text.setText(entry.getValue().toString());
                        }
                        ++n;
                    }
                }
            }
        }
    }

    public void saveParameters() {
        if (this.applyParameters()) {
            FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
            String[] stringArray = new String[]{"*.par", "*.*"};
            String[] stringArray2 = new String[]{"parameter files (*.par)", "All Files (*.*)"};
            fileDialog.setFilterExtensions(stringArray);
            fileDialog.setFilterNames(stringArray2);
            fileDialog.setText("Save parameters in an existing ini file or enter a new file name");
            String string = fileDialog.open();
            if (string != null) {
                string = String.valueOf(fileDialog.getFilterPath()) + System.getProperty("file.separator") + fileDialog.getFileName();
                Transform.getTransformer().saveParameters(string);
                this.setPartName(string);
            }
        } else {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Save parameters error", (String)"Fable transform application couldn't get values in field and/or update transform.py");
        }
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        this.saveParameters();
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
        this.saveParameters();
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public void dispose() {
        this.transform.removePropertyChangeListener(this);
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferencesListener);
    }

    public void removePropertyListener(IPropertyListener iPropertyListener) {
        super.removePropertyListener(iPropertyListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("refresh")) {
            this.updateFields();
            this.setPartName(this.transform.getParamFileName());
        } else if (propertyChangeEvent.getProperty().equals("currentProjectPath")) {
            this.currentPathParam = (String)propertyChangeEvent.getNewValue();
        }
    }
}

