/*
 * Decompiled with CFR 0.152.
 */
package fable.transformation.object;

import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.ToolBox;
import fable.framework.ui.views.ColumnFilePlotView;
import fable.python.ColumnFile;
import fable.python.jep.FableJep;
import fable.python.jep.JavaToJepTools;
import fable.python.jep.StdoutRead;
import fable.transformation.Activator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import jep.Jep;
import jep.JepException;
import org.apache.log4j.Logger;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class Transform {
    Logger logger;
    float[] tth;
    float[] tthteory;
    private String fileteredFile;
    private String parametersFile;
    private String[] keys;
    private String[] filteredfilecoltitles;
    private String currentProjectPath;
    private HashMap<String, Boolean> possvary;
    private HashMap<String, Object> pars = new HashMap();
    private HashMap<String, String> pars_help = new HashMap();
    private HashMap<String, double[]> filtered = new HashMap();
    private Vector<String> vars;
    private FableJep fableJep;
    private static Transform transform = null;
    private ArrayList<IPropertyChangeListener> listeners = new ArrayList();
    private ColumnFile columns;
    public StdoutRead stdout;
    private int nVaryList;
    private File stdout_filename;

    public static Transform getTransformer() {
        if (transform == null) {
            transform = new Transform();
        }
        return transform;
    }

    private Transform() {
        this.logger = Logger.getLogger(Transform.class);
        try {
            this.fableJep = FableJep.getFableJep();
            FableJep.jepImportSpecificDefinition((Jep)this.fableJep.getJep(), (String)"ImageD11", (String)"transformer");
            FableJep.jepImportModules((Jep)this.fableJep.getJep(), (String)"numpy");
            this.fableJep.eval("t=transformer.transformer()");
            try {
                this.stdout_filename = File.createTempFile("transformer", ".stdout");
                this.stdout_filename.deleteOnExit();
                this.logger.debug((Object)("tempFile = " + this.stdout_filename.getAbsolutePath()));
                this.fableJep.redirectStdout(this.stdout_filename.getAbsolutePath());
            }
            catch (IOException iOException) {
                FableUtils.excMsg((Object)this, (String)"Unable to start reading transformer output", (Throwable)iOException);
            }
            String string = Activator.getDefault().getPreferenceStore().getString("pref_parameters_file");
            if (string != null) {
                if (ToolBox.checkIfFileExists((String)string)) {
                    this.loadFileParameters(string);
                } else {
                    this.logger.debug((Object)("Parameter file " + string + " set in calibration preferences not found."));
                }
            }
            this.nVaryList = (Integer)this.fableJep.getValue("len(t.parameterobj.varylist)");
            this.columns = new ColumnFile();
            if (this.columns.getFileName() != null) {
                this.loadFiltered(this.columns.getFileName());
            }
        }
        catch (JepException jepException) {
            FableUtils.excMsg((Object)this, (String)"Cannot create Jep", (Throwable)jepException);
        }
    }

    public void loadFileParameters(String string) {
        this.parametersFile = string;
        try {
            this.fableJep.set("filename", this.parametersFile);
            this.fableJep.eval("t.loadfileparameters(filename)");
            int n = this.parametersFile.lastIndexOf(System.getProperty("file.separator"));
            this.currentProjectPath = n > 0 ? this.parametersFile.substring(0, n) : this.parametersFile;
            this.fireCurrentProjectPath();
        }
        catch (JepException jepException) {
            FableUtils.excMsg((Object)this, (String)("Error loading file parameters for " + this.parametersFile), (Throwable)jepException);
        }
    }

    public void editParameters() {
        try {
            String string;
            this.fableJep.eval("t.updateparameters()");
            this.fableJep.eval("pars=t.pars");
            this.fableJep.eval("vars=t.getvars()");
            this.fableJep.eval("possvars=t.get_variable_list()");
            this.fableJep.eval("print possvars");
            this.fableJep.eval("keys = pars.keys()");
            this.fableJep.eval("vals = pars.values()");
            this.fableJep.eval("res = len(keys)");
            int n = (Integer)this.fableJep.getValue("res");
            this.keys = new String[n];
            int n2 = 0;
            while (n2 < n) {
                this.fableJep.set("i", n2);
                Object object = this.fableJep.getValue("vals[i]");
                string = (String)this.fableJep.getValue("keys[i]");
                this.pars.put(string, object);
                this.fableJep.set("parname", string);
                this.pars_help.put(string, (String)this.fableJep.getValue("t.parameterobj.par_objs[parname].helpstring"));
                this.keys[n2] = string;
                ++n2;
            }
            n2 = (Integer)this.fableJep.getValue("len(vars)");
            this.vars = new Vector();
            int n3 = 0;
            while (n3 < n2) {
                this.fableJep.set("i", n3);
                string = (String)this.fableJep.getValue("vars[i]");
                this.vars.add(string);
                ++n3;
            }
            n3 = (Integer)this.fableJep.getValue("len(possvars)");
            this.possvary = new HashMap();
            int n4 = 0;
            while (n4 < n3) {
                this.fableJep.set("i", n4);
                String string2 = (String)this.fableJep.getValue("possvars[i]");
                Boolean bl = new Boolean(this.vars.contains(string2));
                this.possvary.put(string2, bl);
                ++n4;
            }
            this.nVaryList = this.vars.size();
        }
        catch (JepException jepException) {
            FableUtils.excMsg((Object)this, (String)"Cannot update parameters", (Throwable)jepException);
        }
        this.fireEditParameters();
    }

    public HashMap<String, String> getparsHelp() {
        return this.pars_help;
    }

    public HashMap<String, Object> getpars() {
        return this.pars;
    }

    public HashMap<String, Boolean> getPossVary() {
        return this.possvary;
    }

    public String[] get_filteredfilecoltitles() {
        return this.filteredfilecoltitles;
    }

    public void setColumnObject() {
        boolean bl = true;
        try {
            this.fableJep.eval("column_object=t.colfile");
            if (this.columns == null) {
                this.columns = new ColumnFile();
                bl = false;
            }
            this.columns.setPythonObject(this.fableJep);
            ColumnFilePlotView.view.setColumnFile(this.columns);
            String string = (String)this.fableJep.getValue("column_object.filename");
            this.columns.setFileName(string);
            this.columns.loadRows();
            if (bl) {
                this.columns.fireRemoveAll();
            }
            this.columns.fireAddColumnFile();
        }
        catch (JepException jepException) {
            FableUtils.excMsg((Object)this, (String)"Cannot set column_object for TransformerError", (Throwable)jepException);
        }
    }

    public boolean compute_tth_eta() {
        boolean bl = true;
        if (this.fileteredFile != null && !this.fileteredFile.equals("")) {
            try {
                this.filtered = new HashMap();
                this.fableJep.eval("t.compute_tth_eta()");
                int n = (Integer)this.fableJep.getValue("len(t.colfile.tth)");
                this.tth = new float[n];
                this.tth = this.fableJep.getValue_floatarray("t.colfile.tth.astype(numpy.float32).tostring()");
                this.columns.loadRows();
                this.columns.update();
                String[] stringArray = new String[]{"tth", "eta"};
                this.columns.displayComputedData(stringArray);
            }
            catch (JepException jepException) {
                bl = false;
                FableUtils.excMsg((Object)this, (String)"Cannot create compute_tth_eta", (Throwable)jepException);
            }
        }
        return bl;
    }

    public HashMap<String, double[]> getColumnstoPlot() {
        try {
            int n = (Integer)this.fableJep.getValue("t.colfile.ncols");
            if (this.filteredfilecoltitles == null) {
                this.filteredfilecoltitles = new String[n];
            } else if (this.filteredfilecoltitles.length != n) {
                this.filteredfilecoltitles = new String[n];
            }
            int n2 = 0;
            while (n2 < n) {
                this.fableJep.set("i", n2);
                this.filteredfilecoltitles[n2] = (String)this.fableJep.getValue("t.getcols()[i]");
                this.fableJep.set("name", this.filteredfilecoltitles[n2]);
                this.fableJep.eval("filteredValues=t.getcolumn(name)");
                float[] fArray = this.fableJep.getValue_floatarray("filteredValues.astype(numpy.float32).tostring()");
                double[] dArray = new double[fArray.length];
                int n3 = 0;
                while (n3 < fArray.length) {
                    dArray[n3] = fArray[n3];
                    ++n3;
                }
                this.filtered.put(this.filteredfilecoltitles[n2], dArray);
                ++n2;
            }
        }
        catch (JepException jepException) {
            FableUtils.excMsg((Object)this, (String)"Problem plotting", (Throwable)jepException);
        }
        return this.filtered;
    }

    public boolean fit(float f, float f2) {
        if (this.tth != null && this.tthteory != null) {
            try {
                this.fableJep.flushStdout();
                this.fableJep.set("tthmin", f);
                this.fableJep.set("tthmax", f2);
                this.fableJep.eval("t.fit(tthmin, tthmax)");
                this.fableJep.flushStdout();
                this.editParameters();
            }
            catch (JepException jepException) {
                FableUtils.excMsg((Object)this, (String)"Problem fitting", (Throwable)jepException);
            }
        }
        return true;
    }

    public boolean compute_tth_histo() {
        boolean bl = true;
        try {
            this.fableJep.eval("t.compute_tth_histo()");
            this.columns.loadRows();
            this.columns.update();
            String[] stringArray = new String[]{"tth_hist_prob", "eta"};
            this.columns.displayComputedData(stringArray);
        }
        catch (JepException jepException) {
            bl = false;
            FableUtils.excMsg((Object)this, (String)"Problem computing tth_histogram", (Throwable)jepException);
        }
        return bl;
    }

    public boolean loadFiltered(String string) {
        this.fileteredFile = string;
        boolean bl = false;
        try {
            this.fableJep.set("filename", this.fileteredFile);
            bl = this.fableJep.eval("t.loadfiltered(filename)");
            this.fableJep.flushStdout();
            this.setColumnObject();
            int n = this.fileteredFile.lastIndexOf(System.getProperty("file.separator"));
            if (n < 0) {
                n = 0;
            }
            this.currentProjectPath = this.fileteredFile.substring(0, n);
            this.tth = null;
            this.tthteory = null;
        }
        catch (JepException jepException) {
            FableUtils.excMsg((Object)this, (String)"Unable to load filtered peak", (Throwable)jepException);
        }
        return bl;
    }

    public String getParamFileName() {
        if (this.parametersFile == null || this.parametersFile.equals("")) {
            FableUtils.errMsg((Object)this, (String)"Your default parameter file  set in Calibration preferences (Menu Windows), has not been found. \nSo default values have been loaded from ImageD11 python object. \nTo avoid this message, either try \"Restore Defaults\" in calibration preferences, or you can save these values in a file (i. e. calibration.par) and set this file in your preferences");
            return "";
        }
        return this.parametersFile;
    }

    public boolean addUnitCellPeaks() {
        boolean bl = true;
        if (this.fileteredFile != null && !this.fileteredFile.equals("")) {
            try {
                this.fableJep.eval("t.addcellpeaks()");
                this.fableJep.eval("mytth=t.theorytth");
                int n = (Integer)this.fableJep.getValue("len(t.theorytth)");
                this.tthteory = new float[n];
                this.tthteory = this.fableJep.getValue_floatarray("mytth.astype(numpy.float32).tostring()");
                this.columns.loadRows();
                this.columns.update();
                this.columns.AddUnitCell(this.tthteory);
            }
            catch (JepException jepException) {
                bl = false;
                FableUtils.excMsg((Object)this, (String)"Cannot addUnitCellPeaks", (Throwable)jepException);
            }
        }
        return bl;
    }

    public boolean set_parameters(Object[] objectArray, HashMap<String, Object> hashMap) {
        boolean bl = false;
        try {
            JavaToJepTools.javaHashMapToPyDictionary((Jep)this.fableJep.getJep(), hashMap);
            this.fableJep.eval("t.parameterobj.set_parameters(dictionary)");
            JavaToJepTools.javaTabToPythonList((Jep)this.fableJep.getJep(), (Object[])objectArray);
            this.fableJep.eval("t.parameterobj.set_varylist(list)");
            this.nVaryList = (Integer)this.fableJep.getValue("len(t.parameterobj.varylist)");
            this.fireVaryList();
            this.fireEditParameters();
            bl = true;
        }
        catch (JepException jepException) {
            bl = false;
            FableUtils.excMsg((Object)this, (String)"Cannot do set_parameters", (Throwable)jepException);
            return bl;
        }
        return bl;
    }

    public void saveParameters(String string) {
        try {
            this.fableJep.set("filename", string);
            this.fableJep.eval("t.saveparameters(filename)");
            this.parametersFile = string;
        }
        catch (JepException jepException) {
            FableUtils.excMsg((Object)this, (String)"Problem saving parameters", (Throwable)jepException);
        }
    }

    public boolean computegv() {
        boolean bl = true;
        try {
            if (this.fileteredFile != null && !this.fileteredFile.equals("")) {
                if (this.tth == null) {
                    this.compute_tth_eta();
                }
                this.fableJep.eval("t.computegv()");
                this.columns.loadRows();
                this.columns.update();
            }
        }
        catch (JepException jepException) {
            bl = false;
            FableUtils.excMsg((Object)this, (String)"Problem computing g-vectors", (Throwable)jepException);
        }
        return bl;
    }

    public boolean savegv(String string) {
        boolean bl = false;
        if (!string.trim().equals("")) {
            try {
                if (this.fileteredFile != null && !this.fileteredFile.equals("")) {
                    this.fableJep.set("filename", string);
                    bl = this.fableJep.eval("t.savegv(filename)");
                    this.logger.info((Object)("g-vectors done : " + string));
                }
            }
            catch (JepException jepException) {
                FableUtils.excMsg((Object)this, (String)"Problem saving g-vectors", (Throwable)jepException);
            }
        }
        return bl;
    }

    public boolean saveFilteredPeaks(String string) {
        boolean bl = false;
        if (!string.trim().equals("")) {
            try {
                if (this.fileteredFile != null && !this.fileteredFile.equals("")) {
                    this.fableJep.set("filename", string);
                    bl = this.fableJep.eval("t.write_colfile(filename)");
                    this.logger.info((Object)("write col file done  : " + string));
                }
            }
            catch (JepException jepException) {
                FableUtils.excMsg((Object)this, (String)"Problem computing g-vectors", (Throwable)jepException);
            }
        }
        return bl;
    }

    public float[] getTth() throws JepException {
        float[] fArray = null;
        if (this.fableJep.eval("t.colfile!=None") && !this.fableJep.eval("t.colfile.tth!=None")) {
            fArray = this.fableJep.getValue_floatarray("t.colfile.tth.astype(numpy.float32).tostring()");
        }
        return fArray;
    }

    public float[] getTheoryTth() throws JepException {
        float[] fArray = null;
        if (this.fableJep.eval("t.colfile!=None") && !this.fableJep.eval("t.colfile.theorytth!=None")) {
            fArray = this.fableJep.getValue_floatarray("t.colfile.theorytth.astype(numpy.float32).tostring()");
        }
        return fArray;
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.add(iPropertyChangeListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.listeners.remove(iPropertyChangeListener);
    }

    public void fireEditParameters() {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "refresh", null, this.pars));
        }
    }

    public void fireVaryList() {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "varyList", null, (Object)this.nVaryList));
        }
    }

    public int getvaryList() {
        return this.nVaryList;
    }

    public ColumnFile getColumnfile() {
        return this.columns;
    }

    public void fireCurrentProjectPath() {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "currentProjectPath", null, (Object)this.currentProjectPath));
        }
    }

    public void fireUpdateView() {
        for (IPropertyChangeListener iPropertyChangeListener : this.listeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "updateFields", null, null));
        }
    }

    public void dispose() {
        this.listeners.removeAll(this.listeners);
        transform = null;
    }
}

