/*
 * Decompiled with CFR 0.152.
 */
package fable.transformation.actions;

import fable.transformation.object.Transform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenParameterFile
extends Action
implements IWorkbenchWindowActionDelegate {
    private static final String ID = "fable.transformation.actions.OpenParameterFile.id";

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
    }

    public OpenParameterFile() {
        this.setId(ID);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"));
        this.setToolTipText("Select a parameter file to open for your calibration");
        this.setText("Open parameters file (.par, .pars, .prm)");
    }

    public void run() {
        this.openParameterFile();
    }

    public void run(IAction iAction) {
        this.openParameterFile();
    }

    private void openParameterFile() {
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            try {
                FileDialog fileDialog = new FileDialog(iWorkbenchWindow.getShell(), 0);
                fileDialog.setFilterNames(new String[]{"*.par, *.pars,*.prm", "All Files (*.*)"});
                fileDialog.setFilterExtensions(new String[]{"*.par;*.pars;*.prm", "*.*"});
                if (fileDialog.open() != null) {
                    String string = fileDialog.getFilterPath();
                    String string2 = fileDialog.getFileName();
                    iWorkbenchWindow.getActivePage().showView("fable.transformation.views.paramview");
                    Transform.getTransformer().loadFileParameters(String.valueOf(string) + System.getProperty("file.separator") + string2);
                    Transform.getTransformer().editParameters();
                }
            }
            catch (PartInitException partInitException) {
                MessageDialog.openError((Shell)iWorkbenchWindow.getShell(), (String)"Error", (String)("Error opening view:" + partInitException.getMessage()));
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    public static String getID() {
        return ID;
    }
}

