/*
 * Decompiled with CFR 0.152.
 */
package fable.preprocessor.views;

import fable.framework.toolbox.ComboValueAndText;
import fable.framework.toolbox.FileText;
import fable.framework.toolbox.FloatText;
import fable.framework.toolbox.IntegerText;
import fable.framework.toolbox.LookAndFeel;
import fable.framework.toolbox.SWTUtils;
import fable.framework.toolbox.StringText;
import fable.framework.toolbox.ToolBox;
import fable.framework.toolbox.TypedText;
import fable.framework.views.FableMessageConsole;
import fable.preprocessor.Activator;
import fable.preprocessor.actions.RunAction;
import fable.preprocessor.process.IPreprocessorListener;
import fable.preprocessor.process.Preprocessor;
import fable.preprocessor.process.PreprocessorEvent;
import fable.preprocessor.toolBox.PreprocessorMessage;
import fable.preprocessor.toolBox.Toolbox;
import fable.python.FabioFile;
import fable.python.FabioFileException;
import fable.python.Sample;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class SpdView
extends ViewPart
implements IPropertyChangeListener {
    public static final String ID = "fable.spd.view";
    public static SpdView thisView = null;
    private static IStatusLineManager statusManager;
    private Preprocessor spdProcessor = Preprocessor.getDefault();
    private String selectedMode = "";
    private String onLineDirectory = "";
    private boolean bSizeHasBeenChecked = true;
    private PreprocessListener listenPreprocessorChanges = new PreprocessListener();
    private Shell shell;
    private Display display;
    private Composite spdComposite;
    private Composite applyCorrection;
    private Cursor waitCursor;
    private Cursor normalCursor;
    private Cursor currentCursor;
    private Button chkLock;
    private Button btnReset;
    private Group grp_ExtensionFilter;
    private Group grpspd_dark;
    private Group grpFlood_spd;
    private Group grpDistortion;
    private Group grpOther;
    private Group grpspd_ext;
    private Group grp_zip;
    private Group grpType;
    private String sSampleDirectory;
    private Button btnApplyDark;
    private Button btnApplyFlood;
    private Button btnApplyDist;
    private Button chkTypeEdf;
    private Button chkTypeBruker;
    private Button chkTypeOther;
    private StringText txtTypeOther;
    private Button compressOriginalFiles;
    private Button compressCorrectedFiles;
    private Button browseZip;
    private FileText zipProgram;
    private String preprocessorErrormessage;
    private StringText corExt;
    private Button btnCorExtDefault;
    private Button btnCorExtNew;
    private Group grpSpdDarkopt;
    private FileText darkFile;
    private Button btnDarkFileBrowse;
    private FloatText darkConst;
    private StringText darkExt;
    private Combo cboSaveDark;
    private Button radioDarkInEdf;
    private Button radioDarkFromFile;
    private Button radioNoDarkFile;
    private Button radioDistInEdf;
    private Button radioDistFromFile;
    private Button radioNoDistFile;
    private Button radioFloodInEdf;
    private Button radioFloodFromFile;
    private Button radioNoFloodFile;
    private Button btn_float;
    private Button btn_integer;
    private FloatText inpConst;
    private FloatText inpExp;
    private FloatText inpFactor;
    private IntegerText dvo;
    private FileText floodFile;
    private Button btnFloodFileBrowse;
    private FileText distortionFile;
    private Button btnDistFileBrowse;
    private Combo cboDoDist;
    private Text otherSpdOption;
    private Button btnValidate;
    public static boolean ViewLocked;
    private ArrayList<IPropertyChangeListener> array = new ArrayList();
    private IPropertyChangeListener preferencesListener;
    private ImageDescriptor imagePause = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/stop.gif");
    private ImageDescriptor imagePlay = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/e_forward.gif");
    private ImageDescriptor imageReset = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/revert.gif");
    private ImageDescriptor imageLocked = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/lock.gif");
    private ImageDescriptor imageUnLocked = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/unlock.gif");
    private String alphanumOnly = "[\\p{Punct}&&[^_]]";
    private final int numcolumns = 7;
    private boolean bFloodFileSizeOk = true;
    private boolean bDarkSizeOk = true;

    public void createPartControl(Composite composite) {
        this.initVariables(composite);
        ScrolledComposite scrolledComposite = new ScrolledComposite(composite, 768);
        this.spdComposite = new Composite((Composite)scrolledComposite, 20);
        scrolledComposite.setContent((Control)this.spdComposite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        GridData gridData = new GridData(16, 20, false, false);
        this.spdComposite.setLayout((Layout)gridLayout);
        this.spdComposite.setLayoutData((Object)gridData);
        this.createGroupApply();
        this.createGroupDark();
        this.createGroupFlood();
        this.createGroupDistortion();
        this.createGroupCorExt();
        this.createGroupExtensionFilter();
        this.createGroupOther();
        this.createZip();
        if (Toolbox.isSpdNew()) {
            this.createTypeIntOrFloat();
        }
        this.createGroupLock(this.spdComposite);
        this.addGroupButton(this.spdComposite);
        this.initFieldsAfterPartControl();
        scrolledComposite.setMinHeight(this.display.getPrimaryMonitor().getBounds().height);
        scrolledComposite.setMinWidth(this.display.getPrimaryMonitor().getBounds().width);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setMinSize(this.spdComposite.computeSize(-1, -1));
        this.setHelpContextToChildren(this.spdComposite);
    }

    private void setHelpContextToChildren(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Text text;
            TypedText typedText;
            if (controlArray[n] instanceof Group) {
                this.setHelpContextToChildren((Composite)((Group)controlArray[n]));
            } else if (controlArray[n] instanceof TypedText) {
                typedText = (TypedText)controlArray[n];
                if (typedText.getTextField().getToolTipText() == null) {
                    typedText.getTextField().setToolTipText("Press " + ToolBox.getHelpContextTooltip() + " for Focus.");
                } else {
                    typedText.getTextField().setToolTipText(String.valueOf(typedText.getTextField().getToolTipText()) + " \n\nPress " + ToolBox.getHelpContextTooltip() + " for Focus");
                }
                if (typedText.getToolTipText() == null) {
                    typedText.setToolTipText("Press " + ToolBox.getHelpContextTooltip() + " for Focus.");
                } else {
                    typedText.setToolTipText(String.valueOf(typedText.getToolTipText()) + " \n\nPress " + ToolBox.getHelpContextTooltip() + " for Focus");
                }
                text = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
                text.setHelp((Control)typedText.getTextField(), "fable.preprocessor.otherSpdOption");
            } else if (controlArray[n] instanceof Text) {
                typedText = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
                typedText.setHelp((Control)((Text)controlArray[n]), "fable.preprocessor.otherSpdOption");
                text = (Text)controlArray[n];
                if (text.getToolTipText() == null) {
                    text.setToolTipText("Press " + ToolBox.getHelpContextTooltip() + " for Focus.");
                } else {
                    text.setToolTipText(String.valueOf(text.getToolTipText()) + " \n\nPress " + ToolBox.getHelpContextTooltip() + " for Focus");
                }
            } else if (controlArray[n] instanceof Table) {
                typedText = this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem();
                typedText.setHelp((Control)((Table)controlArray[n]), "fable.preprocessor.otherSpdOption");
            }
            ++n;
        }
    }

    private void createGroupCorExt() {
        this.grpspd_ext = LookAndFeel.getGroup((Composite)this.spdComposite, (String)"Corrected image file extension", (int)3, (int)1);
        this.grpspd_ext.setToolTipText("cor_ext : corrected image file extension.");
        this.btnCorExtDefault = new Button((Composite)this.grpspd_ext, 16);
        this.btnCorExtDefault.setText("default .cor");
        this.btnCorExtDefault.setSelection(true);
        this.btnCorExtDefault.setLayoutData((Object)new GridData(4, 2, false, true));
        this.btnCorExtNew = new Button((Composite)this.grpspd_ext, 16);
        this.btnCorExtNew.setText("other");
        this.btnCorExtDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpdView.this.fireCurrentCorrectedExtensionHasChanged();
            }
        });
        this.btnCorExtNew.setLayoutData((Object)new GridData(4, 2, false, true));
        this.btnCorExtNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = ((Button)selectionEvent.getSource()).getSelection();
                SpdView.this.enableFieldOtherCorrection(bl);
                SpdView.this.fireCurrentCorrectedExtensionHasChanged();
            }
        });
        this.corExt = new StringText((Composite)this.grpspd_ext, 0);
        this.corExt.setName("correction extension");
        this.corExt.setLayoutData((Object)new GridData(4, 2, true, false));
        this.corExt.setToolTipText("cor_ext= Corrected image file extension ; this extension is added to the file extension.");
        this.corExt.getTextField().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SpdView.this.fireCurrentCorrectedExtensionHasChanged();
            }
        });
        if (this.btnCorExtNew.getSelection()) {
            this.corExt.setBackground(Display.getDefault().getSystemColor(1));
        } else {
            this.corExt.setBackground(Display.getDefault().getSystemColor(22));
        }
    }

    protected void fireCurrentCorrectedExtensionHasChanged() {
        String string = "";
        if (!this.btnCorExtDefault.getSelection()) {
            string = String.valueOf(string) + (this.corExt.getText().equals("") ? "cor" : this.corExt.getText());
            if (this.compressCorrectedFiles.getSelection()) {
                string = String.valueOf(string) + ".gz";
            }
        } else if (this.compressCorrectedFiles.getSelection()) {
            string = String.valueOf(string) + "cor.gz";
        }
        this.spdProcessor.fireCurrentCorrectedExtensionHasChanged(string);
    }

    private void createTypeIntOrFloat() {
        this.grpType = LookAndFeel.getGroup((Composite)this.spdComposite, (String)"Output file type", (int)4, (int)2);
        this.grpType.setToolTipText("Writes output files with selected type.\n\nWith 16-bit unsigned integer dvo must \nbe added later to the stored data  values to retrieve the correct values. \nThe dvo value is written as \nan integer value after the header keyDataValueOffset (default 0). \n\n Available on Linux operating system, 64bit architecture.");
        this.btn_integer = new Button((Composite)this.grpType, 16);
        this.btn_integer.setText("Unsigned integer");
        this.btn_integer.setData((Object)"Unsigned16");
        this.btn_float = new Button((Composite)this.grpType, 16);
        this.btn_float.setText("Float");
        this.btn_float.setData((Object)"FloatIEEE32");
        new Label((Composite)this.grpType, 0).setText("Data value offset");
        this.dvo = new IntegerText((Composite)this.grpType, 0);
        this.dvo.setName("dvo");
        this.dvo.setToolTipText("dvo option. must be added later to the stored data values to retrieve the correct values.");
    }

    private void createZip() {
        this.grp_zip = LookAndFeel.getGroup((Composite)this.spdComposite, (String)"Compress data and corrected files", (int)4, (int)1);
        this.grp_zip.setToolTipText("Compress data and corrected files after processing. Please compress data with gzip, file format available for fabio.");
        Composite composite = new Composite((Composite)this.grp_zip, 4);
        composite.setLayout((Layout)new GridLayout(4, false));
        GridData gridData = new GridData(1808, 128, true, true, 4, 15);
        composite.setLayoutData((Object)gridData);
        this.compressCorrectedFiles = new Button(composite, 32);
        this.compressCorrectedFiles.setText("Compress corrected files(gzip)");
        this.compressCorrectedFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpdView.this.zipProgram.setEnabled(((Button)selectionEvent.widget).getSelection() || SpdView.this.compressOriginalFiles.getSelection());
                SpdView.this.zipProgram.set_isRequiredField(((Button)selectionEvent.widget).getSelection() || SpdView.this.compressOriginalFiles.getSelection());
                SpdView.this.zipProgram.showDecoration();
                if (!SpdView.this.compressCorrectedFiles.getSelection() && !SpdView.this.compressOriginalFiles.getSelection()) {
                    SpdView.this.zipProgram.set_bValide(true);
                }
                SpdView.this.fireCurrentCorrectedExtensionHasChanged();
            }
        });
        this.compressOriginalFiles = new Button(composite, 32);
        this.compressOriginalFiles.setText("Compress original files(gzip)");
        this.compressOriginalFiles.setToolTipText("This option allow preprocessor to compress original files after preprocessing.\n WARNING spd program is not abled to read such compressed files.");
        this.compressOriginalFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpdView.this.zipProgram.setEnabled(((Button)selectionEvent.widget).getSelection() || SpdView.this.compressCorrectedFiles.getSelection());
                SpdView.this.zipProgram.set_isRequiredField(((Button)selectionEvent.widget).getSelection() || SpdView.this.compressCorrectedFiles.getSelection());
                SpdView.this.zipProgram.showDecoration();
                if (!SpdView.this.compressCorrectedFiles.getSelection() && !SpdView.this.compressOriginalFiles.getSelection()) {
                    SpdView.this.zipProgram.set_bValide(true);
                }
                if (SpdView.this.compressOriginalFiles.getSelection()) {
                    FableMessageConsole.console.displayInfo("WARNING : After compression, spd is not able to process these original files.");
                }
            }
        });
        this.zipProgram = new FileText(composite, 0);
        this.zipProgram.setName("Zip command");
        this.zipProgram.setLayoutData((Object)new GridData(4, 2, true, false));
        this.browseZip = new Button(composite, 8);
        this.browseZip.setText("Browse...");
        this.browseZip.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(((Button)selectionEvent.widget).getParent().getShell(), 64);
                if (SpdView.this.zipProgram.getText() != null && !SpdView.this.zipProgram.getText().equals("")) {
                    fileDialog.setFilterPath(SpdView.this.zipProgram.getText());
                } else if (SpdView.this.sSampleDirectory != null) {
                    fileDialog.setFilterPath(SpdView.this.sSampleDirectory);
                }
                String string = fileDialog.open();
                if (string != null) {
                    SpdView.this.zipProgram.set_Text(string);
                }
            }
        });
    }

    private void createGroupExtensionFilter() {
        this.grp_ExtensionFilter = LookAndFeel.getGroup((Composite)this.spdComposite, (String)"Source file extension to save an online input data to a file (src_ext)", (int)4, (int)1);
        this.grp_ExtensionFilter.setToolTipText("Select extension file to process.");
        this.chkTypeEdf = new Button((Composite)this.grp_ExtensionFilter, 16);
        this.chkTypeEdf.setText("edf");
        this.chkTypeEdf.setLayoutData((Object)new GridData(4, 2, false, false));
        this.chkTypeBruker = new Button((Composite)this.grp_ExtensionFilter, 16);
        this.chkTypeBruker.setText("bruker");
        this.chkTypeBruker.setLayoutData((Object)new GridData(4, 2, false, false));
        this.chkTypeOther = new Button((Composite)this.grp_ExtensionFilter, 16);
        this.chkTypeOther.setLayoutData((Object)new GridData(4, 2, false, false));
        this.chkTypeOther.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = ((Button)selectionEvent.getSource()).getSelection();
                SpdView.this.enableFieldOther_src_ext(bl);
            }
        });
        this.chkTypeOther.setSelection(true);
        this.chkTypeOther.setText("other");
        this.txtTypeOther = new StringText((Composite)this.grp_ExtensionFilter, 4, " ", "\\p{Punct}", "No punctuation is allowed");
        this.txtTypeOther.setName("other input file extension");
        this.txtTypeOther.setLayoutData((Object)new GridData(4, 2, true, false));
        this.txtTypeOther.setToolTipText("Source image file extension (default None i. e. no input file image is saved).");
        if (this.chkTypeOther.getSelection()) {
            this.txtTypeOther.setBackground(Display.getDefault().getSystemColor(1));
        } else {
            this.txtTypeOther.setBackground(Display.getDefault().getSystemColor(22));
        }
        this.txtTypeOther.setEnabled(this.chkTypeOther.getSelection());
        this.txtTypeOther.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SpdView.this.txtTypeOther.set_Text(((Text)focusEvent.getSource()).getText().replaceAll("\\p{Space}", ""));
            }
        });
    }

    private void enableFieldOther_src_ext(boolean bl) {
        this.txtTypeOther.setEnabled(bl);
        if (bl) {
            this.txtTypeOther.setBackground(Display.getDefault().getSystemColor(1));
        } else {
            this.txtTypeOther.setBackground(Display.getDefault().getSystemColor(22));
        }
    }

    private void enableFieldOtherCorrection(boolean bl) {
        this.corExt.setEnabled(bl);
        this.corExt.set_isRequiredField(bl);
        this.corExt.showDecoration();
        this.corExt.setFocus();
        if (bl) {
            this.corExt.setBackground(Display.getDefault().getSystemColor(1));
        } else {
            this.corExt.setBackground(Display.getDefault().getSystemColor(22));
        }
    }

    private void createGroupApply() {
        this.applyCorrection = new Composite(this.spdComposite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.makeColumnsEqualWidth = true;
        this.applyCorrection.setLayout((Layout)gridLayout);
        this.applyCorrection.setLayoutData((Object)new GridData(16, 20, false, false));
        Label label = new Label(this.applyCorrection, 0);
        label.setText("Apply:");
        this.btnApplyDark = new Button(this.applyCorrection, 32);
        this.btnApplyDark.setText("Dark");
        this.btnApplyDark.setToolTipText("do_dark. If set, then the dark image correction is performed if there is a source for it (file, dark_const or dark_id).");
        this.btnApplyDark.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpdView.this.sendcontrolToDarkGroup();
                SpdView.this.checkDarkSize();
            }
        });
        this.btnApplyFlood = new Button(this.applyCorrection, 32);
        this.btnApplyFlood.setText("Flood");
        this.btnApplyFlood.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpdView.this.sendControlToFloodGroup();
                SpdView.this.checkFloodFile();
            }
        });
        this.btnApplyDist = new Button(this.applyCorrection, 32);
        this.btnApplyDist.setText("Distortion ");
        this.btnApplyDist.setToolTipText("do_distortion");
        this.btnApplyDist.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpdView.this.sendControlToDistGroup();
            }
        });
    }

    private void createGroupDark() {
        this.grpspd_dark = new Group(this.spdComposite, 0);
        this.grpspd_dark.setText("Dark");
        this.grpspd_dark.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        this.grpspd_dark.setLayoutData((Object)gridData);
        Group group = LookAndFeel.getGroup((Composite)this.grpspd_dark, (String)"File", (int)5, (int)3);
        group.setToolTipText("dark_file.");
        this.radioNoDarkFile = new Button((Composite)group, 16);
        this.radioNoDarkFile.setText("None");
        this.radioNoDarkFile.setLayoutData((Object)new GridData(1, 2, false, true));
        this.radioDarkInEdf = new Button((Composite)group, 16);
        this.radioDarkInEdf.setText("From header");
        this.radioDarkInEdf.setLayoutData((Object)new GridData(1, 2, false, true));
        this.radioDarkInEdf.setToolTipText("dark_file=[darkFileName]; add verbose=2 in other options to get file name while spd is processing.");
        this.radioDarkFromFile = new Button((Composite)group, 16);
        this.radioDarkFromFile.setText("File");
        this.radioDarkFromFile.setLayoutData((Object)new GridData(1, 2, false, true));
        this.darkFile = new FileText((Composite)group, 0, "");
        this.darkFile.setName("Dark file");
        this.darkFile.setToolTipText("dark image file name.");
        GridData gridData2 = new GridData(4, 2, true, true);
        this.darkFile.setLayoutData((Object)gridData2);
        this.darkFile.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 13 || keyEvent.keyCode == 0x1000050) {
                    SpdView.this.sendcontrolToDarkGroup();
                    SpdView.this.checkDarkSize();
                }
            }
        });
        this.darkFile.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                SpdView.this.sendcontrolToDarkGroup();
            }
        });
        this.btnDarkFileBrowse = new Button((Composite)group, 8);
        this.btnDarkFileBrowse.setLayoutData((Object)new GridData(16384, 16, true, false));
        this.btnDarkFileBrowse.setText("Browse...");
        this.btnDarkFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(SpdView.this.shell, 0);
                String[] stringArray = new String[]{"edf files  (*.edf)", "All Files (*.*)", "All"};
                String[] stringArray2 = new String[]{"*.edf", "*.*", "*"};
                fileDialog.setFilterExtensions(stringArray2);
                fileDialog.setFilterNames(stringArray);
                fileDialog.setText("Choose dark file...");
                if (SpdView.this.darkFile.getText() != null && !SpdView.this.darkFile.getText().equals("")) {
                    fileDialog.setFilterPath(SpdView.this.darkFile.getText());
                } else if (SpdView.this.sSampleDirectory != null) {
                    fileDialog.setFilterPath(SpdView.this.sSampleDirectory);
                }
                String string = fileDialog.open();
                if (string != null) {
                    SpdView.this.darkFile.set_Text(string);
                    SpdView.this.sendcontrolToDarkGroup();
                    SpdView.this.checkDarkSize();
                }
            }
        });
        this.radioDarkInEdf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpdView.this.sendcontrolToDarkGroup();
                SpdView.this.checkDarkSize();
            }
        });
        this.radioDarkFromFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpdView.this.sendcontrolToDarkGroup();
                SpdView.this.checkDarkSize();
            }
        });
        this.radioNoDarkFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpdView.this.sendcontrolToDarkGroup();
                SpdView.this.checkDarkSize();
            }
        });
        this.darkConst = new FloatText((Composite)this.grpspd_dark, 16384, "Dark const");
        GridData gridData3 = new GridData(4, 0x1000000, true, false);
        this.darkConst.getTextField().setLayoutData((Object)gridData3);
        gridData3.widthHint = 30;
        gridData3.horizontalIndent = 8;
        this.darkConst.setName("dark constant");
        this.darkConst.setToolTipText("dark_const: subtract constant dark image value. Can be specified in addition to dark_file or dark_id.");
        this.darkConst.setLayoutData((Object)new GridData(16384, 2, false, true));
        this.darkConst.set_Text(String.valueOf(0));
        this.darkConst.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                SpdView.this.sendcontrolToDarkGroup();
            }
        });
        this.grpSpdDarkopt = LookAndFeel.getGroup((Composite)this.grpspd_dark, (String)"Factors applied to source and dark image. ", (int)7, (int)3);
        Label label = new Label((Composite)this.grpSpdDarkopt, 0);
        label.setText("Formula is :  corrected  = (source^inp_exp - dark^inp_exp) inp_factor + inp_const");
        label.setLayoutData((Object)new GridData(16384, 2, false, true, 7, 1));
        this.grpSpdDarkopt.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.inpConst = new FloatText((Composite)this.grpSpdDarkopt, 4, "Constant (inp_const)");
        this.inpConst.setName("inp Constant");
        GridData gridData4 = new GridData(4, 0x1000000, true, false);
        this.inpConst.getTextField().setLayoutData((Object)gridData3);
        gridData4.widthHint = 30;
        gridData4.horizontalIndent = 8;
        this.inpConst.setToolTipText("inp_const: add input image constant.");
        this.inpConst.set_Text(String.valueOf(0));
        this.inpExp = new FloatText((Composite)this.grpSpdDarkopt, 4, "Exponent (inp_exp)");
        this.inpExp.setName("Exponent to input image");
        this.inpExp.set_Text(String.valueOf(1));
        GridData gridData5 = new GridData(4, 0x1000000, true, false);
        this.inpExp.getTextField().setLayoutData((Object)gridData5);
        gridData5.widthHint = 30;
        gridData5.horizontalIndent = 8;
        this.inpExp.setToolTipText("inp_exp: apply exponent to input image.");
        this.inpFactor = new FloatText((Composite)this.grpSpdDarkopt, 4, "Factor (inp_factor)");
        this.inpFactor.setName("Multiply with input image factor for dark options");
        this.inpFactor.set_Text(String.valueOf(1));
        GridData gridData6 = new GridData(4, 0x1000000, true, false);
        this.inpFactor.getTextField().setLayoutData((Object)gridData6);
        gridData6.widthHint = 30;
        gridData6.horizontalIndent = 8;
        this.inpFactor.setToolTipText("inp_factor: multiply with input image factor.");
        Label label2 = new Label((Composite)this.grpspd_dark, 0);
        label2.setText("Save dark image memory to file (.dark)? ");
        this.cboSaveDark = new Combo((Composite)this.grpspd_dark, 12);
        this.cboSaveDark.add("No");
        this.cboSaveDark.add("Always");
        this.cboSaveDark.add("If new image");
        this.cboSaveDark.setToolTipText("Save dark image memory to file.Only if input source image is also saved (src_ext not empty)");
        this.darkExt = new StringText((Composite)this.grpspd_dark, 4, "Dark image extension ", this.alphanumOnly, "no punctuation allowed");
        this.darkExt.setName("Dark image extension");
        this.darkExt.setLayoutData((Object)new GridData(36, 2, true, false));
        this.darkExt.setToolTipText("dark image file extension  (default none). Used to save an online dark image to a file. Default is None, no output file is written");
    }

    private void createGroupFlood() {
        this.grpFlood_spd = new Group(this.spdComposite, 0);
        this.grpFlood_spd.setText("Flood");
        this.grpFlood_spd.setLayout((Layout)new GridLayout(5, false));
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        this.grpFlood_spd.setLayoutData((Object)gridData);
        this.radioNoFloodFile = new Button((Composite)this.grpFlood_spd, 16);
        this.radioNoFloodFile.setLayoutData((Object)new GridData(4, 2, false, true));
        this.radioNoFloodFile.setText("None");
        this.radioNoFloodFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpdView.this.sendControlToFloodGroup();
                SpdView.this.checkFloodFile();
            }
        });
        this.radioFloodInEdf = new Button((Composite)this.grpFlood_spd, 16);
        this.radioFloodInEdf.setLayoutData((Object)new GridData(4, 2, false, true));
        this.radioFloodInEdf.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpdView.this.sendControlToFloodGroup();
                SpdView.this.checkFloodFile();
            }
        });
        this.radioFloodInEdf.setText("From header");
        this.radioFloodFromFile = new Button((Composite)this.grpFlood_spd, 16);
        this.radioFloodFromFile.setLayoutData((Object)new GridData(4, 2, false, true));
        this.radioFloodFromFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpdView.this.sendControlToFloodGroup();
                SpdView.this.checkFloodFile();
            }
        });
        this.radioFloodFromFile.setText("File");
        this.floodFile = new FileText((Composite)this.grpFlood_spd, 4, "");
        this.floodFile.setName("flood file");
        this.floodFile.setToolTipText("flood field image file name");
        this.floodFile.setLayoutData((Object)new GridData(4, 2, true, true));
        this.btnFloodFileBrowse = new Button((Composite)this.grpFlood_spd, 8);
        this.btnFloodFileBrowse.setText("Browse...");
        this.btnFloodFileBrowse.setLayoutData((Object)new GridData(16384, 16, true, false));
        this.btnFloodFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(SpdView.this.shell, 0);
                String[] stringArray = new String[]{"edf files (*.edf)", ".cor", "All Files (*.*)", "All"};
                String[] stringArray2 = new String[]{"*.edf", "*.cor", "*.*", "*"};
                fileDialog.setFilterExtensions(stringArray2);
                fileDialog.setFilterNames(stringArray);
                fileDialog.setText("Choose flood file...");
                if (SpdView.this.floodFile.getText() != null && !SpdView.this.floodFile.getText().equals("")) {
                    fileDialog.setFilterPath(SpdView.this.floodFile.getText());
                } else if (SpdView.this.sSampleDirectory != null) {
                    fileDialog.setFilterPath(SpdView.this.sSampleDirectory);
                }
                String string = fileDialog.open();
                if (string != null) {
                    SpdView.this.floodFile.set_Text(string);
                    SpdView.this.checkFloodFile();
                }
            }
        });
    }

    private void createGroupDistortion() {
        this.grpDistortion = new Group(this.spdComposite, 0);
        this.grpDistortion.setText("Spatial distortion");
        this.grpDistortion.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        this.grpDistortion.setLayoutData((Object)gridData);
        Group group = LookAndFeel.getGroup((Composite)this.grpDistortion, (String)"File", (int)5, (int)2);
        group.setToolTipText("distortion_file");
        Label label = new Label((Composite)this.grpDistortion, 0);
        label.setText("Do spatial distortion after");
        this.cboDoDist = new Combo((Composite)this.grpDistortion, 12);
        this.cboDoDist.setLayoutData((Object)new GridData(4, 2, false, false));
        this.cboDoDist.add("dark");
        this.cboDoDist.add("flood");
        this.cboDoDist.add("normalisation");
        GridData gridData2 = new GridData(4);
        gridData2.horizontalSpan = 1;
        gridData2.grabExcessHorizontalSpace = false;
        this.cboDoDist.setLayoutData((Object)gridData2);
        this.radioNoDistFile = new Button((Composite)group, 16);
        this.radioNoDistFile.setText("None");
        this.radioNoDistFile.setLayoutData((Object)new GridData(5, 2, false, true));
        this.radioDistInEdf = new Button((Composite)group, 16);
        this.radioDistInEdf.setText("From header");
        this.radioDistInEdf.setLayoutData((Object)new GridData(4, 2, false, true));
        this.radioDistFromFile = new Button((Composite)group, 16);
        this.radioDistFromFile.setText("File");
        this.radioDistFromFile.setLayoutData((Object)new GridData(4, 2, false, true));
        this.distortionFile = new FileText((Composite)group, 4, "");
        this.distortionFile.setName("Distortion file");
        this.distortionFile.setLayoutData((Object)new GridData(4, 2, true, true));
        this.distortionFile.setToolTipText("distortion file.");
        this.btnDistFileBrowse = new Button((Composite)group, 8);
        this.btnDistFileBrowse.setText("Browse...");
        this.btnDistFileBrowse.setLayoutData((Object)new GridData(16384, 16, true, false));
        this.btnDistFileBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(SpdView.this.shell, 0);
                String[] stringArray = new String[]{"Distortion files (*.spd)", "Spline files (*.spline)", "All Files (*.*)", "All"};
                String[] stringArray2 = new String[]{"*.spd", "*.spline", "*.*", "*"};
                fileDialog.setFilterExtensions(stringArray2);
                fileDialog.setFilterNames(stringArray);
                fileDialog.setText("Choose distortion file...");
                if (SpdView.this.distortionFile.getText() != null && !SpdView.this.distortionFile.getText().equals("")) {
                    fileDialog.setFilterPath(SpdView.this.distortionFile.getText());
                } else if (SpdView.this.sSampleDirectory != null) {
                    fileDialog.setFilterPath(SpdView.this.sSampleDirectory);
                }
                String string = fileDialog.open();
                if (string != null) {
                    SpdView.this.distortionFile.set_Text(string);
                }
            }
        });
        this.radioDistInEdf.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                SpdView.this.sendControlToDistGroup();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpdView.this.sendControlToFloodGroup();
            }
        });
        this.radioDistFromFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                SpdView.this.sendControlToDistGroup();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpdView.this.sendControlToDistGroup();
            }
        });
        this.radioNoDistFile.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                SpdView.this.sendControlToFloodGroup();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpdView.this.sendControlToFloodGroup();
            }
        });
    }

    private void createGroupOther() {
        this.grpOther = LookAndFeel.getGroup((Composite)this.spdComposite, (String)"Add other spd options", (int)1, (int)1);
        this.otherSpdOption = new Text((Composite)this.grpOther, 2818);
        GridData gridData = new GridData(1808);
        gridData.verticalSpan = 15;
        this.otherSpdOption.setLayoutData((Object)gridData);
        this.otherSpdOption.setToolTipText("Add other spd options here.");
    }

    private void initFieldsAfterPartControl() {
        this.cboDoDist.select(1);
        this.cboSaveDark.select(2);
        this.setPreferencesValues();
    }

    private void sendcontrolToDarkGroup() {
        boolean bl = this.btnApplyDark.getSelection();
        this.setEnableGroup((Composite)this.grpspd_dark, bl);
        this.enableFileSelection(this.btnDarkFileBrowse, (Composite)this.darkFile, this.display, this.radioDarkFromFile.getSelection());
        if (bl && (this.darkFile.getText().equals("") || this.darkFile.getText().matches("\\p{Space}+?") && (this.darkConst.getText().equals("") || this.darkConst.getText().matches("\\p{Space}+|0"))) && this.radioDarkFromFile.getSelection()) {
            this.darkFile.set_isRequiredField(bl);
            this.darkConst.set_isRequiredField(bl);
            this.darkFile.showDecoration();
            this.btnDarkFileBrowse.setFocus();
            if (this.darkConst.getText().matches("\\p{Space}") || this.darkConst.getText().equals("")) {
                this.darkConst.showDecoration();
            } else if (this.darkConst.getText().equals("0")) {
                this.darkConst.setMinValue(0.0f, false);
                this.darkConst.showDecoration();
            }
        } else {
            this.darkFile.set_isRequiredField(false);
            this.darkFile.showDecoration();
            this.darkConst.set_isRequiredField(false);
            this.darkConst.set_bValide(true);
            this.darkConst.showDecoration();
            this.darkConst.setMinValue(0.0f, true);
        }
    }

    private void sendControlToFloodGroup() {
        boolean bl = this.btnApplyFlood.getSelection();
        this.setEnableGroup((Composite)this.grpFlood_spd, bl);
        this.enableFileSelection(this.btnFloodFileBrowse, (Composite)this.floodFile, this.display, bl && this.radioFloodFromFile.getSelection());
        this.floodFile.set_isRequiredField(bl && this.radioFloodFromFile.getSelection());
        this.floodFile.showDecoration();
        this.btnFloodFileBrowse.setFocus();
    }

    private void sendControlToDistGroup() {
        boolean bl = this.btnApplyDist.getSelection();
        this.setEnableGroup((Composite)this.grpDistortion, bl);
        this.enableFileSelection(this.btnDistFileBrowse, (Composite)this.distortionFile, this.display, bl && this.radioDistFromFile.getSelection());
        this.setApplyDist(bl);
        this.distortionFile.set_isRequiredField(bl && this.radioDistFromFile.getSelection());
        this.distortionFile.showDecoration();
        this.btnDistFileBrowse.setFocus();
    }

    public void setPreferencesValues() {
        Preferences preferences = Activator.getDefault().getPluginPreferences();
        this.setApplyDark(preferences.getBoolean("pref_auto_dark"));
        this.setApplyDist(preferences.getBoolean("pref_auto_dist"));
        this.setApplyFlood(preferences.getBoolean("pref_auto_flood"));
        this.setTxtFileDark(preferences.getString("pref_dark_file"));
        this.set_dark_ext(preferences.getString("pref_dark_file"));
        this.setTxtFileDist(preferences.getString("pref_dist_file"));
        this.setTxtFileFlood(preferences.getString("pref_flood_file"));
        this.set_command(preferences.getString("pref_cmd_spd"));
        this.setSelectedMode(preferences.getString("pref_mode"));
        this.setCommandMode(preferences);
        this.setOtherSpdOption(preferences.getString("pref_spd_otherOptions"));
        this.setPrefCorrectionExtension(preferences.getString("pref_ext_COR_SELECT"), preferences.getString("pref_ext_COR"));
        this.set_DarkFile_mode(preferences.getString("pref_dark_getFileMode"));
        this.set_DistFile_mode(preferences.getString("pref_dist_getFileMode"));
        this.set_FloodFile_mode(preferences.getString("pref_flood_getFileMode"));
        this.sendcontrolToDarkGroup();
        this.sendControlToDistGroup();
        this.sendControlToFloodGroup();
        this.compressCorrectedFiles.setSelection(preferences.getBoolean("pref_zipCorrected"));
        this.compressCorrectedFiles.notifyListeners(13, new Event());
        this.compressOriginalFiles.setSelection(preferences.getBoolean("pref_zipOriginal"));
        this.compressOriginalFiles.notifyListeners(13, new Event());
        this.zipProgram.set_Text(preferences.getString("pref_zip_program"));
        if (this.btn_float != null) {
            this.btn_float.setSelection(preferences.getString("pref_type").equals("type_float"));
        }
        if (this.btn_integer != null) {
            this.btn_integer.setSelection(preferences.getString("pref_type").equals("type_int"));
        }
        if (this.dvo != null) {
            this.dvo.set_Text(preferences.getString("pref_dvo"));
        }
    }

    private void setCommandMode(Preferences preferences) {
        this.spdProcessor.setSpdMode(preferences.getString("pref_spd_server"));
    }

    private void setPrefCorrectionExtension(String string, String string2) {
        boolean bl = string.equals("Default");
        this.btnCorExtDefault.setSelection(bl);
        this.btnCorExtNew.setSelection(!bl);
        this.corExt.set_Text(string2);
        this.enableFieldOtherCorrection(!bl);
    }

    private ComboValueAndText[] createVerbose() {
        ComboValueAndText[] comboValueAndTextArray = new ComboValueAndText[]{new ComboValueAndText("Low", "-1"), new ComboValueAndText("Medium", "0"), new ComboValueAndText("High", "1"), new ComboValueAndText("Very high", "2")};
        return comboValueAndTextArray;
    }

    private void addGroupButton(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(131072, 0x1000000, false, true);
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        this.btnReset = new Button(composite2, 8);
        final Image image = this.imageReset.createImage();
        Image image2 = new Image((Device)this.display, image.getImageData().scaledTo((int)((double)image.getBounds().width * 1.2), (int)((double)image.getBounds().height * 1.2)));
        this.btnReset.setImage(image2);
        this.btnReset.setToolTipText("Restore defaults values.");
        this.btnReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpdView.this.ResetAll();
            }
        });
        this.btnReset.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                image.dispose();
            }
        });
        this.btnValidate = new Button(composite2, 8);
        this.setImagebtnLaunch(this.spdProcessor.isM_bStatusProcessing());
        this.btnValidate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpdView.this.LaunchPreprocessor();
            }
        });
        this.btnValidate.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent mouseEvent) {
                SpdView.this.shell.setCursor(SpdView.this.normalCursor);
            }

            public void mouseExit(MouseEvent mouseEvent) {
                SpdView.this.shell.setCursor(SpdView.this.currentCursor);
            }

            public void mouseHover(MouseEvent mouseEvent) {
            }
        });
    }

    private void initVariables(Composite composite) {
        thisView = this;
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.preprocessor.actions.RunAction", (IAction)new RunAction());
        this.display = Display.getCurrent();
        thisView.setContentDescription("Choose spd options for preprocessor here");
        thisView.setTitleToolTip("Spd view");
        this.shell = composite.getShell();
        this.waitCursor = new Cursor((Device)this.display, 1);
        this.currentCursor = this.normalCursor = new Cursor((Device)this.display, 0);
        this.spdProcessor.addPropertyChangeListener(this);
        this.spdProcessor.addPreprocessorListener(this.listenPreprocessorChanges);
        this.preferencesListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("pref_zip_program")) {
                    SpdView.this.zipProgram.set_Text(Activator.getDefault().getPreferenceStore().getString("pref_zip_program"));
                }
            }
        };
    }

    public void setFocus() {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("ProcessingView_directory")) {
            this.sSampleDirectory = (String)propertyChangeEvent.getNewValue();
        } else if (!propertyChangeEvent.getProperty().equals("ProcessingView_sample") && propertyChangeEvent.getProperty().equals("ProcessingView_experiment")) {
            this.bSizeHasBeenChecked = false;
        }
    }

    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
        statusManager = iViewSite.getActionBars().getStatusLineManager();
    }

    public void showFileSelection(Button button, Composite composite, boolean bl) {
        composite.setVisible(bl);
        button.setVisible(bl);
    }

    public void enableFileSelection(Button button, Composite composite, Display display, boolean bl) {
        composite.setEnabled(bl);
        button.setEnabled(bl);
        if (bl) {
            composite.setBackground(display.getSystemColor(1));
        } else {
            composite.setBackground(display.getSystemColor(22));
        }
    }

    private void createGroupLock(Composite composite) {
        this.chkLock = new Button(composite, 32);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.chkLock.setLayoutData((Object)gridData);
        this.chkLock.setToolTipText("Allow view to be locked.");
        this.chkLock.setText("Lock view");
        ViewLocked = this.chkLock.getSelection();
        this.chkLock.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SpdView.this.LockAll(((Button)selectionEvent.getSource()).getSelection());
            }
        });
        this.chkLock.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
            }
        });
        this.chkLock.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                SpdView.this.LockAll(SpdView.this.spdProcessor.isM_bStatusProcessing());
            }
        });
    }

    private void ResetAll() {
        this.currentCursor = this.normalCursor;
        this.setPreferencesValues();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean LaunchPreprocessor() {
        boolean bl = true;
        if (!this.spdProcessor.isM_bStatusProcessing()) {
            if (this.spdProcessor.getSpdMode() != "server" && (this.spdProcessor.getSpdCommand() == null || this.spdProcessor.getSpdCommand().trim().equals(""))) {
                this.spdProcessor.setLogMessage(new PreprocessorMessage("Please select preprocessor program in spd preferences window", 0));
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayIn("Please select preprocessor program in spd preferences window");
                    return false;
                } else {
                    SWTUtils.errMsgAsync((String)"Please select preprocessor program in spd preferences window");
                }
                return false;
            }
            if (this.spdProcessor.isOffLine() && !this.checkSelectedFiles()) {
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayError(this.getPreprocessorErrorMessage());
                    return false;
                } else {
                    SWTUtils.errMsgAsync((String)this.getPreprocessorErrorMessage());
                }
                return false;
            }
            if (!this.checkFields(this.spdComposite, true)) {
                this.spdProcessor.setLogMessage(new PreprocessorMessage("Please check options fields. There are wrong values. ", 0));
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayError("Please check options fields. There are wrong values.");
                    return false;
                } else {
                    SWTUtils.errMsgAsync((String)"Please check options fields. There are wrong values.");
                }
                return false;
            }
            if (!this.isBSizeIsOk()) {
                bl = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Check size info message", (String)"One or several sample files don't have \nthe same size and won' t be processed.\nDo you want to continue ?");
            }
            if (!this.setOptions() || !bl) return false;
            this.spdProcessor.setM_bStatusProcessing(true);
            this.LockAll(true);
            this.spdProcessor.run();
            return true;
        } else {
            this.spdProcessor.stop();
            this.spdProcessor.setM_bStatusProcessing(false);
        }
        return true;
    }

    public boolean setOptions() {
        boolean bl = true;
        if (this.btnCorExtDefault.getSelection()) {
            this.spdProcessor.set_cor_ext("");
        } else if (this.btnCorExtNew.getSelection()) {
            this.spdProcessor.set_cor_ext(this.corExt.getText());
        }
        if (this.chkTypeBruker.getSelection()) {
            this.spdProcessor.set_src_ext("\\d+");
        } else if (this.chkTypeEdf.getSelection()) {
            this.spdProcessor.set_src_ext("edf");
        } else if (this.chkTypeOther.getSelection()) {
            this.spdProcessor.set_src_ext(this.txtTypeOther.getText());
        } else {
            this.spdProcessor.set_src_ext("");
        }
        this.spdProcessor.set_inp_const(this.inpConst.getText());
        this.spdProcessor.set_dark_ext(this.darkExt.getText());
        this.spdProcessor.set_save_dark(String.valueOf(this.cboSaveDark.getSelectionIndex()));
        this.spdProcessor.set_inp_factor(this.inpFactor.getText());
        this.spdProcessor.set_inp_exp(this.inpExp.getText());
        this.spdProcessor.set_dark_const(this.darkConst.getText());
        this.spdProcessor.setOtherOptions(this.otherSpdOption.getText());
        int n = this.getCboDoDist();
        this.spdProcessor.setDistortionAction(n);
        this.spdProcessor.setM_applyDarkCorrection(this.btnApplyDark.getSelection());
        this.spdProcessor.setM_applyDistCorrection(this.btnApplyDist.getSelection());
        this.spdProcessor.setM_applyFloodCorrection(this.btnApplyFlood.getSelection());
        if (this.btnApplyDark.getSelection()) {
            if (this.radioDarkFromFile.getSelection()) {
                this.spdProcessor.setM_darkFile(this.darkFile.getText());
            } else if (this.radioDarkInEdf.getSelection()) {
                this.spdProcessor.setM_darkFile("[DarkFileName]");
            } else {
                this.spdProcessor.setM_darkFile("");
            }
        }
        if (this.btnApplyDist.getSelection()) {
            if (this.radioDistInEdf.getSelection()) {
                this.spdProcessor.setM_distFile("[DistortionFileName]");
            } else if (this.radioDistFromFile.getSelection()) {
                this.spdProcessor.setM_distFile(this.distortionFile.getText());
            } else {
                this.spdProcessor.setM_distFile("");
            }
        }
        if (this.btnApplyFlood.getSelection()) {
            if (this.radioFloodInEdf.getSelection()) {
                this.spdProcessor.setM_floodFile("[FloodFileName]");
            } else if (this.radioFloodFromFile.getSelection()) {
                this.spdProcessor.setM_floodFile(this.floodFile.getText());
            } else {
                this.spdProcessor.setM_floodFile("");
            }
        }
        this.spdProcessor.setOtherOptions(this.otherSpdOption.getText());
        this.spdProcessor.setCompress(this.compressOriginalFiles.getSelection(), this.compressCorrectedFiles.getSelection(), this.zipProgram.getText());
        if (this.btn_float != null && this.btn_integer != null) {
            if (this.btn_float.getSelection()) {
                this.spdProcessor.setCorrectionType((String)this.btn_float.getData());
            } else {
                this.spdProcessor.setCorrectionType((String)this.btn_integer.getData());
            }
        }
        if (this.dvo != null) {
            this.spdProcessor.setDataValueOffset(this.dvo.getText());
        }
        return bl;
    }

    private void checkDarkSize() {
        if (this.radioDarkFromFile.getSelection() && this.btnApplyDark.getSelection() && !this.darkFile.getText().equals("")) {
            try {
                FabioFile fabioFile = new FabioFile(this.darkFile.getText());
                Job job = this.spdProcessor.getJobCheckSize();
                this.spdProcessor.checkSize(fabioFile);
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent iJobChangeEvent) {
                        if (!SpdView.this.spdProcessor.isSizeCheckedOk()) {
                            SpdView.this.bDarkSizeOk = false;
                        } else {
                            SpdView.this.bDarkSizeOk = true;
                        }
                    }
                });
            }
            catch (FabioFileException fabioFileException) {
                Activator.log("Error in checkSize while creating dark file", 4, (Exception)((Object)fabioFileException));
                FableMessageConsole.console.displayIn("Error in checkSize while creating dark file:" + fabioFileException.getMessage());
            }
        } else {
            this.resetFlag();
        }
    }

    private void checkFloodFile() {
        if (this.radioFloodFromFile.getSelection() && this.btnApplyFlood.getSelection() && !this.floodFile.getText().equals("")) {
            try {
                FabioFile fabioFile = new FabioFile(this.floodFile.getText());
                this.spdProcessor.checkSize(fabioFile);
                Job job = this.spdProcessor.getJobCheckSize();
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent iJobChangeEvent) {
                        if (!SpdView.this.spdProcessor.isSizeCheckedOk()) {
                            SpdView.this.bFloodFileSizeOk = false;
                        } else {
                            SpdView.this.bFloodFileSizeOk = true;
                        }
                    }
                });
            }
            catch (FabioFileException fabioFileException) {
                Activator.log("Error in checkSize() while creating flood file", 4, (Exception)((Object)fabioFileException));
                FableMessageConsole.console.displayError("Error checkSize while creating flood file:" + fabioFileException.getMessage());
            }
        } else {
            this.resetFlag();
        }
    }

    private void checkSize() {
        this.checkDarkSize();
        this.checkFloodFile();
    }

    private void resetFlag() {
        boolean bl = true;
        Vector<Sample> vector = this.spdProcessor.get_Samples();
        boolean bl2 = false;
        if (!this.btnApplyDark.getSelection() || !this.radioDarkFromFile.getSelection() || this.darkFile.getText().equals("")) {
            bl2 = true;
        }
        if (bl2) {
            bl2 = !this.btnApplyFlood.getSelection() || !this.radioFloodFromFile.getSelection() || this.floodFile.getText().equals("");
        }
        int n = 0;
        while (bl2 && vector != null && n < vector.size() && bl) {
            Sample sample = vector.elementAt(n);
            if (sample != null && sample.hasFile()) {
                int n2 = 0;
                while (n2 < sample.getFabioFiles().size()) {
                    ((FabioFile)sample.getFabioFiles().elementAt(n2)).setFlag(true);
                    ++n2;
                }
            }
            ++n;
        }
        if (bl2) {
            this.spdProcessor.fireShowFlag();
        }
    }

    private void EnableGrpExt() {
        this.grpspd_ext.setEnabled(true);
        this.btnCorExtNew.setEnabled(true);
        this.btnCorExtDefault.setEnabled(true);
        this.enableFieldOtherCorrection(this.btnCorExtNew.getSelection());
    }

    private void EnableGrpSrc() {
        this.grp_ExtensionFilter.setEnabled(true);
        this.chkTypeBruker.setEnabled(true);
        this.chkTypeEdf.setEnabled(true);
        this.chkTypeOther.setEnabled(true);
        this.enableFieldOther_src_ext(this.chkTypeOther.getSelection());
    }

    public void LockAll(boolean bl) {
        this.setEnableGroup(this.applyCorrection, !bl);
        this.setEnableGroup((Composite)this.grpOther, !bl);
        if (bl) {
            this.setDisableGroup((Composite)this.grpspd_ext);
            this.setDisableGroup((Composite)this.grp_ExtensionFilter);
            this.setDisableGroup((Composite)this.grpDistortion);
            this.setDisableGroup((Composite)this.grpFlood_spd);
            this.setDisableGroup((Composite)this.grpspd_dark);
            this.setDisableGroup((Composite)this.grpOther);
        } else {
            this.sendcontrolToDarkGroup();
            this.sendControlToFloodGroup();
            this.sendControlToDistGroup();
            this.EnableGrpExt();
            this.EnableGrpSrc();
        }
        ViewLocked = bl;
        if (bl) {
            statusManager.setMessage(this.imageLocked.createImage(), "Locked");
            if (this.spdProcessor.isM_bStatusProcessing()) {
                this.chkLock.setSelection(true);
                this.chkLock.setEnabled(false);
            } else {
                this.chkLock.setEnabled(true);
            }
            this.btnReset.setEnabled(false);
        } else {
            this.btnReset.setEnabled(true);
            statusManager.setMessage(this.imageUnLocked.createImage(), "Not locked");
            this.chkLock.setEnabled(true);
            this.chkLock.setSelection(false);
        }
        statusManager.update(true);
    }

    private void setImagebtnLaunch(boolean bl) {
        Image image = this.imagePlay.createImage();
        Image image2 = this.imagePause.createImage();
        final Image image3 = new Image((Device)this.display, image.getImageData().scaledTo((int)((double)image.getBounds().width * 1.2), (int)((double)image.getBounds().height * 1.2)));
        final Image image4 = new Image((Device)this.display, image2.getImageData().scaledTo((int)((double)image2.getBounds().width * 1.2), (int)((double)image2.getBounds().height * 1.2)));
        if (!bl) {
            this.btnValidate.setImage(image3);
            this.btnValidate.setToolTipText("Start processing files");
        } else {
            this.btnValidate.setImage(image4);
            this.btnValidate.setToolTipText("Stop processing files");
        }
        this.btnValidate.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                image4.dispose();
                image3.dispose();
            }
        });
    }

    public boolean checkFields(Composite composite, boolean bl) {
        Control[] controlArray = composite.getChildren();
        int n = 0;
        while (n < controlArray.length && bl) {
            if (controlArray[n] instanceof Composite) {
                if (controlArray[n] instanceof TypedText) {
                    TypedText typedText = (TypedText)controlArray[n];
                    boolean bl2 = bl = typedText.is_bValide() && bl;
                    if (bl) {
                        if (typedText.is_isRequiredField()) {
                            boolean bl3 = bl = !typedText.getText().trim().equals("");
                            if (!bl) {
                                this.setPreprocessorErrorMessage("Field " + typedText.toString() + "is required.");
                            }
                        }
                    } else {
                        this.setPreprocessorErrorMessage("Field " + typedText.toString() + "is not valid." + typedText.getErrorMessage());
                    }
                } else {
                    bl = this.checkFields((Composite)controlArray[n], bl);
                }
            }
            ++n;
        }
        return bl;
    }

    public boolean checkSelectedFiles() {
        boolean bl = false;
        if (this.spdProcessor.get_Samples() == null || this.spdProcessor.get_Samples().size() == 0) {
            bl = false;
        } else {
            Vector<Sample> vector = this.spdProcessor.get_Samples();
            int n = 0;
            while (!bl && n < vector.size()) {
                if (vector.elementAt(n).hasFile()) {
                    bl = true;
                }
                ++n;
            }
        }
        if (!bl) {
            this.setPreprocessorErrorMessage("Please select files to process");
            this.spdProcessor.fireShowRequiredFields();
        }
        return bl;
    }

    public String getPreprocessorErrorMessage() {
        return this.preprocessorErrormessage;
    }

    public void setPreprocessorErrorMessage(String string) {
        this.preprocessorErrormessage = string;
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.array.add(iPropertyChangeListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.array.remove(iPropertyChangeListener);
    }

    public void setTxtFileDark(String string) {
        this.darkFile.set_Text(string);
    }

    public void setTxtFileDist(String string) {
        this.distortionFile.set_Text(string);
    }

    public void setOtherSpdOption(String string) {
        this.otherSpdOption.setText(string);
    }

    private void setTxtFileFlood(String string) {
        this.floodFile.set_Text(string);
    }

    public boolean isLocked() {
        return this.chkLock.getSelection();
    }

    public void setSelectedMode(String string) {
        this.selectedMode = string;
        this.spdProcessor.setM_mode(string);
    }

    public void set_dark_ext(String string) {
        this.spdProcessor.set_dark_ext(string);
    }

    public void set_command(String string) {
        this.spdProcessor.setCommand(string);
    }

    public void set_DarkFile_mode(String string) {
        this.radioNoDarkFile.setSelection(string.equals("darkfileNoneRadio"));
        this.radioDarkFromFile.setSelection(string.equals("darkFromFileRadio"));
        this.radioDarkInEdf.setSelection(string.equals("darkHeaderRadio"));
        this.darkFile.setEnabled(string.equals("darkFromFileRadio"));
        this.darkFile.set_isRequiredField(string.equals("darkFromFileRadio"));
        this.darkFile.showDecoration();
    }

    public void set_FloodFile_mode(String string) {
        this.radioNoFloodFile.setSelection(string.equals("floodfileNoneRadio"));
        this.radioFloodFromFile.setSelection(string.equals("floodFromFileRadio"));
        this.radioFloodInEdf.setSelection(string.equals("floodHeaderRadio"));
        this.floodFile.setEnabled(string.equals("floodFromFileRadio"));
        this.floodFile.set_isRequiredField(string.equals("floodFromFileRadio"));
        this.floodFile.showDecoration();
    }

    public void set_DistFile_mode(String string) {
        this.radioNoDistFile.setSelection(string.equals("distfileNoneRadio"));
        this.radioDistFromFile.setSelection(string.equals("distFromFileRadio"));
        this.radioDistInEdf.setSelection(string.equals("distHeaderRadio"));
        this.darkFile.setEnabled(string.equals("distFromFileRadio"));
        this.distortionFile.set_isRequiredField(string.equals("distFromFileRadio"));
        this.distortionFile.showDecoration();
    }

    public void setEnableGroup(Composite composite, boolean bl) {
        Control[] controlArray = composite.getChildren();
        composite.setEnabled(bl);
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] instanceof Composite) {
                if (controlArray[n] instanceof Group) {
                    this.setEnableGroup((Composite)controlArray[n], bl);
                } else if (bl) {
                    controlArray[n].setBackground(this.display.getSystemColor(1));
                } else {
                    controlArray[n].setBackground(this.display.getSystemColor(22));
                }
            } else {
                controlArray[n].setEnabled(bl);
            }
            ++n;
        }
    }

    public void setDisableGroup(Composite composite) {
        Control[] controlArray = composite.getChildren();
        boolean bl = false;
        composite.setEnabled(bl);
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] instanceof Composite) {
                if (controlArray[n] instanceof Group) {
                    this.setDisableGroup((Composite)controlArray[n]);
                } else {
                    if (controlArray[n] instanceof TypedText) {
                        ((TypedText)controlArray[n]).set_isRequiredField(false);
                        ((TypedText)controlArray[n]).set_bValide(true);
                        ((TypedText)controlArray[n]).notifyListeners(24, new Event());
                    }
                    controlArray[n].setBackground(this.display.getSystemColor(22));
                }
            } else {
                controlArray[n].setEnabled(bl);
            }
            ++n;
        }
    }

    public Preprocessor getSpdProcessor() {
        return this.spdProcessor;
    }

    public String getSelectedMode() {
        return this.selectedMode;
    }

    public String getOnLineDirectory() {
        return this.onLineDirectory;
    }

    public boolean isBSizeHasBeenChecked() {
        return this.bSizeHasBeenChecked;
    }

    public boolean isBSizeIsOk() {
        return this.bFloodFileSizeOk && this.bDarkSizeOk;
    }

    public Display getDisplay() {
        return this.display;
    }

    public Composite getSpdComposite() {
        return this.spdComposite;
    }

    public Composite getApplyC() {
        return this.applyCorrection;
    }

    public Cursor getNormalCursor() {
        return this.normalCursor;
    }

    public Cursor getCurrentCursor() {
        return this.currentCursor;
    }

    public Button getChkLock() {
        return this.chkLock;
    }

    public Button getBtnReset() {
        return this.btnReset;
    }

    public String getSSampleDirectory() {
        return this.sSampleDirectory;
    }

    public Boolean getBtnApplyDark() {
        return this.btnApplyDark.getSelection();
    }

    public Boolean getBtnApplyFlood() {
        return this.btnApplyFlood.getSelection();
    }

    public Boolean getBtnApplyDist() {
        return this.btnApplyDist.getSelection();
    }

    public Boolean getChkTypeEdf() {
        return this.chkTypeEdf.getSelection();
    }

    public Boolean getChkTypeBruker() {
        return this.chkTypeBruker.getSelection();
    }

    public Boolean getChkTypeOther() {
        return this.chkTypeOther.getSelection();
    }

    public boolean getZip() {
        return this.compressOriginalFiles.getSelection();
    }

    public String getZipProgram() {
        return this.zipProgram.getText();
    }

    public String getTxtTypeOther() {
        return this.txtTypeOther.getText();
    }

    public String getCorExt() {
        return this.corExt.getText();
    }

    public boolean getCorExtDefault() {
        return this.btnCorExtDefault.getSelection();
    }

    public boolean getCorExtNew() {
        return this.btnCorExtNew.getSelection();
    }

    public String getDarkFile() {
        return this.darkFile.getText();
    }

    public FloatText getDarkConst() {
        return this.darkConst;
    }

    public StringText getDarkExt() {
        return this.darkExt;
    }

    public int getCboSaveDark() {
        return this.cboSaveDark.getSelectionIndex();
    }

    public Button getRadioDarkInEdf() {
        return this.radioDarkInEdf;
    }

    public Button getRadioDarkFromFile() {
        return this.radioDarkFromFile;
    }

    public boolean getRadioNoDarkFile() {
        return this.radioNoDarkFile.getSelection();
    }

    public boolean getRadioDistInEdf() {
        return this.radioDistInEdf.getSelection();
    }

    public boolean getRadioDistFromFile() {
        return this.radioDistFromFile.getSelection();
    }

    public boolean getRadioNoDistFile() {
        return this.radioNoDistFile.getSelection();
    }

    public boolean getRadioFloodInEdf() {
        return this.radioFloodInEdf.getSelection();
    }

    public boolean getRadioFloodFromFile() {
        return this.radioFloodFromFile.getSelection();
    }

    public boolean getRadioNoFloodFile() {
        return this.radioNoFloodFile.getSelection();
    }

    public boolean getOptionfloat() {
        return this.btn_float.getSelection();
    }

    public boolean getBtn_integer() {
        return this.btn_integer.getSelection();
    }

    public Float getInpConst() {
        return Float.valueOf(this.inpConst.getText());
    }

    public Float getInpExp() {
        return Float.valueOf(this.inpExp.getText());
    }

    public Float getInpFactor() {
        return Float.valueOf(this.inpFactor.getText());
    }

    public Integer getDvo() {
        return Integer.valueOf(this.dvo.getText());
    }

    public String getFloodFile() {
        return this.floodFile.getText();
    }

    public String getDistortionFile() {
        return this.distortionFile.getText();
    }

    public int getCboDoDist() {
        int n = 0;
        int n2 = this.cboDoDist.getSelectionIndex();
        switch (n2) {
            case 0: {
                n = 1;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
        }
        return n;
    }

    public String getOtherSpdOption() {
        return this.otherSpdOption.getText();
    }

    public Button getBtnValidate() {
        return this.btnValidate;
    }

    public IPropertyChangeListener getPreferencesListener() {
        return this.preferencesListener;
    }

    public ImageDescriptor getImagePause() {
        return this.imagePause;
    }

    public ImageDescriptor getImagePlay() {
        return this.imagePlay;
    }

    public ImageDescriptor getImageReset() {
        return this.imageReset;
    }

    public ImageDescriptor getImageLocked() {
        return this.imageLocked;
    }

    public ImageDescriptor getImageUnLocked() {
        return this.imageUnLocked;
    }

    public void setOnLineDirectory(String string) {
        this.onLineDirectory = string;
    }

    public void setBSizeHasBeenChecked(boolean bl) {
        this.bSizeHasBeenChecked = bl;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public void setApplyC(Composite composite) {
        this.applyCorrection = composite;
    }

    public void setNormalCursor(Cursor cursor) {
        this.normalCursor = cursor;
    }

    public void setCurrentCursor(Cursor cursor) {
        this.currentCursor = cursor;
    }

    public void setSSampleDirectory(String string) {
        this.sSampleDirectory = string;
    }

    public void setApplyDark(boolean bl) {
        this.btnApplyDark.setSelection(bl);
    }

    public void setApplyFlood(boolean bl) {
        this.btnApplyFlood.setSelection(bl);
    }

    public void setApplyDist(boolean bl) {
        this.btnApplyDist.setSelection(bl);
    }

    public void setChkTypeEdf(boolean bl) {
        this.chkTypeEdf.setSelection(bl);
    }

    public void setChkTypeBruker(boolean bl) {
        this.chkTypeBruker.setSelection(bl);
    }

    public void setChkTypeOther(boolean bl) {
        this.chkTypeOther.setSelection(bl);
    }

    public void setCompressOriginalFiles(boolean bl) {
        this.compressOriginalFiles.setSelection(bl);
        this.compressOriginalFiles.notifyListeners(13, new Event());
    }

    public void setCompressCorrectedFiles(boolean bl) {
        this.compressCorrectedFiles.setSelection(bl);
        this.compressCorrectedFiles.notifyListeners(13, new Event());
    }

    public void setZipProgram(String string) {
        this.zipProgram.set_Text(string);
    }

    public void setTxtTypeOther(String string) {
        this.txtTypeOther.set_Text(string);
    }

    public void setCorExt(String string) {
        this.corExt.set_Text(string);
    }

    public void setBtnCorExtDefault(boolean bl) {
        this.btnCorExtDefault.setSelection(bl);
    }

    public void setBtnCorExtNew(boolean bl) {
        this.btnCorExtNew.setSelection(bl);
    }

    public void setDarkFile(String string) {
        this.darkFile.set_Text(string);
    }

    public void setDarkConst(Float f) {
        this.darkConst.set_Text(String.valueOf(f));
    }

    public void setDarkExt(String string) {
        this.darkExt.set_Text(string);
    }

    public void setCboSaveDark(int n) {
        this.cboSaveDark.select(n);
    }

    public void setRadioDarkInEdf(boolean bl) {
        this.radioDarkInEdf.setSelection(bl);
    }

    public void setRadioDarkFromFile(boolean bl) {
        this.radioDarkFromFile.setSelection(bl);
    }

    public void setRadioNoDarkFile(boolean bl) {
        this.radioNoDarkFile.setSelection(bl);
    }

    public void setRadioDistInEdf(boolean bl) {
        this.radioDistInEdf.setSelection(bl);
    }

    public void setRadioDistFromFile(boolean bl) {
        this.radioDistFromFile.setSelection(bl);
    }

    public void setRadioNoDistFile(boolean bl) {
        this.radioNoDistFile.setSelection(bl);
    }

    public void setRadioFloodInEdf(boolean bl) {
        this.radioFloodInEdf.setSelection(bl);
    }

    public void setRadioFloodFromFile(boolean bl) {
        this.radioFloodFromFile.setSelection(bl);
    }

    public void setRadioNoFloodFile(boolean bl) {
        this.radioNoFloodFile.setSelection(bl);
    }

    public void setOptionFloat(boolean bl) {
        this.btn_float.setSelection(bl);
    }

    public void setOptionInteger(boolean bl) {
        this.btn_integer.setSelection(bl);
    }

    public void setInpConst(Float f) {
        this.inpConst.set_Text(String.valueOf(f));
    }

    public void setInpExp(Float f) {
        this.inpExp.set_Text(String.valueOf(f));
    }

    public void setInpFactor(Float f) {
        this.inpFactor.set_Text(String.valueOf(f));
    }

    public void setDvo(Integer n) {
        this.dvo.set_Text(String.valueOf(n));
    }

    public void setFloodFile(String string) {
        this.floodFile.set_Text(string);
    }

    public void setDistortionFile(String string) {
        this.distortionFile.set_Text(string);
    }

    public void setCboDoDist(int n) {
        this.cboDoDist.select(n);
    }

    public void setPreferencesListener(IPropertyChangeListener iPropertyChangeListener) {
        this.preferencesListener = iPropertyChangeListener;
    }

    public static String getID() {
        return ID;
    }

    public void dispose() {
        this.spdProcessor.removePreprocessorListener(this.listenPreprocessorChanges);
        this.spdProcessor.removePropertyChangeListener(this);
        this.spdProcessor.dispose();
    }

    class PreprocessListener
    implements IPreprocessorListener {
        PreprocessListener() {
        }

        @Override
        public void preprocessorChanged(PreprocessorEvent preprocessorEvent) {
            RunAction runAction = new RunAction();
            if (((Preprocessor)preprocessorEvent.getSource()).isM_bStatusProcessing()) {
                SpdView.this.currentCursor = SpdView.this.waitCursor;
                runAction.setText("Stop");
            } else {
                SpdView.this.currentCursor = SpdView.this.normalCursor;
                runAction.setText("Run");
            }
            if (!SpdView.this.display.isDisposed()) {
                SpdView.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        SpdView.this.setImagebtnLaunch(SpdView.this.spdProcessor.isM_bStatusProcessing());
                        SpdView.this.shell.setCursor(SpdView.this.currentCursor);
                        SpdView.this.LockAll(SpdView.this.spdProcessor.isM_bStatusProcessing());
                    }
                });
            }
        }

        @Override
        public void preprocessorModeChange(PreprocessorEvent preprocessorEvent) {
            SpdView.this.selectedMode = ((Preprocessor)preprocessorEvent.getSource()).getM_mode();
            SpdView.this.selectedMode.equals("ON");
            ((Preprocessor)preprocessorEvent.getSource()).getM_mode().equals("OFF");
        }

        @Override
        public void preprocessorNewMessage(PreprocessorEvent preprocessorEvent) {
            Preprocessor preprocessor = (Preprocessor)preprocessorEvent.getSource();
            if (FableMessageConsole.console != null) {
                PreprocessorMessage preprocessorMessage = preprocessor.getLogMessage();
                switch (preprocessorMessage.getM_Type()) {
                    case 1: {
                        FableMessageConsole.console.displayInfo(preprocessorMessage.getM_Message());
                        break;
                    }
                    case 0: {
                        FableMessageConsole.console.displayError(preprocessorMessage.getM_Message());
                        break;
                    }
                    case 2: {
                        FableMessageConsole.console.displayOut(preprocessorMessage.getM_Message());
                    }
                }
            } else {
                SWTUtils.errMsgAsync((String)preprocessor.getLogMessage().getM_Message());
            }
        }

        @Override
        public void preprocessorStateChange(PreprocessorEvent preprocessorEvent) {
        }

        @Override
        public void preprocessorNewSample(PreprocessorEvent preprocessorEvent) {
            SpdView.this.checkSize();
        }
    }
}

