/*
 * Decompiled with CFR 0.152.
 */
package fable.preprocessor.views;

import fable.framework.toolbox.FileText;
import fable.framework.toolbox.LookAndFeel;
import fable.framework.toolbox.StringText;
import fable.framework.toolbox.ToolBox;
import fable.framework.ui.internal.MainStatusBar;
import fable.framework.views.FableMessageConsole;
import fable.imageviewer.views.ImageView;
import fable.preprocessor.Activator;
import fable.preprocessor.actions.RunAction;
import fable.preprocessor.process.IPreprocessorListener;
import fable.preprocessor.process.Preprocessor;
import fable.preprocessor.process.PreprocessorEvent;
import fable.python.Experiment;
import fable.python.FabioFile;
import fable.python.FabioFileException;
import fable.python.ISampleListener;
import fable.python.Sample;
import fable.python.SampleEvent;
import fable.python.contentprovider.SampleTableContentProvider;
import fable.python.labelprovider.SampleTablelabelProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import java.util.regex.Pattern;
import jep.JepException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ProcessingView
extends ViewPart
implements IPropertyChangeListener,
Preferences.IPropertyChangeListener {
    public static final String ID = "fable.preprocessor.views.processing";
    public static ProcessingView view;
    private String[] files;
    private String fileDescription;
    private String[] selectedSamples;
    private String[] currentSelectedFiles;
    private String[] list;
    private String experimentName = "NA";
    private String sampleName = "NA";
    private String currentExtension = ".cor";
    private Vector<String> titles = new Vector();
    Vector<String> listFiles = null;
    String regularExpressionForExtension;
    private int numberFiles;
    private int columnIndexSelected = -1;
    private Color descriptionColor;
    private int currentIndexSample = 0;
    public Preprocessor spdProcessor = Preprocessor.getDefault();
    boolean bAdded = false;
    private ImageDescriptor GifDelete = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/delete.gif");
    private ImageDescriptor GifRemove = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/subtract.gif");
    private ImageDescriptor GifAdd = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/add.gif");
    private ImageDescriptor gifViewimage = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/ImageView.gif");
    private ImageDescriptor gifbrowncross = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/brownCross.gif");
    private ImageDescriptor gifUpdate = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/refresh.gif");
    private Image imgDelete;
    private Image imgadd;
    private Image imgRemove;
    private Image imgUpdate;
    private Image imgMenuRemove;
    private Image imgMenuView;
    private final Color light_blue = new Color((Device)Display.getCurrent(), 228, 247, 248);
    private final Color light_Red = new Color((Device)Display.getCurrent(), 249, 172, 168);
    private final Color light_Green = new Color((Device)Display.getCurrent(), 168, 249, 200);
    private Button btnRemoveSelect;
    private Button btnRemoveDirectory;
    private Button addKeyInTab;
    private Button removeKeyInTable;
    private TableColumn columnSelected;
    private FileText stextSampleDirectory;
    private ArrayList<IPropertyChangeListener> array = new ArrayList();
    private IPropertyChangeListener preferencesListener;
    private Listener sortListener;
    private SampleListener sampleListener;
    private Sample sample;
    Sample singleSample = null;
    private Vector<Sample> listOfSamples;
    private Job job;
    private Table table;
    private TableViewer directoryTable;
    private SashForm sash;
    private List listKeys;
    private Button chkProcessPrevious;
    private FabioFile f_fabio;
    private Button selectFilesButton;
    private Display display;
    private Vector<FabioFile> sort;
    IStatus job_status;
    private PreprocessListener preprocessorListener;
    private String filter = "";
    private StringText textFilter;
    private Button btnApplyfilter;
    private Button btnClearfilter;
    private Text labelTextFilter;
    Image imgApply;
    Image imgClear;
    private boolean applyFilter = false;
    private ImageDescriptor imageApply = Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)"images/check.gif");

    private void initVariables() {
        this.display = Display.getCurrent();
        this.getViewSite().getActionBars().setGlobalActionHandler("fable.preprocessor.actions.RunAction", (IAction)new RunAction());
        view = this;
        view.setContentDescription("Select files to process here");
        this.filter = Activator.getDefault().getPreferenceStore().getString("pref_sampleNavigator_stem");
        this.imgDelete = this.GifDelete.createImage();
        this.imgadd = this.GifAdd.createImage();
        this.imgRemove = this.GifRemove.createImage();
        this.imgUpdate = this.gifUpdate.createImage();
        this.listOfSamples = new Vector();
        this.sampleListener = new SampleListener();
        this.preprocessorListener = new PreprocessListener();
        this.spdProcessor.addPreprocessorListener(this.preprocessorListener);
        this.spdProcessor.addPropertyChangeListener(this);
        this.preferencesListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("pref_sampleNavigator_type")) {
                    System.out.println("Property change event from navigator preferences");
                    ProcessingView.this.regularExpressionForExtension = fable.framework.navigator.Activator.getDefault().getPreferenceStore().getString("pref_sampleNavigator_type");
                    ProcessingView.this.selectFilesButton.setToolTipText("Files loaded with extension (See Preferences/Fabio files) : " + ProcessingView.this.regularExpressionForExtension);
                } else if (propertyChangeEvent.getProperty().equals("pref_sampleNavigator_stem")) {
                    ProcessingView.this.filter = Activator.getDefault().getPreferenceStore().getString("pref_sampleNavigator_stem");
                    ProcessingView.this.textFilter.set_Text(ProcessingView.this.filter);
                    ProcessingView.this.setFilter();
                }
            }
        };
        fable.framework.navigator.Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.preferencesListener);
        this.regularExpressionForExtension = fable.framework.navigator.Activator.getDefault().getPreferenceStore().getString("pref_sampleNavigator_type");
        this.sortListener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn tableColumn = ProcessingView.this.table.getSortColumn();
                TableColumn tableColumn2 = (TableColumn)event.widget;
                int n = ProcessingView.this.table.getSortDirection();
                if (tableColumn == tableColumn2) {
                    n = n == 128 ? 1024 : 128;
                } else {
                    ProcessingView.this.table.setSortColumn(tableColumn2);
                    n = 1024;
                }
                TableColumn[] tableColumnArray = ProcessingView.this.table.getColumns();
                final TableColumn tableColumn3 = (TableColumn)event.widget;
                ProcessingView.this.columnSelected = (TableColumn)event.widget;
                boolean bl = false;
                final int n2 = 0;
                while (!bl && tableColumnArray != null && n2 < tableColumnArray.length) {
                    if (ProcessingView.this.columnSelected == tableColumnArray[n2]) {
                        ProcessingView.this.columnIndexSelected = n2;
                        bl = true;
                    }
                    ++n2;
                }
                ProcessingView.this.sample.setComparator((String)ProcessingView.this.columnSelected.getData("key"), n);
                if (ProcessingView.this.columnIndexSelected > 1) {
                    ProcessingView.this.removeKeyInTable.setEnabled(true);
                } else {
                    ProcessingView.this.removeKeyInTable.setEnabled(false);
                }
                n2 = n;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ProcessingView.this.sort = ProcessingView.this.sample.getSortedFiles();
                                ProcessingView.this.setSelectedFiles();
                                ProcessingView.this.table.setSortDirection(n2);
                                ProcessingView.this.table.setSortColumn(tableColumn3);
                                int n = 0;
                                while (n < ProcessingView.this.table.getItemCount()) {
                                    ProcessingView.this.table.getItem(n).setBackground(n % 2 == 0 ? Display.getCurrent().getSystemColor(1) : ProcessingView.this.light_blue);
                                    ++n;
                                }
                            }
                        });
                    }
                }).run();
            }
        };
    }

    private void setFilter() {
        if (this.sample != null) {
            int n;
            if (this.applyFilter) {
                n = 0;
                while (n < this.listOfSamples.size()) {
                    this.listOfSamples.elementAt(n).setFilter(this.filter);
                    ++n;
                }
            }
            this.sample.setFilter(this.filter);
            this.sort = this.sample.getFilteredfiles();
            this.updateFilterInfo();
            n = this.sort.size() + 1;
            this.table.setItemCount(n);
            this.setSelectedFiles();
        }
    }

    public void createPartControl(Composite composite) {
        this.initVariables();
        this.titles.add(0, "#");
        this.titles.add(1, "name");
        GridLayout gridLayout = new GridLayout(1, true);
        composite.setLayout((Layout)gridLayout);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("pref_ext_COR")) {
                    ProcessingView.this.currentExtension = "." + Activator.getDefault().getPreferenceStore().getString("pref_ext_COR");
                }
            }
        });
        this.createInfoExperiment(composite);
        this.createTabListe(composite);
        this.enableGroupExperiment(!this.spdProcessor.isOnLine());
        this.clearFilter();
        this.updateStatusLine();
    }

    public void setVisibleProcessPreviousFiles(boolean bl) {
        this.chkProcessPrevious.setVisible(bl);
    }

    private void createInfoExperiment(Composite composite) {
        Group group = LookAndFeel.getGroup((Composite)composite, (String)"Image browser", (int)4, (int)1);
        GridData gridData = new GridData(4, 16, true, false);
        gridData.horizontalSpan = 3;
        this.stextSampleDirectory = new FileText((Composite)group, 4, "Directory");
        this.stextSampleDirectory.set_isRequiredField(true);
        this.stextSampleDirectory.setLayoutData((Object)gridData);
        this.selectFilesButton = new Button((Composite)group, 28);
        this.selectFilesButton.setText("Select directory...");
        this.selectFilesButton.setEnabled(true);
        this.selectFilesButton.setToolTipText("Files loaded with extension (See Preferences/Fabio files) : " + this.regularExpressionForExtension);
        this.selectFilesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Activator.log("ProcessingView :click on selectFilesButton");
                DirectoryDialog directoryDialog = new DirectoryDialog(Display.getDefault().getActiveShell());
                directoryDialog.setFilterPath(ProcessingView.this.stextSampleDirectory.getText());
                String string = directoryDialog.open();
                if (string != null) {
                    ProcessingView.this.addDirectory(string);
                }
            }
        });
    }

    public void addDirectory(final String string) {
        this.setExperimentAndSampleName(string);
        this.job = new Job("Loading directory " + this.sampleName){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                if (ProcessingView.this.listOfSamples == null) {
                    ProcessingView.this.listOfSamples = new Vector();
                }
                final String[] stringArray = ProcessingView.this.loadSample(string);
                iProgressMonitor.beginTask(ProcessingView.this.sampleName, stringArray.length);
                ProcessingView.this.job_status = Status.OK_STATUS;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ProcessingView.this.sample = new Sample(ProcessingView.this.experimentName, ProcessingView.this.sampleName, string, stringArray);
                            ProcessingView.this.listOfSamples.add(ProcessingView.this.sample);
                        }
                        catch (FabioFileException fabioFileException) {
                            FableMessageConsole.console.displayError("An error occured while loding directory : " + fabioFileException.getMessage());
                        }
                    }
                });
                if (iProgressMonitor.isCanceled()) {
                    ProcessingView.this.listOfSamples.remove(ProcessingView.this.sample);
                    ProcessingView.this.sample = null;
                    return Status.CANCEL_STATUS;
                }
                if (ProcessingView.this.sort == null) {
                    ProcessingView.this.sort = new Vector();
                }
                if (ProcessingView.this.applyFilter) {
                    ProcessingView.this.sample.setFilter(ProcessingView.this.filter);
                } else {
                    ProcessingView.this.sample.setFilter("");
                }
                ProcessingView.this.sort = ProcessingView.this.sample.getFilteredfiles();
                ((Sample)ProcessingView.this.listOfSamples.lastElement()).setCurrentFilesFromFabio();
                iProgressMonitor.done();
                iProgressMonitor.beginTask("Files are stored. Show them in table now", stringArray.length);
                ProcessingView.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ProcessingView.this.populateTreeSample();
                    }
                });
                if (iProgressMonitor.isCanceled()) {
                    ProcessingView.this.listOfSamples.remove(ProcessingView.this.sample);
                    ProcessingView.this.sample = null;
                    return Status.CANCEL_STATUS;
                }
                ProcessingView.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ProcessingView.this.currentIndexSample = ProcessingView.this.listOfSamples.indexOf(ProcessingView.this.sample);
                        ProcessingView.this.setCurrentSample(ProcessingView.this.currentIndexSample);
                        Preprocessor.getDefault().fireSampleHasChanged();
                    }
                });
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }
        };
        this.job.setUser(true);
        this.job.schedule();
    }

    private void updateCurrentSampleInfos(int n) {
        this.stextSampleDirectory.set_Text(this.sample.getDirectoryPath());
        if (this.directoryTable.getTable().getItemCount() > 0) {
            this.directoryTable.getTable().setSelection(this.directoryTable.getTable().getItem(n));
            this.directoryTable.getTable().notifyListeners(13, new Event());
        }
    }

    private void setCurrentSample(int n) {
        if (this.listOfSamples != null && this.listOfSamples.size() > 0) {
            this.sample = this.listOfSamples.elementAt(n);
            if (this.sample.hasFile()) {
                this.sample.setCurrentFile((FabioFile)this.sample.getFilteredfiles().elementAt(0));
                this.f_fabio = this.sample.getCurrentFabioFile();
                this.updateFilterInfo();
            }
            this.updateCurrentSampleInfos(n);
        } else {
            this.clearAll();
        }
    }

    private void addFilterTextfield(Group group) {
        this.imgApply = this.imageApply.createImage();
        this.imgClear = this.GifDelete.createImage();
        GridData gridData = new GridData(4, 2, true, false);
        gridData.horizontalSpan = 1;
        this.textFilter = new StringText((Composite)group, 0, "Filter");
        this.textFilter.getTextField().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 13 || keyEvent.keyCode == 0x1000050) {
                    String string = ((Text)keyEvent.widget).getText();
                    ProcessingView.this.filter = string;
                    ProcessingView.this.setFilter();
                }
            }
        });
        this.textFilter.setLayoutData((Object)gridData);
        this.textFilter.set_Text(this.filter);
        this.btnApplyfilter = new Button((Composite)group, 8);
        this.btnApplyfilter.setImage(this.imgApply);
        this.btnApplyfilter.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (ProcessingView.this.imgApply != null && !ProcessingView.this.imgApply.isDisposed()) {
                    ProcessingView.this.imgApply.dispose();
                }
            }
        });
        this.btnApplyfilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProcessingView.this.filter = ProcessingView.this.textFilter.getText();
                ProcessingView.this.setFilter();
            }
        });
        GridData gridData2 = new GridData(4, 0x1000000, false, false);
        this.btnApplyfilter.setLayoutData((Object)gridData2);
        this.btnClearfilter = new Button((Composite)group, 8);
        this.btnClearfilter.setImage(this.imgClear);
        this.btnClearfilter.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (ProcessingView.this.imgClear != null && !ProcessingView.this.imgClear.isDisposed()) {
                    ProcessingView.this.imgClear.dispose();
                }
            }
        });
        this.btnClearfilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProcessingView.this.filter = "";
                ProcessingView.this.textFilter.set_Text("");
                ProcessingView.this.setFilter();
            }
        });
        GridData gridData3 = new GridData(4, 0x1000000, false, false);
        this.btnClearfilter.setLayoutData((Object)gridData3);
        this.labelTextFilter = new Text((Composite)group, 786440);
        this.labelTextFilter.setEditable(false);
        this.labelTextFilter.setBackground(Display.getDefault().getSystemColor(22));
        this.labelTextFilter.setForeground(Display.getDefault().getSystemColor(8));
        GridData gridData4 = new GridData(4, 0x1000000, true, false);
        this.labelTextFilter.setLayoutData((Object)gridData4);
    }

    private void clearFilter() {
        this.labelTextFilter.setText("no filter");
        this.textFilter.set_Text("");
    }

    private void updateFilterInfo() {
        if (this.sample != null) {
            if (this.sample.getFilter().equals("")) {
                this.clearFilter();
            } else {
                int n = this.sample.getFabioFiles().size();
                int n2 = 0;
                if (this.sort != null) {
                    n2 = this.sort.size();
                }
                this.labelTextFilter.setText(String.valueOf(n2) + "/" + n + " files");
                this.textFilter.set_Text(this.sample.getFilter());
            }
        }
    }

    private void createTabListe(Composite composite) {
        int n = 4;
        Group group = LookAndFeel.getGroup((Composite)composite, (String)"Files", (int)n, (int)1);
        GridData gridData = new GridData(4, 4, true, true);
        group.setLayoutData((Object)gridData);
        Composite composite2 = new Composite((Composite)group, 0);
        composite2.setLayout((Layout)new GridLayout(n, false));
        composite2.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        ((GridData)composite2.getLayoutData()).horizontalSpan = n;
        Label label = new Label(composite2, 0);
        label.setText("Header Key");
        this.listKeys = new List(composite2, 2560);
        GridData gridData2 = new GridData(4, 2, true, false);
        gridData2.verticalSpan = 1;
        gridData2.horizontalSpan = 1;
        int n2 = this.listKeys.getItemHeight() * n;
        Rectangle rectangle = this.listKeys.computeTrim(0, 0, 0, n2);
        gridData2.heightHint = rectangle.height;
        this.listKeys.setLayoutData((Object)gridData2);
        this.listKeys.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                ProcessingView.this.addColumn();
            }
        });
        this.listKeys.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 13 || keyEvent.keyCode == 0x1000050) {
                    ProcessingView.this.addColumn();
                }
            }
        });
        this.addKeyInTab = new Button(composite2, 8);
        this.addKeyInTab.setImage(this.imgadd);
        this.addKeyInTab.setToolTipText("Add selected key in table");
        this.addKeyInTab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProcessingView.this.addColumn();
            }
        });
        this.addKeyInTab.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (ProcessingView.this.imgadd != null) {
                    ProcessingView.this.imgadd.dispose();
                }
            }
        });
        this.removeKeyInTable = new Button(composite2, 8);
        this.removeKeyInTable.setImage(this.imgRemove);
        this.removeKeyInTable.setToolTipText("Remove selected column");
        this.removeKeyInTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProcessingView.this.removeColumn();
            }
        });
        this.removeKeyInTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (ProcessingView.this.imgRemove != null) {
                    ProcessingView.this.imgRemove.dispose();
                }
            }
        });
        this.removeKeyInTable.setEnabled(false);
        this.addFilterTextfield(group);
        this.addPocessAllFiles((Composite)group);
        this.sash = new SashForm((Composite)group, 256);
        GridData gridData3 = new GridData(4, 4, true, true);
        gridData3.horizontalAlignment = 4;
        gridData3.verticalAlignment = 4;
        gridData3.horizontalSpan = n;
        this.sash.setLayoutData((Object)gridData3);
        GridData gridData4 = new GridData(4, 4, true, true);
        gridData4.horizontalSpan = 1;
        this.directoryTable = new TableViewer((Composite)this.sash, 2048);
        this.directoryTable.setContentProvider((IContentProvider)new SampleTableContentProvider());
        this.directoryTable.setLabelProvider((IBaseLabelProvider)new SampleTablelabelProvider());
        this.directoryTable.getTable().setHeaderVisible(true);
        this.directoryTable.getTable().setLinesVisible(true);
        this.directoryTable.getTable().addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
                if (mouseEvent.button == 3) {
                    Menu menu = new Menu((Decorations)Display.getCurrent().getActiveShell(), 8);
                    MenuItem menuItem = new MenuItem(menu, 8);
                    ProcessingView.this.imgMenuRemove = ProcessingView.this.GifDelete.createImage();
                    menuItem.setImage(ProcessingView.this.imgMenuRemove);
                    menuItem.setText("Remove from list");
                    menuItem.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            ProcessingView.this.btnRemoveDirectory.notifyListeners(13, new Event());
                        }
                    });
                    menu.setVisible(true);
                    while (!menu.isDisposed() && menu.isVisible()) {
                        if (Display.getCurrent().readAndDispatch()) continue;
                        Display.getCurrent().sleep();
                    }
                    menuItem.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent disposeEvent) {
                            if (ProcessingView.this.imgMenuRemove != null) {
                                ProcessingView.this.imgMenuRemove.dispose();
                            }
                        }
                    });
                    menu.dispose();
                }
            }

            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        this.directoryTable.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = ((Table)selectionEvent.widget).getSelection();
                if (tableItemArray != null && tableItemArray.length > 0) {
                    ProcessingView.this.sample = (Sample)tableItemArray[0].getData();
                    if (ProcessingView.this.sample != null) {
                        if (ProcessingView.this.sample.hasFile()) {
                            ProcessingView.this.currentSelectedFiles = ProcessingView.this.sample.getFiles();
                            ProcessingView.this.sort = ProcessingView.this.sample.getFilteredfiles();
                            ProcessingView.this.setSelectedFiles();
                            if (ProcessingView.this.sample.hasFile()) {
                                ProcessingView.this.sample.setCurrentFile((FabioFile)ProcessingView.this.sample.getFilteredfiles().elementAt(0));
                                ProcessingView.this.f_fabio = ProcessingView.this.sample.getCurrentFabioFile();
                                ProcessingView.this.table.setSelection(1);
                            }
                        } else {
                            ProcessingView.this.currentSelectedFiles = null;
                            ProcessingView.this.populateFileTable("No files to process found in sample", null);
                        }
                        ProcessingView.this.stextSampleDirectory.set_Text(ProcessingView.this.sample.getDirectoryPath());
                        ProcessingView.this.populateCombo();
                        ProcessingView.this.spdProcessor.fireCurrentSampleHasChanged(ProcessingView.this.stextSampleDirectory.getText(), ProcessingView.this.sampleName);
                    }
                }
            }
        });
        this.table = new Table((Composite)this.sash, 268503042);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData gridData5 = new GridData(4, 4, true, true);
        gridData5.horizontalSpan = 3;
        gridData5.verticalIndent = 10;
        this.table.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TableItem tableItem = (TableItem)event.item;
                int n = event.index;
                int n2 = n - 1;
                try {
                    FabioFile fabioFile = (FabioFile)ProcessingView.this.sort.elementAt(n2);
                    tableItem.setData((Object)fabioFile);
                    tableItem.setText(0, "" + n2);
                    tableItem.setText(1, fabioFile.getFileName());
                    int n3 = 2;
                    while (n3 < ProcessingView.this.titles.size()) {
                        try {
                            tableItem.setText(n3, fabioFile.getValue((String)ProcessingView.this.titles.elementAt(n3)));
                        }
                        catch (FabioFileException fabioFileException) {
                            tableItem.setText(n3, "NA");
                            FableMessageConsole.console.displayIn("Processing View : " + fabioFileException.getMessage() + tableItem.getText(1));
                            Activator.log("Error while populate table in ProcessingView", 4, (Exception)((Object)fabioFileException));
                        }
                        ++n3;
                    }
                    tableItem.setBackground(n2 % 2 == 0 ? Display.getCurrent().getSystemColor(1) : ProcessingView.this.light_blue);
                    if (!fabioFile.getFlag()) {
                        tableItem.setImage(0, ProcessingView.this.gifbrowncross.createImage());
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    Activator.log("An error occured in processing view while trying to populate file table", 4, indexOutOfBoundsException);
                    FableMessageConsole.console.displayIn("Processing View : " + indexOutOfBoundsException.getMessage());
                }
            }
        });
        this.table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
                if (mouseEvent.button == 3 && ProcessingView.this.table.getSelectionIndex() > 0) {
                    Menu menu = new Menu((Decorations)Display.getCurrent().getActiveShell(), 8);
                    MenuItem menuItem = new MenuItem(menu, 0);
                    new MenuItem(menu, 2);
                    Menu menu2 = new Menu(menu);
                    MenuItem menuItem2 = new MenuItem(menu, 64);
                    menuItem2.setText("Open image...");
                    ImageData imageData = ProcessingView.this.gifViewimage.createImage().getImageData();
                    ProcessingView.this.imgMenuView = new Image((Device)Display.getDefault(), imageData.scaledTo(imageData.width / 7, imageData.height / 7));
                    menuItem2.setImage(ProcessingView.this.imgMenuView);
                    menuItem2.setMenu(menu2);
                    menuItem2.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent disposeEvent) {
                            if (ProcessingView.this.imgMenuView != null) {
                                ProcessingView.this.imgMenuView.dispose();
                            }
                        }
                    });
                    MenuItem menuItem3 = new MenuItem(menu2, 0);
                    menuItem3.setText("View image");
                    menuItem.setText("Remove from list");
                    ProcessingView.this.imgMenuRemove = ProcessingView.this.GifDelete.createImage();
                    menuItem.setImage(ProcessingView.this.imgMenuRemove);
                    menuItem.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            ProcessingView.this.btnRemoveSelect.notifyListeners(13, new Event());
                        }
                    });
                    menuItem3.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            ProcessingView.this.f_fabio = (FabioFile)ProcessingView.this.table.getItem(ProcessingView.this.table.getSelectionIndex()).getData();
                            try {
                                ImageView imageView = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", "0", 1);
                                if (imageView != null && ProcessingView.this.f_fabio != null) {
                                    imageView.loadFile(ProcessingView.this.f_fabio);
                                    imageView.getImage().displayImage();
                                }
                            }
                            catch (PartInitException partInitException) {
                                FableMessageConsole.console.displayIn("View can not be opened ");
                                Activator.log("Error opening Sample view  from preprocessor.", 4, (Exception)((Object)partInitException));
                            }
                        }
                    });
                    MenuItem menuItem4 = new MenuItem(menu2, 0);
                    menuItem4.setText("View its current corrected image.");
                    menuItem4.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            int n;
                            TableItem tableItem = ProcessingView.this.table.getItem(ProcessingView.this.table.getSelectionIndex());
                            tableItem.getText(1);
                            String string = tableItem.getText(1);
                            ProcessingView.this.currentExtension = Preprocessor.getDefault().get_cor_ext();
                            if (string.contains(".gz") && (n = string.lastIndexOf("gz")) > 0) {
                                string = string.substring(0, n - 1);
                            }
                            String string2 = Preprocessor.getFileNameOfCorrectedFile(string, ProcessingView.this.currentExtension);
                            if (Preprocessor.getDefault().isZipCorrectedFiles()) {
                                string2 = String.valueOf(string2) + ".gz";
                            }
                            string2 = String.valueOf(ProcessingView.this.sample.getDirectoryPath()) + System.getProperty("file.separator") + string2;
                            try {
                                FabioFile fabioFile = new FabioFile(string2);
                                try {
                                    ImageView imageView = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", "1", 1);
                                    if (imageView != null) {
                                        imageView.loadFile(fabioFile);
                                        imageView.getImage().displayImage();
                                    }
                                }
                                catch (PartInitException partInitException) {
                                    FableMessageConsole.console.displayIn("View can not be opened ");
                                    Activator.log("Error opening Sample view  from preprocessor.", 4, (Exception)((Object)partInitException));
                                }
                            }
                            catch (FabioFileException fabioFileException) {
                                FableMessageConsole.console.displayIn("File " + string2 + "  not found");
                            }
                        }
                    });
                    menu.setVisible(true);
                    while (!menu.isDisposed() && menu.isVisible()) {
                        if (Display.getCurrent().readAndDispatch()) continue;
                        Display.getCurrent().sleep();
                    }
                    menu.dispose();
                    menu2.dispose();
                }
            }

            public void mouseUp(MouseEvent mouseEvent) {
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TableItem[] tableItemArray = ProcessingView.this.table.getSelection();
                if (tableItemArray != null && tableItemArray.length > 0) {
                    ProcessingView.this.f_fabio = (FabioFile)tableItemArray[0].getData();
                    ProcessingView.this.populateCombo();
                }
            }
        });
        this.initColumn();
        this.descriptionColor = this.display.getSystemColor(1);
        this.btnRemoveDirectory = new Button((Composite)group, 8);
        GridData gridData6 = new GridData(1, 0, true, false);
        gridData6.horizontalSpan = 1;
        this.btnRemoveDirectory.setLayoutData((Object)gridData6);
        this.btnRemoveDirectory.setImage(this.imgDelete);
        this.btnRemoveDirectory.setText("Remove directory");
        this.btnRemoveDirectory.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (ProcessingView.this.imgDelete != null) {
                    ProcessingView.this.imgDelete.dispose();
                }
            }
        });
        Button button = new Button((Composite)group, 8);
        GridData gridData7 = new GridData(1, 0, true, false);
        gridData7.horizontalSpan = 1;
        button.setLayoutData((Object)gridData6);
        button.setImage(this.imgUpdate);
        button.setText("Update directory");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProcessingView.this.updateDirectory();
                int n = ProcessingView.this.sort.size() + 1;
                ProcessingView.this.table.setItemCount(n);
            }
        });
        button.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (ProcessingView.this.imgUpdate != null && !ProcessingView.this.imgUpdate.isDisposed()) {
                    ProcessingView.this.imgUpdate.dispose();
                }
            }
        });
        this.btnRemoveDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProcessingView.this.removeSelectedSample(ProcessingView.this.sample);
                int n = ProcessingView.this.listOfSamples.size() > 0 ? ProcessingView.this.listOfSamples.size() - 1 : 0;
                ProcessingView.this.currentIndexSample = n;
                ProcessingView.this.setCurrentSample(n);
            }
        });
        this.btnRemoveSelect = new Button((Composite)group, 8);
        GridData gridData8 = new GridData(0x1000008, 0, true, false);
        gridData8.horizontalSpan = 1;
        this.btnRemoveSelect.setLayoutData((Object)gridData8);
        this.btnRemoveSelect.setImage(this.imgDelete);
        this.btnRemoveSelect.setText("Remove files");
        this.btnRemoveSelect.setToolTipText("Remove selected files");
        this.btnRemoveSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProcessingView.this.removeSelectedFiles();
            }
        });
        this.btnRemoveSelect.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (ProcessingView.this.imgDelete != null) {
                    ProcessingView.this.imgDelete.dispose();
                }
            }
        });
        this.sash.setWeights(new int[]{20, 50});
    }

    private void addPocessAllFiles(Composite composite) {
        this.chkProcessPrevious = new Button(composite, 32);
        this.chkProcessPrevious.setSelection(true);
        this.spdProcessor.processAll = this.chkProcessPrevious.getSelection();
        this.chkProcessPrevious.setText("Process files previously scanned");
        this.chkProcessPrevious.setToolTipText("Online mode only: if checked, process current sample files scanned before launching preprocessessor.");
        this.chkProcessPrevious.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ProcessingView.this.spdProcessor.processAll = ((Button)selectionEvent.widget).getSelection();
            }
        });
    }

    private void removeColumn() {
        if (this.columnSelected != null && this.columnIndexSelected > 1 && this.columnIndexSelected < this.table.getColumnCount()) {
            this.columnSelected.dispose();
            this.titles.removeElementAt(this.columnIndexSelected);
            int n = 0;
            while (n < this.titles.size()) {
                this.table.getColumn(n).pack();
                ++n;
            }
        }
    }

    private void removeAllColumnsAdded() {
        int n = 2;
        while (this.table.getColumnCount() > 2) {
            this.table.getColumn(n).dispose();
            this.titles.removeElementAt(n);
        }
        int n2 = 0;
        while (n2 < this.titles.size()) {
            this.table.getColumn(n2).pack();
            ++n2;
        }
    }

    private void addColumn() {
        int n = this.listKeys.getSelectionIndex();
        if (n == -1) {
            n = 0;
        }
        String string = this.listKeys.getItem(n);
        this.titles.add(string);
        TableColumn tableColumn = new TableColumn(this.table, this.table.getStyle());
        tableColumn.setText(this.titles.lastElement());
        tableColumn.addListener(13, this.sortListener);
        tableColumn.setData("key", (Object)this.titles.lastElement());
        tableColumn.setData("index", (Object)(this.titles.size() - 1));
        Job job = new Job("Wait while getting " + string + " stored in file header"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask("get " + (String)ProcessingView.this.titles.lastElement(), ProcessingView.this.sample.getFiles().length);
                if (iProgressMonitor.isCanceled()) {
                    iProgressMonitor.done();
                    return Status.CANCEL_STATUS;
                }
                ProcessingView.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (ProcessingView.this.table.getItemCount() > ProcessingView.this.titles.size()) {
                            ProcessingView.this.table.getItem(ProcessingView.this.titles.size());
                        } else {
                            new TableItem(ProcessingView.this.table, 0);
                        }
                        ProcessingView.this.setSelectedFiles();
                    }
                });
                ProcessingView.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        int n = 0;
                        while (n < ProcessingView.this.titles.size()) {
                            ProcessingView.this.table.getColumn(n).pack();
                            ++n;
                        }
                    }
                });
                iProgressMonitor.worked(100);
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private void initColumn() {
        int n = 0;
        while (n < this.titles.size()) {
            int n2 = 0;
            TableColumn tableColumn = new TableColumn(this.table, n2);
            tableColumn.setText(this.titles.elementAt(n));
            tableColumn.addListener(13, this.sortListener);
            tableColumn.setData("key", (Object)this.titles.elementAt(n));
            tableColumn.setData("index", (Object)n);
            ++n;
        }
        new TableItem(this.table, 0);
        this.clearFiles();
        n = 0;
        while (n < this.titles.size()) {
            this.table.getColumn(n).pack();
            ++n;
        }
        this.table.setSortColumn(this.table.getColumn(1));
        this.table.setSortDirection(1024);
    }

    private void populateCombo() {
        if (this.sample != null && this.sample.hasFile()) {
            this.listKeys.setEnabled(true);
            this.addKeyInTab.setEnabled(true);
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ProcessingView.this.f_fabio != null) {
                            ProcessingView.this.list = ProcessingView.this.f_fabio.getKeys();
                            ToolBox.quicksort((String[])ProcessingView.this.list, (int)0, (int)ProcessingView.this.list.length);
                            ProcessingView.this.listKeys.removeAll();
                            ProcessingView.this.listKeys.setData("HEADER_KEYS", (Object)ProcessingView.this.list);
                            int n = 0;
                            while (n < ProcessingView.this.list.length) {
                                ProcessingView.this.listKeys.add(ProcessingView.this.list[n]);
                                ++n;
                            }
                            ProcessingView.this.listKeys.select(0);
                        }
                    }
                    catch (FabioFileException fabioFileException) {
                        FableMessageConsole.console.displayIn(fabioFileException.getMessage());
                    }
                    catch (JepException jepException) {
                        FableMessageConsole.console.displayIn(jepException.getMessage());
                    }
                }
            });
        } else {
            this.listKeys.removeAll();
            this.listKeys.setEnabled(false);
            this.addKeyInTab.setEnabled(false);
        }
    }

    public static ProcessingView getDefault() {
        return view;
    }

    public void setFocus() {
    }

    private void populateTreeSample() {
        this.directoryTable.setInput((Object)new Experiment(this.listOfSamples));
        this.updatePreprocessor();
    }

    private void setSelectedFiles() {
        this.descriptionColor = this.light_Green;
        if (this.sample.hasFile()) {
            this.populateFileTable("files to process", null);
        }
    }

    public void setProcessingFiles(String[] stringArray) {
        this.descriptionColor = this.light_Red;
        if (stringArray != null) {
            this.updateDirectory();
            int n = this.sort.size() + 1;
            this.table.setItemCount(n);
            this.populateFileTable("files being processed", stringArray);
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.array.add(iPropertyChangeListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.array.remove(iPropertyChangeListener);
    }

    private void updatePreprocessor() {
        Preprocessor preprocessor = Preprocessor.getDefault();
        preprocessor.set_Samples(this.listOfSamples);
        this.spdProcessor.fireExperimentInfoChange(this.selectedSamples, this.experimentName);
    }

    private void populateFileTable(final String string, final String[] stringArray) {
        if (!this.display.isDisposed()) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProcessingView.this.table.clearAll();
                    ProcessingView.this.fileDescription = string;
                    ProcessingView.this.files = stringArray;
                    if (ProcessingView.this.sample.hasFile()) {
                        ProcessingView.this.table.setItemCount(ProcessingView.this.sample.getFilteredfiles().size() + 1);
                    } else {
                        ProcessingView.this.table.setItemCount(1);
                    }
                    TableItem tableItem = ProcessingView.this.table.getItemCount() > 0 ? ProcessingView.this.table.getItem(0) : new TableItem(ProcessingView.this.table, 0);
                    tableItem.setText(0, String.valueOf(ProcessingView.this.sample.getFilteredfiles().size()));
                    tableItem.setText(1, ProcessingView.this.fileDescription);
                    tableItem.setBackground(ProcessingView.this.descriptionColor);
                    int n = 0;
                    while (n < ProcessingView.this.table.getColumnCount()) {
                        ProcessingView.this.table.getColumn(n).pack();
                        ++n;
                    }
                }
            });
        }
    }

    public void setDescription(int n, String string, final int n2) {
        if (n2 == 3) {
            this.descriptionColor = this.light_Red;
        } else if (n2 == 5) {
            this.descriptionColor = this.light_Green;
        } else {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ProcessingView.this.descriptionColor = ProcessingView.this.display.getSystemColor(n2);
                }
            });
        }
        this.setDescription(n, string);
    }

    public void setDescription(int n, String string) {
        this.numberFiles = n;
        this.fileDescription = string;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TableItem tableItem = ProcessingView.this.table.getItemCount() > 0 ? ProcessingView.this.table.getItem(0) : new TableItem(ProcessingView.this.table, 0);
                tableItem.setText(0, Integer.toString(ProcessingView.this.numberFiles));
                tableItem.setText(1, ProcessingView.this.fileDescription);
                tableItem.setBackground(ProcessingView.this.descriptionColor);
            }
        });
    }

    public void clearFiles() {
        this.fileDescription = "please select file(s) or start online mode";
        this.files = null;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ProcessingView.this.descriptionColor = Display.getCurrent().getSystemColor(1);
                ProcessingView.this.table.removeAll();
                TableItem tableItem = ProcessingView.this.table.getItemCount() > 0 ? ProcessingView.this.table.getItem(0) : new TableItem(ProcessingView.this.table, 0);
                tableItem.setText(0, "0");
                tableItem.setText(1, ProcessingView.this.fileDescription);
            }
        });
    }

    private void resetExperimentInfos() {
        this.sample = null;
        this.stextSampleDirectory.set_Text("");
        this.resetCombo();
        this.removeAllColumnsAdded();
        this.updatePreprocessor();
    }

    private void resetCombo() {
        this.listKeys.removeAll();
    }

    private void removeSelectedSample(Sample sample) {
        this.listOfSamples.remove(sample);
        this.populateTreeSample();
        this.clearFilter();
    }

    private void removeSelectedFiles() {
        this.fileDescription = "selected files";
        this.files = null;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ProcessingView.this.descriptionColor = Display.getCurrent().getSystemColor(1);
                TableItem[] tableItemArray = ProcessingView.this.table.getSelection();
                int n = 0;
                while (n < tableItemArray.length) {
                    if ((FabioFile)tableItemArray[n].getData() != null) {
                        ProcessingView.this.sample.removeFabioFile((FabioFile)tableItemArray[n].getData());
                    }
                    ++n;
                }
                ProcessingView.this.setSelectedFiles();
                if (ProcessingView.this.sample.getFilteredfiles().size() == 0) {
                    ProcessingView.this.clearFiles();
                    ProcessingView.this.removeSelectedSample(ProcessingView.this.sample);
                    ProcessingView.this.resetExperimentInfos();
                }
                ProcessingView.this.table.deselectAll();
                ProcessingView.this.updateFilterInfo();
            }
        });
    }

    private void clearAll() {
        if (this.listOfSamples != null) {
            this.listOfSamples.removeAllElements();
        }
        this.currentSelectedFiles = null;
        this.directoryTable.getTable().removeAll();
        this.directoryTable.getTable().clearAll();
        this.table.removeAll();
        this.table.clearAll();
        this.resetExperimentInfos();
    }

    private void enableGroupExperiment(final boolean bl) {
        if (!this.display.isDisposed()) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (bl) {
                        ProcessingView.this.stextSampleDirectory.setBackground(ProcessingView.this.display.getSystemColor(1));
                    } else {
                        ProcessingView.this.stextSampleDirectory.setBackground(ProcessingView.this.display.getSystemColor(22));
                    }
                    ProcessingView.this.stextSampleDirectory.setEnabled(bl);
                    ProcessingView.this.selectFilesButton.setEnabled(bl);
                    ProcessingView.this.btnRemoveSelect.setEnabled(bl);
                    ProcessingView.this.btnRemoveDirectory.setEnabled(bl);
                }
            });
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("SpdView_showRequired")) {
            this.stextSampleDirectory.showDecoration();
        } else if (propertyChangeEvent.getProperty().equals("SpdView_ShowFilesInError")) {
            this.directoryTable.setInput((Object)new Experiment(this.listOfSamples));
        }
    }

    public String[] loadSample(String string) {
        if (string != null && !string.equals("")) {
            String[] stringArray = string.split("[\\\\/]");
            if (stringArray.length > 1) {
                this.experimentName = stringArray[stringArray.length - 2];
                this.sampleName = stringArray[stringArray.length - 1];
            } else {
                this.sampleName = stringArray[stringArray.length - 1];
                this.experimentName = "NA";
            }
            this.files = this.getFiles(string);
        }
        return this.files;
    }

    private void setExperimentAndSampleName(String string) {
        File file;
        if (string != null && (file = new File(string)) != null && file.isDirectory()) {
            this.sampleName = file.getName();
            String string2 = file.getParent();
            if (string2 != null) {
                this.experimentName = new File(string2).getName();
            }
        }
    }

    public void updateDirectory() {
        block3: {
            if (this.sample != null) {
                try {
                    String[] stringArray = this.getFiles(this.sample.getDirectoryPath());
                    this.sample.updatefabioFiles(stringArray);
                    this.sort = this.sample.getFilteredfiles();
                    this.setSelectedFiles();
                }
                catch (FabioFileException fabioFileException) {
                    if (FableMessageConsole.console == null) break block3;
                    FableMessageConsole.console.displayError("An error occured while updating the directory");
                }
            }
        }
    }

    private String[] getFiles(String string) {
        Object object;
        String[] stringArray = null;
        if (this.regularExpressionForExtension.toLowerCase().contains("bruker")) {
            object = Pattern.compile("bruker", 2);
            ((Pattern)object).matcher(this.regularExpressionForExtension).matches();
            this.regularExpressionForExtension = ((Pattern)object).matcher(this.regularExpressionForExtension).replaceAll("\\\\.\\\\\\d+");
        }
        object = ".+(" + this.regularExpressionForExtension + ")";
        stringArray = ToolBox.getFileNamesByEntireRegex((String)string, (String)object, (boolean)true);
        ToolBox.quicksort((String[])stringArray, (int)0, (int)stringArray.length);
        String string2 = System.getProperty("file.separator");
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = String.valueOf(string) + string2 + stringArray[n];
            ++n;
        }
        return stringArray;
    }

    public void dispose() {
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.preferencesListener);
        if (this.light_blue != null && !this.light_blue.isDisposed()) {
            this.light_blue.dispose();
        }
        if (this.light_Red != null && !this.light_Red.isDisposed()) {
            this.light_Red.dispose();
        }
        if (this.light_Green != null && !this.light_Green.isDisposed()) {
            this.light_Green.dispose();
        }
        this.spdProcessor.removePreprocessorListener(this.preprocessorListener);
        this.spdProcessor.removePropertyChangeListener(this);
        this.spdProcessor.dispose();
        super.dispose();
    }

    public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
    }

    public static String getID() {
        return ID;
    }

    private void updateStatusLine() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MainStatusBar mainStatusBar = (MainStatusBar)ProcessingView.this.getViewSite().getActionBars().getStatusLineManager().find("fable_main_status_line");
                if (mainStatusBar != null) {
                    mainStatusBar.setText(Preprocessor.getDefault().getM_modeText());
                    mainStatusBar.setImage(Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)Preprocessor.getDefault().getM_modeImage()).createImage());
                } else {
                    ProcessingView.this.getViewSite().getActionBars().getStatusLineManager().setMessage(Activator.imageDescriptorFromPlugin((String)"fable.preprocessor", (String)Preprocessor.getDefault().getM_modeImage()).createImage(), Preprocessor.getDefault().getM_modeText());
                }
            }
        });
    }

    public Job getJob() {
        return this.job;
    }

    class PreprocessListener
    implements IPreprocessorListener {
        PreprocessListener() {
        }

        @Override
        public void preprocessorChanged(PreprocessorEvent preprocessorEvent) {
        }

        @Override
        public void preprocessorModeChange(PreprocessorEvent preprocessorEvent) {
            final Preprocessor preprocessor = (Preprocessor)preprocessorEvent.getSource();
            if (!ProcessingView.this.display.isDisposed()) {
                ProcessingView.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (preprocessor.isOnLine()) {
                            ProcessingView.this.clearAll();
                        }
                        ProcessingView.this.chkProcessPrevious.setEnabled(preprocessor.isOnLine());
                        ProcessingView.this.enableGroupExperiment(!preprocessor.isOnLine());
                        ProcessingView.this.setVisibleProcessPreviousFiles(preprocessor.isOnLine());
                        ProcessingView.this.updateStatusLine();
                    }
                });
            }
        }

        @Override
        public void preprocessorNewMessage(PreprocessorEvent preprocessorEvent) {
        }

        @Override
        public void preprocessorStateChange(PreprocessorEvent preprocessorEvent) {
            final Preprocessor preprocessor = (Preprocessor)preprocessorEvent.getSource();
            if (!ProcessingView.this.display.isDisposed()) {
                ProcessingView.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (preprocessor.isOnLine()) {
                            ProcessingView.this.clearAll();
                        }
                        ProcessingView.this.chkProcessPrevious.setEnabled(preprocessor.isOnLine() && !preprocessor.isM_bStatusProcessing());
                    }
                });
            }
        }

        @Override
        public void preprocessorNewSample(PreprocessorEvent preprocessorEvent) {
            if (ProcessingView.this.spdProcessor.isOnLine()) {
                ProcessingView.this.sample = ProcessingView.this.spdProcessor.getCurrentSample();
                ProcessingView.this.sample.addSampleListener((ISampleListener)ProcessingView.this.sampleListener);
                ProcessingView.this.listOfSamples.removeAllElements();
                ProcessingView.this.listOfSamples.add(ProcessingView.this.sample);
                if (!ProcessingView.this.display.isDisposed()) {
                    ProcessingView.this.display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ProcessingView.this.populateTreeSample();
                        }
                    });
                }
            }
        }
    }

    class SampleListener
    implements ISampleListener {
        SampleListener() {
        }

        public void newImages(SampleEvent sampleEvent) {
            ProcessingView.this.setProcessingFiles(((Sample)sampleEvent.getSource()).getFiles());
        }

        public void newSample(SampleEvent sampleEvent) {
        }

        public void sampleHasChanged(SampleEvent sampleEvent) {
        }
    }
}

