/*
 * Decompiled with CFR 0.152.
 */
package fable.preprocessor.process;

import fable.framework.views.FableMessageConsole;
import fable.preprocessor.Activator;
import fable.preprocessor.process.IPreprocessorListener;
import fable.preprocessor.process.Preprocessor;
import fable.preprocessor.process.PreprocessorEvent;
import fable.python.Sample;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Display;

public class RetrieveExperimentFromDb
extends Thread
implements IPreprocessorListener {
    private boolean stopListening = false;
    private boolean dataRetrieve = false;
    private Preprocessor spdPreprocessor = Preprocessor.getDefault();
    private DeviceProxy beamline;
    private String onLineDirectory = "";
    private String sampleName = "searching ...";
    private String experiment = "searching ...";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!Display.getDefault().isDisposed() && !this.stopListening) {
            this.dataRetrieve = this.retrieveExperimentData();
            if (!Display.getDefault().isDisposed()) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!Display.getDefault().isDisposed()) {
                            RetrieveExperimentFromDb.this.spdPreprocessor.setSample(new Sample(RetrieveExperimentFromDb.this.experiment, RetrieveExperimentFromDb.this.sampleName, RetrieveExperimentFromDb.this.getSampleDirectory()));
                        }
                    }
                });
            }
            if (!this.spdPreprocessor.getM_mode().equals("ON")) {
                try {
                    Activator.log("Search for on line experiment has been stopped");
                    Logger.getLogger(RetrieveExperimentFromDb.class).info((Object)"Search for on line experiment has been stopped");
                    RetrieveExperimentFromDb retrieveExperimentFromDb = this;
                    synchronized (retrieveExperimentFromDb) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Activator.log("An InterruptedException has been thrown while trying to stand by update Thread :" + interruptedException.getMessage());
                    Logger.getLogger(RetrieveExperimentFromDb.class).error((Object)interruptedException.getMessage());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println("An exception has been thrown while trying to stand by update Thread :" + exception.getMessage());
                    Activator.log("An exception has been thrown while trying to stand by update Thread :" + exception.getMessage());
                    Logger.getLogger(RetrieveExperimentFromDb.class).error((Object)exception.getMessage());
                }
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                Activator.log("Error while thread sleeping ", 4, interruptedException);
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayError("Error while 'experiment retreive data' thread sleeping");
                }
                Logger.getLogger(RetrieveExperimentFromDb.class).error((Object)interruptedException.getMessage());
            }
        }
    }

    private boolean importBeamlineServer() {
        boolean bl = true;
        if (this.beamline == null) {
            try {
                this.beamline = new DeviceProxy("taco://id11/id11/database/1");
                this.beamline.set_rpc_protocol(1);
                bl = true;
            }
            catch (DevFailed devFailed) {
                Activator.log("Error new Device Proxy", 4, (Exception)((Object)devFailed));
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayError("ERROR accessing device Proxy :" + devFailed.getMessage());
                }
                Logger.getLogger(RetrieveExperimentFromDb.class).error((Object)devFailed.getMessage());
                bl = false;
            }
        }
        return bl;
    }

    private boolean retrieveExperimentData() {
        boolean bl = this.importBeamlineServer();
        if (bl) {
            try {
                DeviceData deviceData = new DeviceData();
                String[] stringArray = new String[]{"directory", "%"};
                deviceData.insert(stringArray);
                DeviceData deviceData2 = this.beamline.command_inout("DbQuerySettings", deviceData);
                String[] stringArray2 = deviceData2.extractStringArray();
                this.onLineDirectory = stringArray2[0];
                try {
                    deviceData = new DeviceData();
                    stringArray = new String[]{"experiment", "%"};
                    deviceData.insert(stringArray);
                    deviceData2 = this.beamline.command_inout("DbQuerySettings", deviceData);
                    stringArray2 = deviceData2.extractStringArray();
                    this.experiment = stringArray2[0];
                    try {
                        deviceData = new DeviceData();
                        stringArray = new String[]{"sample", "%"};
                        deviceData.insert(stringArray);
                        deviceData2 = this.beamline.command_inout("DbQuerySettings", deviceData);
                        stringArray2 = deviceData2.extractStringArray();
                        this.sampleName = stringArray2[0];
                    }
                    catch (DevFailed devFailed) {
                        Logger.getLogger(RetrieveExperimentFromDb.class).error((Object)devFailed.getMessage());
                        Activator.log("Error accessing database to retrieve current experiment directory", 4, (Exception)((Object)devFailed));
                        if (FableMessageConsole.console != null) {
                            FableMessageConsole.console.displayError("Error accessing database to retrieve current experiment directory");
                        }
                        bl = false;
                    }
                }
                catch (DevFailed devFailed) {
                    Logger.getLogger(RetrieveExperimentFromDb.class).error((Object)devFailed.getMessage());
                    Activator.log("Error accessing database to retrieve current experiment", 4, (Exception)((Object)devFailed));
                    if (FableMessageConsole.console != null) {
                        FableMessageConsole.console.displayError("Error accessing database to retrieve current experiment");
                    }
                    bl = false;
                }
            }
            catch (DevFailed devFailed) {
                Logger.getLogger(RetrieveExperimentFromDb.class).error((Object)devFailed.getMessage());
                Activator.log("Error accessing database to retrieve current directory", 4, (Exception)((Object)devFailed));
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayError("Error accessing database to retrieve current directory");
                }
                bl = false;
            }
        }
        return bl;
    }

    private String getSampleDirectory() {
        String string = null;
        string = this.onLineDirectory;
        return string;
    }

    public boolean isDataRetrieve() {
        return this.dataRetrieve;
    }

    public void setDataRetrieve(boolean bl) {
        this.dataRetrieve = bl;
    }

    public void stopListeningToDb() {
        this.stopListening = true;
    }

    @Override
    public synchronized void start() {
        this.stopListening = false;
        super.start();
    }

    @Override
    public void preprocessorChanged(PreprocessorEvent preprocessorEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preprocessorModeChange(PreprocessorEvent preprocessorEvent) {
        String string = ((Preprocessor)preprocessorEvent.getSource()).getM_mode();
        if (string.equals("ON")) {
            RetrieveExperimentFromDb retrieveExperimentFromDb = this;
            synchronized (retrieveExperimentFromDb) {
                this.notifyAll();
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayInfo("Start looking for experiments information");
                }
            }
        }
        RetrieveExperimentFromDb retrieveExperimentFromDb = this;
        synchronized (retrieveExperimentFromDb) {
            try {
                this.wait();
                if (FableMessageConsole.console != null) {
                    FableMessageConsole.console.displayInfo("Stop looking for experiments information");
                }
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(this.getClass()).error((Object)interruptedException.getMessage());
            }
        }
    }

    @Override
    public void preprocessorNewMessage(PreprocessorEvent preprocessorEvent) {
    }

    @Override
    public void preprocessorNewSample(PreprocessorEvent preprocessorEvent) {
    }

    @Override
    public void preprocessorStateChange(PreprocessorEvent preprocessorEvent) {
    }
}

