/*
 * Decompiled with CFR 0.152.
 */
package fable.preprocessor.process;

import fable.framework.toolbox.FableUtils;
import fable.framework.toolbox.ToolBox;
import fable.preprocessor.Activator;
import fable.preprocessor.process.IPreprocessorListener;
import fable.preprocessor.process.PreprocessorEvent;
import fable.preprocessor.process.RetrieveExperimentFromDb;
import fable.preprocessor.toolBox.PreprocessorMessage;
import fable.preprocessor.toolBox.Toolbox;
import fable.preprocessor.views.ProcessingView;
import fable.python.FabioFile;
import fable.python.FabioFileException;
import fable.python.Sample;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;

public class Preprocessor
implements Runnable,
Preferences.IPropertyChangeListener {
    public static Preprocessor preprocessor;
    private RetrieveExperimentFromDb updateThread;
    private String m_mode;
    private String darkStem;
    private String darkFile;
    private String floodFile;
    private String distFile;
    private int distortionAction;
    private boolean applyDarkCorrection;
    private boolean applyFloodCorrection;
    private boolean applyDistCorrection;
    private String spdCommand;
    private String extFlood;
    private String extDist;
    private String modeImage;
    private String modeText;
    private String otherOptions;
    private PreprocessorMessage logMessage;
    private boolean m_bStatusProcessing;
    private Vector<IPreprocessorListener> listListener = new Vector();
    private Sample sample;
    private ProcessThread _threadProcess = null;
    private String extTypeRegex;
    private boolean clearCommandOption;
    private String srcExt;
    private String corExt = "";
    private String inpConst;
    private String inpExp;
    private String inpFactor;
    private String saveDark;
    private String dark_const;
    private String darkExt;
    public String spdMode;
    public static int numberImages;
    private String spdServer = null;
    private DeviceProxy spdProxy = null;
    private Vector<Sample> v_Samples = new Vector();
    public boolean processAll = false;
    private boolean bSizeIsOk = true;
    private String reffileDim1 = "";
    private String reffileDim2 = "";
    private boolean zipCorrectedFiles;
    private boolean zipOriginalfiles;
    private String zipCmd;
    private String typeoutfile;
    private String dvo;
    private ArrayList<IPropertyChangeListener> viewsListeners = new ArrayList();
    private int notValidCounter;
    private Job jobToCheckSize;
    private String fileOfComparison;
    public String currentCorrectedFileName = "";
    public int processWorked = 0;

    private Preprocessor() {
        this.logMessage = new PreprocessorMessage();
        Preferences preferences = Activator.getDefault().getPluginPreferences();
        preferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        this.setM_mode(preferences.getString("pref_mode"));
    }

    public boolean isOnLine() {
        boolean bl = false;
        if (this.getM_mode() != null) {
            bl = this.getM_mode().equals("ON");
        }
        return bl;
    }

    public boolean isOffLine() {
        boolean bl = false;
        if (this.getM_mode() != null) {
            bl = this.getM_mode().equals("OFF");
        }
        return bl;
    }

    public boolean isZipCorrectedFiles() {
        return this.zipCorrectedFiles;
    }

    public void setZipCorrectedFiles(boolean bl) {
        this.zipCorrectedFiles = bl;
    }

    public void removeAllNewTypeOfFiles() {
        this.extTypeRegex = "";
    }

    public void addNewTypeOfFiles(String string) {
        if (this.extTypeRegex == null) {
            this.extTypeRegex = "";
        }
        this.extTypeRegex = String.valueOf(this.extTypeRegex) + "(" + string + ")?";
    }

    public void RemoveAllNewTypeOfFiles(String string) {
        this.extTypeRegex = "";
    }

    public static Preprocessor getDefault() {
        if (preprocessor == null) {
            preprocessor = new Preprocessor();
        }
        return preprocessor;
    }

    public void addPreprocessorListener(IPreprocessorListener iPreprocessorListener) {
        this.listListener.add(iPreprocessorListener);
    }

    public void removePreprocessorListener(IPreprocessorListener iPreprocessorListener) {
        this.listListener.remove(iPreprocessorListener);
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.viewsListeners.add(iPropertyChangeListener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.viewsListeners.remove(iPropertyChangeListener);
    }

    public void fireExperimentInfoChange(String[] stringArray, String string) {
        for (IPropertyChangeListener iPropertyChangeListener : this.viewsListeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "ProcessingView_selectedFiles", null, (Object)stringArray));
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "ProcessingView_experiment", null, (Object)string));
        }
    }

    public void fireCurrentSampleHasChanged(String string, String string2) {
        for (IPropertyChangeListener iPropertyChangeListener : this.viewsListeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "ProcessingView_directory", null, (Object)string));
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "ProcessingView_sample", null, (Object)string2));
        }
    }

    public void fireShowRequiredFields() {
        for (IPropertyChangeListener iPropertyChangeListener : this.viewsListeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "SpdView_showRequired", null, (Object)true));
        }
    }

    public void fireCurrentCorrectedExtensionHasChanged(String string) {
        for (IPropertyChangeListener iPropertyChangeListener : this.viewsListeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "SpdView_correctedExtension", null, (Object)string));
        }
    }

    public void fireShowFlag() {
        for (IPropertyChangeListener iPropertyChangeListener : this.viewsListeners) {
            if (iPropertyChangeListener == null) continue;
            iPropertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, "SpdView_ShowFilesInError", null, null));
        }
    }

    private void firePreprocessorChange() {
        PreprocessorEvent preprocessorEvent = new PreprocessorEvent(this);
        Enumeration<IPreprocessorListener> enumeration = this.listListener.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().preprocessorChanged(preprocessorEvent);
        }
    }

    private void firePreprocessorModeChange() {
        PreprocessorEvent preprocessorEvent = new PreprocessorEvent(this);
        Enumeration<IPreprocessorListener> enumeration = this.listListener.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().preprocessorModeChange(preprocessorEvent);
        }
    }

    private void firePreprocessorStateChange() {
        PreprocessorEvent preprocessorEvent = new PreprocessorEvent(this);
        Enumeration<IPreprocessorListener> enumeration = this.listListener.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().preprocessorStateChange(preprocessorEvent);
        }
    }

    private void firePreprocessorNewMessage() {
        PreprocessorEvent preprocessorEvent = new PreprocessorEvent(this);
        Enumeration<IPreprocessorListener> enumeration = this.listListener.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().preprocessorNewMessage(preprocessorEvent);
        }
    }

    public void fireSampleHasChanged() {
        PreprocessorEvent preprocessorEvent = new PreprocessorEvent(this);
        Enumeration<IPreprocessorListener> enumeration = this.listListener.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().preprocessorNewSample(preprocessorEvent);
        }
        if (this.isOnLine() && this.isM_bStatusProcessing()) {
            this.run();
        }
    }

    @Override
    public void run() {
        Vector<Sample> vector = this.get_Samples();
        if (vector != null) {
            numberImages = 0;
            this.processWorked = vector.size();
            int n = 0;
            while (n < vector.size()) {
                this._threadProcess = new ProcessThread(vector.elementAt(n), this.isM_applyDarkCorrection(), this.isM_applyFloodCorrection(), this.isM_applyDistCorrection(), this.getM_mode(), this.get_src_ext());
                if (this.isM_bStatusProcessing()) {
                    this._threadProcess.start();
                }
                ++n;
            }
        }
    }

    public void stop() {
        if (this._threadProcess != null) {
            this._threadProcess.notifyEnd();
        }
    }

    public String getCommand() {
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = "";
        String string3 = "";
        if (string.contains("windows")) {
            string2 = "cmd /C ";
        }
        String string4 = String.valueOf(string2) + string3 + this.getSpdCommand() + string3 + " ";
        if (!this.get_cor_ext().equals("")) {
            string4 = String.valueOf(string4) + " cor_ext=" + this.get_cor_ext();
        }
        if (!this.get_src_ext().equals("")) {
            string4 = String.valueOf(string4) + " src_ext=" + this.get_src_ext();
        }
        if (this.isM_applyDarkCorrection()) {
            if (!this.darkFile.equals("")) {
                string4 = String.valueOf(string4) + " dark_file=" + this.darkFile;
            }
            if (this.get_dark_const() != null && !this.get_dark_const().equals("")) {
                string4 = String.valueOf(string4) + " dark_const=" + this.get_dark_const();
            }
            if (this.get_dark_ext() != null && !this.get_dark_ext().equals("")) {
                string4 = String.valueOf(string4) + " dark_ext=" + this.get_dark_ext();
            }
            if (this.get_inp_const() != null && !this.get_inp_const().equals("")) {
                string4 = String.valueOf(string4) + " inp_const=" + this.get_inp_const();
            }
            if (this.get_inp_factor() != null && !this.get_inp_factor().equals("")) {
                string4 = String.valueOf(string4) + " inp_factor=" + this.get_inp_factor();
            }
            if (this.get_inp_exp() != null && !this.get_inp_exp().equals("")) {
                string4 = String.valueOf(string4) + " inp_exp=" + this.get_inp_exp();
            }
            if (this.get_save_dark() != null && !this.get_inp_const().equals("")) {
                string4 = String.valueOf(string4) + " save_dark=" + this.get_save_dark();
            }
        }
        if (this.isM_applyFloodCorrection() && !this.floodFile.equals("")) {
            string4 = String.valueOf(string4) + " flood_file=" + this.floodFile;
        }
        if (this.isM_applyDistCorrection()) {
            if (!this.distFile.equals("")) {
                string4 = String.valueOf(string4) + " distortion_file=" + this.distFile;
            }
            string4 = String.valueOf(string4) + " do_distortion=" + this.getDistortionAction() + " flat_distortion=1";
        } else {
            string4 = String.valueOf(string4) + " do_distortion=0 ";
        }
        string4 = String.valueOf(string4) + " pass=1";
        if (Toolbox.isSpdNew() && this.dvo != null && this.typeoutfile != null) {
            string4 = String.valueOf(string4) + " dvo=" + this.dvo + " type=" + this.typeoutfile;
        }
        if (this.otherOptions != null) {
            string4 = String.valueOf(string4) + " " + this.otherOptions;
        }
        return String.valueOf(string4) + " ";
    }

    public static void incrementImagesCorrected() {
        ProcessingView.getDefault().setDescription(--numberImages, "files left to process", 3);
        if (numberImages < 1 && preprocessor.isOffLine()) {
            Preprocessor.getDefault().setM_bStatusProcessing(false);
        }
    }

    public boolean isM_bStatusProcessing() {
        return this.m_bStatusProcessing;
    }

    public void setM_bStatusProcessing(boolean bl) {
        if (this.m_bStatusProcessing != bl) {
            this.m_bStatusProcessing = bl;
            if (this.m_bStatusProcessing) {
                Activator.log("Processor Status is running");
            } else {
                Activator.log("Processor Status is stopped");
            }
            this.firePreprocessorStateChange();
            this.firePreprocessorChange();
        }
    }

    public int getDistortionAction() {
        return this.distortionAction;
    }

    public void setDistortionAction(int n) {
        this.distortionAction = n;
    }

    public String getSpdCommand() {
        return this.spdCommand;
    }

    public String getZipCmd() {
        return this.zipCmd;
    }

    public void setZipCmd(String string) {
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            string = "\"" + string + "\"";
        }
        this.zipCmd = string;
    }

    public void setCommand(String string) {
        System.getProperties();
        this.spdCommand = ToolBox.addQuotesForSpacesInName((String)string, (String)"[\\\\/]", (String)System.getProperty("file.separator"));
    }

    public Vector<Sample> get_Samples() {
        return this.v_Samples;
    }

    public Sample getCurrentSample() {
        return this.sample;
    }

    public boolean set_Samples(Vector<Sample> vector) {
        this.v_Samples = (Vector)vector.clone();
        if (this.v_Samples.size() > 0) {
            this.sample = this.v_Samples.elementAt(0);
        }
        return true;
    }

    public boolean setSample(Sample sample) {
        Sample sample2 = null;
        if (this.v_Samples.size() > 0) {
            sample2 = this.v_Samples.elementAt(0);
        }
        boolean bl = false;
        if (sample2 != null) {
            if (!(sample2.getParentDirectoryName().equals(sample.getParentDirectoryName()) && sample2.getDirectoryName().equals(sample.getDirectoryName()) && sample2.getDirectoryPath().equals(sample.getDirectoryPath()))) {
                Activator.log("Sample has changed. New Sample: " + sample + " .Old Sample:" + sample2);
                bl = true;
            }
        } else {
            Activator.log("Set sample: " + sample);
            bl = true;
        }
        if (bl) {
            this.v_Samples.removeAllElements();
            this.v_Samples.setSize(1);
            this.v_Samples.set(0, sample);
            this.sample = sample;
            this.fireSampleHasChanged();
            this.firePreprocessorChange();
        }
        return bl;
    }

    public boolean isM_applyDarkCorrection() {
        return this.applyDarkCorrection;
    }

    public void setM_applyDarkCorrection(boolean bl) {
        if (this.applyDarkCorrection != bl) {
            this.applyDarkCorrection = bl;
            if (bl) {
                this.logMessage.setM_Message("Dark correction will be made while image processing.");
                this.logMessage.setM_Type(1);
            } else {
                this.logMessage.setM_Message("Dark correction will not be made while image processing.");
                this.logMessage.setM_Type(2);
            }
            this.firePreprocessorChange();
        }
    }

    public boolean isM_applyDistCorrection() {
        return this.applyDistCorrection;
    }

    public void setM_applyDistCorrection(boolean bl) {
        if (this.applyDistCorrection != bl) {
            this.applyDistCorrection = bl;
            if (bl) {
                this.logMessage.setM_Message("Spatial distortion will be made while image processing.");
                this.logMessage.setM_Type(1);
            } else {
                this.logMessage.setM_Message("Spatial distortion will not be made while image processing.");
                this.logMessage.setM_Type(2);
            }
            this.firePreprocessorChange();
        }
    }

    public boolean isM_applyFloodCorrection() {
        return this.applyFloodCorrection;
    }

    public void setM_applyFloodCorrection(boolean bl) {
        if (this.applyFloodCorrection != bl) {
            this.applyFloodCorrection = bl;
            if (bl) {
                this.logMessage.setM_Message("Flood correction will be made while image processing.");
                this.logMessage.setM_Type(1);
            } else {
                this.logMessage.setM_Message("Flood correction will not be made while image processing.");
                this.logMessage.setM_Type(2);
            }
            this.firePreprocessorChange();
        }
    }

    public String getM_darkStem() {
        return this.darkStem;
    }

    public void setM_darkStem(String string) {
        if (string != null && !string.equals(this.getM_darkStem())) {
            this.darkStem = string;
            this.logMessage.setM_Message("Dark file has been updated.");
            this.logMessage.setM_Type(1);
            this.firePreprocessorChange();
        }
    }

    public String getM_darkFile() {
        return this.darkFile;
    }

    public void setM_darkFile(String string) {
        if (string != null && !string.equals(this.darkFile)) {
            this.darkFile = string;
            this.logMessage.setM_Message("Dark file has been updated.");
            this.logMessage.setM_Type(1);
            this.firePreprocessorChange();
        }
    }

    public String getM_distFile() {
        return this.distFile;
    }

    public void setM_distFile(String string) {
        if (string != null && !string.equals(this.getM_distFile())) {
            this.distFile = string;
            this.logMessage.setM_Message("Spatial Distortion file has been updated.");
            this.logMessage.setM_Type(1);
            this.firePreprocessorChange();
        }
    }

    public void setOtherOptions(String string) {
        this.otherOptions = string;
    }

    public String getM_floodFile() {
        return this.floodFile;
    }

    public void setM_floodFile(String string) {
        if (string != null && !string.equals(this.getM_floodFile())) {
            this.floodFile = string;
            this.logMessage.setM_Message("Flood file has been updated.");
            this.logMessage.setM_Type(1);
            this.firePreprocessorChange();
        }
    }

    public void setCompress(boolean bl, boolean bl2, String string) {
        this.setZipCmd(string);
        this.zipCorrectedFiles = bl2;
        this.zipOriginalfiles = bl;
    }

    public String getM_mode() {
        return this.m_mode;
    }

    public void setM_mode(String string) {
        if (string != null && !string.equals(this.m_mode)) {
            this.m_mode = string;
            if (this.m_mode.compareTo("OFF") == 0) {
                this.setM_modeImage("images/disconnected.gif");
                this.setM_modeText("Offline");
            } else {
                this.setM_modeImage("images/connected.gif");
                this.setM_modeText("Online");
            }
            this.logMessage.setM_Message("Preprocessor mode is " + this.getM_modeText());
            this.logMessage.setM_Type(1);
            Activator.log("Preprocessor mode is : " + this.getM_modeText());
            if (this.isOnLine()) {
                this.startUpdatExperimentDataThread();
            }
            this.firePreprocessorModeChange();
        }
    }

    public String getSpdMode() {
        return this.spdMode;
    }

    public void setSpdMode(String string) {
        this.spdMode = string;
    }

    private void setSpdServer(String string) {
        this.spdServer = string;
    }

    public void set_cor_ext(String string) {
        this.corExt = string;
    }

    public String get_cor_ext() {
        return this.corExt;
    }

    public void set_src_ext(String string) {
        this.srcExt = string;
    }

    public String get_src_ext() {
        if (this.srcExt == null) {
            this.srcExt = "";
        }
        return this.srcExt;
    }

    public void set_clearCommand(boolean bl) {
        this.clearCommandOption = bl;
    }

    public boolean get_clearOption() {
        return this.clearCommandOption;
    }

    public String get_inp_const() {
        return this.inpConst;
    }

    public String get_dark_const() {
        return this.dark_const;
    }

    public void set_dark_const(String string) {
        this.dark_const = string;
    }

    public String get_dark_ext() {
        return this.darkExt;
    }

    public void set_dark_ext(String string) {
        this.darkExt = string;
    }

    public void set_inp_const(String string) {
        this.inpConst = string;
    }

    public String get_inp_exp() {
        return this.inpExp;
    }

    public void set_inp_exp(String string) {
        this.inpExp = string;
    }

    public String get_inp_factor() {
        return this.inpFactor;
    }

    public void set_inp_factor(String string) {
        this.inpFactor = string;
    }

    public String get_save_dark() {
        return this.saveDark;
    }

    public void set_save_dark(String string) {
        this.saveDark = string;
    }

    public String get_extDist() {
        return this.extDist;
    }

    public void set_extDist(String string) {
        this.extDist = string;
    }

    public String get_extFlood() {
        return this.extFlood;
    }

    public void set_extFlood(String string) {
        this.extFlood = string;
    }

    public String getM_modeImage() {
        return this.modeImage;
    }

    private void setM_modeImage(String string) {
        this.modeImage = string;
    }

    public String getM_modeText() {
        return this.modeText;
    }

    private void setM_modeText(String string) {
        this.modeText = string;
    }

    public PreprocessorMessage getLogMessage() {
        return this.logMessage;
    }

    public void setLogMessage(PreprocessorMessage preprocessorMessage) {
        this.logMessage = preprocessorMessage;
        this.firePreprocessorNewMessage();
    }

    public boolean checkSize(FabioFile fabioFile) {
        this.bSizeIsOk = true;
        this.fileOfComparison = fabioFile.getFileName();
        try {
            this.reffileDim1 = fabioFile.getValue("Dim_1").replaceAll("\\p{Space}", "");
            this.reffileDim2 = fabioFile.getValue("Dim_2").replaceAll("\\p{Space}", "");
        }
        catch (FabioFileException fabioFileException) {
            FableUtils.excMsg((Object)this, (String)"An error occured while comparing image dimension", (Throwable)fabioFileException);
            Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An error occured while comparing image dimension :" + fabioFileException.getMessage(), 0));
        }
        if (this.jobToCheckSize == null) {
            this.initJob();
        }
        this.jobToCheckSize.setUser(true);
        this.jobToCheckSize.schedule();
        return this.bSizeIsOk;
    }

    private boolean checkSize(final String[] stringArray) {
        this.bSizeIsOk = true;
        if (this.applyDarkCorrection && this.darkFile != null && !this.darkFile.equals("")) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (Preprocessor.this.sample.getFabioFiles().size() < 1) {
                            Preprocessor.this.sample.addFabioFiles(stringArray);
                        }
                        Preprocessor.this.bSizeIsOk = Preprocessor.this.checkSize(new FabioFile(Preprocessor.this.darkFile));
                    }
                    catch (FabioFileException fabioFileException) {
                        Preprocessor.this.bSizeIsOk = false;
                        FableUtils.excMsg((Object)this, (String)"An error occured while comparing image dimension", (Throwable)fabioFileException);
                        Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An error occured while comparing image dimension :" + fabioFileException.getMessage(), 0));
                    }
                }
            });
        } else if (this.bSizeIsOk && this.applyFloodCorrection && this.floodFile != null && !this.floodFile.equals("")) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (Preprocessor.this.sample.getFabioFiles().size() < 1) {
                            Preprocessor.this.sample.addFabioFiles(stringArray);
                        }
                        FabioFile fabioFile = new FabioFile(Preprocessor.this.floodFile);
                        Preprocessor.this.bSizeIsOk = Preprocessor.this.checkSize(fabioFile);
                    }
                    catch (FabioFileException fabioFileException) {
                        Preprocessor.this.bSizeIsOk = false;
                        FableUtils.excMsg((Object)this, (String)"An error occured while comparing image dimension", (Throwable)fabioFileException);
                        Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An error occured while comparing image dimension :" + fabioFileException.getMessage(), 0));
                    }
                }
            });
        }
        return this.bSizeIsOk;
    }

    public void setCorrectionType(String string) {
        if (string != null) {
            this.typeoutfile = string;
        }
    }

    public void setDataValueOffset(String string) {
        if (string != null) {
            this.dvo = string;
        }
    }

    public void dispose() {
        if (this.updateThread != null && this.updateThread.isAlive()) {
            this.updateThread.stopListeningToDb();
        }
        Activator.getDefault().getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    public void propertyChange(Preferences.PropertyChangeEvent propertyChangeEvent) {
        Preferences preferences = Activator.getDefault().getPluginPreferences();
        if (propertyChangeEvent.getProperty().equals("pref_mode")) {
            this.setM_mode(preferences.getString("pref_mode"));
        }
    }

    public Job getJobCheckSize() {
        if (this.jobToCheckSize == null) {
            this.initJob();
        }
        return this.jobToCheckSize;
    }

    private void initJob() {
        this.jobToCheckSize = new Job("CheckSize"){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                Vector<Sample> vector = Preprocessor.this.get_Samples();
                int n = 0;
                while (vector != null && n < vector.size()) {
                    final Sample sample = vector.elementAt(n);
                    Preprocessor.this.notValidCounter = 0;
                    if (sample != null && sample.hasFile()) {
                        iProgressMonitor.beginTask("Compare size of images between " + sample.getDirectoryName() + " and " + Preprocessor.this.fileOfComparison, 1);
                        int n2 = 0;
                        while (n2 < 1) {
                            if (iProgressMonitor.isCanceled()) {
                                iProgressMonitor.done();
                                return Status.CANCEL_STATUS;
                            }
                            final FabioFile fabioFile = (FabioFile)sample.getFilteredfiles().elementAt(n2);
                            final String string = fabioFile.getFileName();
                            iProgressMonitor.subTask(string);
                            if (iProgressMonitor.isCanceled()) {
                                iProgressMonitor.done();
                                return Status.CANCEL_STATUS;
                            }
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        String string3 = fabioFile.getValue("Dim_1").replaceAll("\\p{Space}", "");
                                        String string2 = fabioFile.getValue("Dim_2").replaceAll("\\p{Space}", "");
                                        if (!string3.equals(Preprocessor.this.reffileDim1) || !string2.equals(Preprocessor.this.reffileDim2)) {
                                            Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("ERROR " + sample.getDirectoryName() + ":File " + string + "(Dim_1=" + string3 + ",Dim_2=" + string2 + ")  and " + Preprocessor.this.fileOfComparison + "(Dim_1=" + Preprocessor.this.reffileDim1 + ",Dim_2=" + Preprocessor.this.reffileDim2 + ") don't have the same dimensions." + " This file will not be processed", 0));
                                            fabioFile.setFlag(false);
                                            Preprocessor preprocessor = Preprocessor.this;
                                            preprocessor.notValidCounter = preprocessor.notValidCounter + 1;
                                            Preprocessor.this.bSizeIsOk = false;
                                        } else {
                                            fabioFile.setFlag(true);
                                            Preprocessor.this.bSizeIsOk = true;
                                        }
                                    }
                                    catch (FabioFileException fabioFileException) {
                                        Preprocessor.this.bSizeIsOk = true;
                                        FableUtils.excMsg((Object)this, (String)("SpdView.checkSize:" + fabioFileException.getMessage()), (Throwable)fabioFileException);
                                        Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An error occured while comparing image dimension :" + fabioFileException.getMessage(), 0));
                                    }
                                }
                            });
                            if (iProgressMonitor.isCanceled()) {
                                iProgressMonitor.done();
                                return Status.CANCEL_STATUS;
                            }
                            iProgressMonitor.worked(1);
                            ++n2;
                        }
                    }
                    sample.setValide(Preprocessor.this.notValidCounter == 0);
                    ++n;
                }
                iProgressMonitor.done();
                return Status.OK_STATUS;
            }
        };
    }

    public boolean isSizeCheckedOk() {
        return this.bSizeIsOk;
    }

    public static String getFileNameOfCorrectedFile(String string, String string2) {
        String string3;
        int n = string.lastIndexOf(".");
        if (string2.equals("")) {
            if (ToolBox.getFileType((String)string).equals("cor")) {
                n = 0;
            }
            string3 = n > 0 && n + 1 < string.length() ? string.substring(0, n + 1) : String.valueOf(string) + ".";
            string3 = String.valueOf(string3) + "cor";
        } else {
            string3 = String.valueOf(string) + string2;
        }
        return string3;
    }

    private void createUpdateExperimentThread() {
        this.updateThread = new RetrieveExperimentFromDb();
    }

    private void startUpdatExperimentDataThread() {
        if (this.updateThread == null) {
            this.createUpdateExperimentThread();
            this.updateThread.start();
        } else {
            this.restart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restart() {
        try {
            RetrieveExperimentFromDb retrieveExperimentFromDb = this.updateThread;
            synchronized (retrieveExperimentFromDb) {
                this.updateThread.notifyAll();
            }
        }
        catch (Exception exception) {
            FableUtils.excMsg((Object)this, (String)"An error occured while trying to restart processing", (Throwable)exception);
            System.out.println("An exception has been thrown while trying to wake up updateThread: " + exception.getMessage());
        }
    }

    public void compressFiles(String string) {
        block6: {
            String string2 = String.valueOf(preprocessor.getZipCmd()) + " " + string;
            this.setLogMessage(new PreprocessorMessage(string2, 1));
            if (System.getProperty("os.name").toLowerCase().contains("window")) {
                string2 = "cmd /C " + string2;
            }
            try {
                Process process = Runtime.getRuntime().exec(string2);
                StreamReaderThread streamReaderThread = new StreamReaderThread(process.getInputStream());
                StreamReaderThread streamReaderThread2 = new StreamReaderThread(process.getErrorStream());
                streamReaderThread.start();
                streamReaderThread2.start();
                try {
                    process.waitFor();
                    streamReaderThread.join();
                    streamReaderThread2.join();
                    if (process.waitFor() == 0) {
                        Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Compression finished", 1));
                        Activator.log(String.valueOf(string2) + " finished");
                        break block6;
                    }
                    Activator.log("ERROR:" + string2 + " has not finished properly :  " + process.waitFor(), 4, null);
                    this.setLogMessage(new PreprocessorMessage("ERROR:" + string2 + " has not finished properly :  " + process.waitFor(), 0));
                }
                catch (InterruptedException interruptedException) {
                    FableUtils.excMsg((Object)this, (String)(String.valueOf(string2) + " has not finished properly :  "), (Throwable)interruptedException);
                }
            }
            catch (IOException iOException) {
                FableUtils.excMsg((Object)this, (String)(String.valueOf(string2) + " has not finished properly :  "), (Throwable)iOException);
            }
        }
    }

    class ProcessThread
    extends Thread {
        private Boolean applyDark;
        private Boolean applyFlood;
        private Boolean applySpatial;
        private String markNewFileFlag;
        private boolean stopProcessing;
        private boolean onLineMode;
        private long threadTimer;
        private String fileFilter;
        private String threadSampleDirectory;
        private Sample threadSample;
        private String threadSampleName;
        private List<Process> process = new ArrayList<Process>();
        private int nFilesToProcess = 0;

        public ProcessThread(Sample sample, boolean bl, boolean bl2, boolean bl3, String string, String string2) {
            this.threadSample = sample;
            this.threadSampleDirectory = sample.getDirectoryPath();
            char c = this.threadSampleDirectory.contains("\\") ? (char)'\\' : '/';
            this.threadSampleDirectory = String.valueOf(this.threadSampleDirectory) + c;
            this.applyDark = bl;
            this.applyFlood = bl2;
            this.applySpatial = bl3;
            this.stopProcessing = false;
            this.threadSampleName = sample.getDirectoryName();
            this.fileFilter = string2;
            this.onLineMode = !string.equals("OFF");
            this.markNewFileFlag = Preprocessor.getDefault().get_cor_ext();
        }

        @Override
        public void run() {
            this.threadTimer = System.currentTimeMillis();
            Activator.log("Preprocessor Thread start for " + this.toString());
            if (this.onLineMode) {
                Activator.log("Waiting for new files in " + this.threadSampleName);
                Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Waiting for new files in " + this.threadSampleName + ".... ", 1));
            }
            if (Preprocessor.this.isOnLine()) {
                this.processOnLine();
            } else {
                this.processOffline();
            }
        }

        private void processOffline() {
            if (!this.stopProcessing) {
                Object[] objectArray = null;
                if (preprocessor.getM_mode().equals("OFF")) {
                    objectArray = this.threadSample.getFabioFilesToProcess(true);
                } else {
                    objectArray = this.getNewFiles(this.markNewFileFlag);
                    Preprocessor.this.sample.addCurrentFiles((String[])objectArray);
                }
                if (objectArray != null && objectArray.length != 0) {
                    numberImages += objectArray.length;
                    this.setNFilesToProcess(objectArray.length);
                } else {
                    numberImages += 0;
                }
                int n = 0;
                if ((this.applyDark.booleanValue() || this.applyFlood.booleanValue() || this.applySpatial.booleanValue()) && objectArray != null && !objectArray.equals("")) {
                    if (Preprocessor.this.spdMode.equals("server")) {
                        this.sendCommandToServer(preprocessor.getCommand(), (String[])objectArray);
                    } else {
                        this.buildCommand(preprocessor.getCommand(), objectArray);
                    }
                }
                if (this.stopProcessing && n - 1 < objectArray.length) {
                    Integer n2 = objectArray.length - n;
                    Activator.log("Process has been stopped. Number of files to treat : " + n2.toString());
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Process has been stopped. Number of files to treat : " + n2.toString(), 1));
                }
                --Preprocessor.this.processWorked;
                if (Preprocessor.this.processWorked == 0) {
                    this.stopProcessing = true;
                }
            }
            this.interrupt();
            Activator.log("Process ends for " + this.threadSampleName);
            Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Process ends for " + this.threadSampleName, 1));
            if (numberImages == 0) {
                ProcessingView.getDefault().setDescription(numberImages, "finished processing files", 1);
                ProcessingView.getDefault().updateDirectory();
            }
            Preprocessor.getDefault().setM_bStatusProcessing(false);
        }

        private void processOnLine() {
            while (!this.stopProcessing) {
                Object[] objectArray = null;
                if (preprocessor.getM_mode().equals("OFF")) {
                    objectArray = this.threadSample.getFabioFilesToProcess(true);
                } else {
                    objectArray = this.getNewFiles(this.markNewFileFlag);
                    Preprocessor.this.sample.addCurrentFiles((String[])objectArray);
                }
                if (objectArray != null && objectArray.length != 0) {
                    numberImages += objectArray.length;
                    this.setNFilesToProcess(objectArray.length);
                } else {
                    numberImages += 0;
                }
                int n = 0;
                if ((this.applyDark.booleanValue() || this.applyFlood.booleanValue() || this.applySpatial.booleanValue()) && objectArray != null && !objectArray.equals("")) {
                    if (Preprocessor.this.spdMode.equals("server")) {
                        this.sendCommandToServer(preprocessor.getCommand(), (String[])objectArray);
                    } else {
                        this.buildCommand(preprocessor.getCommand(), objectArray);
                    }
                }
                if (n <= 0) continue;
                Activator.log("Waiting for new files in sample:" + this.threadSampleName);
                Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Waiting for new files in sample: " + this.threadSampleName + ".... ", 1));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    FableUtils.excMsg((Object)this, (String)"Sleeping thread waiting for files interrupted", (Throwable)interruptedException);
                }
            }
            this.interrupt();
            Activator.log("Process ends for " + this.threadSampleName);
            Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Process ends for " + this.threadSampleName, 1));
            ProcessingView.getDefault().setDescription(numberImages, "finished processing files", 1);
            Preprocessor.getDefault().setM_bStatusProcessing(false);
        }

        private void importSpdServer() {
            if (Preprocessor.this.spdProxy == null) {
                try {
                    Preprocessor.this.spdProxy = new DeviceProxy(Preprocessor.this.spdServer);
                    Preprocessor.this.spdProxy.set_rpc_protocol(1);
                    Preprocessor.this.spdProxy.set_timeout_millis(60000);
                }
                catch (DevFailed devFailed) {
                    FableUtils.excMsg((Object)this, (String)("Error importing device " + Preprocessor.this.spdServer), (Throwable)devFailed);
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("ERROR importing device " + Preprocessor.this.spdServer, 0));
                }
            }
        }

        private void sendCommandToServer(String string, String[] stringArray) {
            String[] stringArray2;
            DeviceData deviceData;
            if (Preprocessor.this.spdProxy == null) {
                this.importSpdServer();
            }
            String[] stringArray3 = string.split("\\s+");
            int n = 0;
            while (n < stringArray3.length) {
                try {
                    deviceData = new DeviceData();
                    stringArray2 = new String[]{stringArray3[n]};
                    deviceData.insert(stringArray2);
                    Preprocessor.this.spdProxy.command_inout("SpdExecute", deviceData);
                }
                catch (DevFailed devFailed) {
                    FableUtils.excMsg((Object)this, (String)("Error sending command " + stringArray3[n] + " to spd server"), (Throwable)devFailed);
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Error sending command " + stringArray3[n] + " to spd server", 0));
                }
                ++n;
            }
            n = 0;
            while (n < stringArray.length) {
                try {
                    deviceData = new DeviceData();
                    stringArray2 = new String[]{stringArray[n]};
                    deviceData.insert(stringArray2);
                    long l = System.currentTimeMillis();
                    Preprocessor.this.spdProxy.command_inout("SpdExecute", deviceData);
                    long l2 = System.currentTimeMillis() - l;
                    Preprocessor.incrementImagesCorrected();
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Processed file " + stringArray[n] + " took " + l2 + " ms", 1));
                }
                catch (DevFailed devFailed) {
                    FableUtils.excMsg((Object)this, (String)("Error  sending file " + stringArray[n] + " to spd server"), (Throwable)devFailed);
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Error sending file " + stringArray[n] + " to spd server", 0));
                }
                ++n;
            }
        }

        public String[] getNewFiles(String string) {
            String string2 = String.valueOf(this.threadSampleName) + "(\\d+)?\\.(\\w+)?" + string;
            String[] stringArray = ToolBox.getFileNamesByEntireRegex((String)this.threadSampleDirectory, (String)string2, (boolean)true);
            String string3 = String.valueOf(this.threadSampleName) + "(\\d+)?\\." + this.fileFilter;
            String[] stringArray2 = Preprocessor.this.processAll ? ToolBox.getFileNamesByEntireRegex((String)this.threadSampleDirectory, (String)string3, (boolean)true) : ToolBox.getFilesByEntireRegexAndTime((String)this.threadSampleDirectory, (String)string3, (boolean)true, (long)this.threadTimer);
            String[] stringArray3 = null;
            if (stringArray2 != null && stringArray2.length > 0) {
                int n = stringArray2.length;
                int n2 = 0;
                while (n2 < stringArray.length) {
                    int n3 = 0;
                    boolean bl = false;
                    while (!bl && n3 < n) {
                        String string4;
                        int n4 = stringArray2[n3].split("\\.").length;
                        int n5 = stringArray[n2].split("\\.").length;
                        if (n4 == 2 && n5 == 2) {
                            String string5;
                            string4 = stringArray2[n3].split("\\.")[0];
                            if (string4.compareTo(string5 = stringArray[n2].split("\\.")[0]) == 0) {
                                if (n > 1) {
                                    String string6 = stringArray2[n - 1];
                                    stringArray2[n - 1] = stringArray2[n3];
                                    stringArray2[n3] = string6;
                                }
                                bl = true;
                                --n;
                                continue;
                            }
                            ++n3;
                            continue;
                        }
                        Activator.log("Error while getting new Files in preprocesor ; getNewFiles ;  listAllOriginalImagesInDir[j]=" + stringArray2[n3] + " listImagesProcessed[i]=" + stringArray[n2], 4, null);
                        if (n > 1) {
                            string4 = stringArray2[n - 1];
                            stringArray2[n - 1] = stringArray2[n3];
                            stringArray2[n3] = string4;
                        }
                        --n;
                    }
                    ++n2;
                }
                stringArray3 = new String[n];
                n2 = 0;
                while (n2 < n) {
                    stringArray3[n2] = String.valueOf(this.threadSampleDirectory) + stringArray2[n2];
                    Activator.log("New file detected :" + stringArray3[n2]);
                    ++n2;
                }
                if (!Preprocessor.this.checkSize(stringArray3)) {
                    stringArray3 = Preprocessor.this.sample.getFabioFilesToProcess(true);
                    Preprocessor.this.sample.getFabioFiles().removeAllElements();
                }
                if (stringArray3 != null) {
                    ToolBox.quicksort((String[])stringArray3, (int)0, (int)stringArray3.length);
                }
            }
            return stringArray3;
        }

        public void notifyEnd() {
            this.stopProcessing = true;
            if (this.process != null) {
                int n = 0;
                while (n < this.process.size()) {
                    ++n;
                }
            }
        }

        private void buildCommand(String string, Object[] objectArray) {
            String string2 = "";
            int n = 1;
            int n2 = 100 > objectArray.length ? objectArray.length : 100;
            String string3 = "";
            int n3 = 0;
            while (!this.stopProcessing && objectArray != null && n3 < objectArray.length) {
                string2 = (String)objectArray[n3];
                string3 = String.valueOf(string3) + " " + ToolBox.addQuotesForSpacesInName((String)string2, (String)"[\\\\/]", (String)System.getProperty("file.separator"));
                int n4 = n3 + 1;
                int n5 = string3.length();
                if (n4 < objectArray.length) {
                    n5 += ((String)objectArray[n4]).length();
                }
                if (n == n2 || objectArray.length - n3 == 1) {
                    String string4 = String.valueOf(string) + string3;
                    this.executeCommand(string4);
                    n = 1;
                    string3 = "";
                } else {
                    ++n;
                }
                ++n3;
            }
        }

        private void executeCommand(String string) {
            Runtime runtime = Runtime.getRuntime();
            Preprocessor.getDefault().setLogMessage(new PreprocessorMessage(string, 1));
            try {
                Process process = runtime.exec(string);
                this.process.add(process);
                StreamReaderThread streamReaderThread = new StreamReaderThread(process.getInputStream());
                StreamReaderThread streamReaderThread2 = new StreamReaderThread(process.getErrorStream());
                streamReaderThread.start();
                streamReaderThread2.start();
                process.waitFor();
                streamReaderThread.join();
                streamReaderThread2.join();
                if (process.waitFor() == 0) {
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Process finished for command " + string, 1));
                } else {
                    Activator.log("Process for command : " + string + " has not finished properly :  " + process.waitFor(), 4, null);
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("Command has not finished properly:" + string, 0));
                }
            }
            catch (InterruptedException interruptedException) {
                Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An Error occured while waiting for the process to finish (Interrupted exception)", 0));
                FableUtils.excMsg((Object)this, (String)("An Interrupted exception occured while trying to execute command ( processCmd) on file " + Preprocessor.this.currentCorrectedFileName), (Throwable)interruptedException);
            }
            catch (IOException iOException) {
                Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An Error occured while trying to execute command (IOException exception) : " + iOException.getMessage(), 0));
                FableUtils.excMsg((Object)this, (String)("An Error occured while trying to execute command (IOException exception launched in processCmd) on file " + Preprocessor.this.currentCorrectedFileName), (Throwable)iOException);
            }
        }

        public String getInfo() {
            Date date = new Date(this.threadTimer);
            String string = "Thread preprocessor for sample: " + this.threadSampleName;
            string = String.valueOf(string) + "\n";
            string = String.valueOf(string) + "Thread time begin:" + date.toString();
            string = this.onLineMode ? String.valueOf(string) + "Thread preprocessor mode is On Line. \n" : String.valueOf(string) + "Thread Preprocessor mode is Off Line. \n : ";
            string = String.valueOf(string) + " \n";
            if (this.applyDark.booleanValue()) {
                string = String.valueOf(string) + " Dark subtraction will be made.\n ";
            }
            if (this.applySpatial.booleanValue()) {
                string = String.valueOf(string) + " Spatial distortion correction will be made.\n ";
            }
            if (this.applyFlood.booleanValue()) {
                string = String.valueOf(string) + " Flood correction  will be made.\n ";
            }
            return string;
        }

        public void setNFilesToProcess(int n) {
            this.nFilesToProcess = n;
        }

        public int getNFilesToProcess() {
            return this.nFilesToProcess;
        }
    }

    public class StreamReaderThread
    extends Thread {
        String outputMessage;
        InputStream inStream;

        public StreamReaderThread(InputStream inputStream) {
            this.inStream = inputStream;
        }

        @Override
        public void run() {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.inStream));
            int n = 0;
            try {
                while ((this.outputMessage = bufferedReader.readLine()) != null) {
                    Preprocessor.getDefault().setLogMessage(new PreprocessorMessage(this.outputMessage, 1));
                    n = this.outputMessage.indexOf("Correcting") + 1;
                    if (n > 0) {
                        Preprocessor.incrementImagesCorrected();
                        if ((n += new String("Correcting").length()) >= this.outputMessage.length()) continue;
                        Preprocessor.this.currentCorrectedFileName = this.outputMessage.substring(n);
                        if (!Preprocessor.this.zipOriginalfiles) continue;
                        Preprocessor.this.compressFiles(Preprocessor.this.currentCorrectedFileName);
                        continue;
                    }
                    n = this.outputMessage.indexOf("Saving corrected image to file") + 1;
                    if (n <= 0 || (n += new String("Saving corrected image to file").length()) >= this.outputMessage.length()) continue;
                    String string = this.outputMessage.substring(n);
                    if (!Preprocessor.this.zipCorrectedFiles) continue;
                    Preprocessor.this.compressFiles(string);
                }
            }
            catch (IOException iOException) {
                FableUtils.excMsg((Object)this, (String)("An error occured " + Preprocessor.this._threadProcess.threadSampleName + " " + iOException.getMessage()), (Throwable)iOException);
                Preprocessor.getDefault().setLogMessage(new PreprocessorMessage("An error occured " + Preprocessor.this._threadProcess.threadSampleName + " " + iOException.getMessage(), 0));
            }
        }
    }
}

