/*
 * Decompiled with CFR 0.152.
 */
package fable.preprocessor.preferences;

import fable.framework.toolboxpreferences.StringFieldEditorWithRegex;
import fable.preprocessor.Activator;
import fable.preprocessor.toolBox.Toolbox;
import fable.preprocessor.views.SpdView;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SpdPreferences
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private Composite parent;
    public static final String FILE_DARK = "pref_dark_file";
    public static final String FILE_FLOOD = "pref_flood_file";
    public static final String FILE_DIST = "pref_dist_file";
    public static final String APPLY_DARK = "pref_auto_dark";
    public static final String APPLY_FLOOD = "pref_auto_flood";
    public static final String APPLY_DIST = "pref_auto_dist";
    public static final String DARK_FILE_MODE = "pref_dark_getFileMode";
    public static final String FLOOD_FILE_MODE = "pref_flood_getFileMode";
    public static final String DIST_FILE_MODE = "pref_dist_getFileMode";
    public static final String EXT_COR = "pref_ext_COR";
    public static final String EXT_COR_RADIO = "pref_ext_COR_SELECT";
    public static final String EXT_DARK = "pref_ext_dark";
    public static final String EXT_DIST = "pref_ext_dist";
    public static final String EXT_FLOOD = "pref_ext_flood";
    public static final String SPD_OTHER_OPTIONS = "pref_spd_otherOptions";
    public static final String ZIP_ORIGINALFILES = "pref_zipOriginal";
    public static final String ZIP_CORRECTEDFILES = "pref_zipCorrected";
    public static final String ZIP_PROGRAM = "pref_zip_program";
    public static final String TYPE = "pref_type";
    public static final String DVO = "pref_dvo";
    private BooleanFieldEditor bZip;
    private FileFieldEditor bZip_program;
    private BooleanFieldEditor bapplyDark;
    private BooleanFieldEditor bapplyFlood;
    private BooleanFieldEditor bapplyDist;
    private RadioGroupFieldEditor bDarkfileMode;
    private RadioGroupFieldEditor bFloodFileMode;
    private RadioGroupFieldEditor bDistFileMode;
    private RadioGroupFieldEditor modecor_ext;
    private FileFieldEditor fileDark;
    private FileFieldEditor fileFlood;
    private FileFieldEditor filedist;
    private StringFieldEditorWithRegex ext_cor;
    private IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
    private StringFieldEditor spd_other_options;
    private RadioGroupFieldEditor type;
    private StringFieldEditor dvo;
    private BooleanFieldEditor bZipCorrected;
    private List<FieldEditor> fieldsEditors;

    public SpdPreferences() {
        super(1);
        this.setPreferenceStore(this.preferences);
        this.fieldsEditors = new ArrayList<FieldEditor>();
    }

    public void performDefaults() {
        this.fileDark.loadDefault();
        this.fileFlood.loadDefault();
        this.filedist.loadDefault();
        this.bapplyDark.loadDefault();
        this.bapplyDist.loadDefault();
        this.bapplyFlood.loadDefault();
        this.ext_cor.loadDefault();
        this.modecor_ext.loadDefault();
        this.spd_other_options.loadDefault();
        this.bDarkfileMode.loadDefault();
        this.bDistFileMode.loadDefault();
        this.bFloodFileMode.loadDefault();
        this.bZip.loadDefault();
        this.bZip_program.loadDefault();
        if (Toolbox.isSpdNew() && this.type != null) {
            this.type.loadDefault();
        }
        if (Toolbox.isSpdNew() && this.dvo != null) {
            this.dvo.loadDefault();
        }
    }

    public boolean performOk() {
        boolean bl = super.performOk();
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        SpdView spdView = (SpdView)iWorkbenchWindow.getActivePage().findView(SpdView.getID());
        if (spdView != null) {
            spdView.setPreferencesValues();
        }
        return bl;
    }

    protected void createFieldEditors() {
        String[] stringArray = new String[]{"*.edf", "*.*"};
        String[] stringArray2 = new String[]{"*.spd", "*.spline", "*.*"};
        Composite composite = this.getFieldEditorParent();
        GridLayout gridLayout = new GridLayout();
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        Composite composite2 = new Composite(composite, 4);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        composite2.setLayout((Layout)gridLayout2);
        this.modecor_ext = new RadioGroupFieldEditor(EXT_COR_RADIO, "output extension", 2, (String[][])new String[][]{{"Default .cor", "Default"}, {"Other ", "Other"}}, composite, true);
        this.addField((FieldEditor)this.modecor_ext);
        this.fieldsEditors.add((FieldEditor)this.modecor_ext);
        this.ext_cor = new StringFieldEditorWithRegex(EXT_COR, "Extension", this.modecor_ext.getRadioBoxControl(composite));
        this.ext_cor.set_regex("\\p{Punct}|\\p{Space}", "Punctuation and spaces are not allowed");
        this.addField((FieldEditor)this.ext_cor);
        this.fieldsEditors.add((FieldEditor)this.ext_cor);
        this.bZipCorrected = new BooleanFieldEditor(ZIP_CORRECTEDFILES, "Compress corrected files", composite);
        this.bZipCorrected.setLabelText("Compress corrected files after processing");
        this.addField((FieldEditor)this.bZipCorrected);
        this.fieldsEditors.add((FieldEditor)this.bZipCorrected);
        this.bZip = new BooleanFieldEditor(ZIP_ORIGINALFILES, "Compress original files", composite);
        this.bZip.setLabelText("Compress original files after processing");
        this.addField((FieldEditor)this.bZip);
        this.fieldsEditors.add((FieldEditor)this.bZip);
        this.bZip_program = new FileFieldEditor(ZIP_PROGRAM, "Select GZip", composite);
        this.bZip_program.setLabelText("Gzip program");
        this.addField((FieldEditor)this.bZip_program);
        this.fieldsEditors.add((FieldEditor)this.bZip_program);
        if (Toolbox.isSpdNew()) {
            this.type = new RadioGroupFieldEditor(TYPE, "Output file format", 2, (String[][])new String[][]{{"Unsigned Integer", "type_int"}, {"Float ", "type_float"}}, composite, true);
            this.addField((FieldEditor)this.type);
            this.fieldsEditors.add((FieldEditor)this.type);
            this.dvo = new StringFieldEditor(DVO, "Data value offset", composite);
            this.addField((FieldEditor)this.dvo);
            this.fieldsEditors.add((FieldEditor)this.dvo);
        }
        this.bapplyDark = new BooleanFieldEditor(APPLY_DARK, "Apply dark", composite);
        this.addField((FieldEditor)this.bapplyDark);
        this.fieldsEditors.add((FieldEditor)this.bapplyDark);
        this.bDarkfileMode = new RadioGroupFieldEditor(DARK_FILE_MODE, "File option", 3, (String[][])new String[][]{{"None", "darkfileNoneRadio"}, {"From header ", "darkHeaderRadio"}, {"File ", "darkFromFileRadio"}}, composite, true);
        this.addField((FieldEditor)this.bDarkfileMode);
        this.fieldsEditors.add((FieldEditor)this.bDarkfileMode);
        this.fileDark = new FileFieldEditor(FILE_DARK, "Dark file", this.bDarkfileMode.getRadioBoxControl(composite));
        this.fileDark.setFileExtensions(stringArray);
        this.addField((FieldEditor)this.fileDark);
        this.fieldsEditors.add((FieldEditor)this.fileDark);
        this.bapplyFlood = new BooleanFieldEditor(APPLY_FLOOD, "Apply flood", composite);
        this.addField((FieldEditor)this.bapplyFlood);
        this.fieldsEditors.add((FieldEditor)this.bapplyFlood);
        this.bFloodFileMode = new RadioGroupFieldEditor(FLOOD_FILE_MODE, "File option", 3, (String[][])new String[][]{{"None", "floodfileNoneRadio"}, {"From header ", "floodHeaderRadio"}, {"File ", "floodFromFileRadio"}}, composite, true);
        this.addField((FieldEditor)this.bFloodFileMode);
        this.fieldsEditors.add((FieldEditor)this.bFloodFileMode);
        this.fileFlood = new FileFieldEditor(FILE_FLOOD, "Flood file", this.bFloodFileMode.getRadioBoxControl(composite));
        this.fileFlood.setFileExtensions(stringArray);
        this.addField((FieldEditor)this.fileFlood);
        this.fieldsEditors.add((FieldEditor)this.fileFlood);
        this.bapplyDist = new BooleanFieldEditor(APPLY_DIST, "Apply spatial distortion", composite);
        this.addField((FieldEditor)this.bapplyDist);
        this.fieldsEditors.add((FieldEditor)this.bapplyDist);
        this.bDistFileMode = new RadioGroupFieldEditor(DIST_FILE_MODE, "File option", 3, (String[][])new String[][]{{"None", "distfileNoneRadio"}, {"From header ", "distHeaderRadio"}, {"File ", "distFromFileRadio"}}, composite, true);
        this.addField((FieldEditor)this.bDistFileMode);
        this.fieldsEditors.add((FieldEditor)this.bDistFileMode);
        this.filedist = new FileFieldEditor(FILE_DIST, "Spatial distortion file", this.bDistFileMode.getRadioBoxControl(composite));
        this.filedist.setFileExtensions(stringArray2);
        this.addField((FieldEditor)this.filedist);
        this.fieldsEditors.add((FieldEditor)this.filedist);
        this.spd_other_options = new StringFieldEditor(SPD_OTHER_OPTIONS, "Other options for spd", composite);
        this.addField((FieldEditor)this.spd_other_options);
        this.fieldsEditors.add((FieldEditor)this.spd_other_options);
        this.setErrorMessageForAllFields(this.fieldsEditors);
    }

    public boolean isValid() {
        boolean bl = super.isValid();
        if (!bl) {
            this.getErrorMessage();
        } else {
            this.setErrorMessage(null);
        }
        return true;
    }

    public boolean okToLeave() {
        return super.okToLeave();
    }

    public void setErrorMessage(String string) {
        super.setErrorMessage(string);
    }

    private void setErrorMessageForAllFields(List<FieldEditor> list) {
        for (FieldEditor fieldEditor : list) {
            StringFieldEditor stringFieldEditor;
            if (fieldEditor instanceof StringFieldEditor) {
                stringFieldEditor = (StringFieldEditor)fieldEditor;
                stringFieldEditor.setErrorMessage(String.valueOf(stringFieldEditor.getLabelText()) + " " + stringFieldEditor.getErrorMessage());
                continue;
            }
            if (!(fieldEditor instanceof FileFieldEditor)) continue;
            stringFieldEditor = (FileFieldEditor)fieldEditor;
            stringFieldEditor.setErrorMessage(String.valueOf(stringFieldEditor.getLabelText()) + " :" + stringFieldEditor.getErrorMessage().toLowerCase());
        }
    }

    public void init(IWorkbench iWorkbench) {
    }
}

