/*
 * Decompiled with CFR 0.152.
 */
package fable.preprocessor.preferences;

import fable.preprocessor.Activator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreferenceCommand
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String CMD_SPD = "pref_cmd_spd";
    public static final String SPD_MODE = "pref_spd_mode";
    public static final String SPD_SERVER = "pref_spd_server";
    public static final String PREPROCESSOR_MODE_ONOFF = "pref_mode";
    private FileFieldEditor spdCommand;
    private StringFieldEditor spdServer;
    private RadioGroupFieldEditor runMode;
    private RadioGroupFieldEditor spdMode;
    private FileFieldEditor cmdGrainspotter;
    private IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
    private List<FieldEditor> fieldsEditors;

    public PreferenceCommand() {
        super(1);
        this.setPreferenceStore(this.preferences);
        this.fieldsEditors = new ArrayList<FieldEditor>();
    }

    protected void createFieldEditors() {
        final Composite composite = this.getFieldEditorParent();
        GridLayout gridLayout = new GridLayout();
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        GridData gridData2 = new GridData(768);
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        this.spdCommand = new FileFieldEditor(CMD_SPD, "Command", composite);
        this.spdCommand.setValidateStrategy(1);
        this.addField((FieldEditor)this.spdCommand);
        this.fieldsEditors.add((FieldEditor)this.spdCommand);
        this.spdServer = new StringFieldEditor(SPD_SERVER, "Spd device server", composite);
        this.addField((FieldEditor)this.spdServer);
        this.fieldsEditors.add((FieldEditor)this.spdServer);
        this.spdMode = new RadioGroupFieldEditor(SPD_MODE, "Spd mode", 2, (String[][])new String[][]{{"Command line", "OFF"}, {"Device server", "server"}}, composite, true);
        this.addField((FieldEditor)this.spdMode);
        this.fieldsEditors.add((FieldEditor)this.spdMode);
        this.spdMode.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = (String)propertyChangeEvent.getNewValue();
                if (string.equals("server")) {
                    Control control = PreferenceCommand.this.runMode.getRadioBoxControl(composite).getChildren()[0];
                    ((Button)control).setSelection(true);
                }
            }
        });
        this.runMode = new RadioGroupFieldEditor(PREPROCESSOR_MODE_ONOFF, "Run mode", 2, (String[][])new String[][]{{"On line", "ON"}, {"Off Line", "OFF"}}, composite, true);
        this.addField((FieldEditor)this.runMode);
        this.fieldsEditors.add((FieldEditor)this.runMode);
        this.setErrorMessageForAllFields(this.fieldsEditors);
    }

    public boolean isValid() {
        boolean bl = super.isValid();
        if (!bl) {
            this.getErrorMessage();
        } else {
            this.setErrorMessage(null);
        }
        return true;
    }

    public boolean okToLeave() {
        return super.okToLeave();
    }

    protected void performDefaults() {
        this.cmdGrainspotter.loadDefault();
        super.performDefaults();
    }

    private void setErrorMessageForAllFields(List<FieldEditor> list) {
        for (FieldEditor fieldEditor : list) {
            StringFieldEditor stringFieldEditor;
            if (fieldEditor instanceof StringFieldEditor) {
                stringFieldEditor = (StringFieldEditor)fieldEditor;
                stringFieldEditor.setErrorMessage(String.valueOf(stringFieldEditor.getLabelText()) + " " + stringFieldEditor.getErrorMessage());
                continue;
            }
            if (!(fieldEditor instanceof FileFieldEditor)) continue;
            stringFieldEditor = (FileFieldEditor)fieldEditor;
            stringFieldEditor.setErrorMessage(String.valueOf(stringFieldEditor.getLabelText()) + " :" + stringFieldEditor.getErrorMessage().toLowerCase());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if (((FieldEditor)propertyChangeEvent.getSource()).getPreferenceName().equals(SPD_MODE) && !propertyChangeEvent.getNewValue().equals(propertyChangeEvent.getOldValue()) && propertyChangeEvent.getNewValue().equals("server")) {
            this.preferences.setValue(PREPROCESSOR_MODE_ONOFF, "ON");
            this.runMode.load();
        }
    }

    public void init(IWorkbench iWorkbench) {
    }
}

