/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.map;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.ObservableMap;
import org.eclipse.core.internal.databinding.Util;

public class WritableMap
extends ObservableMap {
    public WritableMap() {
        this(Realm.getDefault());
    }

    public WritableMap(Realm realm) {
        super(realm, new HashMap());
    }

    public Object put(Object key, Object value) {
        this.checkRealm();
        Object result = this.wrappedMap.put(key, value);
        if (!Util.equals(result, value)) {
            if (result == null) {
                this.fireMapChange(Diffs.createMapDiffSingleAdd(key, value));
            } else {
                this.fireMapChange(Diffs.createMapDiffSingleChange(key, result, value));
            }
        }
        return result;
    }

    public Object remove(Object key) {
        this.checkRealm();
        Object result = this.wrappedMap.remove(key);
        if (result != null) {
            this.fireMapChange(Diffs.createMapDiffSingleRemove(key, result));
        }
        return result;
    }

    public void clear() {
        this.checkRealm();
        if (!this.isEmpty()) {
            HashMap copy = new HashMap(this.wrappedMap);
            this.wrappedMap.clear();
            this.fireMapChange(Diffs.createMapDiffRemoveAll(copy));
        }
    }

    public void putAll(Map map) {
        this.checkRealm();
        HashSet addedKeys = new HashSet(map.size());
        HashMap changes = new HashMap(map.size());
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object previousValue = this.wrappedMap.put(entry.getKey(), entry.getValue());
            if (previousValue == null) {
                addedKeys.add(entry.getKey());
                continue;
            }
            changes.put(entry.getKey(), previousValue);
        }
        if (!addedKeys.isEmpty() || !changes.isEmpty()) {
            this.fireMapChange(Diffs.createMapDiff(addedKeys, Collections.EMPTY_SET, changes.keySet(), changes, this.wrappedMap));
        }
    }
}

