/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Shade3D;

class Sphere3D {
    Graphics3D g3d;
    private int zShift;
    private static final int maxSphereCache = 128;
    private static final int maxOddSizeSphere = 49;
    private static final int maxSphereDiameter = 1000;
    private static final int[][] sphereShapeCache = new int[128][];
    private static final int SHADE_SLAB_CLIPPED = Shade3D.shadeNormal - 5;

    Sphere3D(Graphics3D graphics3D) {
        this.g3d = graphics3D;
    }

    static synchronized void flushSphereCache() {
        int n = 128;
        while (--n >= 0) {
            Sphere3D.sphereShapeCache[n] = null;
        }
    }

    private static int[] getSphereShape(int n) {
        int[] nArray = sphereShapeCache[n - 1];
        return nArray == null ? Sphere3D.createSphereShape(n) : nArray;
    }

    private static synchronized int[] createSphereShape(int n) {
        float f;
        int n2 = 0;
        boolean bl = (n & 1) != 0;
        float f2 = (float)n / 2.0f;
        float f3 = f2 * f2;
        int n3 = (n + 1) / 2;
        float f4 = bl ? 0.0f : 0.5f;
        int n4 = 0;
        while (n4 < n3) {
            float f5 = f4 * f4;
            float f6 = bl ? 0.0f : 0.5f;
            int n5 = 0;
            while (n5 < n3) {
                f = f6 * f6;
                float f7 = f3 - f5 - f;
                if (f7 >= 0.0f) {
                    ++n2;
                }
                ++n5;
                f6 += 1.0f;
            }
            ++n4;
            f4 += 1.0f;
        }
        int[] nArray = new int[n2];
        int n6 = 0;
        f4 = bl ? 0.0f : 0.5f;
        int n7 = 0;
        while (n7 < n3) {
            float f8 = f4 * f4;
            f = bl ? 0.0f : 0.5f;
            int n8 = 0;
            while (n8 < n3) {
                float f9 = f * f;
                float f10 = f3 - f8 - f9;
                if (f10 >= 0.0f) {
                    float f11 = (float)Math.sqrt(f10);
                    int n9 = (int)f11;
                    byte by = Shade3D.calcDitheredNoisyIntensity(f, f4, f11, f2);
                    byte by2 = Shade3D.calcDitheredNoisyIntensity(-f, f4, f11, f2);
                    byte by3 = Shade3D.calcDitheredNoisyIntensity(f, -f4, f11, f2);
                    byte by4 = Shade3D.calcDitheredNoisyIntensity(-f, -f4, f11, f2);
                    int n10 = n9 | by << 7 | by2 << 13 | by3 << 19 | by4 << 25;
                    nArray[n6++] = n10;
                }
                ++n8;
                f += 1.0f;
            }
            int n11 = n6 - 1;
            nArray[n11] = nArray[n11] | Integer.MIN_VALUE;
            ++n7;
            f4 += 1.0f;
        }
        Sphere3D.sphereShapeCache[n - 1] = nArray;
        return nArray;
    }

    void render(int[] nArray, boolean bl, int n, int n2, int n3, int n4) {
        if (n4 == 1) {
            return;
        }
        if (n > 49) {
            n &= 0xFFFFFFFE;
        }
        int n5 = n + 1 >> 1;
        int n6 = n2 - n5;
        int n7 = n2 + n5;
        if (n7 < 0 || n6 >= this.g3d.width) {
            return;
        }
        int n8 = n3 - n5;
        int n9 = n3 + n5;
        if (n9 < 0 || n8 >= this.g3d.height) {
            return;
        }
        int n10 = n4 - n5;
        int n11 = n4 + n5;
        if (n11 < this.g3d.slab || n10 > this.g3d.depth) {
            return;
        }
        if (n > 128) {
            if (n <= 1000) {
                this.renderLargeSphere(nArray, bl, n, n2, n3, n4);
            }
            return;
        }
        this.zShift = this.g3d.getZShift(n4);
        int[] nArray2 = Sphere3D.getSphereShape(n);
        if (n6 < 0 || n7 >= this.g3d.width || n8 < 0 || n9 >= this.g3d.height || n10 < this.g3d.slab || n4 > this.g3d.depth) {
            this.renderShapeClipped(nArray, bl, nArray2, n, n2, n3, n4);
        } else {
            this.renderShapeUnclipped(nArray, bl, nArray2, n, n2, n3, n4);
        }
    }

    private void renderShapeUnclipped(int[] nArray, boolean bl, int[] nArray2, int n, int n2, int n3, int n4) {
        int[] nArray3 = this.g3d.zbuf;
        int n5 = 0;
        int n6 = this.g3d.width;
        int n7 = 1 - (n & 1);
        int n8 = n6 * n3 + n2;
        int n9 = n8 - n7 * n6;
        int n10 = (n + 1) / 2;
        if (!bl) {
            do {
                int n11;
                int n12 = n8;
                int n13 = n8 - n7;
                int n14 = n9;
                int n15 = n9 - n7;
                do {
                    int n16;
                    if ((n16 = n4 - ((n11 = nArray2[n5++]) & 0x7F)) < nArray3[n12]) {
                        this.g3d.addPixel(n12, n16, nArray[(n11 >> 7 & 0x3F) >> this.zShift]);
                    }
                    if (n16 < nArray3[n13]) {
                        this.g3d.addPixel(n13, n16, nArray[(n11 >> 13 & 0x3F) >> this.zShift]);
                    }
                    if (n16 < nArray3[n14]) {
                        this.g3d.addPixel(n14, n16, nArray[(n11 >> 19 & 0x3F) >> this.zShift]);
                    }
                    if (n16 < nArray3[n15]) {
                        this.g3d.addPixel(n15, n16, nArray[(n11 >> 25 & 0x3F) >> this.zShift]);
                    }
                    ++n12;
                    --n13;
                    ++n14;
                    --n15;
                } while (n11 >= 0);
                n8 += n6;
                n9 -= n6;
            } while (--n10 > 0);
            return;
        }
        int n17 = (n2 ^ n3) & 1;
        int n18 = n17 ^ n7;
        int n19 = n17;
        int n20 = n17 ^ n7;
        int n21 = n18;
        int n22 = n18 ^ n7;
        int n23 = n19 | n20 << 1 | n21 << 2 | n22 << 3;
        do {
            int n24;
            int n25 = n8;
            int n26 = n8 - n7;
            int n27 = n9;
            int n28 = n9 - n7;
            int n29 = n23 ^= 0xFFFFFFFF;
            do {
                n24 = nArray2[n5++];
                int n30 = n4 - (n24 & 0x7F);
                if ((n29 & 1) != 0 && n30 < nArray3[n25]) {
                    this.g3d.addPixel(n25, n30, nArray[(n24 >> 7 & 0x3F) >> this.zShift]);
                }
                if ((n29 & 2) != 0 && n30 < nArray3[n26]) {
                    this.g3d.addPixel(n26, n30, nArray[(n24 >> 13 & 0x3F) >> this.zShift]);
                }
                if ((n29 & 4) != 0 && n30 < nArray3[n27]) {
                    this.g3d.addPixel(n27, n30, nArray[(n24 >> 19 & 0x3F) >> this.zShift]);
                }
                if ((n29 & 8) != 0 && n30 < nArray3[n28]) {
                    this.g3d.addPixel(n28, n30, nArray[(n24 >> 25 & 0x3F) >> this.zShift]);
                }
                ++n25;
                --n26;
                ++n27;
                --n28;
                n29 ^= 0xFFFFFFFF;
            } while (n24 >= 0);
            n8 += n6;
            n9 -= n6;
        } while (--n10 > 0);
    }

    private void renderShapeClipped(int[] nArray, boolean bl, int[] nArray2, int n, int n2, int n3, int n4) {
        int[] nArray3 = this.g3d.zbuf;
        boolean bl2 = this.g3d.addAllPixels;
        int n5 = 0;
        int n6 = this.g3d.width;
        int n7 = this.g3d.height;
        int n8 = this.g3d.slab;
        int n9 = this.g3d.depth;
        int n10 = 1 - (n & 1);
        int n11 = n6 * n3 + n2;
        int n12 = n11 - n10 * n6;
        int n13 = (n + 1) / 2;
        int n14 = n3;
        int n15 = n3 - n10;
        int n16 = (n2 << 16) + (n3 << 1) ^ 0x33333333;
        int n17 = (n2 ^ n3) & 1;
        int n18 = n17 ^ n10;
        int n19 = n17;
        int n20 = n17 ^ n10;
        int n21 = n18;
        int n22 = n18 ^ n10;
        int n23 = n19 | n20 << 1 | n21 << 2 | n22 << 3;
        do {
            int n24;
            boolean bl3 = n14 >= 0 && n14 < n7;
            boolean bl4 = n15 >= 0 && n15 < n7;
            int n25 = n11;
            int n26 = n11 - n10;
            int n27 = n12;
            int n28 = n12 - n10;
            int n29 = n23 ^= 0xFFFFFFFF;
            int n30 = n2;
            int n31 = n2 - n10;
            do {
                boolean bl5;
                int n32;
                boolean bl6 = n31 >= 0 && n31 < n6;
                boolean bl7 = n30 >= 0 && n30 < n6;
                n24 = nArray2[n5++];
                int n33 = n24 & 0x7F;
                if (n4 < n8) {
                    n32 = n4 + n33;
                    bl5 = n32 >= n8;
                } else {
                    n32 = n4 - n33;
                    boolean bl8 = bl5 = n32 < n8;
                }
                if (bl5) {
                    n32 = n8;
                }
                if (n32 >= n8 && n32 <= n9) {
                    int n34;
                    if (bl3) {
                        if (bl7 && (bl2 || (n29 & 1) != 0) && n32 < nArray3[n25]) {
                            n34 = bl5 ? SHADE_SLAB_CLIPPED - 3 + (n16 >> 7 & 7) : n24 >> 7 & 0x3F;
                            this.g3d.addPixel(n25, n32, nArray[n34 >> this.zShift]);
                        }
                        if (bl6 && (bl2 || (n29 & 2) != 0) && n32 < nArray3[n26]) {
                            n34 = bl5 ? SHADE_SLAB_CLIPPED - 3 + (n16 >> 13 & 7) : n24 >> 13 & 0x3F;
                            this.g3d.addPixel(n26, n32, nArray[n34 >> this.zShift]);
                        }
                    }
                    if (bl4) {
                        if (bl7 && (!bl || (n29 & 4) != 0) && n32 < nArray3[n27]) {
                            n34 = bl5 ? SHADE_SLAB_CLIPPED - 3 + (n16 >> 19 & 7) : n24 >> 19 & 0x3F;
                            this.g3d.addPixel(n27, n32, nArray[n34 >> this.zShift]);
                        }
                        if (bl6 && (!bl || (n29 & 8) != 0) && n32 < nArray3[n28]) {
                            n34 = bl5 ? SHADE_SLAB_CLIPPED - 3 + (n16 >> 25 & 7) : n24 >> 25 & 0x3F;
                            this.g3d.addPixel(n28, n32, nArray[n34 >> this.zShift]);
                        }
                    }
                }
                ++n25;
                --n26;
                ++n27;
                --n28;
                ++n30;
                --n31;
                n29 ^= 0xFFFFFFFF;
                if (!bl5) continue;
                n16 = (n16 << 16) + (n16 << 1) + n16 & Integer.MAX_VALUE;
            } while (n24 >= 0);
            n11 += n6;
            n12 -= n6;
            ++n14;
            --n15;
        } while (--n13 > 0);
    }

    private void renderLargeSphere(int[] nArray, boolean bl, int n, int n2, int n3, int n4) {
        if (!Shade3D.sphereShadingCalculated) {
            Shade3D.calcSphereShading();
        }
        int n5 = n / 2;
        this.renderQuadrant(nArray, bl, n5, n2, n3, n4, -1, -1);
        this.renderQuadrant(nArray, bl, n5, n2, n3, n4, -1, 1);
        this.renderQuadrant(nArray, bl, n5, n2, n3, n4, 1, -1);
        this.renderQuadrant(nArray, bl, n5, n2, n3, n4, 1, 1);
    }

    private void renderQuadrant(int[] nArray, boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl2;
        int n7;
        int n8 = (n2 < 0 ? -1 : (n2 < this.g3d.width ? 0 : 1)) + ((n7 = n2 + n * n5) < 0 ? -2 : (n7 < this.g3d.width ? 0 : 2));
        if (n8 == -3 || n8 == 3) {
            return;
        }
        int n9 = (n3 < 0 ? -1 : (n3 < this.g3d.height ? 0 : 1)) + ((n7 = n3 + n * n6) < 0 ? -2 : (n7 < this.g3d.height ? 0 : 2));
        if (n9 == -3 || n9 == 3) {
            return;
        }
        boolean bl3 = bl2 = n4 - n >= this.g3d.slab && n4 <= this.g3d.depth;
        if (n8 == 0 && n9 == 0 && bl2) {
            this.renderQuadrantUnclipped(nArray, bl, n, n2, n3, n4, n5, n6);
        } else {
            this.renderQuadrantClipped(nArray, bl, n, n2, n3, n4, n5, n6);
        }
    }

    private void renderQuadrantUnclipped(int[] nArray, boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n * n;
        int n8 = n * 2 + 1;
        int[] nArray2 = this.g3d.zbuf;
        boolean bl2 = this.g3d.addAllPixels;
        int n9 = this.g3d.width;
        boolean bl3 = ((n2 ^ n3) & 1) == 0;
        int n10 = n9 * n3 + n2;
        if (n6 < 0) {
            n9 = -n9;
        }
        n10 -= n9;
        int n11 = 0;
        int n12 = 0;
        while (n12 <= n7) {
            int n13 = (n10 += n9) - n5;
            bl3 = !bl3;
            boolean bl4 = bl3;
            int n14 = n7 - n12;
            int n15 = n4 - n;
            int n16 = (n11 * n6 + n << 8) / n8;
            int n17 = 0;
            int n18 = 0;
            while (n18 <= n14) {
                int n19;
                if ((bl2 || (bl4 = !bl4)) && nArray2[n13 += n5] > n15 && nArray2[n13] > (n15 = n4 - (n19 = (int)Math.sqrt(n14 - n18)))) {
                    int n20 = (n17 * n5 + n << 8) / n8;
                    this.g3d.addPixel(n13, n15, nArray[Shade3D.sphereIntensities[(n16 << 8) + n20 >> this.zShift]]);
                }
                n18 += n17 + n17 + 1;
                ++n17;
            }
            n12 += n11 + n11 + 1;
            ++n11;
        }
    }

    private void renderQuadrantClipped(int[] nArray, boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n * n;
        int n8 = n * 2 + 1;
        int[] nArray2 = this.g3d.zbuf;
        int n9 = this.g3d.slab;
        int n10 = this.g3d.depth;
        int n11 = this.g3d.height;
        int n12 = this.g3d.width;
        int n13 = n12 * n3 + n2;
        int n14 = n12;
        int n15 = (n2 << 16) + (n3 << 1) ^ 0x33333333;
        if (n6 < 0) {
            n14 = -n12;
        }
        int n16 = n3 - n6;
        int n17 = 0;
        int n18 = 0;
        while (n18 <= n7) {
            if ((n16 += n6) < 0) {
                if (n6 < 0) {
                    return;
                }
            } else if (n16 >= n11) {
                if (n6 > 0) {
                    return;
                }
            } else {
                int n19 = n13;
                int n20 = n7 - n18;
                int n21 = n2 - n5;
                int n22 = (n17 * n6 + n << 8) / n8;
                n15 = (n15 << 16) + (n15 << 1) + n15 & Integer.MAX_VALUE;
                int n23 = 0;
                int n24 = 0;
                while (n24 <= n20) {
                    if ((n21 += n5) < 0) {
                        if (n5 < 0) {
                            break;
                        }
                    } else if (n21 >= n12) {
                        if (n5 > 0) {
                            break;
                        }
                    } else if (!bl || ((n21 ^ n16) & 1) == 0) {
                        boolean bl2;
                        int n25;
                        int n26 = (int)Math.sqrt(n20 - n24);
                        if (n4 < n9) {
                            n25 = n4 + n26;
                            bl2 = n25 >= n9;
                        } else {
                            n25 = n4 - n26;
                            boolean bl3 = bl2 = n25 < n9;
                        }
                        if (bl2) {
                            n25 = n9;
                        }
                        if (n25 >= n9 && n25 <= n10 && nArray2[n19] > n25) {
                            int n27;
                            if (bl2) {
                                n27 = SHADE_SLAB_CLIPPED - 3 + (n15 >> 8 & 7);
                                n15 = (n15 << 16) + (n15 << 1) + n15 & Integer.MAX_VALUE;
                            } else {
                                int n28 = (n23 * n5 + n << 8) / n8;
                                n27 = Shade3D.sphereIntensities[(n22 << 8) + n28];
                            }
                            this.g3d.addPixel(n19, n25, nArray[n27 >> this.zShift]);
                        }
                    }
                    n24 += n23 + n23 + 1;
                    ++n23;
                    n19 += n5;
                }
                n15 = (n15 + n21 + n16 | 1) & Integer.MAX_VALUE;
            }
            n18 += n17 + n17 + 1;
            ++n17;
            n13 += n14;
        }
    }
}

