/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.logging.FableLogger;
import fable.framework.navigator.controller.SampleController;
import fable.framework.toolbox.FableUtils;
import fable.python.FabioFile;
import fable.python.FabioFileException;
import fable.python.Sample;
import fable.python.jep.FableJep;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import jep.JepException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.part.ViewPart;

public class RockingCurveView
extends ViewPart {
    public static final String ID = "fable.imageviewer.views.RockingCurveView";
    private JLDataView dataView;
    private JLChart chart;
    String title;
    private int rockStart = -1;
    private int rockCenter = -1;
    private int rockEnd = -1;
    private int rockRange;
    private int xAxis = 0;
    private int[] rockArea = new int[4];
    private float[] rockX;
    private float[] rockIntensity;
    private Spinner rockStartSpinner;
    private Spinner rockEndSpinner;
    private Label rockStartLabel;
    private Label rockEndLabel;
    private Button updateButton;
    private Button averageButton;
    private Combo xAxisCombo;
    public static RockingCurveView view;
    private Composite swtAwtComponent;
    public SampleController controller = SampleController.getController();
    public Sample sample = null;
    private Frame chartFrame;
    private JApplet chartContainer;
    Logger logger;
    private IProgressMonitor jobMonitor;
    private final String[] imageNumber = new String[]{"image number"};
    private String[] xAxisItems = this.imageNumber;
    private boolean jobRunning = false;
    private boolean average = true;

    public void createPartControl(Composite composite) {
        view = this;
        this.logger = FableLogger.getLogger(RockingCurveView.class);
        composite.setLayout((Layout)new GridLayout());
        this.createChartFrame(composite);
        this.createChart();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 8;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 0, true, false));
        Label label = new Label(composite2, 0);
        label.setText("X Axis");
        this.xAxisCombo = new Combo(composite2, 0);
        this.xAxisCombo.setItems(this.xAxisItems);
        this.xAxisCombo.select(0);
        this.xAxis = 0;
        this.xAxisCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RockingCurveView.this.xAxis = RockingCurveView.this.xAxisCombo.getSelectionIndex();
            }
        });
        this.rockStartLabel = new Label(composite2, 0);
        this.rockStartLabel.setText("Start");
        this.rockStartSpinner = new Spinner(composite2, 0);
        this.rockEndLabel = new Label(composite2, 0);
        this.rockEndLabel.setText("End");
        this.rockEndSpinner = new Spinner(composite2, 0);
        this.averageButton = new Button(composite2, 32);
        this.averageButton.setText("Average");
        this.averageButton.setSelection(true);
        this.average = true;
        this.averageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (RockingCurveView.this.averageButton.getSelection()) {
                    RockingCurveView.this.average = true;
                } else {
                    RockingCurveView.this.average = false;
                }
            }
        });
        this.updateButton = new Button(composite2, 0);
        this.updateButton.setText("Update");
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RockingCurveView.this.rockStart = RockingCurveView.this.rockStartSpinner.getSelection();
                RockingCurveView.this.rockEnd = RockingCurveView.this.rockEndSpinner.getSelection();
                RockingCurveView.this.runIntegratePlotJob();
            }
        });
    }

    public void setFocus() {
    }

    private void createChartFrame(Composite composite) {
        this.swtAwtComponent = new Composite(composite, 0x1040000);
        this.swtAwtComponent.setLayout((Layout)new GridLayout());
        this.swtAwtComponent.setLayoutData((Object)new GridData(1808));
        this.chartFrame = SWT_AWT.new_Frame((Composite)this.swtAwtComponent);
        this.chartContainer = new JApplet();
        this.chartFrame.add(this.chartContainer);
    }

    public void createChart() {
        this.chart = new JLChart();
        this.chart.setHeader("Rocking Curve Plot");
        this.chart.setHeaderFont(new Font("Dialog", 1, 18));
        this.chart.getY1Axis().setName("integrated intensity");
        this.chart.getY1Axis().setAutoScale(true);
        this.chart.getXAxis().setAutoScale(true);
        this.chart.getXAxis().setName("image number");
        this.chart.getXAxis().setGridVisible(true);
        this.chart.getXAxis().setSubGridVisible(true);
        this.chart.getXAxis().setAnnotation(2);
        this.chart.getY1Axis().setGridVisible(true);
        this.chart.getY1Axis().setSubGridVisible(true);
        this.dataView = new JLDataView();
        this.dataView.setName("integrated intensity [" + this.rockArea[0] + "," + this.rockArea[1] + "] - [" + this.rockArea[2] + "," + this.rockArea[3] + "]");
        this.chart.getY1Axis().addDataView(this.dataView);
        this.chartContainer.add((Component)this.chart);
    }

    public void setCenterArea(String string, int n, int n2, int n3, int n4, int n5) {
        if (!this.jobRunning) {
            this.jobRunning = true;
            if (this.sample != this.controller.getCurrentsample()) {
                this.sample = this.controller.getCurrentsample();
                try {
                    String[] stringArray = ((FabioFile)this.sample.getFilteredfiles().get(0)).getKeys();
                    this.xAxisItems = new String[1 + stringArray.length];
                    this.xAxisItems[0] = "image number";
                    int n6 = 0;
                    while (n6 < stringArray.length) {
                        this.xAxisItems[n6 + 1] = stringArray[n6];
                        ++n6;
                    }
                }
                catch (FabioFileException fabioFileException) {
                    FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error setting center area", (Throwable)fabioFileException);
                }
                catch (JepException jepException) {
                    FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error setting center area", (Throwable)jepException);
                }
                this.xAxisCombo.setItems(this.xAxisItems);
                this.xAxisCombo.select(0);
                this.xAxis = 0;
            }
            this.title = string;
            this.rockStartSpinner.setMaximum(this.sample.getFilteredfiles().size() - 1);
            this.rockEndSpinner.setMaximum(this.sample.getFilteredfiles().size() - 1);
            this.rockArea[0] = n2;
            this.rockArea[1] = n3;
            this.rockArea[2] = n4;
            this.rockArea[3] = n5;
            this.rockCenter = n;
            this.rockRange = this.rockEnd - this.rockStart;
            this.rockStart = this.rockRange <= 3 ? n - 3 : n - this.rockRange / 2;
            this.rockEnd = this.rockRange <= 3 ? n + 3 : n + (this.rockRange + 1) / 2;
            this.checkRockRange();
            this.runIntegratePlotJob();
        }
    }

    public void checkRockRange() {
        if (this.rockStart < 0) {
            this.rockStart = 0;
        }
        if (this.rockEnd > this.sample.getFilteredfiles().size() - 1) {
            this.rockEnd = this.sample.getFilteredfiles().size() - 1;
        }
        if (this.rockStart > this.rockEnd) {
            int n = this.rockStart;
            this.rockStart = this.rockEnd;
            this.rockEnd = n;
        }
        this.rockStartSpinner.setSelection(this.rockStart);
        this.rockEndSpinner.setSelection(this.rockEnd);
    }

    public void runIntegratePlotJob() {
        Job job = new Job("Integrate rocking curve for sample " + this.sample.getDirectoryName() + " ... "){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                RockingCurveView.this.jobMonitor = iProgressMonitor;
                iProgressMonitor.beginTask("Integrate rocking curve for sample " + RockingCurveView.this.sample.getDirectoryName() + " ... ", RockingCurveView.this.rockEnd - RockingCurveView.this.rockStart + 1);
                if (RockingCurveView.this.Integrate() != 0) {
                    iProgressMonitor.done();
                    return Status.CANCEL_STATUS;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RockingCurveView.this.Plot();
                    }
                });
                iProgressMonitor.done();
                RockingCurveView.this.jobRunning = false;
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
    }

    public int Integrate() {
        FableJep fableJep = null;
        try {
            fableJep = new FableJep();
        }
        catch (JepException jepException) {
            FableUtils.excMsg((Object)((Object)this), (String)"Error in Integrate creating FableJep", (Throwable)jepException);
        }
        Vector vector = this.sample.getFilteredfiles();
        FabioFile fabioFile = (FabioFile)vector.get(this.rockCenter);
        try {
            int n = fabioFile.getWidth();
            int n2 = fabioFile.getHeight();
            int n3 = (this.rockArea[2] - this.rockArea[0]) * (this.rockArea[3] - this.rockArea[1]);
            this.rockX = new float[this.rockEnd - this.rockStart + 1];
            this.rockIntensity = new float[this.rockEnd - this.rockStart + 1];
            int n4 = 0;
            int n5 = this.rockStart;
            while (n5 <= this.rockEnd) {
                this.jobMonitor.worked(1);
                fabioFile = (FabioFile)vector.get(n5);
                float[] fArray = fabioFile.getImageAsFloat(fableJep);
                if (fabioFile.getWidth() == n && fabioFile.getHeight() == n2) {
                    float f = 0.0f;
                    int n6 = this.rockArea[1];
                    while (n6 < this.rockArea[3]) {
                        int n7 = n * n6;
                        int n8 = this.rockArea[0];
                        while (n8 < this.rockArea[2]) {
                            f += fArray[n7 + n8];
                            ++n8;
                        }
                        ++n6;
                    }
                    this.rockIntensity[n5 - this.rockStart] = this.average ? f / (float)n3 : f;
                } else {
                    this.rockIntensity[n5 - this.rockStart] = Float.NaN;
                    ++n4;
                }
                if (this.xAxis != 0) {
                    this.rockX[n5 - this.rockStart] = Float.NaN;
                    String string = "";
                    try {
                        if (!fabioFile.headerRead) {
                            fabioFile.loadHeader(fableJep);
                        }
                        string = fabioFile.getValue(this.xAxisItems[this.xAxis]);
                    }
                    catch (FabioFileException fabioFileException) {
                        FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error in Integrate loading header", (Throwable)fabioFileException);
                    }
                    try {
                        this.rockX[n5 - this.rockStart] = Float.parseFloat(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error in Integrate loading header", (Throwable)numberFormatException);
                        ++n4;
                    }
                } else {
                    this.rockX[n5 - this.rockStart] = n5;
                }
                ++n5;
            }
            if (n4 != 0) {
                final String string = String.valueOf(n4) + " files will not be plotted on the rocking curve " + "because their size differs or the key chosen for " + "the x axis does not exist";
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)"Confirm", (String)string);
                    }
                });
                return 1;
            }
        }
        catch (JepException jepException) {
            FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error in Integrate", (Throwable)jepException);
        }
        return 0;
    }

    public void Plot() {
        if (this.average) {
            this.chart.getY1Axis().setName("average intensity");
        } else {
            this.chart.getY1Axis().setName("integrated intensity");
        }
        this.chart.getXAxis().setName(this.xAxisItems[this.xAxis]);
        this.chart.setHeader(this.title);
        double[] dArray = new double[this.rockEnd - this.rockStart + 1];
        double[] dArray2 = new double[this.rockEnd - this.rockStart + 1];
        int n = 0;
        while (n < this.rockEnd - this.rockStart + 1) {
            dArray[n] = this.rockX[n];
            dArray2[n] = this.rockIntensity[n];
            ++n;
        }
        this.dataView.setData(dArray, dArray2);
        this.dataView.setName("integrated intensity [" + this.rockArea[0] + "," + this.rockArea[1] + "] - [" + this.rockArea[2] + "," + this.rockArea[3] + "]");
        Dimension dimension = this.chartContainer.getSize();
        this.chart.setSize(dimension);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RockingCurveView.this.chartContainer.repaint();
            }
        });
    }
}

