/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.imageprint.FableImagePrinter;
import fable.framework.imageprint.ImagePrintPreviewDialog;
import fable.framework.imageprint.ImagePrintSetupDialog;
import fable.framework.imageprint.ImagePrintUtils;
import fable.framework.imageprint.PrintSettings;
import fable.framework.logging.FableLogger;
import fable.framework.navigator.controller.SampleController;
import fable.framework.toolbox.ImageSelection;
import fable.framework.toolbox.SWTUtils;
import fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener;
import fr.esrf.tangoatk.widget.util.chart.JLChart;
import fr.esrf.tangoatk.widget.util.chart.JLChartActionEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class LineView
extends ViewPart {
    public static final String ID = "fable.imageviewer.views.LineView";
    private JLDataView dataView;
    private JLChart chart;
    public static LineView view;
    private String title = "Zoom Line Plot";
    private Composite swtAwtComponent;
    public SampleController controller = SampleController.getController();
    private Frame chartFrame;
    private IJLChartActionListener chartActionListener;
    private JApplet chartContainer;
    private Action printSetupAction;
    private Action printPreviewAction;
    private Action printAction;
    private Action copyAction;
    Logger logger;
    Composite parent;

    public void createPartControl(Composite composite) {
        view = this;
        this.parent = composite;
        composite.setLayout((Layout)new GridLayout());
        this.createChartFrame(composite);
        this.createChart();
        this.logger = FableLogger.getLogger(LineView.class);
        this.contributeToActionBars();
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalMenu(iActionBars.getMenuManager());
    }

    private void fillLocalMenu(IMenuManager iMenuManager) {
        this.printSetupAction = new Action("Print Setup"){

            public void run() {
                org.eclipse.swt.graphics.Image image = LineView.this.getSWTChartImage();
                if (image == null) {
                    return;
                }
                ImagePrintSetupDialog imagePrintSetupDialog = new ImagePrintSetupDialog(LineView.this.parent.getDisplay().getActiveShell(), image, FableImagePrinter.settings);
                PrintSettings printSettings = imagePrintSetupDialog.open();
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
                if (printSettings != null) {
                    FableImagePrinter.settings = printSettings;
                }
            }
        };
        this.printPreviewAction = new Action("Print Preview"){

            public void run() {
                org.eclipse.swt.graphics.Image image = LineView.this.getSWTChartImage();
                if (image == null) {
                    return;
                }
                ImagePrintPreviewDialog imagePrintPreviewDialog = new ImagePrintPreviewDialog(LineView.this.parent.getDisplay().getActiveShell(), image, FableImagePrinter.settings);
                PrintSettings printSettings = imagePrintPreviewDialog.open();
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
                if (printSettings != null) {
                    FableImagePrinter.settings = printSettings;
                }
            }
        };
        this.printAction = new Action("Print"){

            public void run() {
                org.eclipse.swt.graphics.Image image = LineView.this.getSWTChartImage();
                if (image == null) {
                    return;
                }
                ImagePrintUtils.dialogPrintImage((Shell)LineView.this.parent.getDisplay().getActiveShell(), (org.eclipse.swt.graphics.Image)image, (Point)LineView.this.parent.getDisplay().getActiveShell().getDisplay().getDPI(), (PrintSettings)FableImagePrinter.settings);
                if (image != null && !image.isDisposed()) {
                    image.dispose();
                }
            }
        };
        this.copyAction = new Action("Copy"){

            public void run() {
                BufferedImage bufferedImage = LineView.this.getAWTChartImage();
                if (bufferedImage == null) {
                    return;
                }
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents((Transferable)new ImageSelection((Image)bufferedImage), null);
            }
        };
        MenuManager menuManager = new MenuManager("Print");
        iMenuManager.add((IContributionItem)menuManager);
        menuManager.add((IAction)this.printSetupAction);
        menuManager.add((IAction)this.printPreviewAction);
        menuManager.add((IAction)this.printAction);
        menuManager = new MenuManager("Edit");
        iMenuManager.add((IContributionItem)menuManager);
        menuManager.add((IAction)this.copyAction);
    }

    public BufferedImage getAWTChartImage() {
        if (this.chart == null) {
            return null;
        }
        int n = this.chart.getSize().width;
        int n2 = this.chart.getSize().height;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        if (bufferedImage == null) {
            return null;
        }
        Color color = this.chart.getBackground();
        this.chart.setBackground(Color.WHITE);
        this.chart.paint(bufferedImage.getGraphics());
        this.chart.setBackground(color);
        return bufferedImage;
    }

    public org.eclipse.swt.graphics.Image getSWTChartImage() {
        if (this.chart == null) {
            return null;
        }
        BufferedImage bufferedImage = this.getAWTChartImage();
        if (bufferedImage == null) {
            return null;
        }
        ImageData imageData = SWTUtils.convertToSWT((BufferedImage)bufferedImage);
        if (imageData == null) {
            return null;
        }
        return new org.eclipse.swt.graphics.Image((Device)this.parent.getDisplay(), imageData);
    }

    public void setFocus() {
    }

    private void createChartFrame(Composite composite) {
        this.swtAwtComponent = new Composite(composite, 0x1040000);
        this.swtAwtComponent.setLayout((Layout)new GridLayout());
        this.swtAwtComponent.setLayoutData((Object)new GridData(1808));
        this.chartFrame = SWT_AWT.new_Frame((Composite)this.swtAwtComponent);
        this.chartContainer = new JApplet();
        this.chartFrame.add(this.chartContainer);
    }

    public void createChart() {
        this.chart = new JLChart();
        this.chart.setHeader(this.title);
        this.chart.setHeaderFont(new Font("Dialog", 1, 18));
        this.chart.getY1Axis().setName("Intensity");
        this.chart.getY1Axis().setAutoScale(true);
        this.chart.getXAxis().setAutoScale(true);
        this.chart.getXAxis().setName("pixel");
        this.chart.getXAxis().setGridVisible(true);
        this.chart.getXAxis().setSubGridVisible(true);
        this.chart.getXAxis().setAnnotation(2);
        this.chart.getY1Axis().setGridVisible(true);
        this.chart.getY1Axis().setSubGridVisible(true);
        this.chart.removeMenuItem(4);
        this.chart.addUserAction("Print Setup");
        this.chart.addUserAction("Print Preview");
        this.chart.addUserAction("Print");
        this.chart.addUserAction("Copy");
        this.chartActionListener = new IJLChartActionListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(final JLChartActionEvent jLChartActionEvent) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (jLChartActionEvent.getName().equals("Print Setup")) {
                            LineView.this.printSetupAction.run();
                        } else if (jLChartActionEvent.getName().equals("Print Preview")) {
                            LineView.this.printPreviewAction.run();
                        } else if (jLChartActionEvent.getName().equals("Print")) {
                            LineView.this.printAction.run();
                        } else if (jLChartActionEvent.getName().equals("Copy")) {
                            LineView.this.copyAction.run();
                        }
                    }
                });
            }

            public boolean getActionState(JLChartActionEvent jLChartActionEvent) {
                return false;
            }
        };
        this.chart.addJLChartActionListener(this.chartActionListener);
        this.chartContainer.add((Component)this.chart);
        this.dataView = new JLDataView();
        this.dataView.setName("Intensity");
        this.chart.getY1Axis().addDataView(this.dataView);
    }

    public void setData(String string, String string2, boolean bl, float[] fArray, String string3, float[] fArray2) {
        double[] dArray = new double[fArray.length];
        double[] dArray2 = new double[fArray.length];
        int n = 0;
        while (n < fArray.length) {
            dArray[n] = fArray[n];
            dArray2[n] = bl ? (double)fArray2[fArray.length - 1 - n] : (double)fArray2[n];
            ++n;
        }
        this.dataView.setData(dArray, dArray2);
        this.dataView.setXDataSorted(false);
        this.chart.setHeader(string);
        this.chart.getXAxis().setName(string2);
        this.chart.getXAxis().setInverted(bl);
        this.chart.getY1Axis().setName(string3);
        Dimension dimension = this.chartContainer.getSize();
        this.chart.setSize(dimension);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LineView.this.chartContainer.repaint();
            }
        });
    }

    public void dispose() {
        if (this.chart != null && this.chartActionListener != null) {
            this.chart.removeJLChartActionListener(this.chartActionListener);
        }
        super.dispose();
    }
}

