/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.logging.FableLogger;
import fable.framework.navigator.controller.SampleController;
import fable.framework.toolbox.FableUtils;
import fable.imageviewer.internal.IImagesVarKeys;
import fable.imageviewer.internal.ImageViewType;
import fable.imageviewer.internal.ZoomSelection;
import fable.imageviewer.model.ImageModel;
import fable.imageviewer.views.ImageView;
import fable.imageviewer.views.ImageViewControls;
import fable.imageviewer.views.LineView;
import fable.imageviewer.views.ProfileView;
import fable.imageviewer.views.ReliefView;
import fable.imageviewer.views.RockingCurveView;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ImageViewImage
implements IImagesVarKeys {
    private static final boolean debug = false;
    private static final boolean debug1 = false;
    private static final float ZOOMFACTOR_LARGE = 0.5f;
    private static final int PEAK_MARKER_SIZE = 3;
    ImageView iv = null;
    private ImageViewControls controls;
    private Canvas imageCanvas;
    private GC imageCanvasGC;
    private Image image = null;
    private ImageData imageData;
    private Rectangle imageRect = new Rectangle(0, 0, 0, 0);
    private Rectangle origRect = new Rectangle(0, 0, 0, 0);
    private Rectangle orientedOrigRect = new Rectangle(0, 0, 0, 0);
    private Rectangle orientedRect = new Rectangle(0, 0, 0, 0);
    double xScale;
    double yScale;
    private Boolean selectingOn = false;
    private int canvasWidth;
    private int canvasHeight;
    private Boolean selectOn = false;
    private boolean imageChanged = true;
    private Boolean newSelection = true;
    private int xSelectionStart;
    private int ySelectionStart;
    private Rectangle selectedArea = new Rectangle(0, 0, 0, 0);
    private Display display;
    private Logger logger = FableLogger.getLogger(this.getClass());
    private ImageView zoomAreaView;
    private LineView lineView;
    private ProfileView profileView;
    private ReliefView zoomReliefView;
    private RockingCurveView zoomRockingCurveView;

    public ImageViewImage(ImageView imageView, ImageViewControls imageViewControls) {
        this.iv = imageView;
        this.controls = imageViewControls;
        imageView.setImage(this);
        imageViewControls.setImage(this);
    }

    public void initializeCanvas() {
        if (this.iv == null || this.controls == null) {
            return;
        }
        this.imageCanvas = this.controls.getImageCanvas();
        this.display = this.iv.getDisplay();
        this.imageCanvas.setBackground(this.display.getSystemColor(16));
        GridData gridData = new GridData(4, 4, true, true);
        this.imageCanvas.setLayoutData((Object)gridData);
        this.imageCanvasGC = new GC((Drawable)this.imageCanvas);
        Rectangle rectangle = this.imageCanvas.getBounds();
        this.canvasWidth = rectangle.width;
        this.canvasHeight = rectangle.height;
        this.imageCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                ImageViewImage.this.imageCanvasGC.dispose();
            }
        });
        this.imageCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (ImageViewImage.this.image == null) {
                    return;
                }
                Rectangle rectangle = ImageViewImage.this.imageCanvas.getBounds();
                paintEvent.gc.fillRectangle(0, 0, rectangle.width, rectangle.height);
                if (ImageViewImage.this.canvasWidth != rectangle.width || ImageViewImage.this.canvasHeight != rectangle.height) {
                    double d = ImageViewImage.this.xScale;
                    double d2 = ImageViewImage.this.yScale;
                    ImageViewImage.this.createScreenImage(ImageViewImage.this.imageData);
                    ((ImageViewImage)ImageViewImage.this).selectedArea.width = (int)Math.round((double)((ImageViewImage)ImageViewImage.this).selectedArea.width * (d /= ImageViewImage.this.xScale));
                    ((ImageViewImage)ImageViewImage.this).selectedArea.height = (int)Math.round((double)((ImageViewImage)ImageViewImage.this).selectedArea.height * (d2 /= ImageViewImage.this.yScale));
                    ((ImageViewImage)ImageViewImage.this).selectedArea.x = (int)Math.round((double)((ImageViewImage)ImageViewImage.this).selectedArea.x * d);
                    ((ImageViewImage)ImageViewImage.this).selectedArea.y = (int)Math.round((double)((ImageViewImage)ImageViewImage.this).selectedArea.y * d2);
                    ImageViewImage.this.canvasWidth = rectangle.width;
                    ImageViewImage.this.canvasHeight = rectangle.height;
                }
                ImageViewImage.this.displayImage();
            }
        });
        this.imageCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                if (ImageViewImage.this.image != null) {
                    ImageViewImage.this.showPixelAtCursor(mouseEvent.x, mouseEvent.y);
                    if (ImageViewImage.this.selectingOn.booleanValue()) {
                        int n = mouseEvent.x - ImageViewImage.this.xSelectionStart;
                        int n2 = mouseEvent.y - ImageViewImage.this.ySelectionStart;
                        ImageViewImage.this.imageCanvasGC.setForeground(ImageViewImage.this.display.getSystemColor(1));
                        ImageViewImage.this.drawImage(false);
                        ZoomSelection zoomSelection = ImageViewImage.this.iv.getZoomSelection();
                        if (zoomSelection == ZoomSelection.AREA || zoomSelection == ZoomSelection.PROFILE || zoomSelection == ZoomSelection.RELIEF || zoomSelection == ZoomSelection.ROCKINGCURVE) {
                            Rectangle rectangle = new Rectangle(ImageViewImage.this.xSelectionStart, ImageViewImage.this.ySelectionStart, n, n2);
                            ImageViewImage.this.imageCanvasGC.setLineWidth(1);
                            ImageViewImage.this.imageCanvasGC.drawRectangle(rectangle);
                        } else if (zoomSelection == ZoomSelection.LINE) {
                            ImageViewImage.this.imageCanvasGC.setXORMode(true);
                            ImageViewImage.this.imageCanvasGC.drawLine(ImageViewImage.this.xSelectionStart, ImageViewImage.this.ySelectionStart, mouseEvent.x, mouseEvent.y);
                            ImageViewImage.this.imageCanvasGC.setXORMode(false);
                        }
                    }
                }
            }
        });
        this.imageCanvas.addListener(7, new Listener(){

            public void handleEvent(Event event) {
                ImageViewImage.this.controls.setStatusText("");
                if (ImageViewImage.this.selectingOn.booleanValue()) {
                    ImageViewImage.this.drawImage(false);
                    ImageViewImage.this.selectingOn = false;
                }
            }
        });
        this.imageCanvas.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.keyCode) {
                    case 27: {
                        if (!ImageViewImage.this.selectingOn.booleanValue()) break;
                        ImageViewImage.this.drawImage(false);
                        ImageViewImage.this.selectingOn = false;
                    }
                }
            }
        });
        this.imageCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                if (ImageViewImage.this.selectingOn.booleanValue()) {
                    ImageViewImage.this.drawImage(false);
                    ImageViewImage.this.selectingOn = false;
                    ImageViewImage.this.selectOn = false;
                }
            }

            public void mouseDown(MouseEvent mouseEvent) {
                if (ImageViewImage.this.image == null) {
                    return;
                }
                if (mouseEvent.button == 1) {
                    if ((mouseEvent.stateMask & 0x40000) != 0) {
                        ImageViewImage.this.selectingOn = false;
                        ImageViewImage.this.selectOn = false;
                        ImageViewImage.this.showZoom(mouseEvent, true);
                    } else if ((mouseEvent.stateMask & 0x20000) != 0) {
                        ImageViewImage.this.selectingOn = false;
                        ImageViewImage.this.selectOn = false;
                        ImageViewImage.this.showZoom(mouseEvent, false);
                    } else if ((mouseEvent.stateMask & 0x10000) != 0) {
                        ImageViewImage.this.selectingOn = false;
                        ImageViewImage.this.selectOn = false;
                        ImageViewImage.this.resetZoom();
                    } else {
                        ImageViewImage.this.selectingOn = true;
                        ImageViewImage.this.xSelectionStart = mouseEvent.x;
                        ImageViewImage.this.ySelectionStart = mouseEvent.y;
                    }
                }
            }

            public void mouseUp(MouseEvent mouseEvent) {
                if (ImageViewImage.this.image == null) {
                    return;
                }
                if (!ImageViewImage.this.selectingOn.booleanValue()) {
                    return;
                }
                if (ImageViewImage.this.xSelectionStart != mouseEvent.x || ImageViewImage.this.ySelectionStart != mouseEvent.y) {
                    ((ImageViewImage)ImageViewImage.this).selectedArea.x = ImageViewImage.this.xSelectionStart;
                    ((ImageViewImage)ImageViewImage.this).selectedArea.y = ImageViewImage.this.ySelectionStart;
                    ((ImageViewImage)ImageViewImage.this).selectedArea.width = mouseEvent.x - ((ImageViewImage)ImageViewImage.this).selectedArea.x;
                    ((ImageViewImage)ImageViewImage.this).selectedArea.height = mouseEvent.y - ((ImageViewImage)ImageViewImage.this).selectedArea.y;
                    ImageViewImage.this.imageCanvasGC.setForeground(ImageViewImage.this.display.getSystemColor(1));
                    ImageViewImage.this.drawImage(false);
                    ImageViewImage.this.imageChanged = true;
                    ImageViewImage.this.newSelection = true;
                    ImageViewImage.this.showSelection();
                }
                ImageViewImage.this.selectingOn = false;
            }
        });
        this.createDropTarget();
    }

    public void dispose() {
        if (this.imageCanvas != null) {
            this.imageCanvas.dispose();
        }
        if (this.image != null) {
            this.image.dispose();
        }
    }

    public void calculateMainRectangles() {
        this.origRect = this.iv.getImageModel().getRect();
        this.orientedOrigRect.x = 0;
        this.orientedOrigRect.y = 0;
        switch (this.iv.getOrientation()) {
            default: {
                this.orientedRect.x = this.imageRect.x;
                this.orientedRect.y = this.imageRect.y;
                this.orientedRect.width = this.imageRect.width;
                this.orientedRect.height = this.imageRect.height;
                this.orientedOrigRect.width = this.origRect.width;
                this.orientedOrigRect.height = this.origRect.height;
                break;
            }
            case 1: {
                this.orientedRect.x = this.origRect.width - this.imageRect.width - this.imageRect.x;
                this.orientedRect.y = this.imageRect.y;
                this.orientedRect.width = this.imageRect.width;
                this.orientedRect.height = this.imageRect.height;
                this.orientedOrigRect.width = this.origRect.width;
                this.orientedOrigRect.height = this.origRect.height;
                break;
            }
            case 2: {
                this.orientedRect.x = this.imageRect.x;
                this.orientedRect.y = this.origRect.height - this.imageRect.height - this.imageRect.y;
                this.orientedRect.width = this.imageRect.width;
                this.orientedRect.height = this.imageRect.height;
                this.orientedOrigRect.width = this.origRect.width;
                this.orientedOrigRect.height = this.origRect.height;
                break;
            }
            case 3: {
                this.orientedRect.x = this.origRect.width - this.imageRect.width - this.imageRect.x;
                this.orientedRect.y = this.origRect.height - this.imageRect.height - this.imageRect.y;
                this.orientedRect.width = this.imageRect.width;
                this.orientedRect.height = this.imageRect.height;
                this.orientedOrigRect.width = this.origRect.width;
                this.orientedOrigRect.height = this.origRect.height;
                break;
            }
            case 6: {
                this.orientedRect.x = this.imageRect.y;
                this.orientedRect.y = this.imageRect.x;
                this.orientedRect.width = this.imageRect.height;
                this.orientedRect.height = this.imageRect.width;
                this.orientedOrigRect.width = this.origRect.height;
                this.orientedOrigRect.height = this.origRect.width;
                break;
            }
            case 4: {
                this.orientedRect.x = this.imageRect.y;
                this.orientedRect.y = this.origRect.width - this.imageRect.width - this.imageRect.x;
                this.orientedRect.width = this.imageRect.height;
                this.orientedRect.height = this.imageRect.width;
                this.orientedOrigRect.width = this.origRect.height;
                this.orientedOrigRect.height = this.origRect.width;
                break;
            }
            case 5: {
                this.orientedRect.x = this.origRect.height - this.imageRect.height - this.imageRect.y;
                this.orientedRect.y = this.imageRect.x;
                this.orientedRect.width = this.imageRect.height;
                this.orientedRect.height = this.imageRect.width;
                this.orientedOrigRect.width = this.origRect.height;
                this.orientedOrigRect.height = this.origRect.width;
                break;
            }
            case 7: {
                this.orientedRect.x = this.origRect.height - this.imageRect.height - this.imageRect.y;
                this.orientedRect.y = this.origRect.width - this.imageRect.width - this.imageRect.x;
                this.orientedRect.width = this.imageRect.height;
                this.orientedRect.height = this.imageRect.width;
                this.orientedOrigRect.width = this.origRect.height;
                this.orientedOrigRect.height = this.origRect.width;
            }
        }
    }

    public void showSelection() {
        if (!this.selectingOn.booleanValue() && !this.selectOn.booleanValue()) {
            return;
        }
        ZoomSelection zoomSelection = this.iv.getZoomSelection();
        if (zoomSelection == ZoomSelection.AREA || zoomSelection == ZoomSelection.RELIEF || zoomSelection == ZoomSelection.ROCKINGCURVE) {
            this.imageCanvasGC.drawRectangle(this.selectedArea);
            if (this.imageChanged) {
                this.showSelectedArea(this.selectedArea, true);
            }
            this.selectOn = true;
        } else if (zoomSelection == ZoomSelection.LINE) {
            this.imageCanvasGC.setXORMode(true);
            this.imageCanvasGC.setLineWidth(this.iv.getLinePeakWidth());
            this.imageCanvasGC.drawLine(this.selectedArea.x, this.selectedArea.y, this.selectedArea.x + this.selectedArea.width, this.selectedArea.y + this.selectedArea.height);
            this.imageCanvasGC.setLineWidth(1);
            this.imageCanvasGC.setXORMode(false);
            if (this.imageChanged) {
                this.showSelectedLine();
            }
            this.selectOn = true;
        } else if (zoomSelection == ZoomSelection.PROFILE) {
            this.imageCanvasGC.drawRectangle(this.selectedArea);
            if (this.imageChanged) {
                this.showProfile();
            }
            this.selectOn = true;
        }
        this.newSelection = false;
    }

    public void showZoom(MouseEvent mouseEvent, boolean bl) {
        float f = bl ? 2.0f : 0.5f;
        Rectangle rectangle = this.imageCanvas.getBounds();
        int n = (int)((float)rectangle.width * f + 0.5f);
        int n2 = (int)((float)rectangle.height * f + 0.5f);
        int n3 = mouseEvent.x - n / 2;
        int n4 = mouseEvent.y - n2 / 2;
        Rectangle rectangle2 = new Rectangle(n3, n4, n, n2);
        this.showSelectedArea(rectangle2, true);
    }

    public void resetZoom() {
        if (this.image == null) {
            return;
        }
        this.selectingOn = false;
        this.selectOn = false;
        this.showSelectedArea(this.origRect, false);
    }

    public void showPeaks() {
        Vector<Float> vector = this.iv.getPeaks();
        if (vector != null) {
            Color color = this.display.getSystemColor(3);
            this.imageCanvasGC.setForeground(color);
            this.imageCanvasGC.setLineWidth(1);
            Point point = new Point(0, 0);
            int n = 0;
            while (n < vector.size() / 2) {
                point = this.tcToScreen(vector.elementAt(n * 2).floatValue(), vector.elementAt(n * 2 + 1).floatValue());
                int n2 = point.x;
                int n3 = point.y;
                Rectangle rectangle = new Rectangle(--n2, --n3, 3, 3);
                this.imageCanvasGC.drawRectangle(rectangle);
                ++n;
            }
        }
    }

    public void showSelectedPeaks(float[] fArray) {
        this.showPeaks();
        if (fArray != null) {
            Color color = this.display.getSystemColor(5);
            this.imageCanvasGC.setForeground(color);
            this.imageCanvasGC.setLineWidth(1);
            Point point = new Point(0, 0);
            int n = 0;
            while (n < fArray.length / 2) {
                int n2 = n * 2;
                point = this.tcToScreen(fArray[n2], fArray[n2 + 1]);
                int n3 = point.x;
                int n4 = point.y;
                Rectangle rectangle = new Rectangle(--n3, --n4, 3, 3);
                this.imageCanvasGC.drawRectangle(rectangle);
                ++n;
            }
        }
    }

    void showPixelAtCursor(int n, int n2) {
        int n3 = (int)((double)n * this.xScale);
        int n4 = (int)((double)n2 * this.yScale);
        if (n3 < 0 || n3 >= this.orientedRect.width || n4 < 0 || n4 >= this.orientedRect.height) {
            if (this.controls != null) {
                this.controls.setStatusText("");
            }
            return;
        }
        Point point = this.orientedToImage(new Point(n3, n4));
        int n5 = point.x;
        int n6 = point.y;
        if (n5 < 0 || n5 >= this.iv.getImageModel().getWidth() || n6 < 0 || n6 >= this.iv.getImageModel().getHeight()) {
            this.controls.setStatusText("");
            return;
        }
        float f = 0.0f;
        f = !this.iv.isImageDiffOn() ? this.iv.getImageModel().getData(n6, n5) : this.iv.getImageDiffModel().getData(n6, n5);
        if (this.controls != null) {
            this.controls.setStatusText(this.iv.getCoordinates().getCoordinateString(n3 + this.orientedRect.x, n4 + this.orientedRect.y, f));
        }
    }

    void showSelectedArea(Rectangle rectangle, boolean bl) {
        Rectangle rectangle2 = bl ? this.screenRectangleToImageRectangle(rectangle, true) : rectangle;
        try {
            float[] fArray;
            float[] fArray2 = null;
            if (!this.iv.isImageDiffOn()) {
                fArray = this.iv.getImageModel().getData(rectangle2);
                fArray2 = this.iv.getImageModel().getStatistics(rectangle2);
            } else {
                fArray = this.iv.getImageDiffModel().getData(rectangle2);
                fArray2 = this.iv.getImageDiffModel().getStatistics(rectangle2);
            }
            float f = fArray2[0];
            float f2 = fArray2[1];
            float f3 = fArray2[2];
            ZoomSelection zoomSelection = this.iv.getZoomSelection();
            if (zoomSelection == ZoomSelection.AREA) {
                IViewReference iViewReference;
                if (this.newSelection.booleanValue()) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", "100", 1);
                }
                if ((iViewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ImageView", "100")) != null) {
                    this.zoomAreaView = (ImageView)iViewReference.getView(true);
                    if (this.zoomAreaView != null) {
                        this.zoomAreaView.setCoordOrigin(this.iv.getCoordOrigin());
                        this.zoomAreaView.setOrientation(this.iv.getOrientation());
                        this.zoomAreaView.getImage().setSelectOn(false);
                        if (!this.iv.isImageDiffOn()) {
                            this.zoomAreaView.getImage().changeImageRect(rectangle2, fArray, this.iv.getImageModel().getFileName(), this.iv.getImageModel());
                            this.zoomAreaView.setPartName("Zoom area " + this.iv.getFileName());
                        } else {
                            this.zoomAreaView.getImage().changeImageRect(rectangle2, fArray, this.iv.getImageModel().getFileName(), this.iv.getImageDiffModel());
                            this.zoomAreaView.setPartName("Zoom difference " + this.iv.getFileName());
                        }
                        this.zoomAreaView.stopListening();
                        this.zoomAreaView.setViewType(ImageViewType.IMAGE_ZOOM_VIEW);
                        if (this.iv.getCoordOrigin() == 4) {
                            this.zoomAreaView.getCoordinates().reset(this.iv.getCoordOrigin(), this.iv.getCoordinates().getX0(), this.iv.getCoordinates().getY0(), this.iv.getCoordinates().getPixelWidth(), this.iv.getCoordinates().getPixelHeight(), this.iv.getCoordinates().getXName(), this.iv.getCoordinates().getYName());
                        } else {
                            this.zoomAreaView.resetCoordinates();
                        }
                        this.zoomAreaView.setMinMax(this.iv.getMinMax());
                        this.zoomAreaView.setPalette(this.iv.getPaletteIndex());
                    }
                }
            } else if (zoomSelection == ZoomSelection.RELIEF) {
                IViewReference iViewReference;
                if (this.newSelection.booleanValue()) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ReliefView", "0", 1);
                }
                if ((iViewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ReliefView", "0")) != null) {
                    this.zoomReliefView = (ReliefView)iViewReference.getView(true);
                    if (this.zoomReliefView != null) {
                        this.zoomReliefView.setImageAsFloat(fArray, rectangle2.width, rectangle2.height, f, f2, f3, this.iv.getImageModel().getFileName());
                    }
                }
            } else if (zoomSelection == ZoomSelection.ROCKINGCURVE) {
                IViewReference iViewReference;
                if (this.newSelection.booleanValue()) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.RockingCurveView", "0", 1);
                }
                if ((iViewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.RockingCurveView", "0")) != null) {
                    this.zoomRockingCurveView = (RockingCurveView)iViewReference.getView(true);
                    if (this.zoomRockingCurveView != null) {
                        int n = rectangle2.width == 0 ? rectangle2.x : rectangle2.x + rectangle2.width - 1;
                        int n2 = rectangle2.height == 0 ? rectangle2.y : rectangle2.y + rectangle2.height - 1;
                        this.zoomRockingCurveView.setCenterArea("Rocking Curve " + this.iv.getFileName(), SampleController.getController().getCurrentFileIndex(), rectangle2.x, rectangle2.y, n, n2);
                    }
                }
            }
        }
        catch (PartInitException partInitException) {
            FableUtils.excMsg((Object)this, (String)"Unable to show selected area", (Throwable)partInitException);
        }
    }

    void showSelectedLine() {
        Rectangle rectangle = this.screenRectangleToOrientedImageRectangle(this.selectedArea, false);
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.y + rectangle.height - 1;
        Point point = new Point(0, 0);
        double[] dArray = new double[]{0.0, 0.0};
        boolean bl = false;
        try {
            IViewReference iViewReference;
            int n5;
            int n6;
            float[] fArray;
            float[] fArray2;
            int n7;
            String string;
            String string2;
            float f = Float.NaN;
            if (Math.abs(n3 - n) >= Math.abs(n4 - n2)) {
                string2 = "Pixels in " + this.iv.getCoordinates().getXName();
                string = "Intensity";
                bl = this.iv.getCoordinates().isXInverted();
                if (n3 < n) {
                    n7 = n;
                    n = n3;
                    n3 = n7;
                    n7 = n2;
                    n2 = n4;
                    n4 = n7;
                }
                n7 = n3 - n + 1;
                fArray2 = new float[n7];
                fArray = new float[n7];
                if (n3 - n != 0) {
                    f = (float)(n4 - n2) / (float)(n3 - n);
                }
                this.logger.debug((Object)("slope " + f));
                int n8 = 0;
                while (n8 < n7) {
                    n6 = n + n8;
                    n5 = (int)((double)((float)n2 + f * (float)n8) + 0.5);
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    if (n5 > this.orientedOrigRect.height - 1) {
                        n5 = this.orientedOrigRect.height - 1;
                    }
                    fArray[n8] = 0.0f;
                    int n9 = n5 - this.iv.getLinePeakWidth() / 2;
                    while (n9 < n5 + this.iv.getLinePeakWidth() / 2 + 1) {
                        point.x = n6;
                        point.y = n5;
                        dArray = this.iv.getCoordinates().getCoordinatesFromOriented(point);
                        fArray2[n8] = (float)dArray[0];
                        point = this.orientedToImage(point);
                        if (!this.iv.isImageDiffOn()) {
                            int n10 = n8;
                            fArray[n10] = fArray[n10] + this.iv.getImageModel().getData(point.y, point.x);
                        } else {
                            int n11 = n8;
                            fArray[n11] = fArray[n11] + this.iv.getImageDiffModel().getData(point.y, point.x);
                        }
                        ++n9;
                    }
                    ++n8;
                }
            } else {
                string2 = "Pixels in " + this.iv.getCoordinates().getYName();
                string = "Intensity";
                bl = this.iv.getCoordinates().isYInverted();
                if (n4 < n2) {
                    n7 = n;
                    n = n3;
                    n3 = n7;
                    n7 = n2;
                    n2 = n4;
                    n4 = n7;
                }
                n7 = n4 - n2 + 1;
                fArray2 = new float[n7];
                fArray = new float[n7];
                if (n3 - n != 0) {
                    f = (float)(n4 - n2) / (float)(n3 - n);
                }
                this.logger.debug((Object)("slope " + f));
                int n12 = 0;
                while (n12 < n7) {
                    n5 = n2 + n12;
                    n6 = n3 - n != 0 ? (int)((double)((float)n + (float)n12 / f) + 0.5) : n;
                    if (n6 < 0) {
                        n6 = 0;
                    }
                    if (n6 > this.orientedOrigRect.width - 1) {
                        n6 = this.orientedOrigRect.width - 1;
                    }
                    fArray[n12] = 0.0f;
                    int n13 = n6 - this.iv.getLinePeakWidth() / 2;
                    while (n13 < n6 + this.iv.getLinePeakWidth() / 2 + 1) {
                        point.x = n6;
                        point.y = n5;
                        dArray = this.iv.getCoordinates().getCoordinatesFromOriented(point);
                        fArray2[n12] = (float)dArray[1];
                        point = this.orientedToImage(point);
                        if (!this.iv.isImageDiffOn()) {
                            int n14 = n12;
                            fArray[n14] = fArray[n14] + this.iv.getImageModel().getData(point.y, point.x);
                        } else {
                            int n15 = n12;
                            fArray[n15] = fArray[n15] + this.iv.getImageDiffModel().getData(point.y, point.x);
                        }
                        ++n13;
                    }
                    this.logger.setLevel(Level.ERROR);
                    ++n12;
                }
            }
            if (this.newSelection.booleanValue()) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.LineView", "0", 1);
            }
            if ((iViewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.LineView", "0")) != null) {
                this.lineView = (LineView)iViewReference.getView(true);
                if (this.lineView != null) {
                    String string3 = "unknown";
                    String string4 = "unknown";
                    point.x = n;
                    point.y = n2;
                    string3 = this.iv.getCoordinates().getCoordinateString(point.x, point.y);
                    point.x = n3;
                    point.y = n4;
                    string4 = this.iv.getCoordinates().getCoordinateString(point.x, point.y);
                    string2 = String.valueOf(string2) + " from (" + string3 + ") to (" + string4 + ") for " + this.iv.getCoordinatesName();
                    this.lineView.setData(this.iv.getFileName(), string2, bl, fArray2, string, fArray);
                }
            }
        }
        catch (PartInitException partInitException) {
            FableUtils.excMsg((Object)this, (String)"Unable to show selected line", (Throwable)partInitException);
        }
    }

    void showProfile() {
        int n;
        Rectangle rectangle = this.screenRectangleToImageRectangle(this.selectedArea, true);
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.x + rectangle.width - 1;
        int n5 = rectangle.y + rectangle.height - 1;
        if (n2 > n4) {
            n = n3;
            n2 = n4;
            n4 = n;
        }
        if (n3 > n5) {
            n = n3;
            n3 = n5;
            n5 = n;
        }
        try {
            IViewReference iViewReference;
            int n6;
            int n7;
            int[] nArray = new int[n4 - n2];
            float[] fArray = new float[n4 - n2];
            int n8 = 0;
            while (n8 < n4 - n2) {
                nArray[n8] = n7 = n2 + n8;
                fArray[n8] = 0.0f;
                n6 = n3;
                while (n6 < n5) {
                    if (!this.iv.isImageDiffOn()) {
                        int n9 = n8;
                        fArray[n9] = fArray[n9] + this.iv.getImageModel().getData(n6, n7);
                    } else {
                        int n10 = n8;
                        fArray[n10] = fArray[n10] + this.iv.getImageDiffModel().getData(n6, n7);
                    }
                    ++n6;
                }
                ++n8;
            }
            int[] nArray2 = new int[n5 - n3];
            float[] fArray2 = new float[n5 - n3];
            n8 = 0;
            while (n8 < n5 - n3) {
                nArray2[n8] = n7 = n3 + n8;
                fArray2[n8] = 0.0f;
                n6 = n3;
                while (n6 < n5) {
                    if (!this.iv.isImageDiffOn()) {
                        int n11 = n8;
                        fArray2[n11] = fArray2[n11] + this.iv.getImageModel().getData(n7, n6);
                    } else {
                        int n12 = n8;
                        fArray2[n12] = fArray2[n12] + this.iv.getImageDiffModel().getData(n7, n6);
                    }
                    ++n6;
                }
                ++n8;
            }
            if (this.newSelection.booleanValue()) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ProfileView", "0", 1);
            }
            if ((iViewReference = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ProfileView", "0")) != null) {
                this.profileView = (ProfileView)iViewReference.getView(true);
                if (this.profileView != null) {
                    this.profileView.setData(this.iv.getFileName(), nArray, fArray, nArray2, fArray2);
                }
            }
        }
        catch (PartInitException partInitException) {
            FableUtils.excMsg((Object)this, (String)"Unable to show profile", (Throwable)partInitException);
        }
    }

    public void changeImageRect(Rectangle rectangle, float[] fArray, String string, ImageModel imageModel) {
        if (this.imageRect.width != rectangle.width || this.imageRect.height != rectangle.height) {
            this.clearCanvas();
        } else {
            this.selectingOn = false;
            this.selectOn = false;
        }
        if (imageModel == null) {
            this.iv.setImageModel(new ImageModel(string, rectangle.width, rectangle.height, fArray));
        } else if (imageModel != this.iv.getImageModel()) {
            this.iv.setImageModel(imageModel);
        }
        this.imageRect = rectangle;
        this.calculateMainRectangles();
        this.iv.resetCoordinates();
        float[] fArray2 = this.iv.getImageModel().getStatistics(this.imageRect);
        this.iv.setMinimum(fArray2[0]);
        this.iv.setMaximum(fArray2[1]);
        this.iv.setMean(fArray2[2]);
        this.iv.setMaximum(this.iv.getMean() + 2.0f * (this.iv.getMean() - this.iv.getMinimum()));
        if (this.iv.getMaximum() - this.iv.getMinimum() < 0.01f) {
            this.iv.setMaximum(this.iv.getMinimum() + 0.01f);
        }
        if (this.controls != null) {
            this.controls.resetAutoscale();
        }
        this.displayImage();
    }

    public void displayImage() {
        if (this.iv.getImageModel() == null || this.iv.getImageModel().getData() == null) {
            return;
        }
        if (this.iv.getCurrentMinimum() == this.iv.getCurrentMaximum()) {
            this.iv.setCurrentMaximum(this.iv.getCurrentMinimum() + 1.0f);
        }
        this.createImageData(this.iv.getCurrentMinimum(), this.iv.getCurrentMaximum(), this.iv.getPalette());
        this.imageData = !this.iv.isImageDiffOn() ? this.createImageData(this.iv.getCurrentMinimum(), this.iv.getCurrentMaximum(), this.iv.getPalette()) : this.createImageData(this.iv.getCurrentMinimum(), this.iv.getCurrentMaximum(), this.iv.getPalette());
        this.createScreenImage(this.imageData);
        this.drawImage(true);
        this.imageChanged = false;
    }

    public ImageData createImageData(float f, float f2, PaletteData paletteData) {
        float f3;
        float f4;
        float[] fArray = !this.iv.isImageDiffOn() ? this.iv.getImageModel().getData(this.imageRect) : this.iv.getImageDiffModel().getData(this.imageRect);
        int n = fArray.length;
        if (n == 0) {
            return null;
        }
        this.calculateMainRectangles();
        this.iv.resetCoordinates();
        if (f2 > f) {
            f4 = 255.0f / (f2 - f);
            f3 = f2 - f;
        } else {
            f4 = 1.0f;
            f3 = 255.0f;
        }
        byte[] byArray = new byte[n];
        Point point = new Point(0, 0);
        int n2 = 0;
        while (n2 < n) {
            float f5 = fArray[n2] < f ? 0.0f : (fArray[n2] >= f2 ? f3 : fArray[n2] - f);
            byte by = (byte)(0xFF & (int)(f5 *= f4));
            point.x = n2 % this.imageRect.width;
            point.y = n2 / this.imageRect.width;
            Point point2 = this.imageToOriented(point);
            int n3 = point2.y * this.orientedRect.width + point2.x;
            byArray[n3] = by;
            ++n2;
        }
        ImageData imageData = new ImageData(this.orientedRect.width, this.orientedRect.height, 8, paletteData, 1, byArray);
        return imageData;
    }

    public Image createScreenImage(ImageData imageData) {
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
            this.image = null;
        }
        Rectangle rectangle = this.imageCanvas.getBounds();
        this.xScale = (double)this.orientedRect.width / (double)rectangle.width;
        this.yScale = (double)this.orientedRect.height / (double)rectangle.height;
        if (this.iv.isKeepAspect()) {
            if (this.xScale > this.yScale) {
                this.yScale = this.xScale;
            } else {
                this.xScale = this.yScale;
            }
        }
        if ((double)this.orientedRect.width / this.xScale < 1.0) {
            this.xScale = (double)this.orientedRect.width / (double)rectangle.width;
        }
        if ((double)this.orientedRect.height / this.yScale < 1.0) {
            this.yScale = (double)this.orientedRect.height / (double)rectangle.height;
        }
        int n = (int)((double)this.orientedRect.width / this.xScale);
        int n2 = (int)((double)this.orientedRect.height / this.yScale);
        if (imageData == null) {
            this.logger.debug((Object)"data is null !");
            this.image = null;
        } else {
            this.image = new Image((Device)Display.getCurrent(), imageData.scaledTo(n, n2));
        }
        return this.image;
    }

    void drawImage(boolean bl) {
        if (this.imageCanvasGC == null || this.image == null) {
            return;
        }
        this.imageCanvasGC.drawImage(this.image, 0, 0);
        if (this.iv.isPeaksOn()) {
            this.showPeaks();
        }
        if (bl && this.selectOn.booleanValue()) {
            this.showSelection();
        }
    }

    private void createDropTarget() {
        DropTarget dropTarget = new DropTarget((Control)this.imageCanvas, 17);
        Transfer[] transferArray = new Transfer[]{TextTransfer.getInstance()};
        dropTarget.setTransfer(transferArray);
        dropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent dropTargetEvent) {
                if (dropTargetEvent.detail == 16) {
                    dropTargetEvent.detail = (dropTargetEvent.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragLeave(DropTargetEvent dropTargetEvent) {
            }

            public void dragOperationChanged(DropTargetEvent dropTargetEvent) {
            }

            public void dragOver(DropTargetEvent dropTargetEvent) {
            }

            public void drop(DropTargetEvent dropTargetEvent) {
                String string;
                if (TextTransfer.getInstance().isSupportedType(dropTargetEvent.currentDataType) && (string = (String)dropTargetEvent.data).startsWith("samplefile")) {
                    ImageViewImage.this.iv.dropFile();
                }
            }

            public void dropAccept(DropTargetEvent dropTargetEvent) {
            }
        });
    }

    public Point orientedToImage(Point point) {
        int n = point.x + this.orientedRect.x;
        int n2 = point.y + this.orientedRect.y;
        int n3 = n;
        int n4 = n2;
        switch (this.iv.getOrientation()) {
            default: {
                break;
            }
            case 1: {
                n3 = this.orientedOrigRect.width - n - 1;
                break;
            }
            case 2: {
                n4 = this.orientedOrigRect.height - n2 - 1;
                break;
            }
            case 3: {
                n3 = this.orientedOrigRect.width - n - 1;
                n4 = this.orientedOrigRect.height - n2 - 1;
                break;
            }
            case 6: {
                n3 = n2;
                n4 = n;
                break;
            }
            case 4: {
                n3 = this.orientedOrigRect.height - n2 - 1;
                n4 = n;
                break;
            }
            case 5: {
                n3 = n2;
                n4 = this.orientedOrigRect.width - n - 1;
                break;
            }
            case 7: {
                n3 = this.orientedOrigRect.height - n2 - 1;
                n4 = this.orientedOrigRect.width - n - 1;
            }
        }
        Point point2 = new Point(n3, n4);
        return point2;
    }

    public Point imageToOriented(Point point) {
        int n = point.x;
        int n2 = point.y;
        int n3 = n;
        int n4 = n2;
        switch (this.iv.getOrientation()) {
            default: {
                break;
            }
            case 1: {
                n3 = this.imageRect.width - n - 1;
                break;
            }
            case 2: {
                n4 = this.imageRect.height - n2 - 1;
                break;
            }
            case 3: {
                n3 = this.imageRect.width - n - 1;
                n4 = this.imageRect.height - n2 - 1;
                break;
            }
            case 6: {
                n3 = n2;
                n4 = n;
                break;
            }
            case 5: {
                n3 = this.imageRect.height - n2 - 1;
                n4 = n;
                break;
            }
            case 4: {
                n3 = n2;
                n4 = this.imageRect.width - n - 1;
                break;
            }
            case 7: {
                n3 = this.imageRect.height - n2 - 1;
                n4 = this.imageRect.width - n - 1;
            }
        }
        return new Point(n3, n4);
    }

    public float[] imageToOriented(float[] fArray) {
        float f = fArray[0];
        float f2 = fArray[1];
        float f3 = f;
        float f4 = f2;
        switch (this.iv.getOrientation()) {
            default: {
                break;
            }
            case 1: {
                f3 = (float)this.imageRect.width - f - 1.0f;
                break;
            }
            case 2: {
                f4 = (float)this.imageRect.height - f2 - 1.0f;
                break;
            }
            case 3: {
                f3 = (float)this.imageRect.width - f - 1.0f;
                f4 = (float)this.imageRect.height - f2 - 1.0f;
                break;
            }
            case 6: {
                f3 = f2;
                f4 = f;
                break;
            }
            case 5: {
                f3 = (float)this.imageRect.height - f2 - 1.0f;
                f4 = f;
                break;
            }
            case 4: {
                f3 = f2;
                f4 = (float)this.imageRect.width - f - 1.0f;
                break;
            }
            case 7: {
                f3 = (float)this.imageRect.height - f2 - 1.0f;
                f4 = (float)this.imageRect.width - f - 1.0f;
            }
        }
        return new float[]{f3, f4};
    }

    public Rectangle screenRectangleToImageRectangle(Rectangle rectangle, boolean bl) {
        int n = rectangle.x - this.imageData.x;
        int n2 = rectangle.y - this.imageData.y;
        int n3 = (int)((double)n * this.xScale);
        int n4 = (int)((double)n2 * this.yScale);
        int n5 = rectangle.width != 0 ? (int)((double)(n + rectangle.width - 1) * this.xScale) : n3;
        int n6 = rectangle.height != 0 ? (int)((double)(n2 + rectangle.height - 1) * this.yScale) : n4;
        Point point = this.orientedToImage(new Point(n3, n4));
        Point point2 = this.orientedToImage(new Point(n5, n6));
        n3 = point.x;
        n4 = point.y;
        n5 = point2.x;
        n6 = point2.y;
        if (bl) {
            int n7;
            if (n3 > n5) {
                n7 = n3;
                n3 = n5;
                n5 = n7;
            }
            if (n4 > n6) {
                n7 = n4;
                n4 = n6;
                n6 = n7;
            }
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= this.origRect.width) {
            n3 = this.origRect.width - 1;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n5 >= this.origRect.width) {
            n5 = this.origRect.width - 1;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n4 >= this.origRect.height) {
            n4 = this.origRect.height - 1;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n6 >= this.origRect.height) {
            n6 = this.origRect.height - 1;
        }
        int n8 = n5 - n3 + 1;
        int n9 = n6 - n4 + 1;
        Rectangle rectangle2 = new Rectangle(n3, n4, n8, n9);
        return rectangle2;
    }

    public Rectangle screenRectangleToOrientedImageRectangle(Rectangle rectangle, boolean bl) {
        int n = rectangle.x - this.imageData.x;
        int n2 = rectangle.y - this.imageData.y;
        int n3 = (int)((double)n * this.xScale);
        int n4 = (int)((double)n2 * this.yScale);
        int n5 = rectangle.width != 0 ? (int)((double)(n + rectangle.width - 1) * this.xScale) : n3;
        int n6 = rectangle.height != 0 ? (int)((double)(n2 + rectangle.height - 1) * this.yScale) : n4;
        if (bl) {
            int n7;
            if (n3 > n5) {
                n7 = n3;
                n3 = n5;
                n5 = n7;
            }
            if (n4 > n6) {
                n7 = n4;
                n4 = n6;
                n6 = n7;
            }
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 >= this.orientedRect.width) {
            n3 = this.orientedRect.width - 1;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n5 >= this.orientedRect.width) {
            n5 = this.orientedRect.width - 1;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (n4 >= this.orientedRect.height) {
            n4 = this.orientedRect.height - 1;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n6 >= this.orientedRect.height) {
            n6 = this.orientedRect.height - 1;
        }
        int n8 = n5 - n3 + 1;
        int n9 = n6 - n4 + 1;
        Rectangle rectangle2 = new Rectangle(n3, n4, n8, n9);
        return rectangle2;
    }

    public Point tcToScreen(float f, float f2) {
        float f3 = f - (float)this.imageRect.x;
        float f4 = f2 - (float)this.imageRect.y;
        float[] fArray = this.imageToOriented(new float[]{f3, f4});
        Point point = new Point((int)((double)fArray[0] / this.xScale), (int)((double)fArray[1] / this.yScale));
        return point;
    }

    public void clearCanvas() {
        if (this.imageCanvas != null && this.imageCanvasGC != null) {
            Rectangle rectangle = this.imageCanvas.getBounds();
            this.imageCanvasGC.fillRectangle(0, 0, rectangle.width, rectangle.height);
        }
    }

    public Rectangle getSelectedArea() {
        return this.selectedArea;
    }

    public void selectZoom(ZoomSelection zoomSelection) {
        this.logger.debug((Object)("set zoom to " + zoomSelection.getName()));
        this.iv.setZoomSelection(zoomSelection);
        this.selectingOn = false;
        this.selectOn = false;
    }

    public boolean isImageChanged() {
        return this.imageChanged;
    }

    public void setImageChanged(boolean bl) {
        this.imageChanged = bl;
    }

    public Rectangle getImageRect() {
        return this.imageRect;
    }

    public void setImageRect(Rectangle rectangle) {
        this.imageRect = rectangle;
    }

    public Rectangle getOrigRect() {
        return this.origRect;
    }

    public Rectangle getOrientedOrigRect() {
        return this.orientedOrigRect;
    }

    public Rectangle getOrientedRect() {
        return this.orientedRect;
    }

    public Boolean getSelectOn() {
        return this.selectOn;
    }

    public void setSelectOn(Boolean bl) {
        this.selectOn = bl;
    }

    public Image getImage() {
        return this.image;
    }
}

