/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.toolbox.FableUtils;
import fable.imageviewer.actions.ImageViewActions;
import fable.imageviewer.internal.Coordinates;
import fable.imageviewer.internal.CustomCoordinatesDialog;
import fable.imageviewer.internal.IImagesVarKeys;
import fable.imageviewer.internal.ZoomSelection;
import fable.imageviewer.rcp.Activator;
import fable.imageviewer.views.ImageView;
import fable.imageviewer.views.ImageViewImage;
import java.text.NumberFormat;
import java.text.ParseException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;

public class ImageViewControls
implements IImagesVarKeys {
    ImageView iv = null;
    private ImageViewImage image = null;
    private Composite controlComposite = null;
    private boolean controlCompositeShowing = true;
    private Display display;
    private Combo coordCombo;
    private Combo orientCombo;
    private Combo lutCombo;
    private Button aspectButton = null;
    private Button peaksButton = null;
    private Button autoscaleButton = null;
    private Text minimumText = null;
    private Text maximumText = null;
    private Text fileNumberText = null;
    private Label statusLabel = null;
    private Canvas imageCanvas;
    private Composite statusGroup;
    private static NumberFormat decimalFormat = NumberFormat.getNumberInstance();
    static boolean customSavedParametersInitialized = false;
    private ImageViewActions actions;

    public ImageViewControls(ImageView imageView) {
        this.iv = imageView;
    }

    public void createControls(Composite composite) {
        if (this.iv == null) {
            return;
        }
        this.image = new ImageViewImage(this.iv, this);
        this.actions = new ImageViewActions(this.iv, this, this.image);
        this.display = this.iv.getDisplay();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite.setLayout((Layout)gridLayout);
        this.iv.getController().addPropertyChangeListener((IPropertyChangeListener)this.iv);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 5;
        this.controlComposite = new Composite(composite, 0);
        this.controlComposite.setLayout((Layout)gridLayout2);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.exclude = !this.controlCompositeShowing;
        this.controlComposite.setLayoutData((Object)gridData);
        this.controlComposite.getAccessible().getControl();
        this.orientCombo = new Combo(this.controlComposite, 0);
        String[] stringArray = new String[8];
        int n = 0;
        while (n < 8) {
            stringArray[n] = orientNameValues[n][0];
            ++n;
        }
        this.orientCombo.setItems(stringArray);
        this.orientCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.orientCombo.setToolTipText("Adjust the orientation with O parameters (o11 o12 o21 o22)");
        this.orientCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = ImageViewControls.this.orientCombo.getSelectionIndex();
                ImageViewControls.this.iv.setOrientation(n);
            }
        });
        Preferences preferences = Activator.getDefault().getPluginPreferences();
        int n2 = preferences.getInt("orientationPreference");
        this.iv.setOrientation(n2);
        this.orientCombo.select(n2);
        if (!customSavedParametersInitialized) {
            String string = "xName";
            try {
                this.iv.setXNameSave(preferences.getString("coordinatesXNamePreference"));
                string = "yName";
                this.iv.setYNameSave(preferences.getString("coordinatesYNamePreference"));
                string = "x0";
                this.iv.setX0Save(Double.parseDouble(preferences.getString("coordinatesX0Preference")));
                string = "y0";
                this.iv.setY0Save(Double.parseDouble(preferences.getString("coordinatesY0Preference")));
                string = "pixelHeight";
                this.iv.setPixelWidthSave(Double.parseDouble(preferences.getString("coordinatesPixelWidthPreference")));
                string = "pixelHeight";
                this.iv.setPixelHeightSave(Double.parseDouble(preferences.getString("coordinatesPixelHeightPreference")));
                customSavedParametersInitialized = true;
            }
            catch (NumberFormatException numberFormatException) {
                FableUtils.excMsg((Object)this, (String)("Error setting custom coordinates from preferences for " + string), (Throwable)numberFormatException);
            }
        }
        this.coordCombo = new Combo(this.controlComposite, 0);
        stringArray = new String[5];
        int n3 = 0;
        while (n3 < 5) {
            stringArray[n3] = coordNameValues[n3][0];
            ++n3;
        }
        this.coordCombo.setItems(stringArray);
        this.coordCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.coordCombo.setToolTipText("Select the origin of the coordinate system for mouse movement");
        this.coordCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = ImageViewControls.this.coordCombo.getSelectionIndex();
                int n2 = ImageViewControls.this.iv.getCoordOrigin();
                ImageViewControls.this.iv.setCoordOrigin(n);
                if (n == 4) {
                    Coordinates coordinates = ImageViewControls.this.iv.getCoordinates();
                    CustomCoordinatesDialog customCoordinatesDialog = coordinates.getType() == 4 ? new CustomCoordinatesDialog(ImageViewControls.this.display.getActiveShell(), coordinates.getX0(), coordinates.getY0(), coordinates.getPixelWidth(), coordinates.getPixelHeight(), coordinates.getXName(), coordinates.getYName()) : new CustomCoordinatesDialog(ImageViewControls.this.display.getActiveShell(), ImageViewControls.this.iv.getX0Save(), ImageViewControls.this.iv.getY0Save(), ImageViewControls.this.iv.getPixelWidthSave(), ImageViewControls.this.iv.getPixelHeightSave(), ImageViewControls.this.iv.getXNameSave(), ImageViewControls.this.iv.getYNameSave());
                    boolean bl = customCoordinatesDialog.open();
                    if (bl) {
                        ImageViewControls.this.iv.setX0Save(customCoordinatesDialog.getX0());
                        ImageViewControls.this.iv.setY0Save(customCoordinatesDialog.getY0());
                        ImageViewControls.this.iv.setPixelWidthSave(customCoordinatesDialog.getPixelWidth());
                        ImageViewControls.this.iv.setPixelHeightSave(customCoordinatesDialog.getPixelHeight());
                        ImageViewControls.this.iv.setXNameSave(customCoordinatesDialog.getXName());
                        ImageViewControls.this.iv.setYNameSave(customCoordinatesDialog.getYName());
                        coordinates.reset(ImageViewControls.this.iv.getCoordOrigin(), ImageViewControls.this.iv.getX0Save(), ImageViewControls.this.iv.getY0Save(), ImageViewControls.this.iv.getPixelWidthSave(), ImageViewControls.this.iv.getPixelHeightSave(), ImageViewControls.this.iv.getXNameSave(), ImageViewControls.this.iv.getYNameSave());
                    } else {
                        ImageViewControls.this.iv.setCoordOrigin(n2);
                    }
                } else {
                    ImageViewControls.this.iv.resetCoordinates();
                }
            }
        });
        n3 = preferences.getInt("coordinatesPreference");
        this.coordCombo.select(n3);
        if (n3 == 4) {
            Coordinates coordinates = this.iv.getCoordinates();
            try {
                coordinates.reset(n3, this.iv.getX0Save(), this.iv.getY0Save(), this.iv.getPixelWidthSave(), this.iv.getPixelHeightSave(), this.iv.getXNameSave(), this.iv.getYNameSave());
            }
            catch (NumberFormatException numberFormatException) {
                FableUtils.excMsg((Object)this, (String)"Error setting custom coordinates", (Throwable)numberFormatException);
                coordinates.resetToDefault();
            }
        } else {
            this.iv.resetCoordinates();
        }
        this.lutCombo = new Combo(this.controlComposite, 0);
        int n4 = paletteNameValues.length;
        stringArray = new String[n4];
        int n5 = 0;
        while (n5 < n4) {
            stringArray[n5] = paletteNameValues[n5][0];
            ++n5;
        }
        this.lutCombo.setItems(stringArray);
        this.lutCombo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.lutCombo.setToolTipText("Set the Color Map");
        this.lutCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = ImageViewControls.this.lutCombo.getSelectionIndex();
                ImageViewControls.this.iv.setPalette(n);
            }
        });
        n5 = preferences.getInt("palettePreference");
        this.iv.setPalette(n5);
        this.iv.setZoomSelection(ZoomSelection.AREA);
        this.peaksButton = new Button(this.controlComposite, 0x1000020);
        this.peaksButton.setText("Show Peaks");
        this.peaksButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.peaksButton.setToolTipText("Display peaks");
        this.peaksButton.setSelection(this.iv.isPeaksOn());
        this.peaksButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageViewControls.this.iv.setPeaksOn(ImageViewControls.this.peaksButton.getSelection());
                ImageViewControls.this.image.displayImage();
            }
        });
        this.aspectButton = new Button(this.controlComposite, 0x1000020);
        this.aspectButton.setText("Keep Aspect Ratio");
        this.aspectButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.aspectButton.setToolTipText("Keep aspect ratio when displaying image");
        this.aspectButton.setSelection(this.iv.isKeepAspect());
        this.aspectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageViewControls.this.iv.setKeepAspect(ImageViewControls.this.aspectButton.getSelection());
                ImageViewControls.this.image.clearCanvas();
                ImageViewControls.this.image.displayImage();
            }
        });
        this.autoscaleButton = new Button(this.controlComposite, 0x1000020);
        this.autoscaleButton.setText("Autoscale Intensity");
        this.autoscaleButton.setLayoutData((Object)new GridData(4, 4, true, true));
        this.autoscaleButton.setSelection(this.iv.isAutoscale());
        this.autoscaleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImageViewControls.this.resetAutoscale();
                ImageViewControls.this.image.displayImage();
            }
        });
        Label label = new Label(this.controlComposite, 0);
        label.setText("Minimum Intensity");
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        this.minimumText = new Text(this.controlComposite, 0);
        this.minimumText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.minimumText.setText("0");
        this.minimumText.setBackground(this.display.getSystemColor(1));
        this.minimumText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                ImageViewControls.this.resetAutoscale();
                ImageViewControls.this.image.displayImage();
            }
        });
        this.minimumText.setEnabled(!this.iv.isAutoscale());
        Label label2 = new Label(this.controlComposite, 0);
        label2.setText("Maximum Intensity");
        label2.setLayoutData((Object)new GridData(4, 4, true, true));
        this.maximumText = new Text(this.controlComposite, 0);
        this.maximumText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.maximumText.setText("0");
        this.maximumText.setBackground(this.display.getSystemColor(1));
        this.maximumText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                ImageViewControls.this.resetAutoscale();
                ImageViewControls.this.image.displayImage();
            }
        });
        this.maximumText.setEnabled(!this.iv.isAutoscale());
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.numColumns = 2;
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)gridLayout3);
        composite2.setLayoutData((Object)new GridData(1808));
        this.imageCanvas = new Canvas(composite2, 0);
        this.image.initializeCanvas();
        Composite composite3 = new Composite(composite, 0);
        GridLayout gridLayout4 = new GridLayout();
        gridLayout4.numColumns = 8;
        composite3.setLayout((Layout)gridLayout4);
        composite3.setLayoutData((Object)new GridData(768));
        this.statusLabel = new Label(composite3, 0);
        this.statusLabel.setLayoutData((Object)new GridData(768));
        this.contributeToActionBars();
        this.createContextMenu();
        this.iv.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this.iv);
    }

    public void resetAutoscale() {
        this.iv.setAutoscale(this.autoscaleButton.getSelection());
        if (this.iv.isAutoscale()) {
            this.minimumText.setEnabled(false);
            this.maximumText.setEnabled(false);
            this.iv.setCurrentMinimum(this.iv.getMinimum());
            this.iv.setCurrentMaximum(this.iv.getMaximum());
        } else {
            this.minimumText.setEnabled(true);
            this.maximumText.setEnabled(true);
            try {
                this.iv.setCurrentMinimum(decimalFormat.parse(this.minimumText.getText()).floatValue());
            }
            catch (ParseException parseException) {
                FableUtils.excNoTraceMsg((Object)this, (String)"Unable to parse minimum value", (Throwable)parseException);
            }
            try {
                this.iv.setCurrentMaximum(decimalFormat.parse(this.maximumText.getText()).floatValue());
            }
            catch (ParseException parseException) {
                FableUtils.excNoTraceMsg((Object)this, (String)"Unable to parse maximum value", (Throwable)parseException);
            }
        }
    }

    public void createFileNumberText() {
        if (this.fileNumberText == null) {
            this.fileNumberText = new Text(this.statusGroup, 2048);
            this.fileNumberText.setToolTipText("Go to image number");
            this.fileNumberText.setEnabled(true);
            this.fileNumberText.addListener(14, new Listener(){

                public void handleEvent(Event event) {
                    int n;
                    int n2 = Integer.parseInt(ImageViewControls.this.fileNumberText.getText());
                    if (n2 > (n = ImageViewControls.this.iv.getController().getCurrentsample().getFilteredfiles().size())) {
                        n2 = n - 1;
                    }
                    ImageViewControls.this.iv.getController().setCurrentFileIndex(n2);
                }
            });
        }
    }

    private void fillLocalMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IAction)this.actions.controlPanelAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.actions.zoomAreaAction);
        iMenuManager.add((IAction)this.actions.zoomLineAction);
        iMenuManager.add((IAction)this.actions.zoomProfileAction);
        iMenuManager.add((IAction)this.actions.zoomReliefAction);
        iMenuManager.add((IAction)this.actions.zoomRockingAction);
        iMenuManager.add((IAction)this.actions.resetZoomAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.actions.copyImageAction);
        iMenuManager.add((IAction)this.actions.setDifferenceAction);
        iMenuManager.add((IAction)this.actions.displayDifferenceAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.actions.slice1DAction);
        iMenuManager.add((IAction)this.actions.slice2DAction);
        MenuManager menuManager = new MenuManager("Print");
        iMenuManager.add((IContributionItem)menuManager);
        menuManager.add((IAction)this.actions.printSetupAction);
        menuManager.add((IAction)this.actions.printPreviewAction);
        menuManager.add((IAction)this.actions.printAction);
        menuManager = new MenuManager("Edit");
        iMenuManager.add((IContributionItem)menuManager);
        menuManager.add((IAction)this.actions.copyAction);
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IAction)this.actions.imageInfoAction);
        iMenuManager.add((IAction)this.actions.inputSummaryAction);
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.actions.controlPanelAction);
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.iv.getViewSite().getActionBars();
        this.fillLocalMenu(iActionBars.getMenuManager());
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                ImageViewControls.this.fillLocalMenu(iMenuManager);
            }
        });
        Menu menu = menuManager.createContextMenu(this.imageCanvas.getAccessible().getControl());
        this.imageCanvas.getAccessible().getControl().setMenu(menu);
    }

    public void setFileNumberText(String string) {
        if (this.fileNumberText != null) {
            this.fileNumberText.setText(string);
        }
    }

    public void setMinMaxText(float[] fArray) {
        this.minimumText.setText(Float.toString(fArray[0]));
        this.maximumText.setText(Float.toString(fArray[1]));
    }

    public float[] getMinMaxText() {
        float[] fArray = new float[2];
        try {
            fArray[0] = decimalFormat.parse(this.minimumText.getText()).floatValue();
            fArray[1] = decimalFormat.parse(this.maximumText.getText()).floatValue();
        }
        catch (ParseException parseException) {
            FableUtils.excNoTraceMsg((Object)this, (String)"Unable to read minimum and/or maximum", (Throwable)parseException);
            fArray[1] = Float.NaN;
            fArray[0] = Float.NaN;
        }
        return fArray;
    }

    public Combo getCoordCombo() {
        return this.coordCombo;
    }

    public Combo getOrientCombo() {
        return this.orientCombo;
    }

    public Combo getLutCombo() {
        return this.lutCombo;
    }

    public void setStatusText(String string) {
        if (this.statusLabel != null && !this.statusLabel.isDisposed()) {
            this.statusLabel.setText(string);
        }
    }

    public Button getAspectButton() {
        return this.aspectButton;
    }

    public Button getAutoscaleButton() {
        return this.autoscaleButton;
    }

    public Button getPeaksButton() {
        return this.peaksButton;
    }

    public Canvas getImageCanvas() {
        return this.imageCanvas;
    }

    public ImageViewImage getImage() {
        return this.image;
    }

    public void setImage(ImageViewImage imageViewImage) {
        this.image = imageViewImage;
    }

    public Composite getControlComposite() {
        return this.controlComposite;
    }

    public boolean getControlCompositeShowing() {
        return this.controlCompositeShowing;
    }

    public void setControlCompositeShowing(boolean bl) {
        this.controlCompositeShowing = bl;
    }
}

