/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.logging.FableLogger;
import fable.framework.navigator.controller.SampleController;
import fable.framework.toolbox.FableUtils;
import fable.imageviewer.internal.Coordinates;
import fable.imageviewer.internal.IImagesVarKeys;
import fable.imageviewer.internal.ImageViewType;
import fable.imageviewer.internal.PaletteUtils;
import fable.imageviewer.internal.ZoomSelection;
import fable.imageviewer.model.ImageModel;
import fable.imageviewer.views.ImagePlay;
import fable.imageviewer.views.ImageViewControls;
import fable.imageviewer.views.ImageViewImage;
import fable.python.FabioFile;
import fable.python.Peak;
import fable.python.PeakSearchSpt;
import fable.python.jep.FableJep;
import java.util.Vector;
import jep.JepException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class ImageView
extends ViewPart
implements IPropertyChangeListener,
IImagesVarKeys,
ISelectionListener {
    public static final String ID = "fable.imageviewer.views.ImageView";
    public static ImageView mainImageView = null;
    private SampleController controller = SampleController.getController();
    private ImageViewControls controls = null;
    public ImageViewImage image = null;
    private Display display;
    private FabioFile fabioFile = null;
    private ImageModel imageModel = null;
    private ImageModel imageDiffModel = null;
    private ImageModel savedImageModel = null;
    private String fileNameSaved = "";
    private Vector<Float> peaks;
    private Coordinates coordinates = new Coordinates();
    double x0Save = 0.0;
    double y0Save = 0.0;
    double pixelWidthSave = 1.0;
    double pixelHeightSave = 1.0;
    String xNameSave = "x";
    String yNameSave = "y";
    private int orientation = 0;
    private ZoomSelection zoomSelection = ZoomSelection.AREA;
    private int coordOrigin = 0;
    private boolean peaksOn = false;
    private boolean autoscale = true;
    private float minimum;
    private float maximum;
    private float mean;
    private float currentMinimum;
    private float currentMaximum;
    private int linePeakWidth = 3;
    private static PaletteData[] palettes = new PaletteData[paletteNameValues.length];
    private PaletteData palette = null;
    private int paletteIndex = 0;
    private boolean keepAspect = false;
    private boolean listening = true;
    public static int secondaryId = 2;
    protected boolean imageDiffOn = false;
    private boolean jobRunning = false;

    public void setPartName(String string) {
        super.setPartName(string);
    }

    public void createPartControl(Composite composite) {
        if (mainImageView == null) {
            mainImageView = this;
            ImagePlay.iv = this;
        }
        this.display = composite.getDisplay();
        this.controls = new ImageViewControls(this);
        this.controls.createControls(composite);
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            Object object = iStructuredSelection.getFirstElement();
            Object[] objectArray = iStructuredSelection.toArray();
            if (object instanceof PeakSearchSpt) {
                PeakSearchSpt peakSearchSpt = (PeakSearchSpt)object;
                FabioFile fabioFile = peakSearchSpt.getImageFile();
                if (fabioFile != null) {
                    this.loadFile(fabioFile);
                    this.setPeaksOn(true);
                    this.image.displayImage();
                    Vector vector = peakSearchSpt.getTabChildren();
                    if (vector != null) {
                        this.setPeaks(vector);
                        this.image.showPeaks();
                    }
                }
            } else if (object instanceof Peak) {
                PeakSearchSpt peakSearchSpt = ((Peak)object).getParent();
                int n = objectArray.length;
                float[] fArray = new float[n * 2];
                int n2 = 0;
                int n3 = 0;
                while (n3 < objectArray.length) {
                    Peak peak = (Peak)objectArray[n3];
                    if (peak.isVisible()) {
                        int n4 = n2 + 1;
                        fArray[n2] = Float.valueOf(peak.getS()).floatValue();
                        fArray[n4] = Float.valueOf(peak.getF()).floatValue();
                        n2 += 2;
                    }
                    ++n3;
                }
                Vector vector = peakSearchSpt.getTabChildren();
                if (vector != null) {
                    this.setPeaks(vector);
                }
                this.setPeaksOn(true);
                this.image.showSelectedPeaks(fArray);
            }
        }
    }

    public void setViewType(ImageViewType imageViewType) {
        if (imageViewType == ImageViewType.IMAGE_MAIN_VIEW) {
            mainImageView = this;
            ImagePlay.setView(mainImageView);
        }
    }

    public void stopListening() {
        if (this.listening) {
            this.controller.removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    public void loadFile(FabioFile fabioFile) {
        if (fabioFile != this.fabioFile) {
            this.peaks = null;
            this.fabioFile = fabioFile;
            try {
                this.imageModel = new ImageModel(this.fabioFile);
            }
            catch (JepException jepException) {
                FableUtils.excNoTraceMsg((Object)this, (String)"Unable to load file", (Throwable)jepException);
                this.image.clearCanvas();
                return;
            }
            if (this.controls != null) {
                this.controls.setStatusText("Loading file " + this.fabioFile.getFileName() + " ... ");
            }
            this.image.setImageChanged(true);
            if (this.image.getImageRect().width != this.imageModel.getWidth() || this.image.getImageRect().height != this.imageModel.getHeight()) {
                this.image.clearCanvas();
            }
            this.image.setImageRect(new Rectangle(this.image.getImageRect().x, this.image.getImageRect().y, this.imageModel.getWidth(), this.imageModel.getHeight()));
            this.image.calculateMainRectangles();
            this.resetCoordinates();
            float[] fArray = this.imageModel.getStatistics(this.image.getImageRect());
            this.minimum = fArray[0];
            this.maximum = fArray[1];
            this.mean = fArray[2];
            this.maximum = this.minimum + 2.0f * (this.mean - this.minimum);
            if (this.maximum - this.minimum < 0.01f) {
                this.maximum = this.minimum + 0.01f;
            }
            if (this.controls != null) {
                this.controls.resetAutoscale();
            }
            this.updateStatusLabel("loading file " + this.fabioFile.getFileName() + " ... took " + this.fabioFile.getTimeToReadImage() + " ms");
            if (this.imageDiffOn) {
                this.calcImageDiff();
            } else {
                this.setPartName("Image " + this.fabioFile.getFileName());
            }
            if (this.controls != null && this.isAutoscale()) {
                this.controls.setMinMaxText(new float[]{this.minimum, this.maximum});
            }
        }
    }

    public void calcImageDiff() {
        long l = System.currentTimeMillis();
        if (this.savedImageModel == null) {
            this.setImageDiffOn(false);
            this.updateStatusLabel("cannot create difference image - no difference image set");
            FableUtils.errMsg((Object)this, (String)"Cannot create difference: no difference image set\n");
            this.setPartName("Image " + this.fabioFile.getFileName());
            return;
        }
        FableLogger.debug((Object)("caculate difference of " + this.imageModel.getFileName() + " and background image " + this.savedImageModel.getFileName()));
        float[] fArray = this.imageModel.getData();
        float[] fArray2 = this.savedImageModel.getData();
        int n = fArray.length;
        int n2 = fArray2.length;
        if (n != n2) {
            FableUtils.errMsg((Object)this, (String)"Cannot create difference:\nnewWidth=%d savedWidth=%d\nnewHeight=%d savedHeight=%d");
            this.setPartName("Image " + this.fabioFile.getFileName());
            return;
        }
        float[] fArray3 = new float[n2];
        int n3 = 0;
        while (n3 < n2) {
            fArray3[n3] = fArray[n3] - fArray2[n3];
            ++n3;
        }
        this.imageDiffModel = new ImageModel(String.valueOf(this.imageModel.getFileName()) + " - " + this.savedImageModel.getFileName(), this.imageModel.getWidth(), this.imageModel.getHeight(), fArray3);
        this.imageDiffModel.reset(String.valueOf(this.imageModel.getFileName()) + " - " + this.savedImageModel.getFileName(), this.imageModel.getWidth(), this.imageModel.getHeight(), fArray3);
        float[] fArray4 = this.imageDiffModel.getStatistics(this.image.getImageRect());
        this.minimum = fArray4[0];
        this.minimum = fArray4[1];
        this.mean = fArray4[2];
        if (this.maximum - this.minimum < 0.01f) {
            this.maximum = this.minimum + 0.01f;
        }
        long l2 = System.currentTimeMillis() - l;
        this.updateStatusLabel(String.valueOf(this.getFileName()) + " - " + this.fileNameSaved + " took " + l2 + " ms");
        this.setPartName("Difference " + this.fabioFile.getFileName());
    }

    public void dropFile() {
        this.fabioFile = null;
        FabioFile fabioFile = this.controller.getCurrentFile();
        this.loadFile(fabioFile);
        this.image.displayImage();
        this.controls.setFileNumberText(Integer.toString(this.controller.getCurrentFileIndex()));
    }

    public void updateStatusLabel(String string) {
        final String string2 = string;
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ImageView.this.controls != null) {
                    ImageView.this.controls.setStatusText(string2);
                }
            }
        });
    }

    public void setPeaks(Vector<Float> vector) {
        this.peaks = vector;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("CurrentFile")) {
            Object object = propertyChangeEvent.getNewValue();
            FabioFile fabioFile = (FabioFile)object;
            this.loadFile(fabioFile);
            this.image.displayImage();
            this.controls.setFileNumberText(Integer.toString(this.controller.getCurrentFileIndex()));
            final int n = this.controller.getCurrentsample().getFilteredfiles().indexOf(object);
            int n2 = this.controller.getCurrentsample().getFilteredfiles().size();
            if (n >= 0 && n < n2 && !this.jobRunning) {
                final int n3 = Math.max(0, n - 3);
                final int n4 = Math.min(n + 3, n2 - 1);
                this.jobRunning = true;
                Job job = new Job("Read files ahead "){

                    protected IStatus run(IProgressMonitor iProgressMonitor) {
                        iProgressMonitor.beginTask("Read files ahead", 7);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Reading files ahead interrupted", (Throwable)interruptedException);
                        }
                        try {
                            FableJep fableJep = new FableJep();
                            int n2 = n3;
                            while (n2 <= n4) {
                                if (n2 >= 0 && n2 < ImageView.this.controller.getCurrentsample().getFilteredfiles().size() && n2 != n) {
                                    ((FabioFile)ImageView.this.controller.getCurrentsample().getFilteredfiles().get(n2)).readImageAsFloat(fableJep);
                                }
                                iProgressMonitor.worked(1);
                                ++n2;
                            }
                            fableJep.getJep().close();
                        }
                        catch (JepException jepException) {
                            FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Unable to access fabioFile while reading files ahead", (Throwable)jepException);
                        }
                        iProgressMonitor.done();
                        ImageView.this.jobRunning = false;
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        }
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        this.controller.removePropertyChangeListener((IPropertyChangeListener)this);
        super.dispose();
        if (this.getSite() != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        }
    }

    public void initWithShowPeaks() {
        if (this.controls == null) {
            return;
        }
        this.setPeaksOn(true);
        this.controls.getPeaksButton().notifyListeners(13, new Event());
    }

    public void setName(String string) {
        this.setPartName(string);
    }

    public void resetCoordinates() {
        if (this.coordOrigin != 4) {
            this.coordinates.reset(this.coordOrigin, this.image.getOrientedOrigRect().width, this.image.getOrientedOrigRect().height);
        }
    }

    public int getCoordOrigin() {
        return this.coordOrigin;
    }

    public void setCoordOrigin(int n) {
        if (n < 0 || n >= coordNameValues.length) {
            return;
        }
        if (this.coordOrigin != n) {
            this.coordOrigin = n;
            if (this.controls != null) {
                this.controls.getCoordCombo().select(n);
            }
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        if (n < 0 || n >= 8) {
            return;
        }
        if (n == this.orientation) {
            return;
        }
        this.orientation = n;
        if (this.controls != null) {
            this.controls.getOrientCombo().select(n);
        }
        this.resetCoordinates();
        this.image.clearCanvas();
        this.image.displayImage();
    }

    public PaletteData getPalette() {
        return this.palette;
    }

    public void setPalette(int n) {
        if (n < 0 || n >= paletteNameValues.length) {
            return;
        }
        if (palettes[n] == null) {
            switch (n) {
                case 0: {
                    ImageView.palettes[n] = PaletteUtils.makeGrayScalePalette();
                    break;
                }
                case 1: {
                    ImageView.palettes[n] = PaletteUtils.makeColorPalette();
                    break;
                }
                case 2: {
                    ImageView.palettes[n] = PaletteUtils.makeRainbow1Palette();
                    break;
                }
                case 3: {
                    ImageView.palettes[n] = PaletteUtils.makeRainbow2Palette();
                    break;
                }
                case 4: {
                    ImageView.palettes[n] = PaletteUtils.makeBluesPalette();
                    break;
                }
                case 5: {
                    ImageView.palettes[n] = PaletteUtils.makeGreensPalette();
                    break;
                }
                case 6: {
                    ImageView.palettes[n] = PaletteUtils.makeRedsPalette();
                    break;
                }
                case 7: {
                    ImageView.palettes[n] = PaletteUtils.makePastel1Palette();
                    break;
                }
                case 8: {
                    ImageView.palettes[n] = PaletteUtils.makeSpringPalette();
                    break;
                }
                case 9: {
                    ImageView.palettes[n] = PaletteUtils.makeSummerPalette();
                    break;
                }
                case 10: {
                    ImageView.palettes[n] = PaletteUtils.makeAutumnPalette();
                    break;
                }
                case 11: {
                    ImageView.palettes[n] = PaletteUtils.makeWinterPalette();
                }
            }
        }
        this.palette = palettes[n];
        if (this.controls != null) {
            this.controls.getLutCombo().select(n);
        }
        this.paletteIndex = n;
        this.image.displayImage();
    }

    public float[] getMinMax() {
        float[] fArray = new float[]{this.currentMinimum, this.currentMaximum};
        return fArray;
    }

    public void setMinMax(float[] fArray) {
        if (this.controls != null) {
            this.controls.setMinMaxText(fArray);
            this.controls.getAutoscaleButton().setSelection(false);
        }
        this.autoscale = false;
        this.image.displayImage();
    }

    public String getFileName() {
        String string = null;
        if (this.imageModel != null) {
            string = this.imageModel.getFileName();
        }
        return string == null ? "" : string;
    }

    public ImageModel getImageModel() {
        return this.imageModel;
    }

    public void setImageModel(ImageModel imageModel) {
        this.imageModel = imageModel;
    }

    public ImageModel getImageDiffModel() {
        return this.imageDiffModel;
    }

    public void setImageDiffModel(ImageModel imageModel) {
        this.imageDiffModel = imageModel;
    }

    public void setImageBackgroundModel(ImageModel imageModel) {
        this.savedImageModel = imageModel;
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public String getCoordinatesName() {
        if (this.coordOrigin < 0 || this.coordOrigin > 4) {
            return "Unknown";
        }
        return coordNameValues[this.coordOrigin][0].split("[\\s\\.]", 2)[0];
    }

    public FabioFile getFabioFile() {
        return this.fabioFile;
    }

    public void setFabioFile(FabioFile fabioFile) {
        this.fabioFile = fabioFile;
    }

    public SampleController getController() {
        return this.controller;
    }

    public boolean isPeaksOn() {
        return this.peaksOn;
    }

    public void setPeaksOn(boolean bl) {
        this.peaksOn = bl;
        Button button = this.controls.getPeaksButton();
        if (this.controls != null && button != null && button.getSelection() != bl) {
            button.setSelection(bl);
        }
    }

    public boolean isKeepAspect() {
        return this.keepAspect;
    }

    public void setKeepAspect(boolean bl) {
        this.keepAspect = bl;
        Button button = this.controls.getAspectButton();
        if (this.controls != null && button != null && button.getSelection() != bl) {
            button.setSelection(bl);
        }
    }

    public boolean isAutoscale() {
        return this.autoscale;
    }

    public void setAutoscale(boolean bl) {
        this.autoscale = bl;
        Button button = this.controls.getAutoscaleButton();
        if (this.controls != null && button != null && button.getSelection() != bl) {
            button.setSelection(bl);
        }
    }

    public ImageViewControls getControls() {
        return this.controls;
    }

    public void setControls(ImageViewControls imageViewControls) {
        this.controls = imageViewControls;
    }

    public ImageViewImage getImage() {
        return this.image;
    }

    public void setImage(ImageViewImage imageViewImage) {
        this.image = imageViewImage;
    }

    public void setZoomSelection(ZoomSelection zoomSelection) {
        this.zoomSelection = zoomSelection;
    }

    public ZoomSelection getZoomSelection() {
        return this.zoomSelection;
    }

    public Vector<Float> getPeaks() {
        return this.peaks;
    }

    public boolean isImageDiffOn() {
        return this.imageDiffOn;
    }

    public void setImageDiffOn(boolean bl) {
        this.imageDiffOn = bl;
        if (bl) {
            this.calcImageDiff();
        } else {
            this.setPartName("Image " + this.fabioFile.getFileName());
        }
        this.image.setImageChanged(true);
        this.image.displayImage();
    }

    public float getMinimum() {
        return this.minimum;
    }

    public void setMinimum(float f) {
        this.minimum = f;
    }

    public float getMaximum() {
        return this.maximum;
    }

    public void setMaximum(float f) {
        this.maximum = f;
    }

    public float getMean() {
        return this.mean;
    }

    public void setMean(float f) {
        this.mean = f;
    }

    public float getCurrentMinimum() {
        return this.currentMinimum;
    }

    public void setCurrentMinimum(float f) {
        this.currentMinimum = f;
    }

    public float getCurrentMaximum() {
        return this.currentMaximum;
    }

    public void setCurrentMaximum(float f) {
        this.currentMaximum = f;
    }

    public double getX0Save() {
        return this.x0Save;
    }

    public void setX0Save(double d) {
        this.x0Save = d;
    }

    public double getY0Save() {
        return this.y0Save;
    }

    public void setY0Save(double d) {
        this.y0Save = d;
    }

    public double getPixelWidthSave() {
        return this.pixelWidthSave;
    }

    public void setPixelWidthSave(double d) {
        this.pixelWidthSave = d;
    }

    public double getPixelHeightSave() {
        return this.pixelHeightSave;
    }

    public void setPixelHeightSave(double d) {
        this.pixelHeightSave = d;
    }

    public String getXNameSave() {
        return this.xNameSave;
    }

    public void setXNameSave(String string) {
        this.xNameSave = string;
    }

    public String getYNameSave() {
        return this.yNameSave;
    }

    public void setYNameSave(String string) {
        this.yNameSave = string;
    }

    public int getLinePeakWidth() {
        return this.linePeakWidth;
    }

    public void setLinePeakWidth(int n) {
        this.linePeakWidth = n;
    }

    public int getPaletteIndex() {
        return this.paletteIndex;
    }

    public void setPaletteIndex(int n) {
        this.paletteIndex = n;
    }

    public void setPalette(PaletteData paletteData) {
        this.palette = paletteData;
    }

    public Display getDisplay() {
        return this.display;
    }
}

