/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.views;

import fable.framework.navigator.controller.SampleController;
import fable.framework.navigator.views.SampleNavigatorView;
import fable.framework.toolbox.FableUtils;
import fable.imageviewer.views.ImageView;
import java.util.Vector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class ImagePlay
extends ViewPart {
    public static final String ID = "fable.imageviewer.views.ImagePlay";
    private Button imageNextButton;
    private Button imagePreviousButton;
    private Button imageFirstButton;
    private Button imageLastButton;
    private Button imagePauseButton;
    private boolean advancePlay = false;
    private int currentFileIndex = 0;
    private int playStep = 1;
    private int playWait = 3000;
    private Thread playThread = null;
    static ImageView iv = null;

    public void createPartControl(Composite composite) {
        int n = 4;
        int n2 = 4;
        boolean bl = true;
        boolean bl2 = false;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        gridLayout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.imageFirstButton = new Button(composite, 8);
        this.imageFirstButton.setText("<<");
        this.imageFirstButton.setLayoutData((Object)new GridData(n, n2, bl, bl2));
        this.imageFirstButton.setToolTipText("Go to first image");
        this.imageFirstButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ImagePlay.this.isAdvancePlay()) {
                    ImagePlay.this.startPlay(-1, 300);
                } else {
                    iv.getController().setCurrentFileIndex(0);
                    iv.getController().getFirstImage();
                }
            }
        });
        this.imagePreviousButton = new Button(composite, 8);
        this.imagePreviousButton.setText("<");
        this.imagePreviousButton.setLayoutData((Object)new GridData(n, n2, bl, bl2));
        this.imagePreviousButton.setToolTipText("Go to previous image");
        this.imagePreviousButton.setEnabled(true);
        this.imagePreviousButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ImagePlay.this.isAdvancePlay()) {
                    ImagePlay.this.startPlay(-1, 3000);
                } else {
                    int n = iv.getController().getCurrentFileIndex() - 1;
                    if (n >= 0) {
                        iv.getController().setCurrentFileIndex(n);
                    } else {
                        if (iv.getController().getCurrentsample() != null) {
                            iv.getController().setCurrentFileIndex(iv.getController().getCurrentsample().getFilteredfiles().size() - 1);
                        }
                        iv.getController().getNext(-1);
                    }
                }
            }
        });
        this.imagePauseButton = new Button(composite, 8);
        this.imagePauseButton.setText("Play");
        this.imagePauseButton.setLayoutData((Object)new GridData(n, n2, bl, bl2));
        this.imagePauseButton.setToolTipText("Play");
        this.imagePauseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ImagePlay.this.setAdvancePlay(!ImagePlay.this.isAdvancePlay());
                if (ImagePlay.this.isAdvancePlay()) {
                    ImagePlay.this.startPlay(1, 3000);
                    ImagePlay.this.imagePauseButton.setText("||");
                    ImagePlay.this.imagePauseButton.setToolTipText("Pause");
                } else {
                    ImagePlay.this.imagePauseButton.setText("Play");
                    ImagePlay.this.imagePauseButton.setToolTipText("Play");
                }
            }
        });
        this.imageNextButton = new Button(composite, 8);
        this.imageNextButton.setText(">");
        this.imageNextButton.setLayoutData((Object)new GridData(n, n2, bl, bl2));
        this.imageNextButton.setToolTipText("Go to next image");
        this.imageNextButton.setEnabled(true);
        this.imageNextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ImagePlay.this.isAdvancePlay()) {
                    ImagePlay.this.startPlay(1, 3000);
                } else {
                    int n = iv.getController().getCurrentFileIndex() + 1;
                    if (iv.getController().getCurrentsample() != null) {
                        if (n >= iv.getController().getCurrentsample().getFilteredfiles().size()) {
                            n = 0;
                        }
                        iv.getController().setCurrentFileIndex(n);
                    }
                    iv.getController().getNext(1);
                }
            }
        });
        this.imageLastButton = new Button(composite, 8);
        this.imageLastButton.setText(">>");
        this.imageLastButton.setLayoutData((Object)new GridData(n, n2, bl, bl2));
        this.imageLastButton.setToolTipText("Go to last image");
        this.imageLastButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ImagePlay.this.isAdvancePlay()) {
                    ImagePlay.this.startPlay(1, 300);
                } else {
                    if (iv.getController().getCurrentsample() != null) {
                        int n = iv.getController().getCurrentsample().getFilteredfiles().size();
                        iv.getController().setCurrentFileIndex(n - 1);
                    }
                    iv.getController().getLastImage();
                }
            }
        });
    }

    public void setFocus() {
    }

    public boolean isAdvancePlay() {
        return this.advancePlay;
    }

    public void setAdvancePlay(boolean bl) {
        this.advancePlay = bl;
    }

    public void startPlay(int n, int n2) {
        this.playStep = n;
        this.playWait = n2;
        if (this.playThread == null) {
            this.playThread = this.PlayThread();
            this.playThread.start();
        }
    }

    public Thread PlayThread() {
        return new Thread(){

            @Override
            public void run() {
                SampleController sampleController = iv.getController();
                Vector vector = SampleNavigatorView.view.getSelectedFilesIndex();
                int n = 0;
                if (vector.size() <= 1) {
                    ImagePlay.this.currentFileIndex = sampleController.getCurrentFileIndex();
                } else {
                    ImagePlay.this.currentFileIndex = (Integer)vector.firstElement();
                }
                while (ImagePlay.this.advancePlay) {
                    try {
                        if (vector.size() <= 1) {
                            ImagePlay imagePlay = ImagePlay.this;
                            imagePlay.currentFileIndex = imagePlay.currentFileIndex + ImagePlay.this.playStep;
                        } else {
                            if ((n += ImagePlay.this.playStep) >= vector.size()) {
                                n = 0;
                            }
                            ImagePlay.this.currentFileIndex = (Integer)vector.elementAt(n);
                        }
                        sampleController.getNext(ImagePlay.this.playStep);
                        if (sampleController.getCurrentsample() != null) {
                            if (ImagePlay.this.currentFileIndex >= sampleController.getCurrentsample().getFilteredfiles().size()) {
                                ImagePlay.this.currentFileIndex = 0;
                            } else if (ImagePlay.this.currentFileIndex < 0) {
                                ImagePlay.this.currentFileIndex = sampleController.getCurrentsample().getFilteredfiles().size() - 1;
                            }
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    iv.getController().setCurrentFileIndex(ImagePlay.this.currentFileIndex);
                                }
                            });
                        }
                        Thread.sleep(ImagePlay.this.playWait);
                    }
                    catch (InterruptedException interruptedException) {
                        FableUtils.excTraceMsg((Object)this, (String)"PlayThread Interrupted", (Throwable)interruptedException);
                    }
                }
                ImagePlay.this.playThread = null;
            }
        };
    }

    public static void setView(ImageView imageView) {
        iv = imageView;
    }
}

