/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.internal;

import fable.framework.toolbox.FableUtils;
import fable.imageviewer.rcp.Activator;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CustomCoordinatesDialog
extends Dialog {
    private static final int DEFAULT_TEXT_WIDTH = 30;
    private double x0 = 0.0;
    private double y0 = 0.0;
    private double pixelWidth = 1.0;
    private double pixelHeight = 1.0;
    private String xName = "x";
    private String yName = "y";
    boolean success = false;
    Text x0Text;
    Text y0Text;
    Text pixelWidthTexy;
    Text pixelHeightText;
    Text xNameText;
    Text yNameText;

    public CustomCoordinatesDialog(Shell shell, double d, double d2, double d3, double d4, String string, String string2) {
        this(shell, d, d2, d3, d4, string, string2, 67680);
        this.x0 = d;
        this.y0 = d2;
        this.pixelWidth = d3;
        this.pixelHeight = d4;
        this.xName = string;
        this.yName = string2;
    }

    public CustomCoordinatesDialog(Shell shell) {
        super(shell, 67680);
        Preferences preferences = Activator.getDefault().getPluginPreferences();
        try {
            this.x0 = Double.parseDouble(preferences.getString("coordinatesX0Preference"));
            this.y0 = Double.parseDouble(preferences.getString("coordinatesY0Preference"));
            this.pixelWidth = Double.parseDouble(preferences.getString("coordinatesPixelWidthPreference"));
            this.pixelHeight = Double.parseDouble(preferences.getString("coordinatesPixelHeightPreference"));
            this.xName = preferences.getString("coordinatesXNamePreference");
            this.yName = preferences.getString("coordinatesYNamePreference");
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public CustomCoordinatesDialog(Shell shell, double d, double d2, double d3, double d4, String string, String string2, int n) {
        super(shell, n);
    }

    public boolean open() {
        Shell shell = new Shell(this.getParent(), this.getStyle() | 0x10);
        shell.setText("Set Custom Coordinates");
        Image image = null;
        try {
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
        }
        catch (Exception exception) {}
        if (image != null) {
            shell.setImage(image);
        }
        this.createContents(shell);
        shell.pack();
        shell.open();
        Display display = this.getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.success;
    }

    private void createContents(final Shell shell) {
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 8;
        formLayout.marginWidth = 8;
        shell.setLayout((Layout)formLayout);
        Group group = new Group((Composite)shell, 2048);
        group.setText("Custom Coordinates");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        group.setLayout((Layout)gridLayout);
        Text text = new Text((Composite)group, 2);
        text.setEditable(false);
        String string = "The displayed coordinates (x1, y1) are defined via the equations:\n\tx1 = pixelWidth * (x - x0)\n\ty2 = pixelWidth * (y - y0)\nwhere (x, y) are the image coordinates with origin at top left.\nThe coordinates can be named other than x and y.";
        text.setText(string);
        GridData gridData = new GridData(272);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)gridData);
        Composite composite = new Composite((Composite)group, 0);
        gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        composite.setLayout((Layout)gridLayout2);
        Label label = new Label(composite, 0);
        label.setText("x0");
        this.setGridData((Control)label);
        final Text text2 = new Text(composite, 133124);
        text2.setText(String.valueOf(this.x0));
        this.setGridData((Control)text2);
        label = new Label(composite, 0);
        label.setText("y0");
        this.setGridData((Control)label);
        final Text text3 = new Text(composite, 133124);
        text3.setText(String.valueOf(this.y0));
        this.setGridData((Control)text3);
        label = new Label(composite, 0);
        label.setText("pixelWidth");
        this.setGridData((Control)label);
        final Text text4 = new Text(composite, 133124);
        text4.setText(String.valueOf(this.pixelWidth));
        this.setGridData((Control)text4);
        label = new Label(composite, 0);
        label.setText("pixelHeight");
        this.setGridData((Control)label);
        final Text text5 = new Text(composite, 133124);
        text5.setText(String.valueOf(this.pixelHeight));
        this.setGridData((Control)text5);
        label = new Label(composite, 0);
        label.setText("xName");
        this.setGridData((Control)label);
        final Text text6 = new Text(composite, 133124);
        text6.setText(this.xName);
        this.setGridData((Control)text6);
        label = new Label(composite, 0);
        label.setText("yName");
        this.setGridData((Control)label);
        final Text text7 = new Text(composite, 133124);
        text7.setText(this.yName);
        this.setGridData((Control)text7);
        Button button = new Button((Composite)shell, 8);
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)group, 8);
        formData.right = new FormAttachment(100, -4);
        button.setLayoutData((Object)formData);
        button.setText("&Cancel");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CustomCoordinatesDialog.this.success = false;
                shell.close();
            }
        });
        Button button2 = new Button((Composite)shell, 8);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment((Control)group, 8);
        formData2.right = new FormAttachment((Control)button, -8);
        button2.setLayoutData((Object)formData2);
        button2.setText("&OK");
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = "xName";
                try {
                    CustomCoordinatesDialog.this.xName = text6.getText();
                    string = "yName";
                    CustomCoordinatesDialog.this.yName = text7.getText();
                    string = "x0";
                    CustomCoordinatesDialog.this.x0 = Double.parseDouble(text2.getText());
                    string = "y0";
                    CustomCoordinatesDialog.this.y0 = Double.parseDouble(text3.getText());
                    string = "pixelWidth";
                    CustomCoordinatesDialog.this.pixelWidth = Double.parseDouble(text4.getText());
                    string = "pixelHeight";
                    CustomCoordinatesDialog.this.pixelHeight = Double.parseDouble(text5.getText());
                    CustomCoordinatesDialog.this.success = true;
                    shell.close();
                }
                catch (NumberFormatException numberFormatException) {
                    FableUtils.excMsg((Object)((Object)this), (String)("Error processing " + string), (Throwable)numberFormatException);
                }
            }
        });
        shell.setDefaultButton(button2);
    }

    private GridData setGridData(Control control) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        if (control instanceof Text) {
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = 30;
        }
        control.setLayoutData((Object)gridData);
        return gridData;
    }

    public double getX0() {
        return this.x0;
    }

    public double getY0() {
        return this.y0;
    }

    public double getPixelWidth() {
        return this.pixelWidth;
    }

    public double getPixelHeight() {
        return this.pixelHeight;
    }

    public String getXName() {
        return this.xName;
    }

    public String getYName() {
        return this.yName;
    }
}

