/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.actions;

import fable.framework.navigator.views.SampleNavigatorView;
import fable.framework.toolbox.FableUtils;
import fable.imageviewer.internal.ImageUtils;
import fable.imageviewer.internal.ZoomSelection;
import fable.imageviewer.views.ImageView;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class Slice1DAction
extends Action
implements IViewActionDelegate {
    ImageView imageView = null;

    public Slice1DAction() {
    }

    public Slice1DAction(String string) {
        super(string, 1);
        this.setEnabled(true);
    }

    public void init(IViewPart iViewPart) {
        this.imageView = (ImageView)iViewPart;
    }

    public void run(IAction iAction) {
        this.slice1D();
    }

    public void run() {
        this.slice1D();
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    private void slice1D() {
        try {
            Vector vector = SampleNavigatorView.view.getSelectedFilesIndex();
            if (vector.size() <= 1) {
                this.imageView.updateStatusLabel("select at least 2 files to make a slice");
            } else {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", Integer.toString(200), 1);
                ImageView imageView = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findViewReference("fable.imageviewer.views.ImageView", Integer.toString(200)).getView(true);
                imageView.stopListening();
                Rectangle rectangle = this.imageView.getImage().getSelectedArea();
                Rectangle rectangle2 = this.imageView.getImage().screenRectangleToImageRectangle(rectangle, true);
                if (this.imageView.getZoomSelection() == ZoomSelection.LINE) {
                    ImageUtils.Slice2DLine(rectangle2.x, rectangle2.y, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, 1);
                } else {
                    this.imageView.updateStatusLabel("zoom on a 1D line to make a slice");
                }
                imageView.setOrientation(this.imageView.getOrientation());
                imageView.setCoordOrigin(this.imageView.getCoordOrigin());
                imageView.setPalette(this.imageView.getPalette());
                imageView.setMinMax(this.imageView.getMinMax());
                imageView.setName("1D Slice " + this.imageView.getFileName());
            }
        }
        catch (PartInitException partInitException) {
            FableUtils.excMsg((Object)((Object)this), (String)"Error opening view", (Throwable)partInitException);
        }
    }
}

