/*
 * Decompiled with CFR 0.152.
 */
package fable.imageviewer.actions;

import fable.framework.toolbox.FableUtils;
import fable.imageviewer.views.ImageView;
import fable.python.FabioFile;
import fable.python.FabioFileException;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenImageAction
extends Action {
    private final IWorkbenchWindow window;
    private static final String CMD_OPEN_IMAGE = "fable.imageviewer.openImageAction";
    private static String previousDirectory = null;

    public OpenImageAction(IWorkbenchWindow iWorkbenchWindow, String string, String string2, String string3) {
        this.window = iWorkbenchWindow;
        this.setText(string);
        this.setId(CMD_OPEN_IMAGE);
        this.setActionDefinitionId(CMD_OPEN_IMAGE);
        previousDirectory = string3;
    }

    public void run() {
        if (this.window != null) {
            String string;
            FileDialog fileDialog = new FileDialog(this.window.getShell(), 4);
            fileDialog.setText("Choose Image");
            if (previousDirectory != null) {
                fileDialog.setFilterPath(previousDirectory);
            }
            if ((string = fileDialog.open()) != null) {
                if (previousDirectory == null) {
                    previousDirectory = new File(string).getAbsolutePath();
                }
                try {
                    FabioFile fabioFile = new FabioFile(string);
                    System.out.println(string);
                    this.loadAndShowImage(fabioFile);
                }
                catch (FabioFileException fabioFileException) {
                    FableUtils.excNoTraceMsg((Object)((Object)this), (String)"Error opening file", (Throwable)fabioFileException);
                }
            }
        }
    }

    public void loadAndShowImage(FabioFile fabioFile) {
        try {
            ImageView imageView = (ImageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("fable.imageviewer.views.ImageView", "0", 1);
            if (imageView != null) {
                imageView.loadFile(fabioFile);
                imageView.getImage().displayImage();
            }
        }
        catch (PartInitException partInitException) {
            FableUtils.excMsg((Object)((Object)this), (String)"Error getting ImageView instance", (Throwable)partInitException);
        }
    }
}

